/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.jdbc;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.SortOrder;
import org.jetbrains.exposed.v1.core.vendors.ForUpdateOption;
import org.jetbrains.exposed.v1.jdbc.EmptySizedIterable;
import org.jetbrains.exposed.v1.jdbc.LazySizedIterable;
import org.jetbrains.exposed.v1.jdbc.SizedIterable;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\b\u0012\u0004\u0012\u0002H\u00020\u0001\"\u0004\b\u0000\u0010\u0002\u001a9\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00040\u0001\"\u0004\b\u0000\u0010\u0002\"\u0004\b\u0001\u0010\u0004*\b\u0012\u0004\u0012\u0002H\u00020\u00012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u0006H\u0086\u0004\u00a8\u0006\u0007"}, d2={"emptySized", "Lorg/jetbrains/exposed/v1/jdbc/SizedIterable;", "T", "mapLazy", "R", "f", "Lkotlin/Function1;", "exposed-jdbc"})
public final class IterableExKt {
    @NotNull
    public static final <T> SizedIterable<T> emptySized() {
        return new EmptySizedIterable();
    }

    @NotNull
    public static final <T, R> SizedIterable<R> mapLazy(@NotNull SizedIterable<? extends T> $this$mapLazy, @NotNull Function1<? super T, ? extends R> f) {
        Intrinsics.checkNotNullParameter($this$mapLazy, (String)"<this>");
        Intrinsics.checkNotNullParameter(f, (String)"f");
        SizedIterable<? extends T> source = $this$mapLazy;
        return new LazySizedIterable<R>(source, f){
            private List<? extends R> loadedResult;
            final /* synthetic */ SizedIterable<T> $source;
            final /* synthetic */ Function1<T, R> $f;
            {
                this.$source = $source;
                this.$f = $f;
            }

            public List<R> getLoadedResult() {
                return this.loadedResult;
            }

            public void setLoadedResult(List<? extends R> list) {
                this.loadedResult = list;
            }

            public SizedIterable<R> limit(int count) {
                return IterableExKt.mapLazy(this.$source.copy().limit(count), this.$f);
            }

            public SizedIterable<R> offset(long start) {
                return IterableExKt.mapLazy(this.$source.copy().offset(start), this.$f);
            }

            public SizedIterable<R> forUpdate(ForUpdateOption option) {
                Intrinsics.checkNotNullParameter((Object)option, (String)"option");
                return IterableExKt.mapLazy(this.$source.copy().forUpdate(option), this.$f);
            }

            public SizedIterable<R> notForUpdate() {
                return IterableExKt.mapLazy(this.$source.copy().notForUpdate(), this.$f);
            }

            public long count() {
                return this.$source.count();
            }

            public boolean empty() {
                return this.$source.empty();
            }

            public SizedIterable<R> copy() {
                return IterableExKt.mapLazy(this.$source.copy(), this.$f);
            }

            public SizedIterable<R> orderBy(Pair<? extends Expression<?>, ? extends SortOrder> ... order) {
                Intrinsics.checkNotNullParameter(order, (String)"order");
                return IterableExKt.mapLazy(this.$source.orderBy(Arrays.copyOf(order, order.length)), this.$f);
            }

            public Iterator<R> iterator() {
                List<R> list = this.getLoadedResult();
                if (list != null) {
                    List<R> $this$iterator_u24lambda_u240 = list;
                    boolean bl = false;
                    return $this$iterator_u24lambda_u240.iterator();
                }
                Iterator<T> sourceIterator = this.$source.iterator();
                return new Iterator<R>(this.$f, sourceIterator){
                    final /* synthetic */ Function1<T, R> $f;
                    final /* synthetic */ Iterator<T> $sourceIterator;
                    {
                        this.$f = $f;
                        this.$sourceIterator = $sourceIterator;
                    }

                    public R next() {
                        return (R)this.$f.invoke(this.$sourceIterator.next());
                    }

                    public boolean hasNext() {
                        return this.$sourceIterator.hasNext();
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }
}

