/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.jdbc.transactions;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.SQLLogKt;
import org.jetbrains.exposed.v1.core.Schema;
import org.jetbrains.exposed.v1.core.SqlLogger;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.StatementContext;
import org.jetbrains.exposed.v1.exceptions.ExposedSQLException;
import org.jetbrains.exposed.v1.jdbc.Database;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.SchemaUtils;
import org.jetbrains.exposed.v1.jdbc.statements.api.JdbcPreparedStatementApi;
import org.jetbrains.exposed.v1.jdbc.transactions.JdbcTransactionInterface;
import org.jetbrains.exposed.v1.jdbc.transactions.JdbcTransactionInterfaceKt;
import org.jetbrains.exposed.v1.jdbc.transactions.TransactionManager;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000>\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a6\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00010\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\b\u001aH\u0010\u0000\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00010\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\r\u001aT\u0010\u000e\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00062\u0017\u0010\u0004\u001a\u0013\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00010\u0005\u00a2\u0006\u0002\b\u0007\u00a2\u0006\u0002\u0010\u0010\u001a-\u0010\u0011\u001a\u0002H\u0001\"\u0004\b\u0000\u0010\u00012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00010\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014\u001a \u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0000\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\nH\u0000\u001a\u0010\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u0000\u001a\u00020\u0006H\u0000\u00a8\u0006\u001b"}, d2={"transaction", "T", "db", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "statement", "Lkotlin/Function1;", "Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/exposed/v1/jdbc/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "transactionIsolation", "", "readOnly", "", "(IZLorg/jetbrains/exposed/v1/jdbc/Database;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "inTopLevelTransaction", "outerTransaction", "(IZLorg/jetbrains/exposed/v1/jdbc/Database;Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "keepAndRestoreTransactionRefAfterRun", "block", "Lkotlin/Function0;", "(Lorg/jetbrains/exposed/v1/jdbc/Database;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "handleSQLException", "", "cause", "Ljava/sql/SQLException;", "attempts", "closeStatementsAndConnection", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionManager.kt\norg/jetbrains/exposed/v1/jdbc/transactions/TransactionManagerKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 JdbcTransactionInterface.kt\norg/jetbrains/exposed/v1/jdbc/transactions/JdbcTransactionInterfaceKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,510:1\n1869#2:511\n808#2,11:512\n1869#2,2:523\n1870#2:525\n51#3,6:526\n1#4:532\n*S KotlinDebug\n*F\n+ 1 TransactionManager.kt\norg/jetbrains/exposed/v1/jdbc/transactions/TransactionManagerKt\n*L\n483#1:511\n484#1:512,11\n484#1:523,2\n483#1:525\n506#1:526,6\n*E\n"})
public final class TransactionManagerKt {
    public static final <T> T transaction(@Nullable Database db, @NotNull Function1<? super JdbcTransaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        return TransactionManagerKt.transaction(JdbcTransactionInterfaceKt.getTransactionManager(db).getDefaultIsolationLevel(), JdbcTransactionInterfaceKt.getTransactionManager(db).getDefaultReadOnly(), db, statement);
    }

    public static /* synthetic */ Object transaction$default(Database database, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return TransactionManagerKt.transaction(database, function1);
    }

    public static final <T> T transaction(int transactionIsolation, boolean readOnly, @Nullable Database db, @NotNull Function1<? super JdbcTransaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        return TransactionManagerKt.keepAndRestoreTransactionRefAfterRun(db, () -> TransactionManagerKt.transaction$lambda$5(db, transactionIsolation, readOnly, statement));
    }

    public static /* synthetic */ Object transaction$default(int n, boolean bl, Database database, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        return TransactionManagerKt.transaction(n, bl, database, function1);
    }

    public static final <T> T inTopLevelTransaction(int transactionIsolation, boolean readOnly, @Nullable Database db, @Nullable JdbcTransaction outerTransaction, @NotNull Function1<? super JdbcTransaction, ? extends T> statement) {
        Intrinsics.checkNotNullParameter(statement, (String)"statement");
        return TransactionManagerKt.keepAndRestoreTransactionRefAfterRun(db, () -> TransactionManagerKt.inTopLevelTransaction$lambda$11(outerTransaction, db, transactionIsolation, readOnly, statement));
    }

    public static /* synthetic */ Object inTopLevelTransaction$default(int n, boolean bl, Database database, JdbcTransaction jdbcTransaction, Function1 function1, int n2, Object object) {
        if ((n2 & 2) != 0) {
            bl = false;
        }
        if ((n2 & 4) != 0) {
            database = null;
        }
        if ((n2 & 8) != 0) {
            jdbcTransaction = null;
        }
        return TransactionManagerKt.inTopLevelTransaction(n, bl, database, jdbcTransaction, function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T keepAndRestoreTransactionRefAfterRun(Database db, Function0<? extends T> block) {
        Object object;
        TransactionManager manager = JdbcTransactionInterfaceKt.getTransactionManager(db);
        JdbcTransaction currentTransaction = manager.currentOrNull();
        try {
            object = block.invoke();
        }
        finally {
            manager.bindTransactionToThread(currentTransaction);
        }
        return (T)object;
    }

    static /* synthetic */ Object keepAndRestoreTransactionRefAfterRun$default(Database database, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            database = null;
        }
        return TransactionManagerKt.keepAndRestoreTransactionRefAfterRun(database, function0);
    }

    /*
     * WARNING - void declaration
     */
    public static final void handleSQLException(@NotNull SQLException cause, @NotNull JdbcTransaction transaction, int attempts) {
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        ExposedSQLException exposedSQLException = cause instanceof ExposedSQLException ? (ExposedSQLException)cause : null;
        Object object = exposedSQLException;
        if (object == null || (object = object.causedByQueries()) == null || (object = CollectionsKt.joinToString$default((Iterable)((Iterable)object), (CharSequence)";\n", null, null, (int)0, null, null, (int)62, null)) == null) {
            object = String.valueOf(transaction.getCurrentStatement());
        }
        Object queriesToLog = object;
        String message = "Transaction attempt #" + attempts + " failed: " + cause.getMessage() + ". Statement(s): " + (String)queriesToLog;
        Object object2 = exposedSQLException;
        if (object2 != null && (object2 = object2.getContexts()) != null) {
            Iterable $this$forEach$iv = (Iterable)object2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$forEach$iv2;
                void $this$filterIsInstanceTo$iv$iv;
                StatementContext it = (StatementContext)element$iv;
                boolean bl = false;
                Iterable $this$filterIsInstance$iv = transaction.getInterceptors$exposed_jdbc();
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof SqlLogger)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filterIsInstance$iv = (List)destination$iv$iv;
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    SqlLogger logger = (SqlLogger)element$iv2;
                    boolean bl2 = false;
                    logger.log(it, (Transaction)transaction);
                }
            }
        }
        SQLLogKt.getExposedLogger().warn(message, (Throwable)cause);
        JdbcTransactionInterfaceKt.rollbackLoggingException(transaction, (Function1<? super Exception, Unit>)((Function1)TransactionManagerKt::handleSQLException$lambda$14));
    }

    public static final void closeStatementsAndConnection(@NotNull JdbcTransaction transaction) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        JdbcPreparedStatementApi currentStatement = transaction.getCurrentStatement();
        try {
            JdbcPreparedStatementApi jdbcPreparedStatementApi = currentStatement;
            if (jdbcPreparedStatementApi != null) {
                JdbcPreparedStatementApi it = jdbcPreparedStatementApi;
                boolean bl = false;
                it.closeIfPossible();
                transaction.setCurrentStatement(null);
            }
            transaction.closeExecutedStatements();
        }
        catch (Exception cause) {
            SQLLogKt.getExposedLogger().warn("Statements close failed", (Throwable)cause);
        }
        JdbcTransactionInterface $this$closeLoggingException$iv = transaction;
        boolean $i$f$closeLoggingException = false;
        try {
            $this$closeLoggingException$iv.close();
        }
        catch (Exception e$iv) {
            Exception it = e$iv;
            boolean bl = false;
            SQLLogKt.getExposedLogger().warn("Transaction close failed: " + it.getMessage() + ". Statement: " + currentStatement, (Throwable)it);
        }
    }

    private static final Unit transaction$lambda$5$lambda$1(JdbcPreparedStatementApi $currentStatement, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + $currentStatement, (Throwable)it);
        return Unit.INSTANCE;
    }

    private static final Unit transaction$lambda$5$lambda$2(JdbcPreparedStatementApi $currentStatement, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + $currentStatement, (Throwable)it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Object transaction$lambda$5(Database $db, int $transactionIsolation, boolean $readOnly, Function1 $statement) {
        Object object;
        block19: {
            block20: {
                Object object2;
                JdbcTransaction outer;
                block18: {
                    Object object3;
                    outer = TransactionManager.Companion.currentOrNull();
                    if (outer == null || $db != null && !Intrinsics.areEqual((Object)((Object)outer.getDb()), (Object)((Object)$db))) break block18;
                    TransactionManager outerManager = JdbcTransactionInterfaceKt.getTransactionManager(outer.getDb());
                    JdbcTransaction transaction = outerManager.newTransaction($transactionIsolation, $readOnly, outer);
                    try {
                        Object it = object3 = $statement.invoke((Object)transaction);
                        boolean bl = false;
                        if (outer.getDb().getUseNestedTransactions()) {
                            transaction.commit();
                        }
                    }
                    catch (SQLException cause) {
                        JdbcPreparedStatementApi currentStatement = transaction.getCurrentStatement();
                        JdbcTransactionInterfaceKt.rollbackLoggingException(transaction, (Function1<? super Exception, Unit>)((Function1)arg_0 -> TransactionManagerKt.transaction$lambda$5$lambda$1(currentStatement, arg_0)));
                        throw cause;
                    }
                    catch (Throwable cause) {
                        if (outer.getDb().getUseNestedTransactions()) {
                            JdbcPreparedStatementApi currentStatement = transaction.getCurrentStatement();
                            JdbcTransactionInterfaceKt.rollbackLoggingException(transaction, (Function1<? super Exception, Unit>)((Function1)arg_0 -> TransactionManagerKt.transaction$lambda$5$lambda$2(currentStatement, arg_0)));
                        }
                        throw cause;
                    }
                    finally {
                        TransactionManager.Companion.resetCurrent(outerManager);
                    }
                    object = object3;
                    break block19;
                }
                Database database = $db;
                TransactionManager existingForDb = database != null ? JdbcTransactionInterfaceKt.getTransactionManager(database) : null;
                object = existingForDb;
                if (object == null || (object = ((TransactionManager)object).currentOrNull()) == null) break block20;
                Object transaction = object;
                boolean bl = false;
                JdbcTransaction jdbcTransaction = outer;
                TransactionManager currentManager = JdbcTransactionInterfaceKt.getTransactionManager(jdbcTransaction != null ? jdbcTransaction.getDb() : null);
                try {
                    TransactionManager.Companion.resetCurrent(existingForDb);
                    Object it = object2 = $statement.invoke(transaction);
                    boolean bl2 = false;
                    if ($db.getUseNestedTransactions()) {
                        ((JdbcTransaction)transaction).commit();
                    }
                }
                finally {
                    TransactionManager.Companion.resetCurrent(currentManager);
                }
                Object object4 = object2;
                object = object4;
                if (object4 != null) break block19;
            }
            object = TransactionManagerKt.inTopLevelTransaction($transactionIsolation, $readOnly, $db, null, $statement);
        }
        return object;
    }

    private static final Unit inTopLevelTransaction$run$lambda$10(JdbcPreparedStatementApi $currentStatement, Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". Statement: " + $currentStatement, (Throwable)it);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <T> T inTopLevelTransaction$run(JdbcTransaction $outerTransaction, Database $db, int $transactionIsolation, boolean $readOnly, Function1<? super JdbcTransaction, ? extends T> $statement) {
        TransactionManager transactionManager;
        int attempts = 0;
        JdbcTransaction jdbcTransaction = $outerTransaction;
        TransactionManager it = transactionManager = JdbcTransactionInterfaceKt.getTransactionManager(jdbcTransaction != null ? jdbcTransaction.getDb() : null);
        boolean bl = false;
        TransactionManager outerManager = it.currentOrNull() != null ? transactionManager : null;
        long intermediateDelay = 0L;
        Long retryInterval = null;
        while (true) {
            if ($db != null) {
                boolean bl2 = false;
                TransactionManager m = JdbcTransactionInterfaceKt.getTransactionManager($db);
                boolean bl3 = false;
                TransactionManager.Companion.resetCurrent(m);
            }
            JdbcTransaction transaction = JdbcTransactionInterfaceKt.getTransactionManager($db).newTransaction($transactionIsolation, $readOnly, $outerTransaction);
            try {
                Schema schema = transaction.getDb().getConfig().getDefaultSchema();
                if (schema != null) {
                    Schema it2 = schema;
                    boolean bl4 = false;
                    SchemaUtils.setSchema$default(SchemaUtils.INSTANCE, it2, false, 2, null);
                }
                Object answer = $statement.invoke((Object)transaction);
                transaction.commit();
                Object bl2 = answer;
                return (T)bl2;
            }
            catch (SQLException cause) {
                TransactionManagerKt.handleSQLException(cause, transaction, attempts);
                if (++attempts >= transaction.getMaxAttempts()) {
                    throw cause;
                }
                if (retryInterval == null) {
                    retryInterval = transaction.getRetryInterval$exposed_jdbc();
                    intermediateDelay = transaction.getMinRetryDelay();
                }
                long delay = transaction.getMinRetryDelay() < transaction.getMaxRetryDelay() ? ThreadLocalRandom.current().nextLong(intermediateDelay += retryInterval * (long)attempts, intermediateDelay + retryInterval) : (transaction.getMinRetryDelay() == transaction.getMaxRetryDelay() ? transaction.getMinRetryDelay() : 0L);
                SQLLogKt.getExposedLogger().warn("Wait " + delay + " milliseconds before retrying");
                try {
                    Thread.sleep(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                continue;
            }
            catch (Throwable cause) {
                JdbcPreparedStatementApi currentStatement = transaction.getCurrentStatement();
                JdbcTransactionInterfaceKt.rollbackLoggingException(transaction, (Function1<? super Exception, Unit>)((Function1)arg_0 -> TransactionManagerKt.inTopLevelTransaction$run$lambda$10(currentStatement, arg_0)));
                throw cause;
            }
            finally {
                TransactionManager.Companion.resetCurrent(outerManager);
                TransactionManagerKt.closeStatementsAndConnection(transaction);
                continue;
            }
            break;
        }
    }

    private static final Object inTopLevelTransaction$lambda$11(JdbcTransaction $outerTransaction, Database $db, int $transactionIsolation, boolean $readOnly, Function1 $statement) {
        return TransactionManagerKt.inTopLevelTransaction$run($outerTransaction, $db, $transactionIsolation, $readOnly, $statement);
    }

    private static final Unit handleSQLException$lambda$14(Exception it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        SQLLogKt.getExposedLogger().warn("Transaction rollback failed: " + it.getMessage() + ". See previous log line for statement", (Throwable)it);
        return Unit.INSTANCE;
    }
}

