/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.Function;
import org.jetbrains.exposed.v1.core.QueryBuilder;
import org.jetbrains.exposed.v1.core.TextColumnType;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B+\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u001a\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\"\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001f\u0010\u0004\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00060\u0005\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/exposed/v1/core/Concat;", "Lorg/jetbrains/exposed/v1/core/Function;", "", "separator", "expr", "", "Lorg/jetbrains/exposed/v1/core/Expression;", "<init>", "(Ljava/lang/String;[Lorg/jetbrains/exposed/v1/core/Expression;)V", "getSeparator", "()Ljava/lang/String;", "getExpr", "()[Lorg/jetbrains/exposed/v1/core/Expression;", "[Lorg/jetbrains/exposed/v1/core/Expression;", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/v1/core/QueryBuilder;", "exposed-core"})
public final class Concat
extends Function<String> {
    @NotNull
    private final String separator;
    @NotNull
    private final Expression<?>[] expr;

    public Concat(@NotNull String separator, Expression<?> ... expr) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        super(new TextColumnType(null, false, 3, null));
        this.separator = separator;
        this.expr = expr;
    }

    @NotNull
    public final String getSeparator() {
        return this.separator;
    }

    @NotNull
    public final Expression<?>[] getExpr() {
        return this.expr;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Expression<?>[] expressionArray = this.expr;
        DatabaseDialectKt.getCurrentDialect().getFunctionProvider().concat(this.separator, queryBuilder, Arrays.copyOf(expressionArray, expressionArray.length));
    }
}

