/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.datetime;

import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalTime;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Instant;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.TimeZone;
import kotlinx.datetime.TimeZoneKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnType;
import org.jetbrains.exposed.v1.core.IColumnType;
import org.jetbrains.exposed.v1.core.IDateColumnType;
import org.jetbrains.exposed.v1.core.datetime.LocalTimeColumnTypeKt;
import org.jetbrains.exposed.v1.core.statements.api.RowApi;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.H2Kt;
import org.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import org.jetbrains.exposed.v1.core.vendors.OracleDialect;
import org.jetbrains.exposed.v1.core.vendors.PostgreSQLDialect;
import org.jetbrains.exposed.v1.core.vendors.SQLiteDialect;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\tJ\u0015\u0010\n\u001a\u00028\u00002\u0006\u0010\b\u001a\u00020\u0007H&\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00112\b\u0010\b\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u0010\u0010\u0014\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0017\u0010\u0019\u001a\u0004\u0018\u00018\u00002\u0006\u0010\b\u001a\u00020\u0015H\u0016\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001b\u001a\u00020\u00152\b\u0010\b\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001aJ\u001a\u0010\u001c\u001a\u00020\u00112\b\u0010\b\u001a\u0004\b\u00028\u0000H\u0016\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016R\u0014\u0010\f\u001a\u00020\rX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\""}, d2={"Lorg/jetbrains/exposed/v1/core/datetime/LocalTimeColumnType;", "T", "Lorg/jetbrains/exposed/v1/core/ColumnType;", "Lorg/jetbrains/exposed/v1/core/IDateColumnType;", "<init>", "()V", "toLocalTime", "Lkotlinx/datetime/LocalTime;", "value", "(Ljava/lang/Object;)Lkotlinx/datetime/LocalTime;", "fromLocalTime", "(Lkotlinx/datetime/LocalTime;)Ljava/lang/Object;", "hasTimePart", "", "getHasTimePart", "()Z", "sqlType", "", "nonNullValueToString", "(Ljava/lang/Object;)Ljava/lang/String;", "localTimeValueFromDB", "", "longToLocalTime", "millis", "", "valueFromDB", "(Ljava/lang/Object;)Ljava/lang/Object;", "notNullValueToDB", "nonNullValueAsDefaultString", "readObject", "rs", "Lorg/jetbrains/exposed/v1/core/statements/api/RowApi;", "index", "", "exposed-core"})
public abstract class LocalTimeColumnType<T>
extends ColumnType<T>
implements IDateColumnType {
    private final boolean hasTimePart;

    public LocalTimeColumnType() {
        super(false, 1, null);
        this.hasTimePart = true;
    }

    @NotNull
    public abstract kotlinx.datetime.LocalTime toLocalTime(T var1);

    public abstract T fromLocalTime(@NotNull kotlinx.datetime.LocalTime var1);

    @Override
    public boolean getHasTimePart() {
        return this.hasTimePart;
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().timeType();
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        kotlinx.datetime.LocalTime localTime = this.toLocalTime(value);
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        if (dialect instanceof OracleDialect || H2Kt.getH2Mode(dialect) == H2Dialect.H2CompatibilityMode.Oracle) {
            return "TIMESTAMP '" + LocalTimeColumnTypeKt.access$formatOracleTime(localTime) + '\'';
        }
        return '\'' + LocalTimeColumnTypeKt.access$formatDefaultTime(localTime) + '\'';
    }

    private final kotlinx.datetime.LocalTime localTimeValueFromDB(Object value) {
        kotlinx.datetime.LocalTime localTime;
        Object object = value;
        if (object instanceof kotlinx.datetime.LocalTime) {
            localTime = (kotlinx.datetime.LocalTime)value;
        } else if (object instanceof Time) {
            LocalTime localTime2 = ((Time)value).toLocalTime();
            Intrinsics.checkNotNullExpressionValue((Object)localTime2, (String)"toLocalTime(...)");
            localTime = ConvertersKt.toKotlinLocalTime((LocalTime)localTime2);
        } else if (object instanceof Timestamp) {
            LocalTime localTime3 = ((Timestamp)value).toLocalDateTime().toLocalTime();
            Intrinsics.checkNotNullExpressionValue((Object)localTime3, (String)"toLocalTime(...)");
            localTime = ConvertersKt.toKotlinLocalTime((LocalTime)localTime3);
        } else {
            localTime = object instanceof Integer ? this.longToLocalTime(((Number)value).intValue()) : (object instanceof Long ? this.longToLocalTime(((Number)value).longValue()) : (object instanceof String ? kotlinx.datetime.LocalTime.Companion.parse((CharSequence)value, LocalTime.Formats.INSTANCE.getISO()) : this.localTimeValueFromDB(value.toString())));
        }
        return localTime;
    }

    private final kotlinx.datetime.LocalTime longToLocalTime(long millis) {
        return TimeZoneKt.toLocalDateTime((Instant)Instant.Companion.fromEpochMilliseconds(millis), (TimeZone)TimeZone.Companion.currentSystemDefault()).getTime();
    }

    @Override
    @Nullable
    public T valueFromDB(@NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.fromLocalTime(this.localTimeValueFromDB(value));
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        kotlinx.datetime.LocalTime localTimeValue = this.toLocalTime(value);
        return DatabaseDialectKt.getCurrentDialect() instanceof SQLiteDialect ? LocalTimeColumnTypeKt.access$formatDefaultTime(localTimeValue) : (H2Kt.getH2Mode(DatabaseDialectKt.getCurrentDialect()) == H2Dialect.H2CompatibilityMode.Oracle ? Timestamp.valueOf(LocalTimeColumnTypeKt.access$formatOracleTime(localTimeValue)).toInstant() : Time.valueOf(ConvertersKt.toJavaLocalTime((kotlinx.datetime.LocalTime)localTimeValue)));
    }

    @Override
    @NotNull
    public String nonNullValueAsDefaultString(@NotNull T value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        kotlinx.datetime.LocalTime localTime = this.toLocalTime(value);
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        return databaseDialect instanceof PostgreSQLDialect ? this.nonNullValueToString(value) + "::time without time zone" : (databaseDialect instanceof MysqlDialect ? '\'' + LocalTimeColumnTypeKt.access$formatMySqlTime(localTime) + '\'' : super.nonNullValueAsDefaultString(value));
    }

    @Override
    @Nullable
    public Object readObject(@NotNull RowApi rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        DatabaseDialect dialect = DatabaseDialectKt.getCurrentDialect();
        return dialect instanceof OracleDialect || H2Kt.getH2Mode(dialect) == H2Dialect.H2CompatibilityMode.Oracle ? rs.getObject(index, Timestamp.class, (IColumnType)this) : super.readObject(rs, index);
    }
}

