/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.statements;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Column;
import org.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import org.jetbrains.exposed.v1.core.IColumnType;
import org.jetbrains.exposed.v1.core.QueryBuilder;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.UpsertBuilder;
import org.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import org.jetbrains.exposed.v1.core.vendors.FunctionProvider;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B(\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u0012\u000e\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\u0006\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001f\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\b\u00028\u00000\u0006X\u0096\u0004\u00f8\u0001\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/exposed/v1/core/statements/InsertValue;", "T", "Lorg/jetbrains/exposed/v1/core/ExpressionWithColumnType;", "column", "Lorg/jetbrains/exposed/v1/core/Column;", "columnType", "Lorg/jetbrains/exposed/v1/core/IColumnType;", "<init>", "(Lorg/jetbrains/exposed/v1/core/Column;Lorg/jetbrains/exposed/v1/core/IColumnType;)V", "getColumn", "()Lorg/jetbrains/exposed/v1/core/Column;", "getColumnType", "()Lorg/jetbrains/exposed/v1/core/IColumnType;", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/v1/core/QueryBuilder;", "exposed-core"})
public final class InsertValue<T>
extends ExpressionWithColumnType<T> {
    @NotNull
    private final Column<T> column;
    @NotNull
    private final IColumnType<T> columnType;

    public InsertValue(@NotNull Column<T> column, @NotNull IColumnType<T> columnType) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(columnType, (String)"columnType");
        this.column = column;
        this.columnType = columnType;
    }

    @NotNull
    public final Column<T> getColumn() {
        return this.column;
    }

    @Override
    @NotNull
    public IColumnType<T> getColumnType() {
        return this.columnType;
    }

    @Override
    public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Transaction transaction = CoreTransactionManager.INSTANCE.currentTransaction();
        FunctionProvider functionProvider = UpsertBuilder.Companion.getFunctionProvider(transaction.getDb().getDialect());
        functionProvider.insertValue(transaction.identity(this.column), queryBuilder);
    }
}

