/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.statements;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.internal.LowPriorityInOverloadResolution;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.AbstractQuery;
import org.jetbrains.exposed.v1.core.AliasKt;
import org.jetbrains.exposed.v1.core.Column;
import org.jetbrains.exposed.v1.core.ColumnTypeKt;
import org.jetbrains.exposed.v1.core.CompositeColumn;
import org.jetbrains.exposed.v1.core.DdlAware;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.InternalApi;
import org.jetbrains.exposed.v1.core.NullableColumnWithTransform;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.dao.id.CompositeID;
import org.jetbrains.exposed.v1.core.dao.id.EntityID;
import org.jetbrains.exposed.v1.core.dao.id.IdTable;
import org.jetbrains.exposed.v1.core.statements.Statement;
import org.jetbrains.exposed.v1.core.statements.StatementType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0012\u001a\u00020\u00132\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\fH\u0096\u0002J\u0014\u0010\u001a\u001a\u00020\u001b2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\fH\u0002J*\u0010\u001c\u001a\u00020\u001b\"\u0004\b\u0001\u0010\u001d2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u001d0\f2\u0006\u0010\u001e\u001a\u0002H\u001dH\u0097\u0002\u00a2\u0006\u0002\u0010\u001fJ6\u0010\u001c\u001a\u00020\u001b\"\b\b\u0001\u0010\u001d*\u00020\r2\u0012\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0 0\f2\u0006\u0010\u001e\u001a\u0002H\u001dH\u0087\u0002\u00a2\u0006\u0004\b!\u0010\u001fJ:\u0010\u001c\u001a\u00020\u001b\"\b\b\u0001\u0010\u001d*\u00020\r2\u0014\u0010\u0014\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u0002H\u001d\u0018\u00010 0\f2\b\u0010\u001e\u001a\u0004\u0018\u0001H\u001dH\u0087\u0002\u00a2\u0006\u0004\b\"\u0010\u001fJR\u0010\u001c\u001a\u00020\u001b\"\n\b\u0001\u0010\u001d*\u0004\u0018\u00010\r\"\u000e\b\u0002\u0010#*\b\u0012\u0004\u0012\u0002H\u001d0 \"\u000e\b\u0003\u0010$*\b\u0012\u0004\u0012\u0002H\u001d0%2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H#0\f2\u0006\u0010\u001e\u001a\u0002H$H\u0087\u0002\u00a2\u0006\u0004\b&\u0010'JF\u0010\u001c\u001a\u00020\u001b\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u001d*\u0004\u0018\u0001H\u0001\"\u000e\b\u0003\u0010$*\b\u0012\u0004\u0012\u0002H\u001d0%2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00010\f2\u0006\u0010\u001e\u001a\u0002H$H\u0096\u0002\u00a2\u0006\u0002\u0010'J)\u0010\u001c\u001a\u00020\u001b\"\u0004\b\u0001\u0010\u001d2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u001d0\f2\n\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030(H\u0096\u0002J*\u0010\u001c\u001a\u00020\u001b\"\u0004\b\u0001\u0010\u001d2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u001d0)2\u0006\u0010\u001e\u001a\u0002H\u001dH\u0096\u0002\u00a2\u0006\u0002\u0010*J\f\u0010+\u001a\u00020\u001b*\u00020,H\u0002J6\u0010-\u001a\u00020\u001b\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u001d*\u0004\u0018\u0001H\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00010\f2\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u0002H\u001d0%H\u0016J<\u0010-\u001a\u00020\u001b\"\u0004\b\u0001\u0010\u0001\"\n\b\u0002\u0010\u001d*\u0004\u0018\u0001H\u00012\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00010\f2\u0012\u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u001d0%0.H\u0016R.\u0010\n\u001a\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0015\u001a\u00020\u0013X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006/"}, d2={"Lorg/jetbrains/exposed/v1/core/statements/UpdateBuilder;", "T", "Lorg/jetbrains/exposed/v1/core/statements/Statement;", "type", "Lorg/jetbrains/exposed/v1/core/statements/StatementType;", "targets", "", "Lorg/jetbrains/exposed/v1/core/Table;", "<init>", "(Lorg/jetbrains/exposed/v1/core/statements/StatementType;Ljava/util/List;)V", "values", "", "Lorg/jetbrains/exposed/v1/core/Column;", "", "getValues$annotations", "()V", "getValues", "()Ljava/util/Map;", "contains", "", "column", "hasBatchedValues", "getHasBatchedValues", "()Z", "setHasBatchedValues", "(Z)V", "checkThatExpressionWasNotSetInPreviousBatch", "", "set", "S", "value", "(Lorg/jetbrains/exposed/v1/core/Column;Ljava/lang/Object;)V", "Lorg/jetbrains/exposed/v1/core/dao/id/EntityID;", "setWithEntityIdValue", "setWithNullableEntityIdValue", "ID", "E", "Lorg/jetbrains/exposed/v1/core/Expression;", "setWithEntityIdExpression", "(Lorg/jetbrains/exposed/v1/core/Column;Lorg/jetbrains/exposed/v1/core/Expression;)V", "Lorg/jetbrains/exposed/v1/core/AbstractQuery;", "Lorg/jetbrains/exposed/v1/core/CompositeColumn;", "(Lorg/jetbrains/exposed/v1/core/CompositeColumn;Ljava/lang/Object;)V", "setComponentValues", "Lorg/jetbrains/exposed/v1/core/dao/id/CompositeID;", "update", "Lkotlin/Function0;", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nUpdateBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateBuilder.kt\norg/jetbrains/exposed/v1/core/statements/UpdateBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,121:1\n1#2:122\n216#3,2:123\n216#3,2:125\n*S KotlinDebug\n*F\n+ 1 UpdateBuilder.kt\norg/jetbrains/exposed/v1/core/statements/UpdateBuilder\n*L\n94#1:123,2\n101#1:125,2\n*E\n"})
public abstract class UpdateBuilder<T>
extends Statement<T> {
    @NotNull
    private final Map<Column<?>, Object> values;
    private boolean hasBatchedValues;

    public UpdateBuilder(@NotNull StatementType type, @NotNull List<? extends Table> targets) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter(targets, (String)"targets");
        super(type, targets);
        this.values = new LinkedHashMap();
    }

    @NotNull
    public final Map<Column<?>, Object> getValues() {
        return this.values;
    }

    @InternalApi
    public static /* synthetic */ void getValues$annotations() {
    }

    public boolean contains(@NotNull Column<?> column) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        return this.values.containsKey(column);
    }

    protected final boolean getHasBatchedValues() {
        return this.hasBatchedValues;
    }

    protected final void setHasBatchedValues(boolean bl) {
        this.hasBatchedValues = bl;
    }

    private final void checkThatExpressionWasNotSetInPreviousBatch(Column<?> column) {
        if (!(!this.values.containsKey(column) || !this.hasBatchedValues)) {
            boolean bl = false;
            String string = column + " is already initialized in a batch";
            throw new IllegalArgumentException(string.toString());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @LowPriorityInOverloadResolution
    public <S> void set(@NotNull Column<S> column, S value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (!(column.getColumnType() instanceof NullableColumnWithTransform || column.getColumnType().getNullable() || value != null && !(value instanceof Op.NULL))) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        if (ColumnTypeKt.isEntityIdentifier(column)) {
            Intrinsics.checkNotNull(value, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.dao.id.EntityID<*>");
            if (((EntityID)value).getValue() instanceof CompositeID) {
                Object t = ((EntityID)value).getValue();
                Intrinsics.checkNotNull(t, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.dao.id.CompositeID");
                this.setComponentValues((CompositeID)t);
                return;
            }
        }
        column.getColumnType().validateValueBeforeUpdate(value);
        this.values.put(column, value);
    }

    @JvmName(name="setWithEntityIdValue")
    public final <S> void setWithEntityIdValue(@NotNull Column<EntityID<S>> column, @NotNull S value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (value instanceof CompositeID) {
            this.setComponentValues((CompositeID)value);
        } else {
            DdlAware ddlAware = column.getForeignKey();
            if (ddlAware == null || (ddlAware = ddlAware.getTargetTable()) == null) {
                ddlAware = column.getTable();
            }
            Intrinsics.checkNotNull((Object)ddlAware, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.dao.id.IdTable<S of org.jetbrains.exposed.v1.core.statements.UpdateBuilder.set>");
            EntityID<S> entityId = new EntityID<S>(value, (IdTable)ddlAware);
            column.getColumnType().validateValueBeforeUpdate(entityId);
            this.values.put(column, entityId);
        }
    }

    @JvmName(name="setWithNullableEntityIdValue")
    public final <S> void setWithNullableEntityIdValue(@NotNull Column<EntityID<S>> column, @Nullable S value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        if (!(column.getColumnType().getNullable() || value != null)) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        if (value instanceof CompositeID) {
            this.setComponentValues((CompositeID)value);
        } else {
            EntityID<S> entityID;
            S s = value;
            if (s != null) {
                S it = s;
                boolean bl = false;
                DdlAware ddlAware = column.getForeignKey();
                if (ddlAware == null || (ddlAware = ddlAware.getTargetTable()) == null) {
                    ddlAware = column.getTable();
                }
                Intrinsics.checkNotNull((Object)ddlAware, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.dao.id.IdTable<S of org.jetbrains.exposed.v1.core.statements.UpdateBuilder.set>");
                entityID = new EntityID<S>(it, (IdTable)ddlAware);
            } else {
                entityID = null;
            }
            EntityID<S> entityId = entityID;
            column.getColumnType().validateValueBeforeUpdate(entityId);
            this.values.put(column, entityId);
        }
    }

    @JvmName(name="setWithEntityIdExpression")
    public final <S, ID extends EntityID<S>, E extends Expression<S>> void setWithEntityIdExpression(@NotNull Column<ID> column, @NotNull E value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (!(column.getColumnType().getNullable() || !(value instanceof Op.NULL))) {
            boolean bl = false;
            String string = "Trying to set null to not nullable column " + column;
            throw new IllegalArgumentException(string.toString());
        }
        this.checkThatExpressionWasNotSetInPreviousBatch(column);
        this.values.put(column, value);
    }

    public <T, S extends T, E extends Expression<S>> void set(@NotNull Column<T> column, @NotNull E value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.update(column, value);
    }

    public <S> void set(@NotNull Column<S> column, @NotNull AbstractQuery<?> value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.update(column, AliasKt.wrapAsExpression(value));
    }

    public <S> void set(@NotNull CompositeColumn<S> column, S value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Map<Column<?>, Object> $this$forEach$iv = column.getRealColumnsWithValues(value);
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Column<?>, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Column<?>, Object> element$iv;
            Map.Entry<Column<?>, Object> entry = element$iv = iterator.next();
            boolean bl = false;
            Column<?> realColumn = entry.getKey();
            Object itsValue = entry.getValue();
            Intrinsics.checkNotNull(realColumn, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.Column<kotlin.Any?>");
            this.set(realColumn, (Expression)itsValue);
        }
    }

    private final void setComponentValues(CompositeID $this$setComponentValues) {
        Map<Column<?>, Object> $this$forEach$iv = $this$setComponentValues.getValues$exposed_core();
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<Column<?>, Object>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Column<?>, Object> element$iv;
            Map.Entry<Column<?>, Object> entry = element$iv = iterator.next();
            boolean bl = false;
            Column<?> idColumn = entry.getKey();
            Object idValue = entry.getValue();
            Intrinsics.checkNotNull(idColumn, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.Column<kotlin.Any?>");
            this.set(idColumn, (Expression)idValue);
        }
    }

    public <T, S extends T> void update(@NotNull Column<T> column, @NotNull Expression<S> value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.checkThatExpressionWasNotSetInPreviousBatch(column);
        this.values.put(column, value);
    }

    public <T, S extends T> void update(@NotNull Column<T> column, @NotNull Function0<? extends Expression<S>> value) {
        Intrinsics.checkNotNullParameter(column, (String)"column");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.update(column, (Expression)value.invoke());
    }
}

