/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugins.migration;

import app.termora.Application;
import app.termora.ApplicationRunnerExtension;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.Host;
import app.termora.HostManager;
import app.termora.I18n;
import app.termora.TermoraFrameManager;
import app.termora.TermoraRestarter;
import app.termora.account.AccountManager;
import app.termora.account.AccountOwner;
import app.termora.database.DatabaseManager;
import app.termora.database.OwnerType;
import app.termora.highlight.KeywordHighlight;
import app.termora.highlight.KeywordHighlightManager;
import app.termora.keymap.Keymap;
import app.termora.keymap.KeymapManager;
import app.termora.keymgr.KeyManager;
import app.termora.keymgr.OhKeyPair;
import app.termora.macro.Macro;
import app.termora.macro.MacroManager;
import app.termora.plugins.migration.Database;
import app.termora.plugins.migration.Doorman;
import app.termora.plugins.migration.DoormanDialog;
import app.termora.plugins.migration.MigrationDialog;
import app.termora.snippet.Snippet;
import app.termora.snippet.SnippetManager;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\u0005H\u0002J\b\u0010\f\u001a\u00020\u0005H\u0002J\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lapp/termora/plugins/migration/MigrationApplicationRunnerExtension;", "Lapp/termora/ApplicationRunnerExtension;", "<init>", "()V", "ready", "", "openDoor", "openDatabase", "migrate", "askMigrate", "", "moveOldDirectory", "restart", "getDatabaseFile", "Ljava/io/File;", "Companion", "migration"})
public final class MigrationApplicationRunnerExtension
implements ApplicationRunnerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(MigrationApplicationRunnerExtension.class);
    @NotNull
    private static final Lazy<MigrationApplicationRunnerExtension> instance$delegate = LazyKt.lazy(MigrationApplicationRunnerExtension::instance_delegate$lambda$0);

    private MigrationApplicationRunnerExtension() {
    }

    public void ready() {
        File file = this.getDatabaseFile();
        if (!file.exists()) {
            return;
        }
        CountDownLatch countDownLatch = new CountDownLatch(1);
        SwingUtilities.invokeAndWait(() -> MigrationApplicationRunnerExtension.ready$lambda$0(this, countDownLatch));
        countDownLatch.await();
    }

    private final void openDoor() {
        if (Doorman.Companion.getInstance().isWorking() && !new DoormanDialog(null).open()) {
            Disposer.dispose((Disposable)((Disposable)TermoraFrameManager.Companion.getInstance()));
        }
    }

    private final void openDatabase() {
        try {
            Database.Companion.getDatabase();
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
            JOptionPane.showMessageDialog(null, "Unable to open database", I18n.INSTANCE.getString("termora.title"), 0);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final void migrate() {
        Database database = Database.Companion.getDatabase();
        AccountManager accountManager = AccountManager.Companion.getInstance();
        DatabaseManager databaseManager = DatabaseManager.Companion.getInstance();
        String ownerId = accountManager.getAccountId();
        HostManager hostManager = HostManager.Companion.getInstance();
        SnippetManager snippetManager = SnippetManager.Companion.getInstance();
        MacroManager macroManager = MacroManager.Companion.getInstance();
        KeymapManager keymapManager = KeymapManager.Companion.getInstance();
        KeyManager keyManager = KeyManager.Companion.getInstance();
        KeywordHighlightManager highlightManager = KeywordHighlightManager.Companion.getInstance();
        AccountOwner accountOwner = new AccountOwner(accountManager.getAccountId(), accountManager.getEmail(), OwnerType.User);
        for (Host host : database.getHosts()) {
            if (host.getDeleted()) continue;
            HostManager.addHost$default((HostManager)hostManager, (Host)Host.copy$default((Host)host, null, null, null, null, (int)0, null, null, null, null, null, null, (long)0L, null, (String)accountManager.getAccountId(), null, (String)"User", (boolean)false, (long)0L, (long)0L, (int)483327, null), null, (int)2, null);
        }
        for (Snippet snippet : database.getSnippets()) {
            if (snippet.getDeleted()) continue;
            snippetManager.addSnippet(snippet);
        }
        for (Macro macro : database.getMacros()) {
            macroManager.addMacro(macro);
        }
        for (Keymap keymap : database.getKeymaps()) {
            keymapManager.addKeymap(keymap);
        }
        for (OhKeyPair keypair : database.getKeyPairs()) {
            keyManager.addOhKeyPair(keypair, accountOwner);
        }
        for (KeywordHighlight e : database.getKeywordHighlights()) {
            highlightManager.addKeywordHighlight(e, accountOwner);
        }
        Database.Property[] propertyArray = new Database.Property[]{database.getSync(), database.getProperties(), database.getTerminal(), database.getSftp(), database.getAppearance()};
        List list = CollectionsKt.listOf((Object[])propertyArray);
        for (Database.Property property : list) {
            for (Map.Entry<String, String> k : property.getProperties().entrySet()) {
                databaseManager.setSetting(property.getName() + "." + k.getKey(), k.getValue());
            }
        }
        for (Map.Entry entry : database.getSafetyProperties().getProperties().entrySet()) {
            databaseManager.setSetting(database.getProperties().getName() + "." + entry.getKey(), (String)entry.getValue());
        }
    }

    private final boolean askMigrate() {
        if (new MigrationDialog(null).open()) {
            return true;
        }
        this.moveOldDirectory();
        this.restart();
        return false;
    }

    private final void moveOldDirectory() {
        Disposer.dispose((Disposable)Database.Companion.getDatabase());
        File file = this.getDatabaseFile();
        String[] stringArray = new String[]{file.getName() + "-old-" + System.currentTimeMillis()};
        FileUtils.moveDirectory((File)file, (File)FileUtils.getFile((File)file.getParentFile(), (String[])stringArray));
    }

    private final void restart() {
        TermoraRestarter.scheduleRestart$default((TermoraRestarter)TermoraRestarter.Companion.getInstance(), null, (boolean)false, null, (int)4, null);
    }

    @NotNull
    public final File getDatabaseFile() {
        String[] stringArray = new String[]{"storage"};
        File file = FileUtils.getFile((File)Application.INSTANCE.getBaseDataDir(), (String[])stringArray);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getFile(...)");
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void ready$lambda$0(MigrationApplicationRunnerExtension this$0, CountDownLatch $countDownLatch) {
        try {
            this$0.openDatabase();
            this$0.openDoor();
            if (this$0.askMigrate()) {
                this$0.migrate();
                this$0.moveOldDirectory();
                this$0.restart();
            }
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            $countDownLatch.countDown();
        }
    }

    private static final MigrationApplicationRunnerExtension instance_delegate$lambda$0() {
        return new MigrationApplicationRunnerExtension();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0007\u001a\u00020\b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\r"}, d2={"Lapp/termora/plugins/migration/MigrationApplicationRunnerExtension$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "instance", "Lapp/termora/plugins/migration/MigrationApplicationRunnerExtension;", "getInstance", "()Lapp/termora/plugins/migration/MigrationApplicationRunnerExtension;", "instance$delegate", "Lkotlin/Lazy;", "migration"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MigrationApplicationRunnerExtension getInstance() {
            Lazy lazy = instance$delegate;
            return (MigrationApplicationRunnerExtension)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

