/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.SplitPaneUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u0010\u0011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00060\rR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lapp/termora/JSplitPaneWithZeroSizeDivider;", "Ljavax/swing/JPanel;", "splitPane", "Ljavax/swing/JSplitPane;", "topOffset", "Ljava/util/function/Supplier;", "", "<init>", "(Ljavax/swing/JSplitPane;Ljava/util/function/Supplier;)V", "dividerDragSize", "layeredPane", "Lapp/termora/JSplitPaneWithZeroSizeDivider$LayeredPane;", "divider", "Lapp/termora/JSplitPaneWithZeroSizeDivider$Divider;", "doLayout", "", "Divider", "LayeredPane", "termora"})
public final class JSplitPaneWithZeroSizeDivider
extends JPanel {
    @NotNull
    private final JSplitPane splitPane;
    @NotNull
    private final Supplier<Integer> topOffset;
    private final int dividerDragSize;
    @NotNull
    private final LayeredPane layeredPane;
    @NotNull
    private final Divider divider;

    public JSplitPaneWithZeroSizeDivider(@NotNull JSplitPane splitPane2, @NotNull Supplier<Integer> topOffset) {
        Intrinsics.checkNotNullParameter((Object)splitPane2, (String)"splitPane");
        Intrinsics.checkNotNullParameter(topOffset, (String)"topOffset");
        super(new BorderLayout());
        this.splitPane = splitPane2;
        this.topOffset = topOffset;
        this.dividerDragSize = 7;
        this.layeredPane = new LayeredPane();
        this.divider = new Divider();
        Component component = this.splitPane;
        Integer n = JLayeredPane.DEFAULT_LAYER;
        Intrinsics.checkNotNull((Object)n, (String)"null cannot be cast to non-null type kotlin.Any");
        this.layeredPane.add(component, n);
        Component component2 = this.divider;
        Integer n2 = JLayeredPane.PALETTE_LAYER;
        Intrinsics.checkNotNull((Object)n2, (String)"null cannot be cast to non-null type kotlin.Any");
        this.layeredPane.add(component2, n2);
        this.add((Component)this.layeredPane, "Center");
    }

    @Override
    public void doLayout() {
        super.doLayout();
        this.layeredPane.doLayout();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lapp/termora/JSplitPaneWithZeroSizeDivider$Divider;", "Ljavax/swing/JComponent;", "<init>", "(Lapp/termora/JSplitPaneWithZeroSizeDivider;)V", "dragging", "", "dragStartX", "", "initialDividerLocation", "splitPaneUI", "Lapp/termora/SplitPaneUI;", "getSplitPaneUI", "()Lapp/termora/SplitPaneUI;", "paint", "", "g", "Ljava/awt/Graphics;", "termora"})
    private final class Divider
    extends JComponent {
        private boolean dragging;
        private int dragStartX;
        private int initialDividerLocation;

        public Divider() {
            this.setCursor(Cursor.getPredefinedCursor(11));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        dragging = true;
                        dragStartX = e.getXOnScreen();
                        initialDividerLocation = JSplitPaneWithZeroSizeDivider.this.splitPane.getDividerLocation();
                        this.getSplitPaneUI().startDragging();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (SwingUtilities.isLeftMouseButton(e)) {
                        if (dragging) {
                            int deltaX = e.getXOnScreen() - dragStartX;
                            int newLocation = initialDividerLocation + deltaX;
                            this.getSplitPaneUI().finishDraggingTo(newLocation);
                        }
                        dragging = false;
                    }
                }
            });
            this.addMouseMotionListener(new MouseMotionAdapter(){

                @Override
                public void mouseDragged(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (dragging) {
                        int deltaX = e.getXOnScreen() - dragStartX;
                        int newLocation = initialDividerLocation + deltaX;
                        this.getSplitPaneUI().dragDividerTo(newLocation);
                    }
                }
            });
        }

        private final SplitPaneUI getSplitPaneUI() {
            javax.swing.plaf.SplitPaneUI splitPaneUI = JSplitPaneWithZeroSizeDivider.this.splitPane.getUI();
            Intrinsics.checkNotNull((Object)splitPaneUI, (String)"null cannot be cast to non-null type app.termora.SplitPaneUI");
            return (SplitPaneUI)((Object)splitPaneUI);
        }

        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            g.setColor(UIManager.getColor("controlShadow"));
            g.fillRect(this.getWidth() / 2, 0, 1, this.getHeight());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lapp/termora/JSplitPaneWithZeroSizeDivider$LayeredPane;", "Ljavax/swing/JLayeredPane;", "<init>", "(Lapp/termora/JSplitPaneWithZeroSizeDivider;)V", "w", "", "getW", "()I", "doLayout", "", "paint", "g", "Ljava/awt/Graphics;", "termora"})
    private final class LayeredPane
    extends JLayeredPane {
        private final int getW() {
            return (JSplitPaneWithZeroSizeDivider.this.dividerDragSize - 1) / 2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doLayout() {
            Object object = this.getTreeLock();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getTreeLock(...)");
            Object object2 = object;
            JSplitPaneWithZeroSizeDivider jSplitPaneWithZeroSizeDivider = JSplitPaneWithZeroSizeDivider.this;
            Object object3 = object2;
            synchronized (object3) {
                boolean bl = false;
                Component[] componentArray = this.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                for (Component c : componentArray) {
                    if (Intrinsics.areEqual((Object)c, (Object)jSplitPaneWithZeroSizeDivider.divider)) {
                        c.setVisible(jSplitPaneWithZeroSizeDivider.splitPane.getLeftComponent().isVisible());
                        int n = jSplitPaneWithZeroSizeDivider.splitPane.getDividerLocation() - this.getW();
                        Object t = jSplitPaneWithZeroSizeDivider.topOffset.get();
                        Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                        int n2 = ((Number)t).intValue();
                        int n3 = jSplitPaneWithZeroSizeDivider.dividerDragSize;
                        int n4 = this.getHeight();
                        Object t2 = jSplitPaneWithZeroSizeDivider.topOffset.get();
                        Intrinsics.checkNotNullExpressionValue(t2, (String)"get(...)");
                        c.setBounds(n, n2, n3, n4 - ((Number)t2).intValue());
                        continue;
                    }
                    c.setBounds(0, 0, this.getWidth(), this.getHeight());
                }
                Unit unit = Unit.INSTANCE;
            }
        }

        @Override
        public void paint(@NotNull Graphics g) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            super.paint(g);
            if (JSplitPaneWithZeroSizeDivider.this.divider.isVisible()) {
                g.setColor(UIManager.getColor("controlShadow"));
                int n = JSplitPaneWithZeroSizeDivider.this.splitPane.getDividerLocation();
                Object t = JSplitPaneWithZeroSizeDivider.this.topOffset.get();
                Intrinsics.checkNotNullExpressionValue(t, (String)"get(...)");
                g.fillRect(n, 0, 1, ((Number)t).intValue());
            }
        }
    }
}

