/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicColor;
import app.termora.Graphics2DKt;
import app.termora.TerminalTab;
import app.termora.TerminalTabbed;
import app.termora.TerminalTabbedManager;
import app.termora.TermoraFrame;
import app.termora.TermoraFrameManager;
import app.termora.TermoraLayout;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProviders;
import app.termora.database.DatabaseManager;
import app.termora.keymap.KeyShortcut;
import app.termora.keymap.Keymap;
import app.termora.keymap.KeymapManager;
import app.termora.keymap.Shortcut;
import com.formdev.flatlaf.extras.components.FlatTabbedPane;
import com.formdev.flatlaf.ui.FlatTabbedPaneUI;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.EventObject;
import java.util.List;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.plaf.TabbedPaneUI;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002:\u0004+,-.B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\"H\u0014J\u0010\u0010#\u001a\u00020\u00182\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020%H\u0016J\b\u0010(\u001a\u00020\u001fH\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010'\u001a\u00020%H\u0016R\u0012\u0010\u0005\u001a\u00060\u0006R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0019R\u001e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0018@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001c\u0010\u001d\u00a8\u0006/"}, d2={"Lapp/termora/MyTabbedPane;", "Lcom/formdev/flatlaf/extras/components/FlatTabbedPane;", "Lapp/termora/Disposable;", "<init>", "()V", "dragMouseAdaptor", "Lapp/termora/MyTabbedPane$DragMouseAdaptor;", "terminalTabbedManager", "Lapp/termora/TerminalTabbedManager;", "getTerminalTabbedManager", "()Lapp/termora/TerminalTabbedManager;", "owner", "Lapp/termora/TermoraFrame;", "getOwner", "()Lapp/termora/TermoraFrame;", "keymap", "Lapp/termora/keymap/Keymap;", "getKeymap", "()Lapp/termora/keymap/Keymap;", "tabOrder", "", "getTabOrder", "()Ljava/lang/String;", "isScreen", "", "()Z", "value", "isSwitchTabMode", "setSwitchTabMode", "(Z)V", "initEvents", "", "processMouseEvent", "e", "Ljava/awt/event/MouseEvent;", "isShiftPressedOnly", "modifiersEx", "", "setSelectedIndex", "index", "updateUI", "getIconAt", "Ljavax/swing/Icon;", "MyAWTEventListener", "DragMouseAdaptor", "MyMyTabbedPaneUI", "MyIcon", "termora"})
public final class MyTabbedPane
extends FlatTabbedPane
implements Disposable {
    @NotNull
    private final DragMouseAdaptor dragMouseAdaptor = new DragMouseAdaptor();
    private boolean isSwitchTabMode;

    public MyTabbedPane() {
        this.setFocusable(false);
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"focusColor", (Object)new DynamicColor("TabbedPane.background")), TuplesKt.to((Object)"hoverColor", (Object)new DynamicColor("TabbedPane.background"))};
        this.setStyleMap(MapsKt.mapOf((Pair[])pairArray));
        this.initEvents();
    }

    private final TerminalTabbedManager getTerminalTabbedManager() {
        return new AnActionEvent((Object)this, "", new EventObject(this)).getData(DataProviders.INSTANCE.getTerminalTabbedManager());
    }

    private final TermoraFrame getOwner() {
        TermoraFrame termoraFrame = new AnActionEvent((Object)this, "", new EventObject(this)).getData(DataProviders.INSTANCE.getTermoraFrame());
        Intrinsics.checkNotNull((Object)termoraFrame, (String)"null cannot be cast to non-null type app.termora.TermoraFrame");
        return termoraFrame;
    }

    private final Keymap getKeymap() {
        return KeymapManager.Companion.getInstance().getActiveKeymap();
    }

    private final String getTabOrder() {
        return DatabaseManager.Companion.getInstance().getAppearance().getTabOrder();
    }

    private final boolean isScreen() {
        return TermoraLayout.Companion.getLayout() == TermoraLayout.Screen;
    }

    private final void setSwitchTabMode(boolean value) {
        if (Intrinsics.areEqual((Object)this.getTabOrder(), (Object)"Always")) {
            if (!this.isSwitchTabMode) {
                this.isSwitchTabMode = true;
                this.repaint();
            }
            return;
        }
        if (Intrinsics.areEqual((Object)this.getTabOrder(), (Object)"Hide")) {
            if (this.isSwitchTabMode) {
                this.isSwitchTabMode = false;
                this.repaint();
            }
            return;
        }
        if (Intrinsics.areEqual((Object)this.getTabOrder(), (Object)"AsNeed") && this.isSwitchTabMode != value) {
            this.isSwitchTabMode = value;
            this.repaint();
        }
    }

    private final void initEvents() {
        this.addMouseListener(this.dragMouseAdaptor);
        this.addMouseMotionListener(this.dragMouseAdaptor);
        MyAWTEventListener awtEventListener2 = new MyAWTEventListener();
        this.getToolkit().addAWTEventListener(awtEventListener2, 72L);
        Disposer.register(this, new Disposable(this, awtEventListener2){
            final /* synthetic */ MyTabbedPane this$0;
            final /* synthetic */ MyAWTEventListener $awtEventListener;
            {
                this.this$0 = $receiver;
                this.$awtEventListener = $awtEventListener;
            }

            public void dispose() {
                this.this$0.getToolkit().removeAWTEventListener(this.$awtEventListener);
            }
        });
    }

    protected void processMouseEvent(@NotNull MouseEvent e) {
        int index;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e.getID() == 500 && SwingUtilities.isLeftMouseButton(e) && this.isShiftPressedOnly(e.getModifiersEx())) {
            int index2 = this.indexAtLocation(e.getX(), e.getY());
            if (index2 >= 0) {
                BiConsumer biConsumer = this.getTabCloseCallback();
                if (biConsumer != null) {
                    biConsumer.accept(this, index2);
                }
                return;
            }
        } else if (e.getID() == 501 && this.isShiftPressedOnly(e.getModifiersEx()) && (index = this.indexAtLocation(e.getX(), e.getY())) >= 0) {
            return;
        }
        super.processMouseEvent(e);
    }

    private final boolean isShiftPressedOnly(int modifiersEx) {
        return (modifiersEx & 0x200) == 0 && (modifiersEx & 0x2000) == 0 && (modifiersEx & 0x80) == 0 && (modifiersEx & 0x40) != 0;
    }

    public void setSelectedIndex(int index) {
        int oldIndex = this.getSelectedIndex();
        super.setSelectedIndex(index);
        this.firePropertyChange("selectedIndex", oldIndex, index);
    }

    public void updateUI() {
        super.updateUI();
        this.setUI((TabbedPaneUI)((Object)new MyMyTabbedPaneUI()));
    }

    @Nullable
    public Icon getIconAt(int index) {
        if (this.isSwitchTabMode) {
            Icon icon = super.getIconAt(index);
            Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"getIconAt(...)");
            return new MyIcon(icon, index, this.getSelectedIndex() == index);
        }
        return super.getIconAt(index);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\bH\u0002J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u001eH\u0016J\n\u0010\u001f\u001a\u0004\u0018\u00010\fH\u0002J\u0018\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\"H\u0002J \u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lapp/termora/MyTabbedPane$DragMouseAdaptor;", "Ljava/awt/event/MouseAdapter;", "Ljava/awt/KeyEventDispatcher;", "<init>", "(Lapp/termora/MyTabbedPane;)V", "mousePressedPoint", "Ljava/awt/Point;", "tabIndex", "", "cancelled", "", "window", "Ljava/awt/Window;", "terminalTab", "Lapp/termora/TerminalTab;", "isDragging", "lastVisitTabIndex", "releasedPoint", "mousePressed", "", "e", "Ljava/awt/event/MouseEvent;", "mouseDragged", "startDrag", "stopDrag", "mouseReleased", "createTabImage", "Ljava/awt/image/BufferedImage;", "index", "dispatchKeyEvent", "Ljava/awt/event/KeyEvent;", "getTopMostWindowUnderMouse", "dragToAnotherWindow", "oldFrame", "Lapp/termora/TermoraFrame;", "frame", "moveTab", "terminalTabbedManager", "Lapp/termora/TerminalTabbedManager;", "tab", "termora"})
    @SourceDebugExtension(value={"SMAP\nMyTabbedPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MyTabbedPane.kt\napp/termora/MyTabbedPane$DragMouseAdaptor\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,409:1\n1#2:410\n*E\n"})
    private final class DragMouseAdaptor
    extends MouseAdapter
    implements KeyEventDispatcher {
        @NotNull
        private Point mousePressedPoint = new Point();
        private int tabIndex = -1;
        private boolean cancelled;
        @Nullable
        private Window window;
        @Nullable
        private TerminalTab terminalTab;
        private boolean isDragging;
        private int lastVisitTabIndex = -1;
        @NotNull
        private Point releasedPoint = new Point();

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            int index = MyTabbedPane.this.indexAtLocation(e.getX(), e.getY());
            if (index < 0 || !MyTabbedPane.this.isTabClosable(index).booleanValue()) {
                this.tabIndex = -1;
                this.mousePressedPoint = new Point();
                return;
            }
            this.tabIndex = index;
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            this.mousePressedPoint = point;
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (this.isDragging) {
                Window window = this.window;
                if (window != null) {
                    window.setLocation(e.getLocationOnScreen());
                }
                this.lastVisitTabIndex = MyTabbedPane.this.indexAtLocation(e.getX(), e.getY());
            } else if (this.tabIndex >= 0) {
                int diff = 5;
                if (Math.abs(this.mousePressedPoint.y - e.getY()) >= diff || Math.abs(this.mousePressedPoint.x - e.getX()) >= diff) {
                    this.startDrag(e);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void startDrag(MouseEvent e) {
            void it;
            TerminalTab terminalTab;
            JDialog jDialog;
            if (this.isDragging) {
                return;
            }
            TerminalTabbedManager terminalTabbedManager = MyTabbedPane.this.getTerminalTabbedManager();
            if (terminalTabbedManager == null) {
                return;
            }
            TerminalTabbedManager terminalTabbedManager2 = terminalTabbedManager;
            JDialog it2 = jDialog = new JDialog(MyTabbedPane.this.getOwner());
            boolean $i$a$-also-MyTabbedPane$DragMouseAdaptor$startDrag$window$22 = false;
            this.window = it2;
            JDialog window = jDialog;
            window.setUndecorated(true);
            BufferedImage image = this.createTabImage(this.tabIndex);
            window.setSize(new Dimension(image.getWidth(), image.getHeight()));
            window.add(new JLabel(new ImageIcon(image)));
            window.setLocation(e.getLocationOnScreen());
            window.addWindowListener(new WindowAdapter(this){
                final /* synthetic */ DragMouseAdaptor this$0;
                {
                    this.this$0 = $receiver;
                }

                public void windowClosed(WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.this$0);
                }

                public void windowOpened(WindowEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.this$0);
                }
            });
            TerminalTab $i$a$-also-MyTabbedPane$DragMouseAdaptor$startDrag$window$22 = terminalTab = terminalTabbedManager2.getTerminalTabs().get(this.tabIndex);
            TerminalTabbedManager terminalTabbedManager3 = terminalTabbedManager2;
            boolean bl = false;
            this.terminalTab = it;
            terminalTabbedManager3.closeTerminalTab(terminalTab, false);
            window.setVisible(true);
            this.isDragging = true;
            this.cancelled = false;
        }

        private final void stopDrag() {
            Window c;
            if (!this.isDragging) {
                return;
            }
            Window window = c = this.cancelled ? (Window)MyTabbedPane.this.getOwner() : this.getTopMostWindowUnderMouse();
            if (c == null) {
                TermoraFrame window2 = TermoraFrameManager.Companion.getInstance().createWindow();
                this.dragToAnotherWindow(MyTabbedPane.this.getOwner(), window2);
                window2.setLocation(this.releasedPoint);
                window2.setVisible(true);
            } else if (!Intrinsics.areEqual((Object)c, (Object)MyTabbedPane.this.getOwner()) && c instanceof TermoraFrame) {
                this.dragToAnotherWindow(MyTabbedPane.this.getOwner(), (TermoraFrame)c);
            } else {
                TerminalTab tab = this.terminalTab;
                TerminalTabbedManager terminalTabbedManager = MyTabbedPane.this.getTerminalTabbedManager();
                if (tab != null && terminalTabbedManager != null) {
                    this.moveTab(terminalTabbedManager, tab, this.lastVisitTabIndex);
                }
            }
            Window window3 = this.window;
            if (window3 != null) {
                window3.dispose();
            }
            this.isDragging = false;
            this.tabIndex = -1;
            this.cancelled = false;
            this.lastVisitTabIndex = -1;
        }

        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Point point = e.getPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getPoint(...)");
            this.releasedPoint = point;
            this.stopDrag();
        }

        private final BufferedImage createTabImage(int index) {
            Rectangle tabBounds = MyTabbedPane.this.getBoundsAt(index);
            BufferedImage image = new BufferedImage(tabBounds.width, tabBounds.height, 2);
            Graphics2D g2 = image.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            g2.translate(-tabBounds.x, -tabBounds.y);
            MyTabbedPane.this.paint(g2);
            g2.dispose();
            return image;
        }

        @Override
        public boolean dispatchKeyEvent(@NotNull KeyEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (e.getKeyCode() == 27) {
                this.cancelled = true;
                this.stopDrag();
                return true;
            }
            return false;
        }

        private final Window getTopMostWindowUnderMouse() {
            Point mouseLocation = MouseInfo.getPointerInfo().getLocation();
            TermoraFrame owner = MyTabbedPane.this.getOwner();
            if (owner.isVisible() && owner.getBounds().contains(mouseLocation)) {
                return owner;
            }
            Window[] windows = Window.getWindows();
            int n = windows.length + -1;
            if (0 <= n) {
                do {
                    Component topComponent;
                    int i;
                    Window window;
                    if (!((window = windows[i = n--]) instanceof TermoraFrame) || !((TermoraFrame)window).isVisible() || !((TermoraFrame)window).getBounds().contains(mouseLocation) || (topComponent = SwingUtilities.getDeepestComponentAt(window, mouseLocation.x - ((TermoraFrame)window).getX(), mouseLocation.y - ((TermoraFrame)window).getY())) == null) continue;
                    return SwingUtilities.getWindowAncestor(topComponent);
                } while (0 <= n);
            }
            return null;
        }

        private final void dragToAnotherWindow(TermoraFrame oldFrame, TermoraFrame frame) {
            TerminalTab terminalTab = this.terminalTab;
            if (terminalTab == null) {
                return;
            }
            TerminalTab tab = terminalTab;
            TerminalTabbed terminalTabbed = frame.getData(DataProviders.INSTANCE.getTerminalTabbed());
            if (terminalTabbed == null) {
                return;
            }
            TerminalTabbed tabbedManager = terminalTabbed;
            MyTabbedPane myTabbedPane = frame.getData(DataProviders.INSTANCE.getTabbedPane$termora());
            if (myTabbedPane == null) {
                return;
            }
            MyTabbedPane tabbedPane = myTabbedPane;
            Point location = new Point(MouseInfo.getPointerInfo().getLocation());
            SwingUtilities.convertPointFromScreen(location, (Component)((Object)tabbedPane));
            int index = tabbedPane.indexAtLocation(location.x, location.y);
            this.moveTab(tabbedManager, tab, index);
            if (frame.hasFocus()) {
                return;
            }
            SwingUtilities.invokeLater(() -> DragMouseAdaptor.dragToAnotherWindow$lambda$0(frame, tabbedPane));
        }

        private final void moveTab(TerminalTabbedManager terminalTabbedManager, TerminalTab tab, int lastVisitTabIndex) {
            if (this.cancelled) {
                TerminalTabbedManager.addTerminalTab$default(terminalTabbedManager, this.tabIndex, tab, false, 4, null);
            } else if (lastVisitTabIndex > 0) {
                TerminalTabbedManager.addTerminalTab$default(terminalTabbedManager, lastVisitTabIndex, tab, false, 4, null);
            } else if (lastVisitTabIndex == 0) {
                TerminalTabbedManager.addTerminalTab$default(terminalTabbedManager, 1, tab, false, 4, null);
            } else {
                TerminalTabbedManager.addTerminalTab$default(terminalTabbedManager, tab, false, 2, null);
            }
        }

        private static final void dragToAnotherWindow$lambda$0(TermoraFrame $frame, MyTabbedPane $tabbedPane) {
            block0: {
                $frame.requestFocus();
                Component component = $tabbedPane.getSelectedComponent();
                if (component == null) break block0;
                component.requestFocusInWindow();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lapp/termora/MyTabbedPane$MyAWTEventListener;", "Ljava/awt/event/AWTEventListener;", "<init>", "(Lapp/termora/MyTabbedPane;)V", "eventDispatched", "", "event", "Ljava/awt/AWTEvent;", "termora"})
    private final class MyAWTEventListener
    implements AWTEventListener {
        @Override
        public void eventDispatched(@NotNull AWTEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (event instanceof KeyEvent) {
                List<Shortcut> shortcuts;
                if (MyTabbedPane.this.isSwitchTabMode) {
                    MyTabbedPane.this.setSwitchTabMode(false);
                }
                if ((shortcuts = MyTabbedPane.this.getKeymap().getShortcut("SwitchTabAction")).isEmpty()) {
                    return;
                }
                Object object = CollectionsKt.first(shortcuts);
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type app.termora.keymap.KeyShortcut");
                KeyShortcut shortcut = (KeyShortcut)object;
                int modifiers = KeyStroke.getKeyStroke(((KeyEvent)event).getKeyCode(), ((KeyEvent)event).getModifiersEx()).getModifiers();
                if (shortcut.getKeyStroke().getModifiers() != modifiers) {
                    return;
                }
                if (!Intrinsics.areEqual((Object)SwingUtilities.getWindowAncestor(((KeyEvent)event).getComponent()), (Object)MyTabbedPane.this.getOwner())) {
                    return;
                }
                if (!MyTabbedPane.this.isSwitchTabMode) {
                    MyTabbedPane.this.setSwitchTabMode(true);
                }
            } else if (event instanceof WindowEvent) {
                if (((WindowEvent)event).getID() == 208 || ((WindowEvent)event).getID() == 206) {
                    if (MyTabbedPane.this.isSwitchTabMode) {
                        MyTabbedPane.this.setSwitchTabMode(false);
                    }
                } else if (((WindowEvent)event).getID() == 207 || ((WindowEvent)event).getID() == 205) {
                    MyTabbedPane.this.setSwitchTabMode(MyTabbedPane.this.isSwitchTabMode);
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0016J\b\u0010\u0011\u001a\u00020\u0004H\u0016J\b\u0010\u0012\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lapp/termora/MyTabbedPane$MyIcon;", "Ljavax/swing/Icon;", "icon", "tabIndex", "", "isSelected", "", "<init>", "(Lapp/termora/MyTabbedPane;Ljavax/swing/Icon;IZ)V", "paintIcon", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "getIconWidth", "getIconHeight", "termora"})
    private final class MyIcon
    implements Icon {
        @NotNull
        private final Icon icon;
        private final int tabIndex;
        private final boolean isSelected;

        public MyIcon(Icon icon, int tabIndex, boolean isSelected) {
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            this.icon = icon;
            this.tabIndex = tabIndex;
            this.isSelected = isSelected;
        }

        @Override
        public void paintIcon(@NotNull Component c, @NotNull Graphics g, int x, int y) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            if (MyTabbedPane.this.isScreen() && this.tabIndex == 0) {
                this.icon.paintIcon(c, g, x, y);
                return;
            }
            if (!MyTabbedPane.this.isSwitchTabMode) {
                this.icon.paintIcon(c, g, x, y);
                return;
            }
            if (!(g instanceof Graphics2D)) {
                return;
            }
            Graphics2DKt.save((Graphics2D)g);
            Graphics2DKt.setupAntialiasing((Graphics2D)g);
            FontMetrics fm = g.getFontMetrics(((Graphics2D)g).getFont());
            String text = String.valueOf(this.tabIndex + 1);
            int textWidth = fm.stringWidth(text);
            int textHeight = fm.getAscent();
            int centerX = x + (this.icon.getIconWidth() - textWidth) / 2;
            int centerY = y + (this.icon.getIconHeight() + textHeight) / 2 - 1;
            ((Graphics2D)g).setColor(c.getForeground());
            ((Graphics2D)g).drawString(text, centerX, centerY);
            Graphics2DKt.restore((Graphics2D)g);
        }

        @Override
        public int getIconWidth() {
            return this.icon.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.icon.getIconHeight();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0014\u00a8\u0006\u0014"}, d2={"Lapp/termora/MyTabbedPane$MyMyTabbedPaneUI;", "Lcom/formdev/flatlaf/ui/FlatTabbedPaneUI;", "<init>", "(Lapp/termora/MyTabbedPane;)V", "paintIcon", "", "g", "Ljava/awt/Graphics;", "tabPlacement", "", "tabIndex", "icon", "Ljavax/swing/Icon;", "iconRect", "Ljava/awt/Rectangle;", "isSelected", "", "createMoreTabsButton", "Ljavax/swing/JButton;", "MyMoreTabsButton", "termora"})
    private final class MyMyTabbedPaneUI
    extends FlatTabbedPaneUI {
        protected void paintIcon(@NotNull Graphics g, int tabPlacement, int tabIndex, @NotNull Icon icon, @Nullable Rectangle iconRect, boolean isSelected) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
            super.paintIcon(g, tabPlacement, tabIndex, (Icon)new MyIcon(icon, tabIndex, isSelected), iconRect, isSelected);
        }

        @NotNull
        protected JButton createMoreTabsButton() {
            return (JButton)((Object)new MyMoreTabsButton());
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\t"}, d2={"Lapp/termora/MyTabbedPane$MyMyTabbedPaneUI$MyMoreTabsButton;", "Lcom/formdev/flatlaf/ui/FlatTabbedPaneUI$FlatMoreTabsButton;", "Lcom/formdev/flatlaf/ui/FlatTabbedPaneUI;", "<init>", "(Lapp/termora/MyTabbedPane$MyMyTabbedPaneUI;)V", "createTabMenuItem", "Ljavax/swing/JMenuItem;", "tabIndex", "", "termora"})
        private final class MyMoreTabsButton
        extends FlatTabbedPaneUI.FlatMoreTabsButton {
            public MyMoreTabsButton() {
                super((FlatTabbedPaneUI)MyMyTabbedPaneUI.this);
            }

            @Nullable
            protected JMenuItem createTabMenuItem(int tabIndex) {
                JMenuItem item = super.createTabMenuItem(tabIndex);
                if (tabIndex == 0 && MyTabbedPane.this.isScreen()) {
                    item.setText(Application.INSTANCE.getName());
                }
                return item;
            }
        }
    }
}

