/*
 * Decompiled with CFR 0.152.
 */
package app.termora.account;

import app.termora.Application;
import app.termora.ApplicationRunnerExtension;
import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.ResponseException;
import app.termora.ScopeKt;
import app.termora.account.Account;
import app.termora.account.AccountExtension;
import app.termora.account.AccountHttp;
import app.termora.account.AccountManager;
import app.termora.account.PullService;
import app.termora.account.PushService;
import app.termora.account.PushService$PushDataRequest$;
import app.termora.account.SyncService;
import app.termora.database.Data;
import app.termora.database.DatabaseChangedExtension;
import app.termora.plugin.DispatchThread;
import app.termora.plugin.Extension;
import app.termora.plugin.internal.extension.DynamicExtensionHandler;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002\u001f B\t\b\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\n\u001a\u00020\tH\u0082@\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\f\u001a\u00020\tH\u0002J\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0010\u0010\u0012\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\b\u0010\u0013\u001a\u00020\tH\u0016J(\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\tR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lapp/termora/account/PushService;", "Lapp/termora/account/SyncService;", "Lapp/termora/Disposable;", "Lapp/termora/ApplicationRunnerExtension;", "Lapp/termora/database/DatabaseChangedExtension;", "<init>", "()V", "channel", "Lkotlinx/coroutines/channels/Channel;", "", "schedule", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "synchronize", "getUnsyncedData", "", "Lapp/termora/database/Data;", "data", "delete", "push", "ready", "onDataChanged", "id", "", "type", "action", "Lapp/termora/database/DatabaseChangedExtension$Action;", "source", "Lapp/termora/database/DatabaseChangedExtension$Source;", "getDispatchThread", "Lapp/termora/plugin/DispatchThread;", "trigger", "Companion", "PushDataRequest", "termora"})
@SourceDebugExtension(value={"SMAP\nPushService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PushService.kt\napp/termora/account/PushService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Json.kt\nkotlinx/serialization/json/Json\n*L\n1#1,259:1\n774#2:260\n865#2,2:261\n827#2:263\n855#2,2:264\n1#3:266\n205#4:267\n222#4:268\n222#4:269\n*S KotlinDebug\n*F\n+ 1 PushService.kt\napp/termora/account/PushService\n*L\n95#1:260\n95#1:261,2\n96#1:263\n96#1:264,2\n154#1:267\n178#1:268\n196#1:269\n*E\n"})
public final class PushService
extends SyncService
implements Disposable,
ApplicationRunnerExtension,
DatabaseChangedExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Channel<Unit> channel;
    private static final Logger log = LoggerFactory.getLogger(PushService.class);

    private PushService() {
        Disposer.register(this, DynamicExtensionHandler.Companion.getInstance().register(AccountExtension.class, (Extension)new AccountExtension(){

            @Override
            public void onAccountChanged(Account oldAccount, Account newAccount) {
                Intrinsics.checkNotNullParameter((Object)oldAccount, (String)"oldAccount");
                Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
                if (oldAccount.isLocally() && !newAccount.isLocally()) {
                    this.trigger();
                }
            }
        }));
        this.channel = ChannelKt.Channel$default((int)-1, null, null, (int)6, null);
    }

    /*
     * Unable to fully structure code
     */
    private final Object schedule(Continuation<? super Unit> $completion) {
        if (!($completion instanceof schedule.1)) ** GOTO lbl-1000
        var4_2 = $completion;
        if ((var4_2.label & -2147483648) != 0) {
            var4_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                /* synthetic */ Object result;
                final /* synthetic */ PushService this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return PushService.access$schedule(this.this$0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var5_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $continuation.label = 1;
                v0 = this.channel.receiveCatching-JP2dKIU((Continuation)$continuation);
                ** if (v0 != var5_4) goto lbl18
lbl17:
                // 1 sources

                return var5_4;
lbl18:
                // 1 sources

                ** GOTO lbl24
            }
            case 1: {
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = ((ChannelResult)$result).unbox-impl();
lbl24:
                    // 2 sources

                    if (ChannelResult.isSuccess-impl((Object)v0)) {
                        this.synchronize();
                    }
                }
                catch (Exception e) {
                    if (!PushService.log.isErrorEnabled()) ** GOTO lbl30
                    PushService.log.error(e.getMessage(), (Throwable)e);
                }
lbl30:
                // 3 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void synchronize() {
        if (this.isFreePlan()) {
            return;
        }
        List<Data> list = this.getUnsyncedData();
        for (Data data : list) {
            try {
                this.synchronize(data);
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<Data> getUnsyncedData() {
        void $this$filterNotTo$iv$iv;
        Data it;
        Iterable $this$filterTo$iv$iv;
        Set<String> ownerIds = this.getAccountManager().getOwnerIds();
        Iterable $this$filter$iv = this.getDatabaseManager().unsyncedData();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Data)element$iv$iv;
            boolean bl = false;
            if (!ownerIds.contains(it.getOwnerId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filterNot = false;
        $this$filterTo$iv$iv = $this$filterNot$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = (Data)element$iv$iv;
            boolean bl = false;
            if (AccountManager.Companion.isLocally(it.getOwnerId())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void synchronize(Data data) {
        Lock lock = this.getSyncLock();
        lock.lock();
        try {
            boolean bl = false;
            if (data.getDeleted()) {
                this.delete(data);
            } else {
                this.push(data);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private final void delete(Data data) {
        Request request = Request.Builder.delete$default((Request.Builder)new Request.Builder().url(this.getAccountManager().getServer() + "/v1/data/" + data.getId() + "?ownerId=" + data.getOwnerId() + "&ownerType=" + data.getOwnerType()), null, (int)1, null).build();
        try {
            AccountHttp.execute$default(AccountHttp.INSTANCE, null, request, 1, null);
        }
        catch (Exception e) {
            if (e instanceof ResponseException && ((ResponseException)e).getCode() == 403 && Intrinsics.areEqual((Object)data.getOwnerType(), (Object)"Team")) {
                this.getAccountManager().refreshAccount();
            }
            throw e;
        }
        SyncService.updateData$default(this, data.getId(), true, null, null, 12, null);
        if (log.isInfoEnabled()) {
            log.info("\u6570\u636e: {} \u5df2\u4ece\u4e91\u7aef\u5220\u9664", (Object)data.getId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void push(Data data) {
        Json version;
        JsonObject json;
        void this_$iv;
        boolean $i$f$decodeFromString;
        Object string$iv;
        Object it;
        void this_$iv2;
        String encryptedData = this.encryptData(data.getId(), data.getData(), data.getOwnerId());
        if (StringsKt.isBlank((CharSequence)encryptedData)) {
            if (log.isErrorEnabled()) {
                log.error("\u6570\u636e: {} \u6ca1\u6709\u627e\u5230\u5bf9\u5e94 ownerId \u7684\u5bc6\u94a5\uff0c\u6b64\u6570\u636e\u5c06\u6807\u8bb0\u4e3a\u5df2\u540c\u6b65", (Object)data.getId());
            }
            SyncService.updateData$default(this, data.getId(), true, null, null, 12, null);
            return;
        }
        PushDataRequest requestData = new PushDataRequest(data.getId(), data.getOwnerId(), data.getOwnerType(), data.getVersion(), data.getType(), encryptedData);
        Request.Builder builder2 = new Request.Builder().url(this.getAccountManager().getServer() + "/v1/data/push");
        Json json2 = Application.INSTANCE.getOhMyJson();
        PushDataRequest value$iv = requestData;
        boolean $i$f$encodeToString22 = false;
        this_$iv2.getSerializersModule();
        Request request = builder2.post(RequestBody.Companion.create(this_$iv2.encodeToString((SerializationStrategy)PushDataRequest.Companion.serializer(), (Object)value$iv), MediaType.Companion.get("application/json"))).build();
        Response response = AccountHttp.INSTANCE.getClient().newCall(request).execute();
        Object $i$f$encodeToString22 = (Closeable)response;
        Throwable throwable = null;
        try {
            String string;
            it = (Response)$i$f$encodeToString22;
            boolean bl = false;
            Closeable closeable = (Closeable)response.body();
            Throwable throwable2 = null;
            try {
                ResponseBody it2 = (ResponseBody)closeable;
                boolean bl2 = false;
                ResponseBody responseBody = it2;
                string = responseBody != null ? responseBody.string() : null;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            it = string;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)$i$f$encodeToString22, (Throwable)throwable);
        }
        Object text = it;
        $i$f$encodeToString22 = (CharSequence)text;
        if ($i$f$encodeToString22 == null || StringsKt.isBlank((CharSequence)$i$f$encodeToString22)) {
            throw new ResponseException(response.code(), "response body is empty", response);
        }
        if (response.code() == 403) {
            if (log.isWarnEnabled()) {
                log.warn("\u6570\u636e: {} \u6ca1\u6709\u6743\u9650\u63a8\u9001\u5230\u4e91\u7aef\uff0c\u6b64\u6570\u636e\u5c06\u5728\u4e0b\u6b21\u4fee\u6539\u65f6\u63a8\u9001", (Object)data.getId());
            }
            SyncService.updateData$default(this, data.getId(), true, data.getVersion(), null, 8, null);
            if (Intrinsics.areEqual((Object)data.getOwnerType(), (Object)"Team")) {
                this.getAccountManager().refreshAccount();
            }
            return;
        }
        if (response.code() == 409) {
            throwable = Application.INSTANCE.getOhMyJson();
            string$iv = text;
            $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            json = (JsonObject)this_$iv.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), (String)string$iv);
            JsonElement jsonElement = (JsonElement)json.get((Object)"data");
            Long l = jsonElement != null && (jsonElement = JsonElementKt.getJsonObject((JsonElement)jsonElement)) != null && (jsonElement = (JsonElement)jsonElement.get((Object)"version")) != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? Long.valueOf(JsonElementKt.getLong((JsonPrimitive)jsonElement)) : (version = null);
            if (version == null && log.isWarnEnabled()) {
                log.warn("\u6570\u636e: {} \u63a8\u9001\u65f6\u7248\u672c\u51b2\u7a81\uff0c\u89e6\u53d1\u62c9\u53d6", (Object)data.getId());
            }
            PullService.Companion.getInstance().trigger();
            return;
        }
        if (!response.isSuccessful()) {
            throw new ResponseException(response.code(), response);
        }
        version = Application.INSTANCE.getOhMyJson();
        string$iv = text;
        $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        json = (JsonObject)this_$iv.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), (String)string$iv);
        JsonElement jsonElement = (JsonElement)json.get((Object)"version");
        long version2 = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? JsonElementKt.getLong((JsonPrimitive)jsonElement) : data.getVersion();
        SyncService.updateData$default(this, data.getId(), true, version2, null, 8, null);
        if (log.isInfoEnabled()) {
            log.info("\u6570\u636e: {} \u5df2\u63a8\u9001\u81f3\u4e91\u7aef", (Object)data.getId());
        }
    }

    @Override
    public void ready() {
        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PushService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
lbl6:
                        // 3 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.L$0 = $this$launch;
                            this.label = 1;
                            v0 = PushService.access$schedule(this.this$0, (Continuation)this);
                            if (v0 != var3_3) continue;
                            return var3_3;
                        }
                        break;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
                        ** GOTO lbl6
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PushService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var3_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)10, (DurationUnit)DurationUnit.SECONDS), (Continuation)((Continuation)this));
                        if (v0 == var3_3) {
                            return var3_3;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 4 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            this.L$0 = $this$launch;
                            this.label = 2;
                            v1 = PushService.access$getChannel$p(this.this$0).send((Object)Unit.INSTANCE, (Continuation)this);
                            if (v1 == var3_3) {
                                return var3_3;
                            }
                            ** GOTO lbl28
                        }
                        break;
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl28:
                        // 2 sources

                        this.L$0 = $this$launch;
                        this.label = 3;
                        v2 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1, (DurationUnit)DurationUnit.MINUTES), (Continuation)((Continuation)this));
                        if (v2 != var3_3) ** GOTO lbl16
                        return var3_3;
                    }
                    case 3: {
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
                        ** GOTO lbl16
                    }
                }
                return Unit.INSTANCE;
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Disposer.register(this, new Disposable(this){
            final /* synthetic */ PushService this$0;
            {
                this.this$0 = $receiver;
            }

            public void dispose() {
                SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)PushService.access$getChannel$p(this.this$0)), null, (int)1, null);
            }
        });
    }

    @Override
    public void onDataChanged(@NotNull String id, @NotNull String type, @NotNull DatabaseChangedExtension.Action action2, @NotNull DatabaseChangedExtension.Source source) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        if (source == DatabaseChangedExtension.Source.User) {
            this.trigger();
        }
    }

    @Override
    @NotNull
    public DispatchThread getDispatchThread() {
        return DispatchThread.BGT;
    }

    public final void trigger() {
        ChannelResult.isSuccess-impl((Object)this.channel.trySend-JP2dKIU((Object)Unit.INSTANCE));
    }

    public /* synthetic */ PushService(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ Object access$schedule(PushService $this, Continuation $completion) {
        return $this.schedule((Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ Channel access$getChannel$p(PushService $this) {
        return $this.channel;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/account/PushService$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/account/PushService;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PushService getInstance() {
            return (PushService)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(PushService.class), Companion::getInstance$lambda$0);
        }

        private static final PushService getInstance$lambda$0() {
            return new PushService(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 .2\u00020\u0001:\u0002-.B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bBU\b\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\n\u0010\u0010J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003JE\u0010\u001f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010#\u001a\u00020\rH\u00d6\u0001J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J%\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00002\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0001\u00a2\u0006\u0002\b,R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0012R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006/"}, d2={"Lapp/termora/account/PushService$PushDataRequest;", "", "objectId", "", "ownerId", "ownerType", "version", "", "type", "data", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;JLjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getObjectId", "()Ljava/lang/String;", "getOwnerId", "getOwnerType", "getVersion", "()J", "getType", "getData", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$termora", "$serializer", "Companion", "termora"})
    private static final class PushDataRequest {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String objectId;
        @NotNull
        private final String ownerId;
        @NotNull
        private final String ownerType;
        private final long version;
        @NotNull
        private final String type;
        @NotNull
        private final String data;

        public PushDataRequest(@NotNull String objectId, @NotNull String ownerId, @NotNull String ownerType, long version, @NotNull String type, @NotNull String data) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
            Intrinsics.checkNotNullParameter((Object)ownerType, (String)"ownerType");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            this.objectId = objectId;
            this.ownerId = ownerId;
            this.ownerType = ownerType;
            this.version = version;
            this.type = type;
            this.data = data;
        }

        @NotNull
        public final String getObjectId() {
            return this.objectId;
        }

        @NotNull
        public final String getOwnerId() {
            return this.ownerId;
        }

        @NotNull
        public final String getOwnerType() {
            return this.ownerType;
        }

        public final long getVersion() {
            return this.version;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        @NotNull
        public final String getData() {
            return this.data;
        }

        @NotNull
        public final String component1() {
            return this.objectId;
        }

        @NotNull
        public final String component2() {
            return this.ownerId;
        }

        @NotNull
        public final String component3() {
            return this.ownerType;
        }

        public final long component4() {
            return this.version;
        }

        @NotNull
        public final String component5() {
            return this.type;
        }

        @NotNull
        public final String component6() {
            return this.data;
        }

        @NotNull
        public final PushDataRequest copy(@NotNull String objectId, @NotNull String ownerId, @NotNull String ownerType, long version, @NotNull String type, @NotNull String data) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
            Intrinsics.checkNotNullParameter((Object)ownerType, (String)"ownerType");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            return new PushDataRequest(objectId, ownerId, ownerType, version, type, data);
        }

        public static /* synthetic */ PushDataRequest copy$default(PushDataRequest pushDataRequest, String string, String string2, String string3, long l, String string4, String string5, int n, Object object) {
            if ((n & 1) != 0) {
                string = pushDataRequest.objectId;
            }
            if ((n & 2) != 0) {
                string2 = pushDataRequest.ownerId;
            }
            if ((n & 4) != 0) {
                string3 = pushDataRequest.ownerType;
            }
            if ((n & 8) != 0) {
                l = pushDataRequest.version;
            }
            if ((n & 0x10) != 0) {
                string4 = pushDataRequest.type;
            }
            if ((n & 0x20) != 0) {
                string5 = pushDataRequest.data;
            }
            return pushDataRequest.copy(string, string2, string3, l, string4, string5);
        }

        @NotNull
        public String toString() {
            return "PushDataRequest(objectId=" + this.objectId + ", ownerId=" + this.ownerId + ", ownerType=" + this.ownerType + ", version=" + this.version + ", type=" + this.type + ", data=" + this.data + ")";
        }

        public int hashCode() {
            int result2 = this.objectId.hashCode();
            result2 = result2 * 31 + this.ownerId.hashCode();
            result2 = result2 * 31 + this.ownerType.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.version);
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + this.data.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PushDataRequest)) {
                return false;
            }
            PushDataRequest pushDataRequest = (PushDataRequest)other;
            if (!Intrinsics.areEqual((Object)this.objectId, (Object)pushDataRequest.objectId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ownerId, (Object)pushDataRequest.ownerId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ownerType, (Object)pushDataRequest.ownerType)) {
                return false;
            }
            if (this.version != pushDataRequest.version) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)pushDataRequest.type)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.data, (Object)pushDataRequest.data);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$termora(PushDataRequest self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.objectId);
            output.encodeStringElement(serialDesc, 1, self.ownerId);
            output.encodeStringElement(serialDesc, 2, self.ownerType);
            output.encodeLongElement(serialDesc, 3, self.version);
            output.encodeStringElement(serialDesc, 4, self.type);
            output.encodeStringElement(serialDesc, 5, self.data);
        }

        public /* synthetic */ PushDataRequest(int seen0, String objectId, String ownerId, String ownerType, long version, String type, String data, SerializationConstructorMarker serializationConstructorMarker) {
            if (63 != (0x3F & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)63, (SerialDescriptor)PushDataRequest$$serializer.INSTANCE.getDescriptor());
            }
            this.objectId = objectId;
            this.ownerId = ownerId;
            this.ownerType = ownerType;
            this.version = version;
            this.type = type;
            this.data = data;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lapp/termora/account/PushService$PushDataRequest$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lapp/termora/account/PushService$PushDataRequest;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<PushDataRequest> serializer() {
                return (KSerializer)PushDataRequest$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

