/*
 * Decompiled with CFR 0.152.
 */
package app.termora.account;

import app.termora.AES;
import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.PBKDF2;
import app.termora.RSA;
import app.termora.ResponseException;
import app.termora.account.Account;
import app.termora.account.AccountHttp;
import app.termora.account.AccountManager;
import app.termora.account.Server;
import app.termora.account.ServerManager$LoginResponse$;
import app.termora.account.ServerManager$MeResponse$;
import app.termora.account.ServerManager$MeTeam$;
import app.termora.account.ServerManager$ServerInfo$;
import app.termora.account.Subscription;
import app.termora.account.Subscription$;
import app.termora.account.Team;
import app.termora.account.TeamRole;
import java.io.Closeable;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.EnumsKt;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001b2\u00020\u0001:\u0005\u001b\u001c\u001d\u001e\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fJ(\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\rH\u0002J0\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\u000f2\u0006\u0010\u001a\u001a\u00020\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006 "}, d2={"Lapp/termora/account/ServerManager;", "", "<init>", "()V", "isLoggingIn", "Ljava/util/concurrent/atomic/AtomicBoolean;", "accountManager", "Lapp/termora/account/AccountManager;", "getAccountManager", "()Lapp/termora/account/AccountManager;", "login", "", "server", "Lapp/termora/account/Server;", "username", "", "password", "mfa", "doLogin", "getServerInfo", "Lapp/termora/account/ServerManager$ServerInfo;", "callLogin", "Lapp/termora/account/ServerManager$LoginResponse;", "serverInfo", "callMe", "Lapp/termora/account/ServerManager$MeResponse;", "accessToken", "Companion", "ServerInfo", "LoginResponse", "MeResponse", "MeTeam", "termora"})
@SourceDebugExtension(value={"SMAP\nServerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerManager.kt\napp/termora/account/ServerManager\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,171:1\n222#2:172\n205#2:173\n222#2:175\n222#2:176\n1#3:174\n*S KotlinDebug\n*F\n+ 1 ServerManager.kt\napp/termora/account/ServerManager\n*L\n106#1:172\n118#1:173\n138#1:175\n148#1:176\n*E\n"})
public final class ServerManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicBoolean isLoggingIn = new AtomicBoolean(false);

    private ServerManager() {
    }

    private final AccountManager getAccountManager() {
        return AccountManager.Companion.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void login(@NotNull Server server, @NotNull String username, @NotNull String password, @NotNull String mfa) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)mfa, (String)"mfa");
        if (!this.getAccountManager().isLocally()) {
            throw new IllegalStateException("Already logged in");
        }
        if (!this.isLoggingIn.compareAndSet(false, true)) {
            throw new IllegalStateException("Logging in");
        }
        try {
            this.doLogin(server, username, password, mfa);
        }
        finally {
            this.isLoggingIn.compareAndSet(true, false);
        }
    }

    private final void doLogin(Server server, String username, String password, String mfa) {
        ServerInfo serverInfo = this.getServerInfo(server);
        LoginResponse loginResponse = this.callLogin(serverInfo, server, username, password, mfa);
        MeResponse meResponse = this.callMe(server.getServer(), loginResponse.getAccessToken());
        String string = serverInfo.getSalt() + ":" + username;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] salt = byArray;
        char[] cArray = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        byte[] privateKeySecureKey = PBKDF2.INSTANCE.hash(salt, cArray, 1024, 256);
        char[] cArray2 = password.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
        byte[] privateKeySecureIv = PBKDF2.INSTANCE.hash(salt, cArray2, 1024, 128);
        byte[] byArray2 = Base64.decodeBase64((String)meResponse.getPrivateKey());
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"decodeBase64(...)");
        byte[] privateKeyEncoded = AES.CBC.INSTANCE.decrypt(privateKeySecureKey, privateKeySecureIv, byArray2);
        PrivateKey privateKey = RSA.INSTANCE.generatePrivate(privateKeyEncoded);
        byte[] byArray3 = Base64.decodeBase64((String)meResponse.getPublicKey());
        Intrinsics.checkNotNullExpressionValue((Object)byArray3, (String)"decodeBase64(...)");
        PublicKey publicKey = RSA.INSTANCE.generatePublic(byArray3);
        byte[] byArray4 = Base64.decodeBase64((String)meResponse.getSecretKey());
        Intrinsics.checkNotNullExpressionValue((Object)byArray4, (String)"decodeBase64(...)");
        byte[] secretKey = RSA.INSTANCE.decrypt(privateKey, byArray4);
        List teams = new ArrayList();
        for (MeTeam team : meResponse.getTeams()) {
            String string2 = team.getId();
            String string3 = team.getName();
            byte[] byArray5 = Base64.decodeBase64((String)team.getSecretKey());
            Intrinsics.checkNotNullExpressionValue((Object)byArray5, (String)"decodeBase64(...)");
            teams.add(new Team(string2, string3, RSA.INSTANCE.decrypt(privateKey, byArray5), team.getRole()));
        }
        this.getAccountManager().login$termora(new Account(meResponse.getId(), server.getServer(), meResponse.getEmail(), teams, meResponse.getSubscriptions(), loginResponse.getAccessToken(), loginResponse.getRefreshToken(), secretKey, publicKey, privateKey));
    }

    /*
     * WARNING - void declaration
     */
    private final ServerInfo getServerInfo(Server server) {
        void this_$iv;
        Request request = new Request.Builder().url(server.getServer() + "/v1/client/system").get().build();
        Json json = Application.INSTANCE.getOhMyJson();
        String string$iv = AccountHttp.execute$default(AccountHttp.INSTANCE, null, request, 1, null);
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (ServerInfo)this_$iv.decodeFromString((DeserializationStrategy)ServerInfo.Companion.serializer(), string$iv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final LoginResponse callLogin(ServerInfo serverInfo, Server server, String username, String password, String mfa) {
        void this_$iv;
        Json message;
        Object it;
        void this_$iv2;
        String passwordHex = DigestUtils.sha256Hex((String)(serverInfo.getSalt() + ":" + username + ":" + password));
        Json json = Application.INSTANCE.getOhMyJson();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"email", (Object)username), TuplesKt.to((Object)"password", (Object)passwordHex), TuplesKt.to((Object)"mfa", (Object)mfa)};
        Map value$iv = MapsKt.mapOf((Pair[])pairArray);
        boolean $i$f$encodeToString = false;
        this_$iv2.getSerializersModule();
        RequestBody requestBody = RequestBody.Companion.create(this_$iv2.encodeToString((SerializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, BuiltinSerializersKt.getNullable((KSerializer)StringSerializer.INSTANCE)), (Object)value$iv), MediaType.Companion.get("application/json"));
        Request request = new Request.Builder().url(server.getServer() + "/v1/login").post(requestBody).build();
        Response response = AccountHttp.INSTANCE.getClient().newCall(request).execute();
        Closeable closeable = (Closeable)response;
        Throwable throwable = null;
        try {
            String string;
            it = (Response)closeable;
            boolean bl = false;
            Closeable closeable2 = (Closeable)response.body();
            Throwable throwable2 = null;
            try {
                ResponseBody it2 = (ResponseBody)closeable2;
                boolean bl2 = false;
                ResponseBody responseBody = it2;
                string = responseBody != null ? responseBody.string() : null;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            it = string;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        Object text = it;
        if (text == null) {
            throw new ResponseException(response.code(), response);
        }
        if (!response.isSuccessful()) {
            JsonElement jsonElement = (JsonElement)JsonElementKt.getJsonObject((JsonElement)Application.INSTANCE.getOhMyJson().parseToJsonElement((String)text)).get((Object)"message");
            message = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null;
            throw new IllegalStateException((String)message);
        }
        message = Application.INSTANCE.getOhMyJson();
        Object string$iv = text;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (LoginResponse)this_$iv.decodeFromString((DeserializationStrategy)LoginResponse.Companion.serializer(), (String)string$iv);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final MeResponse callMe(@NotNull String server, @NotNull String accessToken) {
        void this_$iv;
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
        Request request = new Request.Builder().url(server + "/v1/users/me").header("Authorization", "Bearer " + accessToken).build();
        String text = AccountHttp.execute$default(AccountHttp.INSTANCE, null, request, 1, null);
        Json json = Application.INSTANCE.getOhMyJson();
        String string$iv = text;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        return (MeResponse)this_$iv.decodeFromString((DeserializationStrategy)MeResponse.Companion.serializer(), string$iv);
    }

    public /* synthetic */ ServerManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/account/ServerManager$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/account/ServerManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ServerManager getInstance() {
            return (ServerManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(ServerManager.class), Companion::getInstance$lambda$0);
        }

        private static final ServerManager getInstance$lambda$0() {
            return new ServerManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000  2\u00020\u0001:\u0002\u001f B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006B/\b\u0010\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u0005\u0010\u000bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0001\u00a2\u0006\u0002\b\u001eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006!"}, d2={"Lapp/termora/account/ServerManager$LoginResponse;", "", "accessToken", "", "refreshToken", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getAccessToken", "()Ljava/lang/String;", "getRefreshToken", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$termora", "$serializer", "Companion", "termora"})
    public static final class LoginResponse {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String accessToken;
        @NotNull
        private final String refreshToken;

        public LoginResponse(@NotNull String accessToken, @NotNull String refreshToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
        }

        @NotNull
        public final String getAccessToken() {
            return this.accessToken;
        }

        @NotNull
        public final String getRefreshToken() {
            return this.refreshToken;
        }

        @NotNull
        public final String component1() {
            return this.accessToken;
        }

        @NotNull
        public final String component2() {
            return this.refreshToken;
        }

        @NotNull
        public final LoginResponse copy(@NotNull String accessToken, @NotNull String refreshToken) {
            Intrinsics.checkNotNullParameter((Object)accessToken, (String)"accessToken");
            Intrinsics.checkNotNullParameter((Object)refreshToken, (String)"refreshToken");
            return new LoginResponse(accessToken, refreshToken);
        }

        public static /* synthetic */ LoginResponse copy$default(LoginResponse loginResponse, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = loginResponse.accessToken;
            }
            if ((n & 2) != 0) {
                string2 = loginResponse.refreshToken;
            }
            return loginResponse.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "LoginResponse(accessToken=" + this.accessToken + ", refreshToken=" + this.refreshToken + ")";
        }

        public int hashCode() {
            int result2 = this.accessToken.hashCode();
            result2 = result2 * 31 + this.refreshToken.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LoginResponse)) {
                return false;
            }
            LoginResponse loginResponse = (LoginResponse)other;
            if (!Intrinsics.areEqual((Object)this.accessToken, (Object)loginResponse.accessToken)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.refreshToken, (Object)loginResponse.refreshToken);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$termora(LoginResponse self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.accessToken);
            output.encodeStringElement(serialDesc, 1, self.refreshToken);
        }

        public /* synthetic */ LoginResponse(int seen0, String accessToken, String refreshToken, SerializationConstructorMarker serializationConstructorMarker) {
            if (3 != (3 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)3, (SerialDescriptor)LoginResponse$$serializer.INSTANCE.getDescriptor());
            }
            this.accessToken = accessToken;
            this.refreshToken = refreshToken;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lapp/termora/account/ServerManager$LoginResponse$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lapp/termora/account/ServerManager$LoginResponse;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<LoginResponse> serializer() {
                return (KSerializer)LoginResponse$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 32\u00020\u0001:\u000223BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0004\b\r\u0010\u000eBm\b\u0010\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\u000e\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\t\u0012\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\u0004\b\r\u0010\u0013J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0003H\u00c6\u0003J\t\u0010!\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0003J[\u0010$\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\u00032\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\tH\u00c6\u0001J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010(\u001a\u00020\u0010H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001J%\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00002\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0001\u00a2\u0006\u0002\b1R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001b\u00a8\u00064"}, d2={"Lapp/termora/account/ServerManager$MeResponse;", "", "id", "", "email", "publicKey", "privateKey", "secretKey", "teams", "", "Lapp/termora/account/ServerManager$MeTeam;", "subscriptions", "Lapp/termora/account/Subscription;", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getId", "()Ljava/lang/String;", "getEmail", "getPublicKey", "getPrivateKey", "getSecretKey", "getTeams", "()Ljava/util/List;", "getSubscriptions", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$termora", "$serializer", "Companion", "termora"})
    public static final class MeResponse {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String id;
        @NotNull
        private final String email;
        @NotNull
        private final String publicKey;
        @NotNull
        private final String privateKey;
        @NotNull
        private final String secretKey;
        @NotNull
        private final List<MeTeam> teams;
        @NotNull
        private final List<Subscription> subscriptions;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public MeResponse(@NotNull String id, @NotNull String email, @NotNull String publicKey, @NotNull String privateKey, @NotNull String secretKey, @NotNull List<MeTeam> teams, @NotNull List<Subscription> subscriptions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter(teams, (String)"teams");
            Intrinsics.checkNotNullParameter(subscriptions, (String)"subscriptions");
            this.id = id;
            this.email = email;
            this.publicKey = publicKey;
            this.privateKey = privateKey;
            this.secretKey = secretKey;
            this.teams = teams;
            this.subscriptions = subscriptions;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getEmail() {
            return this.email;
        }

        @NotNull
        public final String getPublicKey() {
            return this.publicKey;
        }

        @NotNull
        public final String getPrivateKey() {
            return this.privateKey;
        }

        @NotNull
        public final String getSecretKey() {
            return this.secretKey;
        }

        @NotNull
        public final List<MeTeam> getTeams() {
            return this.teams;
        }

        @NotNull
        public final List<Subscription> getSubscriptions() {
            return this.subscriptions;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.email;
        }

        @NotNull
        public final String component3() {
            return this.publicKey;
        }

        @NotNull
        public final String component4() {
            return this.privateKey;
        }

        @NotNull
        public final String component5() {
            return this.secretKey;
        }

        @NotNull
        public final List<MeTeam> component6() {
            return this.teams;
        }

        @NotNull
        public final List<Subscription> component7() {
            return this.subscriptions;
        }

        @NotNull
        public final MeResponse copy(@NotNull String id, @NotNull String email, @NotNull String publicKey, @NotNull String privateKey, @NotNull String secretKey, @NotNull List<MeTeam> teams, @NotNull List<Subscription> subscriptions) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)email, (String)"email");
            Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            Intrinsics.checkNotNullParameter(teams, (String)"teams");
            Intrinsics.checkNotNullParameter(subscriptions, (String)"subscriptions");
            return new MeResponse(id, email, publicKey, privateKey, secretKey, teams, subscriptions);
        }

        public static /* synthetic */ MeResponse copy$default(MeResponse meResponse, String string, String string2, String string3, String string4, String string5, List list, List list2, int n, Object object) {
            if ((n & 1) != 0) {
                string = meResponse.id;
            }
            if ((n & 2) != 0) {
                string2 = meResponse.email;
            }
            if ((n & 4) != 0) {
                string3 = meResponse.publicKey;
            }
            if ((n & 8) != 0) {
                string4 = meResponse.privateKey;
            }
            if ((n & 0x10) != 0) {
                string5 = meResponse.secretKey;
            }
            if ((n & 0x20) != 0) {
                list = meResponse.teams;
            }
            if ((n & 0x40) != 0) {
                list2 = meResponse.subscriptions;
            }
            return meResponse.copy(string, string2, string3, string4, string5, list, list2);
        }

        @NotNull
        public String toString() {
            return "MeResponse(id=" + this.id + ", email=" + this.email + ", publicKey=" + this.publicKey + ", privateKey=" + this.privateKey + ", secretKey=" + this.secretKey + ", teams=" + this.teams + ", subscriptions=" + this.subscriptions + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.email.hashCode();
            result2 = result2 * 31 + this.publicKey.hashCode();
            result2 = result2 * 31 + this.privateKey.hashCode();
            result2 = result2 * 31 + this.secretKey.hashCode();
            result2 = result2 * 31 + ((Object)this.teams).hashCode();
            result2 = result2 * 31 + ((Object)this.subscriptions).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MeResponse)) {
                return false;
            }
            MeResponse meResponse = (MeResponse)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)meResponse.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.email, (Object)meResponse.email)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.publicKey, (Object)meResponse.publicKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.privateKey, (Object)meResponse.privateKey)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.secretKey, (Object)meResponse.secretKey)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.teams, meResponse.teams)) {
                return false;
            }
            return Intrinsics.areEqual(this.subscriptions, meResponse.subscriptions);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$termora(MeResponse self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeStringElement(serialDesc, 0, self.id);
            output.encodeStringElement(serialDesc, 1, self.email);
            output.encodeStringElement(serialDesc, 2, self.publicKey);
            output.encodeStringElement(serialDesc, 3, self.privateKey);
            output.encodeStringElement(serialDesc, 4, self.secretKey);
            output.encodeSerializableElement(serialDesc, 5, (SerializationStrategy)lazyArray[5].getValue(), self.teams);
            output.encodeSerializableElement(serialDesc, 6, (SerializationStrategy)lazyArray[6].getValue(), self.subscriptions);
        }

        public /* synthetic */ MeResponse(int seen0, String id, String email, String publicKey, String privateKey, String secretKey, List teams, List subscriptions, SerializationConstructorMarker serializationConstructorMarker) {
            if (127 != (0x7F & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)127, (SerialDescriptor)MeResponse$$serializer.INSTANCE.getDescriptor());
            }
            this.id = id;
            this.email = email;
            this.publicKey = publicKey;
            this.privateKey = privateKey;
            this.secretKey = secretKey;
            this.teams = teams;
            this.subscriptions = subscriptions;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, null, null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)MeTeam$$serializer.INSTANCE)), LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)Subscription$.serializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lapp/termora/account/ServerManager$MeResponse$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lapp/termora/account/ServerManager$MeResponse;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<MeResponse> serializer() {
                return (KSerializer)MeResponse$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 (2\u00020\u0001:\u0002'(B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0004\b\b\u0010\tBC\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010\u00a8\u0006)"}, d2={"Lapp/termora/account/ServerManager$MeTeam;", "", "id", "", "name", "role", "Lapp/termora/account/TeamRole;", "secretKey", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lapp/termora/account/TeamRole;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Ljava/lang/String;Lapp/termora/account/TeamRole;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getId", "()Ljava/lang/String;", "getName", "getRole", "()Lapp/termora/account/TeamRole;", "getSecretKey", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$termora", "$serializer", "Companion", "termora"})
    public static final class MeTeam {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String id;
        @NotNull
        private final String name;
        @NotNull
        private final TeamRole role;
        @NotNull
        private final String secretKey;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public MeTeam(@NotNull String id, @NotNull String name, @NotNull TeamRole role, @NotNull String secretKey) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            this.id = id;
            this.name = name;
            this.role = role;
            this.secretKey = secretKey;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final TeamRole getRole() {
            return this.role;
        }

        @NotNull
        public final String getSecretKey() {
            return this.secretKey;
        }

        @NotNull
        public final String component1() {
            return this.id;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        @NotNull
        public final TeamRole component3() {
            return this.role;
        }

        @NotNull
        public final String component4() {
            return this.secretKey;
        }

        @NotNull
        public final MeTeam copy(@NotNull String id, @NotNull String name, @NotNull TeamRole role, @NotNull String secretKey) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)((Object)role), (String)"role");
            Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
            return new MeTeam(id, name, role, secretKey);
        }

        public static /* synthetic */ MeTeam copy$default(MeTeam meTeam, String string, String string2, TeamRole teamRole, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = meTeam.id;
            }
            if ((n & 2) != 0) {
                string2 = meTeam.name;
            }
            if ((n & 4) != 0) {
                teamRole = meTeam.role;
            }
            if ((n & 8) != 0) {
                string3 = meTeam.secretKey;
            }
            return meTeam.copy(string, string2, teamRole, string3);
        }

        @NotNull
        public String toString() {
            return "MeTeam(id=" + this.id + ", name=" + this.name + ", role=" + this.role + ", secretKey=" + this.secretKey + ")";
        }

        public int hashCode() {
            int result2 = this.id.hashCode();
            result2 = result2 * 31 + this.name.hashCode();
            result2 = result2 * 31 + this.role.hashCode();
            result2 = result2 * 31 + this.secretKey.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof MeTeam)) {
                return false;
            }
            MeTeam meTeam = (MeTeam)other;
            if (!Intrinsics.areEqual((Object)this.id, (Object)meTeam.id)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)meTeam.name)) {
                return false;
            }
            if (this.role != meTeam.role) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.secretKey, (Object)meTeam.secretKey);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$termora(MeTeam self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeStringElement(serialDesc, 0, self.id);
            output.encodeStringElement(serialDesc, 1, self.name);
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), (Object)self.role);
            output.encodeStringElement(serialDesc, 3, self.secretKey);
        }

        public /* synthetic */ MeTeam(int seen0, String id, String name, TeamRole role, String secretKey, SerializationConstructorMarker serializationConstructorMarker) {
            if (15 != (0xF & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)15, (SerialDescriptor)MeTeam$$serializer.INSTANCE.getDescriptor());
            }
            this.id = id;
            this.name = name;
            this.role = role;
            this.secretKey = secretKey;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> EnumsKt.createSimpleEnumSerializer((String)"app.termora.account.TeamRole", (Enum[])TeamRole.values())), null};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lapp/termora/account/ServerManager$MeTeam$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lapp/termora/account/ServerManager$MeTeam;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<MeTeam> serializer() {
                return (KSerializer)MeTeam$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 \u001d2\u00020\u0001:\u0002\u001c\u001dB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B%\b\u0010\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\u0004\u0010\nJ\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0001\u00a2\u0006\u0002\b\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001e"}, d2={"Lapp/termora/account/ServerManager$ServerInfo;", "", "salt", "", "<init>", "(Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getSalt", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$termora", "$serializer", "Companion", "termora"})
    public static final class ServerInfo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String salt;

        public ServerInfo(@NotNull String salt) {
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            this.salt = salt;
        }

        @NotNull
        public final String getSalt() {
            return this.salt;
        }

        @NotNull
        public final String component1() {
            return this.salt;
        }

        @NotNull
        public final ServerInfo copy(@NotNull String salt) {
            Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
            return new ServerInfo(salt);
        }

        public static /* synthetic */ ServerInfo copy$default(ServerInfo serverInfo, String string, int n, Object object) {
            if ((n & 1) != 0) {
                string = serverInfo.salt;
            }
            return serverInfo.copy(string);
        }

        @NotNull
        public String toString() {
            return "ServerInfo(salt=" + this.salt + ")";
        }

        public int hashCode() {
            return this.salt.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServerInfo)) {
                return false;
            }
            ServerInfo serverInfo = (ServerInfo)other;
            return Intrinsics.areEqual((Object)this.salt, (Object)serverInfo.salt);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$termora(ServerInfo self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.salt);
        }

        public /* synthetic */ ServerInfo(int seen0, String salt, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)ServerInfo$$serializer.INSTANCE.getDescriptor());
            }
            this.salt = salt;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lapp/termora/account/ServerManager$ServerInfo$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lapp/termora/account/ServerManager$ServerInfo;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<ServerInfo> serializer() {
                return (KSerializer)ServerInfo$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

