/*
 * Decompiled with CFR 0.152.
 */
package app.termora.highlight;

import app.termora.DialogWrapper;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.database.DatabaseManager;
import app.termora.highlight.ChooseColorTemplateDialog;
import app.termora.highlight.ColorPanel;
import app.termora.highlight.KeywordHighlight;
import app.termora.highlight.KeywordHighlightView;
import app.termora.terminal.ColorPalette;
import app.termora.terminal.TerminalColor;
import com.formdev.flatlaf.extras.components.FlatTextField;
import com.formdev.flatlaf.extras.components.FlatToolBar;
import com.formdev.flatlaf.ui.FlatLineBorder;
import com.formdev.flatlaf.util.SystemInfo;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u00107\u001a\u000208H\u0002J\b\u00109\u001a\u000208H\u0002J\b\u0010:\u001a\u00020;H\u0014J\u0018\u0010<\u001a\u00020#2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020\u000bH\u0002J\b\u0010@\u001a\u000208H\u0014J\f\u0010A\u001a\u00020B*\u00020>H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001bR\u0011\u0010\"\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020#\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010%R\u0011\u0010(\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010,\u001a\u00020)\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010+R\u000e\u0010.\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00100\u001a\u00020/X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u00101\u001a\u0004\u0018\u000102X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u0006C"}, d2={"Lapp/termora/highlight/NewKeywordHighlightDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "colorPalette", "Lapp/termora/terminal/ColorPalette;", "<init>", "(Ljava/awt/Window;Lapp/termora/terminal/ColorPalette;)V", "getColorPalette", "()Lapp/termora/terminal/ColorPalette;", "formMargin", "", "keywordHighlightView", "Lapp/termora/highlight/KeywordHighlightView;", "getKeywordHighlightView", "()Lapp/termora/highlight/KeywordHighlightView;", "keywordHighlightView$delegate", "Lkotlin/Lazy;", "keywordTextField", "Lcom/formdev/flatlaf/extras/components/FlatTextField;", "getKeywordTextField", "()Lcom/formdev/flatlaf/extras/components/FlatTextField;", "descriptionTextField", "getDescriptionTextField", "boldCheckBox", "Ljavax/swing/JCheckBox;", "getBoldCheckBox", "()Ljavax/swing/JCheckBox;", "italicCheckBox", "getItalicCheckBox", "underlineCheckBox", "getUnderlineCheckBox", "lineThroughCheckBox", "getLineThroughCheckBox", "textColor", "Lapp/termora/highlight/ColorPanel;", "getTextColor", "()Lapp/termora/highlight/ColorPanel;", "backgroundColor", "getBackgroundColor", "matchCaseBtn", "Ljavax/swing/JToggleButton;", "getMatchCaseBtn", "()Ljavax/swing/JToggleButton;", "regexBtn", "getRegexBtn", "textColorRevert", "Ljavax/swing/JButton;", "backgroundColorRevert", "keywordHighlight", "Lapp/termora/highlight/KeywordHighlight;", "getKeywordHighlight", "()Lapp/termora/highlight/KeywordHighlight;", "setKeywordHighlight", "(Lapp/termora/highlight/KeywordHighlight;)V", "initEvents", "", "repaintKeywordHighlightView", "createCenterPanel", "Ljavax/swing/JComponent;", "createColorPanel", "color", "Ljava/awt/Color;", "title", "doOKAction", "toRGB", "", "termora"})
@SourceDebugExtension(value={"SMAP\nNewKeywordHighlightDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NewKeywordHighlightDialog.kt\napp/termora/highlight/NewKeywordHighlightDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,277:1\n1#2:278\n*E\n"})
public final class NewKeywordHighlightDialog
extends DialogWrapper {
    @NotNull
    private final ColorPalette colorPalette;
    @NotNull
    private final String formMargin;
    @NotNull
    private final Lazy keywordHighlightView$delegate;
    @NotNull
    private final FlatTextField keywordTextField;
    @NotNull
    private final FlatTextField descriptionTextField;
    @NotNull
    private final JCheckBox boldCheckBox;
    @NotNull
    private final JCheckBox italicCheckBox;
    @NotNull
    private final JCheckBox underlineCheckBox;
    @NotNull
    private final JCheckBox lineThroughCheckBox;
    @NotNull
    private final ColorPanel textColor;
    @NotNull
    private final ColorPanel backgroundColor;
    @NotNull
    private final JToggleButton matchCaseBtn;
    @NotNull
    private final JToggleButton regexBtn;
    @NotNull
    private final JButton textColorRevert;
    @NotNull
    private final JButton backgroundColorRevert;
    @Nullable
    private KeywordHighlight keywordHighlight;

    /*
     * WARNING - void declaration
     */
    public NewKeywordHighlightDialog(@NotNull Window owner, @NotNull ColorPalette colorPalette) {
        void $this$regexBtn_u24lambda_u240;
        JToggleButton $this$matchCaseBtn_u24lambda_u240;
        JToggleButton jToggleButton;
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)colorPalette, (String)"colorPalette");
        super(owner);
        this.colorPalette = colorPalette;
        this.formMargin = "7dlu";
        this.keywordHighlightView$delegate = LazyKt.lazy(NewKeywordHighlightDialog::keywordHighlightView_delegate$lambda$0);
        this.keywordTextField = new FlatTextField();
        this.descriptionTextField = new FlatTextField();
        this.boldCheckBox = new JCheckBox(I18n.INSTANCE.getString("termora.highlight.bold"));
        this.italicCheckBox = new JCheckBox(I18n.INSTANCE.getString("termora.highlight.italic"));
        this.underlineCheckBox = new JCheckBox(I18n.INSTANCE.getString("termora.highlight.underline"));
        this.lineThroughCheckBox = new JCheckBox(I18n.INSTANCE.getString("termora.highlight.line-through"));
        this.textColor = this.createColorPanel(new Color(this.colorPalette.getColor(TerminalColor.Basic.INSTANCE.getFOREGROUND())), I18n.INSTANCE.getString("termora.highlight.text-color"));
        this.backgroundColor = this.createColorPanel(new Color(this.colorPalette.getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND())), I18n.INSTANCE.getString("termora.highlight.background-color"));
        JToggleButton jToggleButton2 = jToggleButton = new JToggleButton((Icon)((Object)Icons.INSTANCE.getMatchCase()));
        NewKeywordHighlightDialog newKeywordHighlightDialog = this;
        boolean bl = false;
        $this$matchCaseBtn_u24lambda_u240.setToolTipText(I18n.INSTANCE.getString("termora.match-case"));
        newKeywordHighlightDialog.matchCaseBtn = jToggleButton;
        $this$matchCaseBtn_u24lambda_u240 = jToggleButton = new JToggleButton((Icon)((Object)Icons.INSTANCE.getRegex()));
        newKeywordHighlightDialog = this;
        boolean bl2 = false;
        $this$regexBtn_u24lambda_u240.setToolTipText(I18n.INSTANCE.getString("termora.regex"));
        newKeywordHighlightDialog.regexBtn = jToggleButton;
        this.textColorRevert = new JButton((Icon)((Object)Icons.INSTANCE.getRevert()));
        this.backgroundColorRevert = new JButton((Icon)((Object)Icons.INSTANCE.getRevert()));
        this.setModal(true);
        this.setTitle(I18n.INSTANCE.getString("termora.highlight"));
        this.setResizable(false);
        this.setControlsVisible(false);
        this.boldCheckBox.setHorizontalAlignment(0);
        this.italicCheckBox.setHorizontalAlignment(0);
        this.underlineCheckBox.setHorizontalAlignment(0);
        this.lineThroughCheckBox.setHorizontalAlignment(0);
        this.getKeywordHighlightView().setPreferredSize(new Dimension(-1, 100));
        this.textColorRevert.setFocusable(false);
        this.textColorRevert.setEnabled(false);
        this.textColorRevert.setToolTipText("Use terminal foreground");
        this.textColorRevert.putClientProperty("JButton.buttonType", "toolBarButton");
        this.backgroundColorRevert.setFocusable(false);
        this.backgroundColorRevert.setEnabled(false);
        this.backgroundColorRevert.setToolTipText("Use terminal background");
        this.backgroundColorRevert.putClientProperty("JButton.buttonType", "toolBarButton");
        this.matchCaseBtn.setToolTipText(I18n.INSTANCE.getString("termora.match-case"));
        FlatToolBar box = new FlatToolBar();
        box.add((Component)this.matchCaseBtn);
        box.add((Component)this.regexBtn);
        this.keywordTextField.setTrailingComponent((JComponent)box);
        this.repaintKeywordHighlightView();
        this.initEvents();
        this.init();
        this.pack();
        this.setSize(new Dimension(UIManager.getInt("Dialog.width") - 200, Math.max(this.getHeight(), this.getPreferredSize().height)));
        this.setLocationRelativeTo(null);
    }

    @NotNull
    public final ColorPalette getColorPalette() {
        return this.colorPalette;
    }

    private final KeywordHighlightView getKeywordHighlightView() {
        Lazy lazy = this.keywordHighlightView$delegate;
        return (KeywordHighlightView)lazy.getValue();
    }

    @NotNull
    public final FlatTextField getKeywordTextField() {
        return this.keywordTextField;
    }

    @NotNull
    public final FlatTextField getDescriptionTextField() {
        return this.descriptionTextField;
    }

    @NotNull
    public final JCheckBox getBoldCheckBox() {
        return this.boldCheckBox;
    }

    @NotNull
    public final JCheckBox getItalicCheckBox() {
        return this.italicCheckBox;
    }

    @NotNull
    public final JCheckBox getUnderlineCheckBox() {
        return this.underlineCheckBox;
    }

    @NotNull
    public final JCheckBox getLineThroughCheckBox() {
        return this.lineThroughCheckBox;
    }

    @NotNull
    public final ColorPanel getTextColor() {
        return this.textColor;
    }

    @NotNull
    public final ColorPanel getBackgroundColor() {
        return this.backgroundColor;
    }

    @NotNull
    public final JToggleButton getMatchCaseBtn() {
        return this.matchCaseBtn;
    }

    @NotNull
    public final JToggleButton getRegexBtn() {
        return this.regexBtn;
    }

    @Nullable
    public final KeywordHighlight getKeywordHighlight() {
        return this.keywordHighlight;
    }

    public final void setKeywordHighlight(@Nullable KeywordHighlight keywordHighlight) {
        this.keywordHighlight = keywordHighlight;
    }

    private final void initEvents() {
        this.textColor.addPropertyChangeListener("color", arg_0 -> NewKeywordHighlightDialog.initEvents$lambda$0(this, arg_0));
        this.backgroundColor.addPropertyChangeListener("color", arg_0 -> NewKeywordHighlightDialog.initEvents$lambda$1(this, arg_0));
        this.boldCheckBox.addActionListener(arg_0 -> NewKeywordHighlightDialog.initEvents$lambda$2(this, arg_0));
        this.italicCheckBox.addActionListener(arg_0 -> NewKeywordHighlightDialog.initEvents$lambda$3(this, arg_0));
        this.underlineCheckBox.addActionListener(arg_0 -> NewKeywordHighlightDialog.initEvents$lambda$4(this, arg_0));
        this.lineThroughCheckBox.addActionListener(arg_0 -> NewKeywordHighlightDialog.initEvents$lambda$5(this, arg_0));
        this.textColorRevert.addActionListener(arg_0 -> NewKeywordHighlightDialog.initEvents$lambda$6(this, arg_0));
        this.backgroundColorRevert.addActionListener(arg_0 -> NewKeywordHighlightDialog.initEvents$lambda$7(this, arg_0));
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ NewKeywordHighlightDialog this$0;
            {
                this.this$0 = $receiver;
            }

            public void windowActivated(WindowEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.removeWindowListener(this);
                NewKeywordHighlightDialog.access$repaintKeywordHighlightView(this.this$0);
            }
        });
    }

    private final void repaintKeywordHighlightView() {
        this.getKeywordHighlightView().setBold(this.boldCheckBox.isSelected());
        this.getKeywordHighlightView().setItalic(this.italicCheckBox.isSelected());
        this.getKeywordHighlightView().setUnderline(this.underlineCheckBox.isSelected());
        this.getKeywordHighlightView().setLineThrough(this.lineThroughCheckBox.isSelected());
        if (this.textColor.getColor() == null && this.textColor.getColorIndex() == -1) {
            this.getKeywordHighlightView().setTextColor(new Color(this.colorPalette.getColor(TerminalColor.Basic.INSTANCE.getFOREGROUND())));
        } else if (this.textColor.getColor() != null) {
            this.getKeywordHighlightView().setTextColor(this.textColor.getColor());
        } else {
            this.getKeywordHighlightView().setTextColor(new Color(this.colorPalette.getXTerm256Color(this.textColor.getColorIndex())));
        }
        if (this.backgroundColor.getColor() == null && this.backgroundColor.getColorIndex() == -1) {
            this.getKeywordHighlightView().setBackgroundColor(new Color(this.colorPalette.getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND())));
        } else if (this.backgroundColor.getColor() != null) {
            this.getKeywordHighlightView().setBackgroundColor(this.backgroundColor.getColor());
        } else {
            this.getKeywordHighlightView().setBackgroundColor(new Color(this.colorPalette.getXTerm256Color(this.backgroundColor.getColorIndex())));
        }
        this.getKeywordHighlightView().repaint();
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        FormBuilder formBuilder;
        FormLayout layout = new FormLayout("left:pref, " + this.formMargin + ", default:grow, 2dlu, left:pref", "pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref");
        JPanel stylePanel = FormBuilder.create().debug(false).layout(new FormLayout("default:grow, " + this.formMargin + ", default:grow, " + this.formMargin + ", default:grow, " + this.formMargin + ", default:grow", "pref")).add((Component)this.boldCheckBox).xy(1, 1).add((Component)this.italicCheckBox).xy(3, 1).add((Component)this.underlineCheckBox).xy(5, 1).add((Component)this.lineThroughCheckBox).xy(7, 1).build();
        int rows = 0;
        rows = 1;
        int step = 2;
        FormBuilder $this$createCenterPanel_u24lambda_u240 = formBuilder = FormBuilder.create().layout(layout).debug(false).padding((SystemInfo.isWindows ? this.formMargin : "0dlu") + ", " + this.formMargin + ", " + this.formMargin + ", " + this.formMargin, new Object[0]).add(I18n.INSTANCE.getString("termora.highlight.keyword") + ":", new Object[0]).xy(1, rows).add((Component)this.keywordTextField).xyw(3, rows, 3);
        boolean bl = false;
        FormBuilder $this$createCenterPanel_u24lambda_u241 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.highlight.description") + ":", new Object[0]).xy(1, rows += step).add((Component)this.descriptionTextField).xyw(3, rows, 3);
        boolean bl2 = false;
        FormBuilder $this$createCenterPanel_u24lambda_u242 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.highlight.text-color") + ":", new Object[0]).xy(1, rows += step).add((Component)this.textColor).xy(3, rows).add((Component)this.textColorRevert).xy(5, rows);
        boolean bl3 = false;
        FormBuilder $this$createCenterPanel_u24lambda_u243 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.highlight.background-color") + ":", new Object[0]).xy(1, rows += step).add((Component)this.backgroundColor).xy(3, rows).add((Component)this.backgroundColorRevert).xy(5, rows);
        boolean bl4 = false;
        FormBuilder $this$createCenterPanel_u24lambda_u244 = formBuilder = formBuilder.add((Component)stylePanel).xyw(1, rows += step, 5, "fill, center");
        boolean bl5 = false;
        FormBuilder $this$createCenterPanel_u24lambda_u245 = formBuilder = formBuilder.add((Component)this.getKeywordHighlightView()).xyw(1, rows += step, 5);
        boolean bl6 = false;
        rows += step;
        JPanel jPanel = formBuilder.build();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
        return jPanel;
    }

    private final ColorPanel createColorPanel(Color color, String title) {
        NewKeywordHighlightDialog owner = this;
        int arc = UIManager.getInt("Component.arc");
        FlatLineBorder lineBorder = new FlatLineBorder(new Insets(1, 1, 1, 1), (Color)DynamicColor.Companion.getBorderColor(), 1.0f, arc);
        ColorPanel colorPanel = new ColorPanel();
        colorPanel.setBackground(color);
        colorPanel.setPreferredSize(this.keywordTextField.getPreferredSize());
        colorPanel.setBorder((Border)lineBorder);
        colorPanel.addMouseListener(new MouseAdapter(owner, title, colorPanel, this){
            final /* synthetic */ NewKeywordHighlightDialog $owner;
            final /* synthetic */ String $title;
            final /* synthetic */ ColorPanel $colorPanel;
            final /* synthetic */ NewKeywordHighlightDialog this$0;
            {
                this.$owner = $owner;
                this.$title = $title;
                this.$colorPanel = $colorPanel;
                this.this$0 = $receiver;
            }

            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (SwingUtilities.isLeftMouseButton(e)) {
                    ChooseColorTemplateDialog dialog2 = new ChooseColorTemplateDialog((Window)this.$owner, this.$title);
                    dialog2.setLocationRelativeTo(this.$owner);
                    Color color = this.$colorPanel.getColor();
                    if (color == null) {
                        Color color2 = Color.orange;
                        color = color2;
                        Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"orange");
                    }
                    dialog2.setDefaultColor(color);
                    dialog2.setVisible(true);
                    if (!dialog2.getOk()) {
                        return;
                    }
                    this.$colorPanel.setColorIndex(-1);
                    this.$colorPanel.setColor(null);
                    int n = dialog2.getColorIndex();
                    boolean bl = 1 <= n ? n < 17 : false;
                    if (bl) {
                        this.$colorPanel.setColorIndex(dialog2.getColorIndex());
                        this.$colorPanel.setBackground(new Color(this.this$0.getColorPalette().getXTerm256Color(dialog2.getColorIndex())));
                    } else {
                        this.$colorPanel.setColor(dialog2.getColor());
                    }
                    NewKeywordHighlightDialog.access$repaintKeywordHighlightView(this.this$0);
                }
            }
        });
        return colorPanel;
    }

    @Override
    protected void doOKAction() {
        int n;
        int newTextColor;
        String string = this.keywordTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        if (StringsKt.isBlank((CharSequence)string)) {
            this.keywordTextField.setOutline((Object)"error");
            this.keywordTextField.requestFocusInWindow();
            return;
        }
        if (this.textColor.getColor() != null) {
            Color color = this.textColor.getColor();
            v2 = color != null ? this.toRGB(color) : 0;
        } else {
            v2 = newTextColor = this.textColor.getColorIndex() == -1 ? 0 : this.textColor.getColorIndex();
        }
        if (this.backgroundColor.getColor() != null) {
            Color color = this.backgroundColor.getColor();
            n = color != null ? this.toRGB(color) : 0;
        } else {
            n = this.backgroundColor.getColorIndex() == -1 ? 0 : this.backgroundColor.getColorIndex();
        }
        int newBackgroundColor = n;
        String string2 = this.keywordTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String string3 = this.descriptionTextField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
        this.keywordHighlight = new KeywordHighlight(null, null, null, string2, string3, this.matchCaseBtn.isSelected(), this.regexBtn.isSelected(), newTextColor, newBackgroundColor, this.boldCheckBox.isSelected(), this.italicCheckBox.isSelected(), this.lineThroughCheckBox.isSelected(), this.underlineCheckBox.isSelected(), false, 0L, 0L, 57351, null);
        super.doOKAction();
    }

    private final int toRGB(Color $this$toRGB) {
        return 65536 * $this$toRGB.getRed() + 256 * $this$toRGB.getGreen() + $this$toRGB.getBlue();
    }

    private static final KeywordHighlightView keywordHighlightView_delegate$lambda$0() {
        return new KeywordHighlightView(0, DatabaseManager.Companion.getInstance().getTerminal().getFontSize(), 1, null);
    }

    private static final void initEvents$lambda$0(NewKeywordHighlightDialog this$0, PropertyChangeEvent it) {
        this$0.repaintKeywordHighlightView();
        this$0.textColorRevert.setEnabled(!Intrinsics.areEqual((Object)it.getNewValue(), (Object)new Color(this$0.colorPalette.getColor(TerminalColor.Basic.INSTANCE.getFOREGROUND()))));
    }

    private static final void initEvents$lambda$1(NewKeywordHighlightDialog this$0, PropertyChangeEvent it) {
        this$0.repaintKeywordHighlightView();
        this$0.backgroundColorRevert.setEnabled(!Intrinsics.areEqual((Object)it.getNewValue(), (Object)new Color(this$0.colorPalette.getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND()))));
    }

    private static final void initEvents$lambda$2(NewKeywordHighlightDialog this$0, ActionEvent it) {
        this$0.repaintKeywordHighlightView();
    }

    private static final void initEvents$lambda$3(NewKeywordHighlightDialog this$0, ActionEvent it) {
        this$0.repaintKeywordHighlightView();
    }

    private static final void initEvents$lambda$4(NewKeywordHighlightDialog this$0, ActionEvent it) {
        this$0.repaintKeywordHighlightView();
    }

    private static final void initEvents$lambda$5(NewKeywordHighlightDialog this$0, ActionEvent it) {
        this$0.repaintKeywordHighlightView();
    }

    private static final void initEvents$lambda$6(NewKeywordHighlightDialog this$0, ActionEvent it) {
        this$0.textColor.setColor(null);
        this$0.textColor.setBackground(new Color(this$0.colorPalette.getColor(TerminalColor.Basic.INSTANCE.getFOREGROUND())));
        this$0.textColor.setColorIndex(-1);
        this$0.repaintKeywordHighlightView();
    }

    private static final void initEvents$lambda$7(NewKeywordHighlightDialog this$0, ActionEvent it) {
        this$0.backgroundColor.setColor(null);
        this$0.backgroundColor.setBackground(new Color(this$0.colorPalette.getColor(TerminalColor.Basic.INSTANCE.getBACKGROUND())));
        this$0.backgroundColor.setColorIndex(-1);
        this$0.repaintKeywordHighlightView();
    }

    public static final /* synthetic */ void access$repaintKeywordHighlightView(NewKeywordHighlightDialog $this) {
        $this.repaintKeywordHighlightView();
    }
}

