/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.FramePlugin;
import app.termora.ScopeKt;
import app.termora.account.AccountPlugin;
import app.termora.plugin.Plugin;
import app.termora.plugin.PluginDescription;
import app.termora.plugin.PluginDescriptor;
import app.termora.plugin.PluginOrigin;
import app.termora.plugin.PluginXmlParser;
import app.termora.plugin.internal.badge.BadgePlugin;
import app.termora.plugin.internal.extension.DynamicExtensionPlugin;
import app.termora.plugin.internal.local.LocalInternalPlugin;
import app.termora.plugin.internal.plugin.PluginInternalPlugin;
import app.termora.plugin.internal.rdp.RDPInternalPlugin;
import app.termora.plugin.internal.sftppty.SFTPPtyInternalPlugin;
import app.termora.plugin.internal.ssh.SSHInternalPlugin;
import app.termora.plugin.internal.telnet.TelnetInternalPlugin;
import app.termora.plugin.internal.updater.UpdaterPlugin;
import app.termora.plugin.internal.wsl.WSLInternalPlugin;
import app.termora.terminal.panel.vw.FloatingToolbarPlugin;
import app.termora.transfer.internal.local.LocalPlugin;
import app.termora.transfer.internal.sftp.SFTPPlugin;
import com.formdev.flatlaf.util.SystemInfo;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.semver4j.Semver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001b\u001cB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bJ\u0011\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0013H\u0002J\b\u0010\u0018\u001a\u00020\u0013H\u0002J\u0018\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lapp/termora/plugin/PluginManager;", "", "<init>", "()V", "plugins", "", "Lapp/termora/plugin/PluginDescriptor;", "pluginIds", "", "", "getLoadedPlugins", "", "Lapp/termora/plugin/Plugin;", "getLoadedPluginDescriptor", "", "()[Lapp/termora/plugin/PluginDescriptor;", "getPluginDirectory", "Ljava/io/File;", "loadPlugins", "", "pluginsFile", "origin", "Lapp/termora/plugin/PluginOrigin;", "loadInternalPlugins", "loadSystemPlugins", "loadPlugin", "file", "Companion", "PluginClassLoader", "termora"})
@SourceDebugExtension(value={"SMAP\nPluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginManager.kt\napp/termora/plugin/PluginManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,254:1\n1563#2:255\n1634#2,3:256\n1056#2:259\n37#3,2:260\n37#3,2:262\n*S KotlinDebug\n*F\n+ 1 PluginManager.kt\napp/termora/plugin/PluginManager\n*L\n64#1:255\n64#1:256,3\n68#1:259\n68#1:260,2\n192#1:262,2\n*E\n"})
public final class PluginManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PluginDescriptor> plugins = new ArrayList();
    @NotNull
    private final Set<String> pluginIds = new LinkedHashSet();
    private static final Logger log = LoggerFactory.getLogger(PluginManager.class);
    @NotNull
    private static final String PLUGIN_DIR = "TERMORA_PLUGIN_DIRECTORY";

    private PluginManager() {
        this.loadInternalPlugins();
        this.loadSystemPlugins();
        this.loadPlugins(this.getPluginDirectory(), PluginOrigin.External);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Plugin> getLoadedPlugins() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.plugins;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PluginDescriptor pluginDescriptor = (PluginDescriptor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getPlugin());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final PluginDescriptor[] getLoadedPluginDescriptor() {
        Iterable $this$sortedBy$iv = this.plugins;
        boolean $i$f$sortedBy = false;
        Collection $this$toTypedArray$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                PluginDescriptor it = (PluginDescriptor)a;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(it.getPlugin().getName().length());
                it = (PluginDescriptor)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPlugin().getName().length()));
            }
        });
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new PluginDescriptor[0]);
    }

    @NotNull
    public final File getPluginDirectory() {
        String dir = (String)StringUtils.defaultIfBlank((CharSequence)System.getProperty(PLUGIN_DIR), (CharSequence)System.getenv(PLUGIN_DIR));
        if (StringUtils.isNotBlank((CharSequence)dir)) {
            return new File(dir);
        }
        return new File(Application.INSTANCE.getBaseDataDir(), "plugins");
    }

    private final void loadPlugins(File pluginsFile, PluginOrigin origin) {
        if (log.isInfoEnabled()) {
            log.info("Loading plugins " + FilenameUtils.normalize((String)pluginsFile.getAbsolutePath()));
        }
        if (!pluginsFile.exists() || !pluginsFile.isDirectory()) {
            return;
        }
        Object[] dirs = pluginsFile.listFiles(PluginManager::loadPlugins$lambda$0);
        if (ArrayUtils.isEmpty((Object[])dirs)) {
            return;
        }
        Intrinsics.checkNotNull((Object)dirs);
        for (Object file : dirs) {
            try {
                Intrinsics.checkNotNull((Object)file);
                this.loadPlugin((File)file, origin);
            }
            catch (Throwable e) {
                if (!log.isErrorEnabled()) continue;
                log.error("Failed to load plugin file " + (File)file, e);
            }
        }
    }

    private final void loadInternalPlugins() {
        Semver semver = Semver.parse((String)Application.INSTANCE.getVersion());
        if (semver == null) {
            return;
        }
        Semver version = semver;
        this.plugins.add(new PluginDescriptor(new DynamicExtensionPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new PluginInternalPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new AccountPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new BadgePlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new UpdaterPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new FramePlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new SSHInternalPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new LocalInternalPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new RDPInternalPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new TelnetInternalPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        if (SystemUtils.IS_OS_WINDOWS) {
            this.plugins.add(new PluginDescriptor(new WSLInternalPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        }
        this.plugins.add(new PluginDescriptor(new SFTPPtyInternalPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new LocalPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new SFTPPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
        this.plugins.add(new PluginDescriptor(new FloatingToolbarPlugin(), null, null, PluginOrigin.Internal, version, null, null, 102, null));
    }

    private final void loadSystemPlugins() {
        File file;
        String appPath = Application.INSTANCE.getAppPath();
        if (StringsKt.isBlank((CharSequence)appPath)) {
            return;
        }
        if (SystemInfo.isMacOS) {
            File file2 = new File(appPath).getParentFile();
            if (file2 == null || (file2 = file2.getParentFile()) == null) {
                return;
            }
            contents = file2;
            file = new File(contents, "plugins");
        } else if (SystemInfo.isWindows) {
            File file3 = new File(appPath).getParentFile();
            if (file3 == null) {
                return;
            }
            contents = file3;
            var4_3 = new String[]{"plugins"};
            file = FileUtils.getFile((File)contents, (String[])var4_3);
        } else if (SystemInfo.isLinux) {
            File file4 = new File(appPath).getParentFile();
            if (file4 == null || (file4 = file4.getParentFile()) == null) {
                return;
            }
            contents = file4;
            var4_3 = new String[]{"lib", "plugins"};
            file = FileUtils.getFile((File)contents, (String[])var4_3);
        } else {
            throw new IllegalStateException(SystemUtils.OS_NAME);
        }
        File plugins = file;
        Intrinsics.checkNotNull((Object)plugins);
        this.loadPlugins(plugins, PluginOrigin.System);
    }

    private final void loadPlugin(File file, PluginOrigin origin) {
        Collection jars;
        File[] updatedFiles;
        String[] stringArray = new String[]{"uninstalled"};
        File uninstalledFile = FileUtils.getFile((File)file, (String[])stringArray);
        if (uninstalledFile.exists()) {
            BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(file, null){
                int label;
                final /* synthetic */ File $file;
                {
                    this.$file = $file;
                    super(2, $completion);
                }

                public final Object invokeSuspend(Object $result) {
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)$result);
                            FileUtils.deleteQuietly((File)this.$file);
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)2, null);
            return;
        }
        String[] stringArray2 = new String[]{"updated"};
        File updatedFile = FileUtils.getFile((File)file, (String[])stringArray2);
        File[] fileArray = updatedFile.listFiles(PluginManager::loadPlugin$lambda$0);
        if (fileArray == null) {
            fileArray = updatedFiles = new File[]{};
        }
        if (updatedFile.exists()) {
            if (!(updatedFiles.length == 0)) {
                File[] fileArray2 = file.listFiles(PluginManager::loadPlugin$lambda$1);
                if (fileArray2 == null) {
                    fileArray2 = new File[]{};
                }
                for (File item : fileArray2) {
                    FileUtils.deleteQuietly((File)item);
                }
                for (File item : updatedFiles) {
                    FileUtils.moveFileToDirectory((File)item, (File)file, (boolean)false);
                }
            }
            FileUtils.deleteQuietly((File)updatedFile);
        }
        if ((jars = FileUtils.listFiles((File)file, (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".jar"), (IOFileFilter)FileFilterUtils.falseFileFilter())).isEmpty()) {
            return;
        }
        Intrinsics.checkNotNull((Object)jars);
        Collection $this$toTypedArray$iv = jars;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PluginClassLoader loader = new PluginClassLoader(thisCollection$iv.toArray(new File[0]));
        Enumeration<URL> enumeration = loader.findResources("META-INF/plugin.xml");
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"findResources(...)");
        Iterator iterator2 = CollectionsKt.iterator(enumeration);
        while (iterator2.hasNext()) {
            URL e = (URL)iterator2.next();
            try {
                Class<?> clazz;
                URL iconResource = loader.findResource("META-INF/pluginIcon.svg");
                URL darkIconResource = loader.findResource("META-INF/pluginIcon_dark.svg");
                InputStream inputStream = e.openStream();
                Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"openStream(...)");
                URL uRL = iconResource;
                URL uRL2 = darkIconResource;
                PluginXmlParser.MyPluginDescriptor pluginDescriptor = PluginXmlParser.INSTANCE.parse(inputStream, uRL != null ? uRL.openStream() : null, uRL2 != null ? uRL2.openStream() : null);
                if (this.pluginIds.contains(pluginDescriptor.getId()) || !Plugin.class.isAssignableFrom(clazz = Class.forName(pluginDescriptor.getEntry(), false, loader))) continue;
                Object obj = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type app.termora.plugin.Plugin");
                Plugin entry = (Plugin)obj;
                this.pluginIds.add(pluginDescriptor.getId());
                Icon icon = pluginDescriptor.getIcon();
                String string = pluginDescriptor.getId();
                Semver semver = pluginDescriptor.getVersion();
                List<PluginDescription> list = pluginDescriptor.getDescriptions();
                this.plugins.add(new PluginDescriptor(entry, string, icon, origin, semver, list, file));
                if (!log.isInfoEnabled()) break;
                log.info("Loaded plugin " + entry.getName() + " from " + entry);
                break;
            }
            catch (Throwable ex) {
                if (!log.isErrorEnabled()) continue;
                log.error("Failed to load plugin entry " + e.getFile(), ex);
            }
        }
    }

    private static final boolean loadPlugins$lambda$0(File file) {
        return file.isDirectory();
    }

    private static final boolean loadPlugin$lambda$0(File it) {
        return it.isFile();
    }

    private static final boolean loadPlugin$lambda$1(File it) {
        return it.isFile();
    }

    public /* synthetic */ PluginManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lapp/termora/plugin/PluginManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "PLUGIN_DIR", "", "getInstance", "Lapp/termora/plugin/PluginManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PluginManager getInstance() {
            return (PluginManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(PluginManager.class), Companion::getInstance$lambda$0);
        }

        private static final PluginManager getInstance$lambda$0() {
            return new PluginManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001c\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0014\u0010\f\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016\u00a8\u0006\r"}, d2={"Lapp/termora/plugin/PluginManager$PluginClassLoader;", "Ljava/net/URLClassLoader;", "jarFiles", "", "Ljava/io/File;", "<init>", "([Ljava/io/File;)V", "getResources", "Ljava/util/Enumeration;", "Ljava/net/URL;", "name", "", "getResource", "termora"})
    @SourceDebugExtension(value={"SMAP\nPluginManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluginManager.kt\napp/termora/plugin/PluginManager$PluginClassLoader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,254:1\n11561#2:255\n11896#2,3:256\n37#3,2:259\n*S KotlinDebug\n*F\n+ 1 PluginManager.kt\napp/termora/plugin/PluginManager$PluginClassLoader\n*L\n243#1:255\n243#1:256,3\n243#1:259,2\n*E\n"})
    private static final class PluginClassLoader
    extends URLClassLoader {
        /*
         * WARNING - void declaration
         */
        public PluginClassLoader(@NotNull File[] jarFiles) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter((Object)jarFiles, (String)"jarFiles");
            File[] fileArray = jarFiles;
            PluginClassLoader pluginClassLoader = this;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var10_11 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.toURI().toURL());
            }
            Collection $this$toTypedArray$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            super(thisCollection$iv.toArray(new URL[0]));
        }

        @Override
        @Nullable
        public Enumeration<URL> getResources(@Nullable String name) {
            return this.findResources(name);
        }

        @Override
        @Nullable
        public URL getResource(@Nullable String name) {
            return this.findResource(name);
        }
    }
}

