/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.rdp;

import app.termora.Authentication;
import app.termora.AuthenticationType;
import app.termora.FixedLengthTextArea;
import app.termora.Host;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.Options;
import app.termora.OptionsPane;
import app.termora.OutlinePasswordField;
import app.termora.OutlineTextField;
import app.termora.PortSpinner;
import app.termora.Proxy;
import app.termora.ProxyType;
import app.termora.plugin.internal.BasicProxyOption;
import app.termora.plugin.internal.rdp.RDPHostOptionsPane;
import com.formdev.flatlaf.extras.components.FlatComboBox;
import com.formdev.flatlaf.ui.FlatTextBorder;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001:\u0001\u001bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0018\u0010\u0004\u001a\u00060\u0005R\u00020\u0000X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lapp/termora/plugin/internal/rdp/RDPHostOptionsPane;", "Lapp/termora/OptionsPane;", "<init>", "()V", "generalOption", "Lapp/termora/plugin/internal/rdp/RDPHostOptionsPane$GeneralOption;", "getGeneralOption", "()Lapp/termora/plugin/internal/rdp/RDPHostOptionsPane$GeneralOption;", "proxyOption", "Lapp/termora/plugin/internal/BasicProxyOption;", "getProxyOption", "()Lapp/termora/plugin/internal/BasicProxyOption;", "owner", "Ljava/awt/Window;", "getOwner", "()Ljava/awt/Window;", "getHost", "Lapp/termora/Host;", "setHost", "", "host", "validateFields", "", "validateField", "textField", "Ljavax/swing/JTextField;", "setOutlineError", "GeneralOption", "termora"})
public class RDPHostOptionsPane
extends OptionsPane {
    @NotNull
    private final GeneralOption generalOption = new GeneralOption();
    @NotNull
    private final BasicProxyOption proxyOption = new BasicProxyOption(null, 1, null);

    public RDPHostOptionsPane() {
        this.addOption(this.generalOption);
        this.addOption(this.proxyOption);
    }

    @NotNull
    protected final GeneralOption getGeneralOption() {
        return this.generalOption;
    }

    @NotNull
    protected final BasicProxyOption getProxyOption() {
        return this.proxyOption;
    }

    @NotNull
    protected final Window getOwner() {
        Window window = SwingUtilities.getWindowAncestor(this);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        return window;
    }

    @NotNull
    public Host getHost() {
        Object object;
        Object object2;
        String string;
        Object object3;
        Object object4;
        String name = this.generalOption.getNameTextField().getText();
        String protocol = "RDP";
        String host = this.generalOption.getHostTextField().getText();
        Object object5 = this.generalOption.getPortTextField().getValue();
        if (object5 == null) {
            object5 = 3389;
        }
        int port = (Integer)object5;
        Authentication authentication = Authentication.Companion.getNo();
        Proxy proxy = Proxy.Companion.getNo();
        Object object6 = this.generalOption.getAuthenticationTypeComboBox().getSelectedItem();
        Intrinsics.checkNotNull((Object)object6, (String)"null cannot be cast to non-null type app.termora.AuthenticationType");
        AuthenticationType authenticationType = (AuthenticationType)((Object)object6);
        String string2 = this.generalOption.getDesktopTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
        String desktop = ((Object)StringsKt.trim((CharSequence)string2)).toString();
        if (authenticationType == AuthenticationType.Password) {
            char[] cArray = this.generalOption.getPasswordTextField().getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            object4 = cArray;
            authentication = authentication.copy(authenticationType, new String((char[])object4));
        }
        if (this.proxyOption.getProxyTypeComboBox().getSelectedItem() != ProxyType.No) {
            object4 = proxy;
            Object object7 = this.proxyOption.getProxyTypeComboBox().getSelectedItem();
            Intrinsics.checkNotNull((Object)object7, (String)"null cannot be cast to non-null type app.termora.ProxyType");
            object3 = (ProxyType)((Object)object7);
            String string3 = this.proxyOption.getProxyHostTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            string = string3;
            String string4 = this.proxyOption.getProxyUsernameTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            object2 = string4;
            char[] cArray = this.proxyOption.getProxyPasswordTextField().getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            char[] cArray2 = cArray;
            object = new String(cArray2);
            Object object8 = this.proxyOption.getProxyPortTextField().getValue();
            Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type kotlin.Int");
            int n = (Integer)object8;
            Object object9 = this.proxyOption.getProxyAuthenticationTypeComboBox().getSelectedItem();
            Intrinsics.checkNotNull((Object)object9, (String)"null cannot be cast to non-null type app.termora.AuthenticationType");
            AuthenticationType authenticationType2 = (AuthenticationType)((Object)object9);
            proxy = ((Proxy)object4).copy((ProxyType)((Object)object3), string, n, authenticationType2, (String)object2, (String)object);
        }
        Intrinsics.checkNotNull((Object)name);
        object4 = name;
        Intrinsics.checkNotNull((Object)host);
        object3 = host;
        String string5 = this.generalOption.getUsernameTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
        string = string5;
        object2 = authentication;
        object = proxy;
        long l = System.currentTimeMillis();
        String string6 = this.generalOption.getRemarkTextArea().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
        String string7 = string6;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"desktop", (Object)desktop)};
        Options options = Options.copy$default(Options.Companion.getDefault(), null, null, null, null, null, 0, null, null, false, null, null, MapsKt.mutableMapOf((Pair[])pairArray), 2047, null);
        return new Host(null, (String)object4, protocol, (String)object3, port, string, string7, (Authentication)object2, (Proxy)object, options, null, l, null, null, null, null, false, 0L, 0L, 521217, null);
    }

    public final void setHost(@NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.generalOption.getPortTextField().setValue(host.getPort());
        this.generalOption.getNameTextField().setText(host.getName());
        this.generalOption.getUsernameTextField().setText(host.getUsername());
        this.generalOption.getHostTextField().setText(host.getHost());
        this.generalOption.getRemarkTextArea().setText(host.getRemark());
        this.generalOption.getAuthenticationTypeComboBox().setSelectedItem((Object)host.getAuthentication().getType());
        if (host.getAuthentication().getType() == AuthenticationType.Password) {
            this.generalOption.getPasswordTextField().setText(host.getAuthentication().getPassword());
        }
        OutlineTextField outlineTextField = this.generalOption.getDesktopTextField();
        String string = host.getOptions().getExtras().get("desktop");
        if (string == null) {
            string = "";
        }
        outlineTextField.setText(string);
        this.proxyOption.getProxyTypeComboBox().setSelectedItem((Object)host.getProxy().getType());
        this.proxyOption.getProxyHostTextField().setText(host.getProxy().getHost());
        this.proxyOption.getProxyPasswordTextField().setText(host.getProxy().getPassword());
        this.proxyOption.getProxyUsernameTextField().setText(host.getProxy().getUsername());
        this.proxyOption.getProxyPortTextField().setValue(host.getProxy().getPort());
        this.proxyOption.getProxyAuthenticationTypeComboBox().setSelectedItem((Object)host.getProxy().getAuthenticationType());
    }

    public final boolean validateFields() {
        CharSequence charSequence;
        Host host = this.getHost();
        if (this.validateField((JTextField)((Object)this.generalOption.getNameTextField())) || this.validateField((JTextField)((Object)this.generalOption.getHostTextField()))) {
            return false;
        }
        if (this.validateField((JTextField)((Object)this.generalOption.getUsernameTextField()))) {
            return false;
        }
        if (host.getAuthentication().getType() == AuthenticationType.Password && this.validateField((JTextField)((Object)this.generalOption.getPasswordTextField()))) {
            return false;
        }
        if (host.getProxy().getType() != ProxyType.No) {
            if (this.validateField((JTextField)((Object)this.proxyOption.getProxyHostTextField()))) {
                return false;
            }
            if (host.getProxy().getAuthenticationType() != AuthenticationType.No && (this.validateField((JTextField)((Object)this.proxyOption.getProxyUsernameTextField())) || this.validateField((JTextField)((Object)this.proxyOption.getProxyPasswordTextField())))) {
                return false;
            }
        }
        String string = this.generalOption.getDesktopTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        String desktop = ((Object)StringsKt.trim((CharSequence)string)).toString();
        if (!StringsKt.isBlank((CharSequence)desktop) && !new Regex("^\\d+x\\d+$").matches(charSequence = (CharSequence)desktop)) {
            this.setOutlineError((JTextField)((Object)this.generalOption.getDesktopTextField()));
            return false;
        }
        return true;
    }

    private final boolean validateField(JTextField textField) {
        if (textField.isEnabled()) {
            String string = textField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this.setOutlineError(textField);
                return true;
            }
        }
        return false;
    }

    private final void setOutlineError(JTextField textField) {
        this.selectOptionJComponent(textField);
        textField.putClientProperty("JComponent.outline", "error");
        textField.requestFocusInWindow();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020!H\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020*H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0011\u0010\u0011\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\fR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006,"}, d2={"Lapp/termora/plugin/internal/rdp/RDPHostOptionsPane$GeneralOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/plugin/internal/rdp/RDPHostOptionsPane;)V", "portTextField", "Lapp/termora/PortSpinner;", "getPortTextField", "()Lapp/termora/PortSpinner;", "nameTextField", "Lapp/termora/OutlineTextField;", "getNameTextField", "()Lapp/termora/OutlineTextField;", "usernameTextField", "getUsernameTextField", "hostTextField", "getHostTextField", "desktopTextField", "getDesktopTextField", "passwordTextField", "Lapp/termora/OutlinePasswordField;", "getPasswordTextField", "()Lapp/termora/OutlinePasswordField;", "remarkTextArea", "Lapp/termora/FixedLengthTextArea;", "getRemarkTextArea", "()Lapp/termora/FixedLengthTextArea;", "authenticationTypeComboBox", "Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "Lapp/termora/AuthenticationType;", "getAuthenticationTypeComboBox", "()Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "getCenterComponent", "termora"})
    @SourceDebugExtension(value={"SMAP\nRDPHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RDPHostOptionsPane.kt\napp/termora/plugin/internal/rdp/RDPHostOptionsPane$GeneralOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,304:1\n1#2:305\n*E\n"})
    protected final class GeneralOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final PortSpinner portTextField;
        @NotNull
        private final OutlineTextField nameTextField;
        @NotNull
        private final OutlineTextField usernameTextField;
        @NotNull
        private final OutlineTextField hostTextField;
        @NotNull
        private final OutlineTextField desktopTextField;
        @NotNull
        private final OutlinePasswordField passwordTextField;
        @NotNull
        private final FixedLengthTextArea remarkTextArea;
        @NotNull
        private final FlatComboBox<AuthenticationType> authenticationTypeComboBox;

        public GeneralOption() {
            super(new BorderLayout());
            this.portTextField = new PortSpinner(3389);
            this.nameTextField = new OutlineTextField(128);
            this.usernameTextField = new OutlineTextField(128);
            this.hostTextField = new OutlineTextField(255);
            this.desktopTextField = new OutlineTextField(255);
            this.passwordTextField = new OutlinePasswordField(255, false, 2, null);
            this.remarkTextArea = new FixedLengthTextArea(512);
            this.authenticationTypeComboBox = new FlatComboBox();
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final PortSpinner getPortTextField() {
            return this.portTextField;
        }

        @NotNull
        public final OutlineTextField getNameTextField() {
            return this.nameTextField;
        }

        @NotNull
        public final OutlineTextField getUsernameTextField() {
            return this.usernameTextField;
        }

        @NotNull
        public final OutlineTextField getHostTextField() {
            return this.hostTextField;
        }

        @NotNull
        public final OutlineTextField getDesktopTextField() {
            return this.desktopTextField;
        }

        @NotNull
        public final OutlinePasswordField getPasswordTextField() {
            return this.passwordTextField;
        }

        @NotNull
        public final FixedLengthTextArea getRemarkTextArea() {
            return this.remarkTextArea;
        }

        @NotNull
        public final FlatComboBox<AuthenticationType> getAuthenticationTypeComboBox() {
            return this.authenticationTypeComboBox;
        }

        private final void initView() {
            this.add((Component)this.getCenterComponent(), "Center");
            this.authenticationTypeComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Object object;
                    Object text;
                    Object object2 = value;
                    if (object2 == null || (object2 = object2.toString()) == null) {
                        object2 = text = "";
                    }
                    if ((object = value) == AuthenticationType.Password) {
                        text = "Password";
                    } else if (object == AuthenticationType.PublicKey) {
                        text = "Public Key";
                    } else if (object == AuthenticationType.KeyboardInteractive) {
                        text = "Keyboard Interactive";
                    }
                    Component component = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                    return component;
                }
            });
            this.desktopTextField.setPlaceholderText(I18n.INSTANCE.getString("termora.new-host.rdp.desktop-placeholder"));
            this.authenticationTypeComboBox.addItem((Object)AuthenticationType.No);
            this.authenticationTypeComboBox.addItem((Object)AuthenticationType.Password);
            this.authenticationTypeComboBox.setSelectedItem((Object)AuthenticationType.Password);
        }

        private final void initEvents() {
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ GeneralOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SwingUtilities.invokeLater(() -> initEvents.1.componentResized$lambda$0(this.this$0));
                    this.this$0.removeComponentListener(this);
                }

                private static final void componentResized$lambda$0(GeneralOption this$0) {
                    this$0.getNameTextField().requestFocusInWindow();
                }
            });
            this.authenticationTypeComboBox.addItemListener(arg_0 -> GeneralOption.initEvents$lambda$0(this, arg_0));
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)((Object)Icons.INSTANCE.getSettings());
        }

        @Override
        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.new-host.general");
        }

        @Override
        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private final JComponent getCenterComponent() {
            void $this$getCenterComponent_u24lambda_u246;
            Object object;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow, 7dlu, pref, 7dlu, default", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
            this.remarkTextArea.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
            this.remarkTextArea.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
            this.remarkTextArea.setRows(8);
            this.remarkTextArea.setLineWrap(true);
            this.remarkTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$getCenterComponent_u24lambda_u240 = object = FormBuilder.create().layout(layout).add(I18n.INSTANCE.getString("termora.new-host.general.name") + ":", new Object[0]).xy(1, rows).add((Component)((Object)this.nameTextField)).xyw(3, rows, 5);
            boolean bl = false;
            FormBuilder $this$getCenterComponent_u24lambda_u241 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.host") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.hostTextField)).xy(3, rows).add(I18n.INSTANCE.getString("termora.new-host.general.port") + ":", new Object[0]).xy(5, rows).add((Component)((Object)this.portTextField)).xy(7, rows);
            boolean bl2 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u242 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.username") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.usernameTextField)).xyw(3, rows, 5);
            boolean bl3 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u243 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.authentication") + ":", new Object[0]).xy(1, rows += step).add((Component)this.authenticationTypeComboBox).xyw(3, rows, 5);
            boolean bl4 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u244 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.password") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.passwordTextField)).xyw(3, rows, 5);
            boolean bl5 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u245 = object = object.add(I18n.INSTANCE.getString("termora.new-host.rdp.resolution") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.desktopTextField)).xyw(3, rows, 5);
            boolean bl6 = false;
            FormBuilder formBuilder = object.add(I18n.INSTANCE.getString("termora.new-host.general.remark") + ":", new Object[0]).xy(1, rows += step);
            $this$getCenterComponent_u24lambda_u245 = object = new JScrollPane((Component)((Object)this.remarkTextArea));
            FormBuilder formBuilder2 = formBuilder;
            boolean bl7 = false;
            $this$getCenterComponent_u24lambda_u246.setBorder((Border)new FlatTextBorder());
            Object $this$getCenterComponent_u24lambda_u247 = object = formBuilder2.add((Component)object).xyw(3, rows, 5);
            boolean bl8 = false;
            rows += step;
            JPanel panel2 = object.build();
            Intrinsics.checkNotNull((Object)panel2);
            return panel2;
        }

        private static final void initEvents$lambda$0(GeneralOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                this$0.passwordTextField.setEnabled(this$0.authenticationTypeComboBox.getSelectedItem() == AuthenticationType.Password);
            }
        }
    }
}

