/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.wsl;

import app.termora.Host;
import app.termora.PtyConnectorFactory;
import app.termora.PtyHostTerminalTab;
import app.termora.TerminalTab;
import app.termora.WindowScope;
import app.termora.terminal.PtyConnector;
import app.termora.terminal.TerminalSize;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0014J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lapp/termora/plugin/internal/wsl/WSLHostTerminalTab;", "Lapp/termora/PtyHostTerminalTab;", "windowScope", "Lapp/termora/WindowScope;", "host", "Lapp/termora/Host;", "<init>", "(Lapp/termora/WindowScope;Lapp/termora/Host;)V", "openPtyConnector", "Lapp/termora/terminal/PtyConnector;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "createReconnectTerminalTab", "Lapp/termora/TerminalTab;", "sendStartupCommand", "", "ptyConnector", "bytes", "", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nWSLHostTerminalTab.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WSLHostTerminalTab.kt\napp/termora/plugin/internal/wsl/WSLHostTerminalTab\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,59:1\n37#2,2:60\n*S KotlinDebug\n*F\n+ 1 WSLHostTerminalTab.kt\napp/termora/plugin/internal/wsl/WSLHostTerminalTab\n*L\n42#1:60,2\n*E\n"})
public final class WSLHostTerminalTab
extends PtyHostTerminalTab {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public WSLHostTerminalTab(@NotNull WindowScope windowScope, @NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)windowScope, (String)"windowScope");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(windowScope, host, null, 4, null);
    }

    @Override
    @Nullable
    public Object openPtyConnector(@NotNull Continuation<? super PtyConnector> $completion) {
        TerminalSize winSize = this.getTerminalPanel().winSize();
        String drive = System.getenv("SystemRoot");
        String[] stringArray = new String[]{drive, "System32", "wsl.exe"};
        String wsl = FileUtils.getFile((String[])stringArray).getAbsolutePath();
        List commands = new ArrayList();
        Intrinsics.checkNotNull((Object)wsl);
        commands.add(wsl);
        commands.add("-d");
        commands.add(this.getHost().getHost());
        CharSequence[] charSequenceArray = new CharSequence[]{this.getHost().getOptions().getStartupCommand()};
        if (StringUtils.isNoneBlank((CharSequence[])charSequenceArray)) {
            commands.addAll((Collection)Companion.parseCommand(this.getHost().getOptions().getStartupCommand()));
        }
        PtyConnectorFactory ptyConnectorFactory = PtyConnectorFactory.Companion.getInstance();
        Collection $this$toTypedArray$iv = commands;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        int n = winSize.getRows();
        int n2 = winSize.getCols();
        Map<String, String> map = this.getHost().getOptions().envs();
        Charset charset = Charsets.toCharset((String)this.getHost().getOptions().getEncoding(), (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"toCharset(...)");
        PtyConnector ptyConnector = PtyConnectorFactory.createPtyConnector$default(ptyConnectorFactory, thisCollection$iv.toArray(new String[0]), n, n2, map, null, charset, 16, null);
        return ptyConnector;
    }

    @Override
    @NotNull
    protected TerminalTab createReconnectTerminalTab() {
        return new WSLHostTerminalTab(this.getWindowScope(), this.getHost());
    }

    @Override
    public void sendStartupCommand(@NotNull PtyConnector ptyConnector, @NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)ptyConnector, (String)"ptyConnector");
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lapp/termora/plugin/internal/wsl/WSLHostTerminalTab$Companion;", "", "<init>", "()V", "parseCommand", "", "", "command", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> parseCommand(@NotNull String command) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            List result2 = new ArrayList();
            Matcher matcher = Pattern.compile("\"([^\"]*)\"|(\\S+)").matcher(command);
            while (matcher.find()) {
                boolean bl;
                if (matcher.group(1) != null) {
                    String string = matcher.group(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                    bl = result2.add(string);
                    continue;
                }
                String string = matcher.group(2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                bl = result2.add(StringsKt.replace$default((String)string, (String)"\\\\ ", (String)" ", (boolean)false, (int)4, null));
            }
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

