/*
 * Decompiled with CFR 0.152.
 */
package app.termora.tag;

import app.termora.account.AccountOwner;
import app.termora.tag.Tag;
import app.termora.tag.TagManager;
import java.util.Collection;
import javax.swing.DefaultListModel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lapp/termora/tag/TagListModel;", "Ljavax/swing/DefaultListModel;", "Lapp/termora/tag/Tag;", "accountOwner", "Lapp/termora/account/AccountOwner;", "<init>", "(Lapp/termora/account/AccountOwner;)V", "tagManager", "Lapp/termora/tag/TagManager;", "getTagManager", "()Lapp/termora/tag/TagManager;", "addElement", "", "element", "setElementAt", "index", "", "removeElement", "", "obj", "", "removeElementAt", "termora"})
public final class TagListModel
extends DefaultListModel<Tag> {
    @NotNull
    private final AccountOwner accountOwner;

    public TagListModel(@NotNull AccountOwner accountOwner) {
        Intrinsics.checkNotNullParameter((Object)accountOwner, (String)"accountOwner");
        this.accountOwner = accountOwner;
        super.addAll((Collection)this.getTagManager().getTags(this.accountOwner.getId()));
    }

    private final TagManager getTagManager() {
        return TagManager.Companion.getInstance();
    }

    @Override
    public void addElement(@NotNull Tag element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.getTagManager().addTag(element, this.accountOwner);
        super.addElement(element);
    }

    @Override
    public void setElementAt(@NotNull Tag element, int index) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        this.getTagManager().addTag(element, this.accountOwner);
        super.setElementAt(element, index);
    }

    @Override
    public boolean removeElement(@NotNull Object obj) {
        Intrinsics.checkNotNullParameter((Object)obj, (String)"obj");
        if (obj instanceof Tag) {
            this.getTagManager().removeTag(((Tag)obj).getId());
        }
        return super.removeElement(obj);
    }

    @Override
    public void removeElementAt(int index) {
        Object e = this.getElementAt(index);
        Intrinsics.checkNotNullExpressionValue(e, (String)"getElementAt(...)");
        this.removeElement(e);
    }
}

