/*
 * Decompiled with CFR 0.152.
 */
package app.termora.tag;

import app.termora.ColorHash;
import app.termora.ColorIcon;
import app.termora.CryptoKt;
import app.termora.Disposable;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.OptionPane;
import app.termora.account.AccountOwner;
import app.termora.tag.Tag;
import app.termora.tag.TagListModel;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\b\u0010\u0017\u001a\u00020\u0016H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000e\u001a\u0010\u0012\f\u0012\n \t*\u0004\u0018\u00010\u00100\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lapp/termora/tag/TagPanel;", "Ljavax/swing/JPanel;", "Lapp/termora/Disposable;", "accountOwner", "Lapp/termora/account/AccountOwner;", "<init>", "(Lapp/termora/account/AccountOwner;)V", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "model", "Lapp/termora/tag/TagListModel;", "list", "Ljavax/swing/JList;", "Lapp/termora/tag/Tag;", "addBtn", "Ljavax/swing/JButton;", "editBtn", "deleteBtn", "initView", "", "initEvents", "createCenterPanel", "Ljavax/swing/JComponent;", "termora"})
@SourceDebugExtension(value={"SMAP\nTagPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TagPanel.kt\napp/termora/tag/TagPanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,141:1\n1#2:142\n11591#3:143\n11926#3,3:144\n*S KotlinDebug\n*F\n+ 1 TagPanel.kt\napp/termora/tag/TagPanel\n*L\n98#1:143\n98#1:144,3\n*E\n"})
public final class TagPanel
extends JPanel
implements Disposable {
    @NotNull
    private final TagListModel model;
    @NotNull
    private final JList<Tag> list;
    @NotNull
    private final JButton addBtn;
    @NotNull
    private final JButton editBtn;
    @NotNull
    private final JButton deleteBtn;

    public TagPanel(@NotNull AccountOwner accountOwner) {
        Intrinsics.checkNotNullParameter((Object)accountOwner, (String)"accountOwner");
        super(new BorderLayout());
        this.model = new TagListModel(accountOwner);
        this.list = new JList(this.model);
        this.addBtn = new JButton(I18n.INSTANCE.getString("termora.new-host.tunneling.add"));
        this.editBtn = new JButton(I18n.INSTANCE.getString("termora.keymgr.edit"));
        this.deleteBtn = new JButton(I18n.INSTANCE.getString("termora.remove"));
        this.initView();
        this.initEvents();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private final void initView() {
        this.editBtn.setEnabled(false);
        this.deleteBtn.setEnabled(false);
        this.list.setFixedCellHeight(UIManager.getInt("Tree.rowHeight"));
        this.list.setSelectionMode(2);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object text = value instanceof Tag ? ((Tag)value).getText() : value;
                Component c = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                if (!(value instanceof Tag)) {
                    return c;
                }
                this.setIcon(new ColorIcon(0, 0, ColorHash.INSTANCE.hash(((Tag)value).getId()), false, 11, null));
                return c;
            }
        });
        this.add((Component)this.createCenterPanel(), "Center");
    }

    private final void initEvents() {
        this.addBtn.addActionListener(arg_0 -> TagPanel.initEvents$lambda$0(this, arg_0));
        this.editBtn.addActionListener(arg_0 -> TagPanel.initEvents$lambda$1(this, arg_0));
        this.deleteBtn.addActionListener(arg_0 -> TagPanel.initEvents$lambda$2(this, arg_0));
        this.list.getSelectionModel().addListSelectionListener(arg_0 -> TagPanel.initEvents$lambda$3(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createCenterPanel() {
        FormBuilder formBuilder;
        void $this$createCenterPanel_u24lambda_u240;
        JScrollPane jScrollPane;
        JPanel panel2 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane2 = jScrollPane = new JScrollPane(this.list);
        JPanel jPanel = panel2;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, DynamicColor.Companion.getBorderColor()));
        jPanel.add((Component)jScrollPane, "Center");
        int rows = 0;
        rows = 1;
        int step = 2;
        String formMargin = "4dlu";
        FormLayout layout = new FormLayout("default:grow", "pref, " + formMargin + ", pref, " + formMargin + ", pref");
        FormBuilder formBuilder2 = formBuilder = FormBuilder.create().layout(layout).padding(new EmptyBorder(0, 12, 0, 0)).add((Component)this.addBtn).xy(1, rows);
        jPanel = panel2;
        boolean bl2 = false;
        FormBuilder $this$createCenterPanel_u24lambda_u241 = formBuilder = formBuilder.add((Component)this.editBtn).xy(1, rows += step);
        boolean bl3 = false;
        FormBuilder $this$createCenterPanel_u24lambda_u242 = formBuilder = formBuilder.add((Component)this.deleteBtn).xy(1, rows += step);
        boolean bl4 = false;
        rows += step;
        jPanel.add((Component)formBuilder.build(), "East");
        panel2.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        return panel2;
    }

    private static final void initEvents$lambda$0(TagPanel this$0, ActionEvent it) {
        String text = OptionPane.showInputDialog$default(OptionPane.INSTANCE, this$0.getOwner(), I18n.INSTANCE.getString("termora.tag"), null, null, 12, null);
        CharSequence charSequence = text;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            this$0.model.addElement(new Tag(CryptoKt.randomUUID(), text, System.currentTimeMillis(), System.currentTimeMillis()));
        }
    }

    private static final void initEvents$lambda$1(TagPanel this$0, ActionEvent it) {
        int index = this$0.list.getSelectedIndex();
        if (index >= 0) {
            Tag tag = (Tag)this$0.model.getElementAt(index);
            Object object = OptionPane.INSTANCE;
            Window window = this$0.getOwner();
            String string = tag.getText();
            String string2 = I18n.INSTANCE.getString("termora.tag");
            String text = OptionPane.showInputDialog$default((OptionPane)object, window, string2, string, null, 8, null);
            if (!((object = (CharSequence)text) == null || StringsKt.isBlank((CharSequence)object))) {
                TagListModel tagListModel = this$0.model;
                Intrinsics.checkNotNull((Object)tag);
                tagListModel.setElementAt(Tag.copy$default(tag, null, text, 0L, System.currentTimeMillis(), 5, null), index);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void initEvents$lambda$2(TagPanel this$0, ActionEvent it) {
        if (OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, SwingUtilities.getWindowAncestor(this$0), I18n.INSTANCE.getString("termora.keymgr.delete-warning"), null, 0, 2, null, null, null, null, 492, null) == 0) {
            void $this$mapTo$iv$iv;
            int[] nArray = this$0.list.getSelectedIndices();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedIndices(...)");
            int[] $this$map$iv = nArray;
            boolean $i$f$map = false;
            int[] nArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it2;
                void item$iv$iv;
                void var11_10 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((Tag)this$0.model.getElementAt((int)it2));
            }
            for (Tag tag : (List)destination$iv$iv) {
                TagListModel tagListModel = this$0.model;
                Intrinsics.checkNotNull((Object)tag);
                tagListModel.removeElement(tag);
            }
        }
    }

    private static final void initEvents$lambda$3(TagPanel this$0, ListSelectionEvent it) {
        JButton jButton = this$0.editBtn;
        int[] nArray = this$0.list.getSelectedIndices();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedIndices(...)");
        jButton.setEnabled(!(nArray.length == 0));
        this$0.deleteBtn.setEnabled(this$0.editBtn.isEnabled());
    }
}

