/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer;

import app.termora.database.DatabaseManager;
import app.termora.transfer.AbstractTransfer;
import app.termora.transfer.Transfer;
import app.termora.transfer.TransferAction;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0001 B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0016\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001bH\u0096@\u00a2\u0006\u0002\u0010\u001cJ\b\u0010\u001d\u001a\u00020\u0015H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lapp/termora/transfer/FileTransfer;", "Lapp/termora/transfer/AbstractTransfer;", "Ljava/io/Closeable;", "parentId", "", "source", "Ljava/nio/file/Path;", "target", "size", "", "action", "Lapp/termora/transfer/TransferAction;", "priority", "Lapp/termora/transfer/Transfer$Priority;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;JLapp/termora/transfer/TransferAction;Lapp/termora/transfer/Transfer$Priority;)V", "input", "Ljava/io/InputStream;", "output", "Ljava/io/OutputStream;", "isPreserveModificationTime", "", "()Z", "closed", "Ljava/util/concurrent/atomic/AtomicBoolean;", "transfer", "bufferSize", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "scanning", "close", "", "Companion", "termora"})
public final class FileTransfer
extends AbstractTransfer
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long size;
    @NotNull
    private final TransferAction action;
    private InputStream input;
    private OutputStream output;
    @NotNull
    private final AtomicBoolean closed;
    private static final Logger log = LoggerFactory.getLogger(FileTransfer.class);

    public FileTransfer(@NotNull String parentId, @NotNull Path source, @NotNull Path target, long size, @NotNull TransferAction action2, @NotNull Transfer.Priority priority) {
        Intrinsics.checkNotNullParameter((Object)parentId, (String)"parentId");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)action2), (String)"action");
        Intrinsics.checkNotNullParameter((Object)((Object)priority), (String)"priority");
        super(parentId, source, target, false, priority);
        this.size = size;
        this.action = action2;
        this.closed = new AtomicBoolean(false);
    }

    public /* synthetic */ FileTransfer(String string, Path path, Path path2, long l, TransferAction transferAction, Transfer.Priority priority, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            priority = Transfer.Priority.Normal;
        }
        this(string, path, path2, l, transferAction, priority);
    }

    private final boolean isPreserveModificationTime() {
        return DatabaseManager.Companion.getInstance().getSftp().getPreserveModificationTime();
    }

    @Override
    @Nullable
    public Object transfer(int bufferSize, @NotNull Continuation<? super Long> $completion) {
        int len;
        OpenOption[] openOptionArray;
        Path path;
        if (this.closed.get()) {
            throw new IllegalStateException("Transfer already closed");
        }
        if (this.input == null) {
            path = this.source();
            openOptionArray = new OpenOption[]{StandardOpenOption.READ};
            InputStream inputStream = Files.newInputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
            this.input = inputStream;
        }
        if (this.output == null) {
            OutputStream outputStream;
            if (this.action == TransferAction.Overwrite) {
                OpenOption[] openOptionArray2 = new OpenOption[]{};
                OutputStream outputStream2 = Files.newOutputStream(this.target(), Arrays.copyOf(openOptionArray2, openOptionArray2.length));
                outputStream = outputStream2;
                Intrinsics.checkNotNullExpressionValue((Object)outputStream2, (String)"newOutputStream(...)");
            } else {
                path = this.target();
                openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.APPEND};
                OutputStream outputStream3 = Files.newOutputStream(path, Arrays.copyOf(openOptionArray, openOptionArray.length));
                outputStream = outputStream3;
                Intrinsics.checkNotNullExpressionValue((Object)outputStream3, (String)"newOutputStream(...)");
            }
            this.output = outputStream;
        }
        byte[] buffer = new byte[bufferSize];
        InputStream inputStream = this.input;
        if (inputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"input");
            inputStream = null;
        }
        if ((len = inputStream.read(buffer)) <= 0) {
            return Boxing.boxLong((long)0L);
        }
        OutputStream outputStream = this.output;
        if (outputStream == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"output");
            outputStream = null;
        }
        outputStream.write(buffer, 0, len);
        return Boxing.boxLong((long)len);
    }

    @Override
    public boolean scanning() {
        return false;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public void close() {
        block11: {
            if (!this.closed.compareAndSet(false, true)) break block11;
            if (this.input != null) {
                InputStream inputStream = this.input;
                if (inputStream == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"input");
                    inputStream = null;
                }
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            if (this.output != null) {
                OutputStream outputStream = this.output;
                if (outputStream == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"output");
                    outputStream = null;
                }
                IOUtils.closeQuietly((OutputStream)outputStream);
            }
            if (this.isPreserveModificationTime()) {
                Object object;
                Object object2 = this;
                try {
                    Path path;
                    FileTransfer $this$close_u24lambda_u240 = object2;
                    boolean bl = false;
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    FileTime fileTime = Files.getLastModifiedTime($this$close_u24lambda_u240.source(), Arrays.copyOf(linkOptionArray, linkOptionArray.length));
                    Intrinsics.checkNotNullExpressionValue((Object)fileTime, (String)"getLastModifiedTime(...)");
                    FileTime time = fileTime;
                    FileSystem fs = $this$close_u24lambda_u240.target().getFileSystem();
                    if (fs instanceof SftpFileSystem && ((SftpFileSystem)fs).getVersion() == 3) {
                        BasicFileAttributeView view = Files.getFileAttributeView($this$close_u24lambda_u240.target(), BasicFileAttributeView.class, new LinkOption[0]);
                        view.setTimes(time, time, null);
                        path = Unit.INSTANCE;
                    } else {
                        path = Files.setLastModifiedTime($this$close_u24lambda_u240.target(), time);
                    }
                    object = Result.constructor-impl((Object)path);
                }
                catch (Throwable bl) {
                    object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                }
                object2 = object;
                Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                if (throwable != null) {
                    Object it = object = throwable;
                    boolean bl = false;
                    if (log.isWarnEnabled() && !(it instanceof UnsupportedOperationException)) {
                        log.warn(((Throwable)it).getMessage(), (Throwable)it);
                    }
                }
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/transfer/FileTransfer$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

