/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer;

import app.termora.I18n;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.util.Set;
import javax.swing.table.DefaultTableModel;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00172\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0005J\u0014\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u0005H\u0016J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\u0006\u0010\u0015\u001a\u00020\u0016\u00a8\u0006\u0019"}, d2={"Lapp/termora/transfer/TransportTableModel;", "Ljavax/swing/table/DefaultTableModel;", "<init>", "()V", "getColumnCount", "", "getPath", "Ljava/nio/file/Path;", "row", "getAttributes", "Lapp/termora/transfer/TransportTableModel$Attributes;", "getColumnClass", "Ljava/lang/Class;", "columnIndex", "getValueAt", "", "column", "getColumnName", "", "isCellEditable", "", "clear", "", "Companion", "Attributes", "termora"})
public final class TransportTableModel
extends DefaultTableModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_FILE_SIZE = 2;
    public static final int COLUMN_LAST_MODIFIED_TIME = 3;
    public static final int COLUMN_ATTRS = 4;
    public static final int COLUMN_OWNER = 5;

    @Override
    public int getColumnCount() {
        return 6;
    }

    @NotNull
    public final Path getPath(int row) {
        Object object = super.getValueAt(row, 0);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type java.nio.file.Path");
        return (Path)object;
    }

    @NotNull
    public final Attributes getAttributes(int row) {
        Object object = super.getValueAt(row, 1);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type app.termora.transfer.TransportTableModel.Attributes");
        return (Attributes)object;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int columnIndex) {
        return Attributes.class;
    }

    @Override
    @Nullable
    public Object getValueAt(int row, int column) {
        return this.getAttributes(row);
    }

    @Override
    @NotNull
    public String getColumnName(int column) {
        return switch (column) {
            case 0 -> I18n.INSTANCE.getString("termora.transport.table.filename");
            case 2 -> I18n.INSTANCE.getString("termora.transport.table.size");
            case 1 -> I18n.INSTANCE.getString("termora.transport.table.type");
            case 3 -> I18n.INSTANCE.getString("termora.transport.table.modified-time");
            case 4 -> I18n.INSTANCE.getString("termora.transport.table.permissions");
            case 5 -> I18n.INSTANCE.getString("termora.transport.table.owner");
            default -> "";
        };
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    public final void clear() {
        while (this.getRowCount() > 0) {
            this.removeRow(this.getRowCount() - 1);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\b\u0018\u0000 ,2\u00020\u0001:\u0001,BU\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\u0006\u0010\u000e\u001a\u00020\u0003\u0012\u0006\u0010\u000f\u001a\u00020\n\u00a2\u0006\u0004\b\u0010\u0010\u0011J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0006H\u00c6\u0003J\t\u0010 \u001a\u00020\u0006H\u00c6\u0003J\t\u0010!\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\"\u001a\u00020\nH\u00c6\u0003J\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003Ji\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\n2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\b\b\u0002\u0010\u000e\u001a\u00020\u00032\b\b\u0002\u0010\u000f\u001a\u00020\nH\u00c6\u0001J\u0013\u0010'\u001a\u00020\u00062\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010)\u001a\u00020*H\u00d6\u0001J\t\u0010+\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0015R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0013R\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0017R\u0011\u0010\u001c\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0015\u00a8\u0006-"}, d2={"Lapp/termora/transfer/TransportTableModel$Attributes;", "", "name", "", "type", "isDirectory", "", "isFile", "isSymbolicLink", "fileSize", "", "permissions", "", "Ljava/nio/file/attribute/PosixFilePermission;", "owner", "lastModifiedTime", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZZZJLjava/util/Set;Ljava/lang/String;J)V", "getName", "()Ljava/lang/String;", "getType", "()Z", "getFileSize", "()J", "getPermissions", "()Ljava/util/Set;", "getOwner", "getLastModifiedTime", "isParent", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "other", "hashCode", "", "toString", "Companion", "termora"})
    public static final class Attributes {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String name;
        @NotNull
        private final String type;
        private final boolean isDirectory;
        private final boolean isFile;
        private final boolean isSymbolicLink;
        private final long fileSize;
        @NotNull
        private final Set<PosixFilePermission> permissions;
        @NotNull
        private final String owner;
        private final long lastModifiedTime;

        public Attributes(@NotNull String name, @NotNull String type, boolean isDirectory, boolean isFile, boolean isSymbolicLink, long fileSize, @NotNull Set<? extends PosixFilePermission> permissions, @NotNull String owner, long lastModifiedTime) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.name = name;
            this.type = type;
            this.isDirectory = isDirectory;
            this.isFile = isFile;
            this.isSymbolicLink = isSymbolicLink;
            this.fileSize = fileSize;
            this.permissions = permissions;
            this.owner = owner;
            this.lastModifiedTime = lastModifiedTime;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final String getType() {
            return this.type;
        }

        public final boolean isDirectory() {
            return this.isDirectory;
        }

        public final boolean isFile() {
            return this.isFile;
        }

        public final boolean isSymbolicLink() {
            return this.isSymbolicLink;
        }

        public final long getFileSize() {
            return this.fileSize;
        }

        @NotNull
        public final Set<PosixFilePermission> getPermissions() {
            return this.permissions;
        }

        @NotNull
        public final String getOwner() {
            return this.owner;
        }

        public final long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final boolean isParent() {
            return Intrinsics.areEqual((Object)this.name, (Object)"..");
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final String component2() {
            return this.type;
        }

        public final boolean component3() {
            return this.isDirectory;
        }

        public final boolean component4() {
            return this.isFile;
        }

        public final boolean component5() {
            return this.isSymbolicLink;
        }

        public final long component6() {
            return this.fileSize;
        }

        @NotNull
        public final Set<PosixFilePermission> component7() {
            return this.permissions;
        }

        @NotNull
        public final String component8() {
            return this.owner;
        }

        public final long component9() {
            return this.lastModifiedTime;
        }

        @NotNull
        public final Attributes copy(@NotNull String name, @NotNull String type, boolean isDirectory, boolean isFile, boolean isSymbolicLink, long fileSize, @NotNull Set<? extends PosixFilePermission> permissions, @NotNull String owner, long lastModifiedTime) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return new Attributes(name, type, isDirectory, isFile, isSymbolicLink, fileSize, permissions, owner, lastModifiedTime);
        }

        public static /* synthetic */ Attributes copy$default(Attributes attributes, String string, String string2, boolean bl, boolean bl2, boolean bl3, long l, Set set, String string3, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                string = attributes.name;
            }
            if ((n & 2) != 0) {
                string2 = attributes.type;
            }
            if ((n & 4) != 0) {
                bl = attributes.isDirectory;
            }
            if ((n & 8) != 0) {
                bl2 = attributes.isFile;
            }
            if ((n & 0x10) != 0) {
                bl3 = attributes.isSymbolicLink;
            }
            if ((n & 0x20) != 0) {
                l = attributes.fileSize;
            }
            if ((n & 0x40) != 0) {
                set = attributes.permissions;
            }
            if ((n & 0x80) != 0) {
                string3 = attributes.owner;
            }
            if ((n & 0x100) != 0) {
                l2 = attributes.lastModifiedTime;
            }
            return attributes.copy(string, string2, bl, bl2, bl3, l, set, string3, l2);
        }

        @NotNull
        public String toString() {
            return "Attributes(name=" + this.name + ", type=" + this.type + ", isDirectory=" + this.isDirectory + ", isFile=" + this.isFile + ", isSymbolicLink=" + this.isSymbolicLink + ", fileSize=" + this.fileSize + ", permissions=" + this.permissions + ", owner=" + this.owner + ", lastModifiedTime=" + this.lastModifiedTime + ")";
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.type.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.isDirectory);
            result2 = result2 * 31 + Boolean.hashCode(this.isFile);
            result2 = result2 * 31 + Boolean.hashCode(this.isSymbolicLink);
            result2 = result2 * 31 + Long.hashCode(this.fileSize);
            result2 = result2 * 31 + ((Object)this.permissions).hashCode();
            result2 = result2 * 31 + this.owner.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.lastModifiedTime);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Attributes)) {
                return false;
            }
            Attributes attributes = (Attributes)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)attributes.name)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.type, (Object)attributes.type)) {
                return false;
            }
            if (this.isDirectory != attributes.isDirectory) {
                return false;
            }
            if (this.isFile != attributes.isFile) {
                return false;
            }
            if (this.isSymbolicLink != attributes.isSymbolicLink) {
                return false;
            }
            if (this.fileSize != attributes.fileSize) {
                return false;
            }
            if (!Intrinsics.areEqual(this.permissions, attributes.permissions)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.owner, (Object)attributes.owner)) {
                return false;
            }
            return this.lastModifiedTime == attributes.lastModifiedTime;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005\u00a8\u0006\n"}, d2={"Lapp/termora/transfer/TransportTableModel$Attributes$Companion;", "", "<init>", "()V", "computeType", "", "isSymbolicLink", "", "isDirectory", "name", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String computeType(boolean isSymbolicLink, boolean isDirectory, @NotNull String name) {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                if (isSymbolicLink) {
                    return I18n.INSTANCE.getString("termora.transport.table.type.symbolic-link");
                }
                if (isDirectory) {
                    return I18n.INSTANCE.getString("termora.folder");
                }
                if (Intrinsics.areEqual((Object)name, (Object)"..")) {
                    return "";
                }
                try {
                    String string = FilenameUtils.getExtension((String)name);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getExtension(...)");
                    return string;
                }
                catch (Exception exception) {
                    int idx = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
                    if (idx < 0) {
                        return "";
                    }
                    String string = name.substring(idx + 1);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    return string;
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lapp/termora/transfer/TransportTableModel$Companion;", "", "<init>", "()V", "COLUMN_NAME", "", "COLUMN_TYPE", "COLUMN_FILE_SIZE", "COLUMN_LAST_MODIFIED_TIME", "COLUMN_ATTRS", "COLUMN_OWNER", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

