/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer.internal.sftp;

import app.termora.CryptoKt;
import app.termora.I18n;
import app.termora.WindowScope;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.transfer.Transfer;
import app.termora.transfer.TransferIndeterminate;
import app.termora.transfer.TransferManager;
import app.termora.transfer.TransportContextMenuExtension;
import app.termora.transfer.TransportPopupMenu;
import app.termora.transfer.TransportTableModel;
import app.termora.transfer.TransportViewer;
import app.termora.transfer.internal.sftp.CompressMode;
import java.awt.event.ActionListener;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.sftp.client.fs.SftpFileSystem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0003\u001d\u001e\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000e0\rH\u0016J:\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00180\u000e0\rH\u0002J0\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\b\u0010\u001b\u001a\u00020\u001cH\u0016\u00a8\u0006 "}, d2={"Lapp/termora/transfer/internal/sftp/ExtractTransportContextMenuExtension;", "Lapp/termora/transfer/TransportContextMenuExtension;", "<init>", "()V", "createJMenuItem", "Ljavax/swing/JMenuItem;", "windowScope", "Lapp/termora/WindowScope;", "fileSystem", "Ljava/nio/file/FileSystem;", "popupMenu", "Lapp/termora/transfer/TransportPopupMenu;", "files", "", "Lkotlin/Pair;", "Ljava/nio/file/Path;", "Lapp/termora/transfer/TransportTableModel$Attributes;", "extract", "", "event", "Lapp/termora/actions/AnActionEvent;", "Lorg/apache/sshd/sftp/client/fs/SftpFileSystem;", "location", "Lapp/termora/transfer/internal/sftp/ExtractTransportContextMenuExtension$ExtractLocation;", "Lapp/termora/transfer/internal/sftp/CompressMode;", "mode", "file", "ordered", "", "Companion", "ExtractTransfer", "ExtractLocation", "termora"})
@SourceDebugExtension(value={"SMAP\nExtractTransportContextMenuExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExtractTransportContextMenuExtension.kt\napp/termora/transfer/internal/sftp/ExtractTransportContextMenuExtension\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,189:1\n1761#2,3:190\n295#2,2:193\n*S KotlinDebug\n*F\n+ 1 ExtractTransportContextMenuExtension.kt\napp/termora/transfer/internal/sftp/ExtractTransportContextMenuExtension\n*L\n30#1:190,3\n35#1:193,2\n*E\n"})
public final class ExtractTransportContextMenuExtension
implements TransportContextMenuExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ExtractTransportContextMenuExtension instance = new ExtractTransportContextMenuExtension();

    private ExtractTransportContextMenuExtension() {
    }

    @Override
    @NotNull
    public JMenuItem createJMenuItem(@NotNull WindowScope windowScope, @Nullable FileSystem fileSystem, @NotNull TransportPopupMenu popupMenu, @NotNull List<? extends Pair<? extends Path, TransportTableModel.Attributes>> files) {
        boolean hasParent;
        block10: {
            Intrinsics.checkNotNullParameter((Object)windowScope, (String)"windowScope");
            Intrinsics.checkNotNullParameter((Object)((Object)popupMenu), (String)"popupMenu");
            Intrinsics.checkNotNullParameter(files, (String)"files");
            if (files.isEmpty() || !(fileSystem instanceof SftpFileSystem)) {
                throw new UnsupportedOperationException();
            }
            Iterable $this$any$iv = files;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                v0 = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Pair it = (Pair)element$iv;
                    boolean bl = false;
                    if (!(((TransportTableModel.Attributes)it.getSecond()).isParent() || ((TransportTableModel.Attributes)it.getSecond()).isDirectory())) continue;
                    v0 = true;
                    break block10;
                }
                v0 = hasParent = false;
            }
        }
        if (hasParent) {
            throw new UnsupportedOperationException();
        }
        Map map = new LinkedHashMap();
        for (Pair<? extends Path, TransportTableModel.Attributes> pair : files) {
            Object v1;
            Path path;
            block11: {
                path = (Path)pair.component1();
                TransportTableModel.Attributes attr = (TransportTableModel.Attributes)pair.component2();
                Iterable $this$firstOrNull$iv = (Iterable)CompressMode.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CompressMode it = (CompressMode)((Object)element$iv);
                    boolean bl = false;
                    if (!StringsKt.endsWith((String)attr.getName(), (String)("." + it.getExtension()), (boolean)true)) continue;
                    v1 = element$iv;
                    break block11;
                }
                v1 = null;
            }
            CompressMode mode = v1;
            if (mode == null) {
                throw new UnsupportedOperationException();
            }
            map.put(path, mode);
        }
        JMenu extractMenu = new JMenu(I18n.INSTANCE.getString("termora.transport.table.contextmenu.extract"));
        extractMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.extract.here")).addActionListener((ActionListener)((Object)new AnAction(this, fileSystem, files, map){
            final /* synthetic */ ExtractTransportContextMenuExtension this$0;
            final /* synthetic */ FileSystem $fileSystem;
            final /* synthetic */ List<Pair<Path, TransportTableModel.Attributes>> $files;
            final /* synthetic */ Map<Path, CompressMode> $map;
            {
                this.this$0 = $receiver;
                this.$fileSystem = $fileSystem;
                this.$files = $files;
                this.$map = $map;
            }

            /*
             * WARNING - void declaration
             */
            protected void actionPerformed(AnActionEvent evt) {
                Collection<Pair> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                Iterable iterable = this.$files;
                Map<Path, CompressMode> map = this.$map;
                ExtractLocation extractLocation = ExtractLocation.Here;
                SftpFileSystem sftpFileSystem = (SftpFileSystem)this.$fileSystem;
                AnActionEvent anActionEvent = evt;
                ExtractTransportContextMenuExtension extractTransportContextMenuExtension = this.this$0;
                boolean $i$f$map = false;
                void var5_9 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Pair pair = (Pair)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(TuplesKt.to((Object)it.getFirst(), (Object)MapsKt.getValue(map, (Object)it.getFirst())));
                }
                collection = (List)destination$iv$iv;
                ExtractTransportContextMenuExtension.access$extract(extractTransportContextMenuExtension, anActionEvent, sftpFileSystem, extractLocation, (List)collection);
            }
        }));
        if (files.size() == 1) {
            Pair pair = (Pair)CollectionsKt.first(files);
            String name = StringUtils.removeEndIgnoreCase((String)((TransportTableModel.Attributes)pair.getSecond()).getName(), (String)("." + ((CompressMode)((Object)MapsKt.getValue((Map)map, (Object)pair.getFirst()))).getExtension()));
            Object[] objectArray = new Object[1];
            Intrinsics.checkNotNull((Object)name);
            objectArray[0] = name;
            String text = I18n.INSTANCE.getString("termora.transport.table.contextmenu.extract.single", objectArray);
            extractMenu.add(text).addActionListener((ActionListener)((Object)new AnAction(this, fileSystem, files, map){
                final /* synthetic */ ExtractTransportContextMenuExtension this$0;
                final /* synthetic */ FileSystem $fileSystem;
                final /* synthetic */ List<Pair<Path, TransportTableModel.Attributes>> $files;
                final /* synthetic */ Map<Path, CompressMode> $map;
                {
                    this.this$0 = $receiver;
                    this.$fileSystem = $fileSystem;
                    this.$files = $files;
                    this.$map = $map;
                }

                /*
                 * WARNING - void declaration
                 */
                protected void actionPerformed(AnActionEvent evt) {
                    Collection<Pair> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    Iterable iterable = this.$files;
                    Map<Path, CompressMode> map = this.$map;
                    ExtractLocation extractLocation = ExtractLocation.Self;
                    SftpFileSystem sftpFileSystem = (SftpFileSystem)this.$fileSystem;
                    AnActionEvent anActionEvent = evt;
                    ExtractTransportContextMenuExtension extractTransportContextMenuExtension = this.this$0;
                    boolean $i$f$map = false;
                    void var5_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Pair pair = (Pair)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(TuplesKt.to((Object)it.getFirst(), (Object)MapsKt.getValue(map, (Object)it.getFirst())));
                    }
                    collection = (List)destination$iv$iv;
                    ExtractTransportContextMenuExtension.access$extract(extractTransportContextMenuExtension, anActionEvent, sftpFileSystem, extractLocation, (List)collection);
                }
            }));
        } else {
            extractMenu.add(I18n.INSTANCE.getString("termora.transport.table.contextmenu.extract.multi")).addActionListener((ActionListener)((Object)new AnAction(this, fileSystem, files, map){
                final /* synthetic */ ExtractTransportContextMenuExtension this$0;
                final /* synthetic */ FileSystem $fileSystem;
                final /* synthetic */ List<Pair<Path, TransportTableModel.Attributes>> $files;
                final /* synthetic */ Map<Path, CompressMode> $map;
                {
                    this.this$0 = $receiver;
                    this.$fileSystem = $fileSystem;
                    this.$files = $files;
                    this.$map = $map;
                }

                /*
                 * WARNING - void declaration
                 */
                protected void actionPerformed(AnActionEvent evt) {
                    Collection<Pair> collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    Iterable iterable = this.$files;
                    Map<Path, CompressMode> map = this.$map;
                    ExtractLocation extractLocation = ExtractLocation.Self;
                    SftpFileSystem sftpFileSystem = (SftpFileSystem)this.$fileSystem;
                    AnActionEvent anActionEvent = evt;
                    ExtractTransportContextMenuExtension extractTransportContextMenuExtension = this.this$0;
                    boolean $i$f$map = false;
                    void var5_9 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        Pair pair = (Pair)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add(TuplesKt.to((Object)it.getFirst(), (Object)MapsKt.getValue(map, (Object)it.getFirst())));
                    }
                    collection = (List)destination$iv$iv;
                    ExtractTransportContextMenuExtension.access$extract(extractTransportContextMenuExtension, anActionEvent, sftpFileSystem, extractLocation, (List)collection);
                }
            }));
        }
        return extractMenu;
    }

    private final void extract(AnActionEvent event, SftpFileSystem fileSystem, ExtractLocation location, List<? extends Pair<? extends Path, ? extends CompressMode>> files) {
        for (Pair<? extends Path, ? extends CompressMode> pair : files) {
            this.extract(event, fileSystem, location, (CompressMode)((Object)pair.getSecond()), (Path)pair.getFirst());
        }
    }

    private final void extract(AnActionEvent event, SftpFileSystem fileSystem, ExtractLocation location, CompressMode mode, Path file) {
        TransferManager transferManager = event.getData(TransportViewer.Companion.getMyTransferManager());
        if (transferManager == null) {
            return;
        }
        TransferManager transferManager2 = transferManager;
        Path path = file.getParent();
        if (path == null) {
            path = file.getFileSystem().getPath(file.getFileSystem().getSeparator(), new String[0]);
        }
        Path workdir = path;
        Path target = location == ExtractLocation.Self ? workdir.resolve(StringUtils.removeEndIgnoreCase((String)PathsKt.getName((Path)file), (String)("." + mode.getExtension()))) : workdir;
        Intrinsics.checkNotNull((Object)workdir);
        Intrinsics.checkNotNull((Object)target);
        transferManager2.addTransfer(new ExtractTransfer(fileSystem, mode, file, workdir, target));
    }

    @Override
    public long ordered() {
        return 2L;
    }

    public static final /* synthetic */ void access$extract(ExtractTransportContextMenuExtension $this, AnActionEvent event, SftpFileSystem fileSystem, ExtractLocation location, List files) {
        $this.extract(event, fileSystem, location, files);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/transfer/internal/sftp/ExtractTransportContextMenuExtension$Companion;", "", "<init>", "()V", "instance", "Lapp/termora/transfer/internal/sftp/ExtractTransportContextMenuExtension;", "getInstance", "()Lapp/termora/transfer/internal/sftp/ExtractTransportContextMenuExtension;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ExtractTransportContextMenuExtension getInstance() {
            return instance;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/transfer/internal/sftp/ExtractTransportContextMenuExtension$ExtractLocation;", "", "<init>", "(Ljava/lang/String;I)V", "Self", "Here", "termora"})
    private static final class ExtractLocation
    extends Enum<ExtractLocation> {
        public static final /* enum */ ExtractLocation Self = new ExtractLocation();
        public static final /* enum */ ExtractLocation Here = new ExtractLocation();
        private static final /* synthetic */ ExtractLocation[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static ExtractLocation[] values() {
            return (ExtractLocation[])$VALUES.clone();
        }

        public static ExtractLocation valueOf(String value) {
            return Enum.valueOf(ExtractLocation.class, value);
        }

        @NotNull
        public static EnumEntries<ExtractLocation> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = extractLocationArray = new ExtractLocation[]{ExtractLocation.Self, ExtractLocation.Here};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\b\u0010\u0016\u001a\u00020\bH\u0016J\b\u0010\n\u001a\u00020\bH\u0016J\b\u0010\u0017\u001a\u00020\u0012H\u0016J\b\u0010\u0018\u001a\u00020\u0010H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u000eH\u0016J\b\u0010\u001d\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lapp/termora/transfer/internal/sftp/ExtractTransportContextMenuExtension$ExtractTransfer;", "Lapp/termora/transfer/Transfer;", "Lapp/termora/transfer/TransferIndeterminate;", "fileSystem", "Lorg/apache/sshd/sftp/client/fs/SftpFileSystem;", "mode", "Lapp/termora/transfer/internal/sftp/CompressMode;", "file", "Ljava/nio/file/Path;", "workdir", "target", "<init>", "(Lorg/apache/sshd/sftp/client/fs/SftpFileSystem;Lapp/termora/transfer/internal/sftp/CompressMode;Ljava/nio/file/Path;Ljava/nio/file/Path;Ljava/nio/file/Path;)V", "myID", "", "end", "", "transfer", "", "bufferSize", "", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "source", "size", "isDirectory", "priority", "Lapp/termora/transfer/Transfer$Priority;", "scanning", "id", "parentId", "termora"})
    private static final class ExtractTransfer
    implements Transfer,
    TransferIndeterminate {
        @NotNull
        private final SftpFileSystem fileSystem;
        @NotNull
        private final CompressMode mode;
        @NotNull
        private final Path file;
        @NotNull
        private final Path workdir;
        @NotNull
        private final Path target;
        @NotNull
        private final String myID;
        private boolean end;

        public ExtractTransfer(@NotNull SftpFileSystem fileSystem, @NotNull CompressMode mode, @NotNull Path file, @NotNull Path workdir, @NotNull Path target) {
            Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
            Intrinsics.checkNotNullParameter((Object)((Object)mode), (String)"mode");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)workdir, (String)"workdir");
            Intrinsics.checkNotNullParameter((Object)target, (String)"target");
            this.fileSystem = fileSystem;
            this.mode = mode;
            this.file = file;
            this.workdir = workdir;
            this.target = target;
            this.myID = CryptoKt.randomUUID();
        }

        @Override
        @Nullable
        public Object transfer(int bufferSize, @NotNull Continuation<? super Long> $completion) {
            if (this.end) {
                return Boxing.boxLong((long)0L);
            }
            StringBuilder command = new StringBuilder();
            command.append("cd '" + ((Object)this.workdir.toAbsolutePath()).toString() + "'");
            command.append(" && ");
            if (this.mode == CompressMode.TarGz || this.mode == CompressMode.Tar) {
                command.append(" mkdir -p '" + ((Object)this.target.toAbsolutePath()).toString() + "' ");
                command.append(" && ");
                command.append(" tar ");
                StringBuilder stringBuilder = this.mode == CompressMode.Tar ? command.append(" -xf ") : command.append(" -zxf ");
                command.append(" '" + ((Object)this.source().toAbsolutePath()).toString() + "' ");
                command.append(" -C '" + ((Object)this.target.toAbsolutePath()).toString() + "' ");
            } else if (this.mode == CompressMode.Zip) {
                command.append(" unzip -o -q ");
                command.append(" '" + ((Object)this.source().toAbsolutePath()).toString() + "' ");
                command.append(" -d '" + ((Object)this.target.toAbsolutePath()).toString() + "' ");
            } else if (this.mode == CompressMode.SevenZ) {
                command.append(" 7z x ");
                command.append(" '" + ((Object)this.source().toAbsolutePath()).toString() + "' ");
                command.append(" -o'" + ((Object)this.target.toAbsolutePath()).toString() + "' -y > /dev/null");
            }
            this.fileSystem.getClientSession().executeRemoteCommand(command.toString(), (OutputStream)System.out, Charsets.UTF_8);
            this.end = true;
            return Boxing.boxLong((long)this.size());
        }

        @Override
        @NotNull
        public Path source() {
            return this.file;
        }

        @Override
        @NotNull
        public Path target() {
            return this.target;
        }

        @Override
        public long size() {
            return 1L;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        @NotNull
        public Transfer.Priority priority() {
            return Transfer.Priority.High;
        }

        @Override
        public boolean scanning() {
            return false;
        }

        @Override
        @NotNull
        public String id() {
            return this.myID;
        }

        @Override
        @NotNull
        public String parentId() {
            return "";
        }
    }
}

