/*
 * Decompiled with CFR 0.152.
 */
package com.github.hstyi.restart4j;

import com.github.hstyi.restart4j.ExecCommandsHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;

public class Restarter {
    private static final String os = System.getProperty("os.name").toLowerCase();
    private static final String arch = System.getProperty("os.arch").toLowerCase();
    private static final boolean isWin = os.contains("win");
    private static final boolean isMac = os.contains("mac");
    private static final boolean isUnix = os.contains("nix") || os.contains("nux");
    private static final boolean isArm64 = arch.contains("aarch64");
    private static volatile Supplier<Integer> currentProcessHandler;
    private static volatile Supplier<Path> tempDirectoryHandler;
    private static volatile ExecCommandsHandler execCommandsHandler;

    public static void restart(String[] commands) throws IOException {
        Path path = Restarter.getRestarterPath();
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add(path.toAbsolutePath().toString());
        cmds.add(currentProcessHandler.get().toString());
        cmds.add(String.valueOf(commands.length));
        cmds.addAll(Arrays.asList(commands));
        execCommandsHandler.exec(cmds);
    }

    private static String getFilename() {
        return isWin ? "restarter.exe" : "restarter";
    }

    private static Path getRestarterPath() throws IOException {
        Path path;
        String restarterPath = System.getProperty("restarter.path");
        if (restarterPath != null && Files.exists(path = Paths.get(restarterPath, new String[0]), new LinkOption[0])) {
            return path;
        }
        String resourceName = Restarter.getResourceName();
        InputStream resource = Restarter.class.getResourceAsStream(resourceName);
        if (resource == null) {
            throw new FileNotFoundException(resourceName);
        }
        Path dir = tempDirectoryHandler.get();
        Path path2 = Paths.get(dir.toString(), Restarter.getFilename());
        try (InputStream is = resource;){
            try (OutputStream os = Files.newOutputStream(path2, new OpenOption[0]);){
                int read;
                byte[] buffer = new byte[1024];
                while ((read = is.read(buffer)) != -1) {
                    os.write(buffer, 0, read);
                }
            }
            if (!Files.isExecutable(path2) && !path2.toFile().setExecutable(true)) {
                throw new IOException("Cannot set executable permissions on " + path2);
            }
        }
        return path2;
    }

    private static String getResourceName() {
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        if (isWin) {
            sb.append("win32");
        } else if (isMac) {
            sb.append("darwin");
        } else if (isUnix) {
            sb.append("linux");
        } else {
            throw new RuntimeException("Unsupported operating system: " + os);
        }
        sb.append('/');
        if (isArm64) {
            sb.append("aarch64");
        } else {
            sb.append("x86_64");
        }
        sb.append('/');
        sb.append(Restarter.getFilename());
        return sb.toString();
    }

    public static void setProcessHandler(Supplier<Integer> processHandler) {
        currentProcessHandler = processHandler;
    }

    public static void setTempDirectoryHandler(Supplier<Path> tempDirectoryHandler) {
        Restarter.tempDirectoryHandler = tempDirectoryHandler;
    }

    public static void setExecCommandsHandler(ExecCommandsHandler execCommandsHandler) {
        Restarter.execCommandsHandler = execCommandsHandler;
    }

    static /* synthetic */ boolean access$000() {
        return isWin;
    }

    static {
        Restarter.setProcessHandler(() -> Integer.parseInt(ManagementFactory.getRuntimeMXBean().getName().split("@")[0]));
        Restarter.setTempDirectoryHandler(() -> {
            try {
                return Files.createTempDirectory("restarter-", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        });
        Restarter.setExecCommandsHandler(new ExecCommandsHandler(){
            private final File nul = new File(Restarter.access$000() ? "NUL" : "/dev/null");

            @Override
            public void exec(List<String> commands) throws IOException {
                ProcessBuilder pb = new ProcessBuilder(commands);
                pb.redirectOutput(this.nul);
                pb.redirectError(this.nul);
                pb.directory(Paths.get(System.getProperty("user.home"), new String[0]).toFile());
                pb.start();
            }
        });
    }
}

