/*
 * Decompiled with CFR 0.152.
 */
package org.tinylog.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.tinylog.Level;
import org.tinylog.configuration.Configuration;
import org.tinylog.provider.InternalLogger;

public final class ConfigurationParser {
    private ConfigurationParser() {
    }

    public static Level getGlobalLevel() {
        return ConfigurationParser.parse(Configuration.get((String)"level"), Level.TRACE);
    }

    public static Map<String, Level> getCustomLevels() {
        HashMap<String, Level> levels = new HashMap<String, Level>();
        for (Map.Entry entry : Configuration.getSiblings((String)"level@").entrySet()) {
            String packageOrClass = ((String)entry.getKey()).substring("level@".length());
            Level level = ConfigurationParser.parse((String)entry.getValue(), null);
            if (level == null) continue;
            levels.put(packageOrClass, level);
        }
        return levels;
    }

    public static List<String> getTags() {
        ArrayList<String> tags = new ArrayList<String>();
        for (String writerProperty : Configuration.getSiblings((String)"writer").keySet()) {
            String[] tagArray;
            String tag = Configuration.get((String)(writerProperty + ".tag"));
            if (tag == null || tag.isEmpty() || tag.equals("-")) continue;
            for (String tagArrayItem : tagArray = tag.split(",")) {
                if (tags.contains(tagArrayItem = tagArrayItem.replaceAll("@.*", "").trim()) || tagArrayItem.isEmpty()) continue;
                tags.add(tagArrayItem);
            }
        }
        return tags;
    }

    public static boolean isWritingThreadEnabled() {
        String enabled = Configuration.get((String)"writingthread");
        return enabled != null && Boolean.parseBoolean(enabled.trim());
    }

    public static boolean isAutoShutdownEnabled() {
        String enabled = Configuration.get((String)"autoshutdown");
        return enabled == null || Boolean.parseBoolean(enabled.trim());
    }

    public static Level parse(String property, Level defaultValue) {
        if (property == null) {
            return defaultValue;
        }
        try {
            return Level.valueOf((String)property.trim().toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException ex) {
            InternalLogger.log((Level)Level.ERROR, (String)("Illegal severity level: " + property));
            return defaultValue;
        }
    }
}

