/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnType;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\t\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/exposed/v1/core/DecimalColumnType;", "Lorg/jetbrains/exposed/v1/core/ColumnType;", "Ljava/math/BigDecimal;", "precision", "", "scale", "<init>", "(II)V", "getPrecision", "()I", "getScale", "sqlType", "", "valueFromDB", "value", "", "equals", "", "other", "hashCode", "Companion", "exposed-core"})
public final class DecimalColumnType
extends ColumnType<BigDecimal> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int precision;
    private final int scale;
    @NotNull
    private static final DecimalColumnType INSTANCE = new DecimalColumnType(MathContext.DECIMAL64.getPrecision(), 20);

    public DecimalColumnType(int precision, int scale) {
        super(false, 1, null);
        this.precision = precision;
        this.scale = scale;
    }

    public final int getPrecision() {
        return this.precision;
    }

    public final int getScale() {
        return this.scale;
    }

    @Override
    @NotNull
    public String sqlType() {
        return "DECIMAL(" + this.precision + ", " + this.scale + ')';
    }

    @Override
    @NotNull
    public BigDecimal valueFromDB(@NotNull Object value) {
        BigDecimal bigDecimal;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Object object = value;
        if (object instanceof BigDecimal) {
            bigDecimal = (BigDecimal)value;
        } else if (object instanceof Double) {
            if (Double.isNaN(((Number)value).doubleValue())) {
                throw new IllegalStateException(("Unexpected value of type Double: NaN of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
            }
            bigDecimal = new BigDecimal(String.valueOf(((Number)value).doubleValue()));
        } else if (object instanceof Float) {
            if (Float.isNaN(((Number)value).floatValue())) {
                throw new IllegalStateException(("Unexpected value of type Float: NaN of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
            }
            bigDecimal = new BigDecimal(String.valueOf(((Number)value).floatValue()));
        } else if (object instanceof Long) {
            BigDecimal bigDecimal2 = BigDecimal.valueOf(((Number)value).longValue());
            bigDecimal = bigDecimal2;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal2, (String)"valueOf(...)");
        } else if (object instanceof Integer) {
            BigDecimal bigDecimal3 = BigDecimal.valueOf(((Number)value).intValue());
            bigDecimal = bigDecimal3;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal3, (String)"valueOf(...)");
        } else if (object instanceof Short) {
            BigDecimal bigDecimal4 = BigDecimal.valueOf(((Number)value).shortValue());
            bigDecimal = bigDecimal4;
            Intrinsics.checkNotNullExpressionValue((Object)bigDecimal4, (String)"valueOf(...)");
        } else {
            throw new IllegalStateException(("Unexpected value of type Decimal: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        BigDecimal bigDecimal5 = bigDecimal.setScale(this.scale, RoundingMode.HALF_EVEN);
        Intrinsics.checkNotNullExpressionValue((Object)bigDecimal5, (String)"setScale(...)");
        return bigDecimal5;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!Intrinsics.areEqual(this.getClass(), object != null ? object.getClass() : null)) {
            return false;
        }
        if (!super.equals(other)) {
            return false;
        }
        Intrinsics.checkNotNull((Object)other, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.DecimalColumnType");
        DecimalColumnType cfr_ignored_0 = (DecimalColumnType)other;
        if (this.precision != ((DecimalColumnType)other).precision) {
            return false;
        }
        return this.scale == ((DecimalColumnType)other).scale;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.precision;
        result = 31 * result + this.scale;
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/exposed/v1/core/DecimalColumnType$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/jetbrains/exposed/v1/core/DecimalColumnType;", "getINSTANCE$exposed_core", "()Lorg/jetbrains/exposed/v1/core/DecimalColumnType;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DecimalColumnType getINSTANCE$exposed_core() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

