/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.range;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.semver4j.internal.Tokenizers;
import org.semver4j.processor.CompositeProcessor;
import org.semver4j.processor.Processor;
import org.semver4j.range.Range;
import org.semver4j.range.RangeList;

class RangeExpressionParser {
    private static final Pattern SPLITTER_PATTERN = Pattern.compile("(\\s*)([<>]?=?)\\s*");
    private static final Pattern COMPARATOR_PATTERN = Pattern.compile(Tokenizers.COMPARATOR);
    private final Processor processor;

    RangeExpressionParser() {
        this(CompositeProcessor.all());
    }

    RangeExpressionParser(Processor processor) {
        this.processor = processor;
    }

    RangeList parse(String range, boolean includePreRelease) {
        String[] rangeSections;
        RangeList rangeList = new RangeList(includePreRelease);
        range = range.trim();
        for (String rangeSection : rangeSections = range.split("\\|\\|")) {
            rangeSection = RangeExpressionParser.stripWhitespacesBetweenRangeOperator(rangeSection);
            rangeSection = this.applyProcessors(rangeSection, includePreRelease);
            List<Range> ranges = RangeExpressionParser.addRanges(rangeSection);
            rangeList.add(ranges);
        }
        return rangeList;
    }

    private static String stripWhitespacesBetweenRangeOperator(String rangeSection) {
        Matcher matcher = SPLITTER_PATTERN.matcher(rangeSection);
        return matcher.replaceAll("$1$2").trim();
    }

    private String applyProcessors(String range, boolean includePreRelease) {
        return Optional.ofNullable(this.processor.process(range, includePreRelease)).orElse(range);
    }

    private static List<Range> addRanges(String range) {
        String[] parsedRanges;
        ArrayList<Range> ranges = new ArrayList<Range>();
        for (String parsedRange : parsedRanges = range.split("\\s+")) {
            Matcher matcher = COMPARATOR_PATTERN.matcher(parsedRange);
            if (!matcher.matches()) continue;
            String rangeOperator = matcher.group(1);
            String version = matcher.group(2);
            ranges.add(new Range(version, Range.RangeOperator.value(rangeOperator)));
        }
        return ranges;
    }
}

