/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.Application;
import app.termora.ApplicationRunner;
import app.termora.ApplicationSingleton;
import com.formdev.flatlaf.util.SystemInfo;
import java.awt.Toolkit;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinylog.configuration.Configuration;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u00020\u0005H\u0002J\b\u0010\u0007\u001a\u00020\u0005H\u0002J\b\u0010\b\u001a\u00020\u0005H\u0002\u00a8\u0006\t"}, d2={"Lapp/termora/ApplicationInitializr;", "", "<init>", "()V", "run", "", "setupNativeLibraries", "setupTinylog", "checkSingleton", "termora"})
@SourceDebugExtension(value={"SMAP\nApplicationInitializr.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationInitializr.kt\napp/termora/ApplicationInitializr\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,137:1\n29#2,3:138\n*S KotlinDebug\n*F\n+ 1 ApplicationInitializr.kt\napp/termora/ApplicationInitializr\n*L\n54#1:138,3\n*E\n"})
public final class ApplicationInitializr {
    public final void run() {
        long millis2;
        String delay = System.getProperty("app-delay");
        CharSequence charSequence = delay;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) && (millis2 = NumberUtils.toLong((String)delay, (long)0L)) > 0L) {
            Thread.sleep(millis2);
        }
        this.setupNativeLibraries();
        this.setupTinylog();
        this.checkSingleton();
        if (SystemInfo.isMacOS) {
            System.setProperty("apple.awt.application.name", Application.INSTANCE.getName());
        }
        if (SystemInfo.isLinux) {
            ApplicationInitializr millis2 = this;
            try {
                ApplicationInitializr $this$run_u24lambda_u240 = millis2;
                boolean bl = false;
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Field awtAppClassNameField = toolkit.getClass().getDeclaredField("awtAppClassName");
                awtAppClassNameField.setAccessible(true);
                awtAppClassNameField.set(toolkit, Application.INSTANCE.getName());
                Object object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
        }
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        new ApplicationRunner().run();
        long runtime = System.currentTimeMillis() - start$iv;
        Logger log = LoggerFactory.getLogger(this.getClass());
        if (log.isInfoEnabled()) {
            log.info("Application initialization " + runtime + "ms");
        }
    }

    private final void setupNativeLibraries() {
        String[] stringArray;
        File flatlaf;
        String[] stringArray2;
        File sqlite;
        String[] stringArray3;
        File restart4j;
        String[] stringArray4;
        File jSerialComm;
        String[] stringArray5;
        File pty4j;
        String[] stringArray6;
        File dylib;
        String appPath = Application.INSTANCE.getAppPath();
        if (StringUtils.isBlank((CharSequence)appPath)) {
            return;
        }
        File contents = new File(appPath);
        if (SystemUtils.IS_OS_MAC_OSX || SystemUtils.IS_OS_LINUX) {
            File file = contents.getParentFile();
            if (file == null || (file = file.getParentFile()) == null) {
                return;
            }
            contents = file;
            if (SystemUtils.IS_OS_LINUX) {
                contents = new File(contents, "lib");
            }
        } else if (SystemUtils.IS_OS_WINDOWS) {
            File file = contents.getParentFile();
            if (file == null) {
                return;
            }
            contents = file;
        }
        if (!(dylib = FileUtils.getFile((File)contents, (String[])(stringArray6 = new String[]{"app", "dylib"}))).exists()) {
            return;
        }
        String[] stringArray7 = new String[]{"jna"};
        File jna = FileUtils.getFile((File)dylib, (String[])stringArray7);
        if (jna.exists()) {
            System.setProperty("jna.nounpack", "true");
            System.setProperty("jna.boot.library.path", jna.getAbsolutePath());
        }
        if ((pty4j = FileUtils.getFile((File)dylib, (String[])(stringArray5 = new String[]{"pty4j"}))).exists()) {
            System.setProperty("pty4j.preferred.native.folder", pty4j.getAbsolutePath());
        }
        if ((jSerialComm = FileUtils.getFile((File)dylib, (String[])(stringArray4 = new String[]{"jSerialComm"}))).exists()) {
            System.setProperty("jSerialComm.library.path", jSerialComm.getAbsolutePath());
        }
        if ((restart4j = FileUtils.getFile((File)dylib, (String[])(stringArray3 = new String[]{"restart4j", SystemUtils.IS_OS_WINDOWS ? "restarter.exe" : "restarter"}))).exists()) {
            System.setProperty("restarter.path", restart4j.getAbsolutePath());
        }
        if ((sqlite = FileUtils.getFile((File)dylib, (String[])(stringArray2 = new String[]{"sqlite-jdbc"}))).exists()) {
            System.setProperty("org.sqlite.lib.path", sqlite.getAbsolutePath());
        }
        if ((flatlaf = FileUtils.getFile((File)dylib, (String[])(stringArray = new String[]{"flatlaf"}))).exists()) {
            System.setProperty("flatlaf.nativeLibraryPath", flatlaf.getAbsolutePath());
        }
    }

    private final void setupTinylog() {
        if (SystemInfo.isWindows) {
            File dir = new File(Application.INSTANCE.getBaseDataDir(), "logs");
            FileUtils.forceMkdir((File)dir);
            String string = dir.getAbsolutePath();
            String string2 = Application.INSTANCE.getName().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
            Configuration.set((String)"writer_file.latest", (String)(string + "/" + string2 + ".log"));
            Configuration.set((String)"writer_file.file", (String)(dir.getAbsolutePath() + "/{date:yyyy}-{date:MM}-{date:dd}.log"));
        }
    }

    private final void checkSingleton() {
        if (ApplicationSingleton.Companion.getInstance().isSingleton()) {
            return;
        }
        System.err.println("Program is already running");
        System.exit(1);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }
}

