/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import com.formdev.flatlaf.extras.components.FlatComboBox;
import com.formdev.flatlaf.util.FontUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00020\bR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/FontComboBox;", "Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "", "<init>", "()V", "fontsLoaded", "", "getItems", "", "termora"})
public final class FontComboBox
extends FlatComboBox<String> {
    private boolean fontsLoaded;

    public FontComboBox() {
        final FontComboBox fontComboBox = this;
        fontComboBox.renderer = new DefaultListCellRenderer(fontComboBox){
            {
                this.setPreferredSize(new Dimension(this.getPreferredSize().width, $fontComboBox.getPreferredSize().height - 2));
                this.setMaximumSize(new Dimension(this.getPreferredSize().width, this.getPreferredSize().height));
            }

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Object text = value;
                if (text instanceof String) {
                    if (StringsKt.isBlank((CharSequence)((CharSequence)text))) {
                        text = "&lt;None&gt;";
                    }
                    Component component = super.getListCellRendererComponent(list, "<html><font face='" + text + "'>" + text + "</font></html>", index, isSelected, cellHasFocus);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                    return component;
                }
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                return component;
            }
        };
        fontComboBox.setMaximumSize(fontComboBox.getPreferredSize());
        fontComboBox.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (fontsLoaded) {
                    return;
                }
                Object selectedItem = fontComboBox.getSelectedItem();
                Set<String> families = this.getItems();
                String[] stringArray = FontUtils.getAvailableFontFamilyNames();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getAvailableFontFamilyNames(...)");
                for (String family : stringArray) {
                    if (families.contains(family)) continue;
                    fontComboBox.addItem(family);
                }
                fontComboBox.setSelectedItem(selectedItem);
                fontsLoaded = true;
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }
        });
    }

    @NotNull
    public final Set<String> getItems() {
        Set families = new LinkedHashSet();
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getItemAt(i);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getItemAt(...)");
            families.add(object);
        }
        return families;
    }
}

