/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.AbstractI18n;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\u0014J\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0016J\b\u0010\u0017\u001a\u00020\bH\u0014J\b\u0010\u0018\u001a\u00020\u0005H\u0014R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lapp/termora/I18n;", "Lapp/termora/AbstractI18n;", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "myBundle", "Ljava/util/ResourceBundle;", "getMyBundle", "()Ljava/util/ResourceBundle;", "myBundle$delegate", "Lkotlin/Lazy;", "supportedLanguages", "Ljava/util/SortedMap;", "", "containsLanguage", "locale", "Ljava/util/Locale;", "isChinaMainland", "", "getLanguages", "", "getBundle", "getLogger", "termora"})
public final class I18n
extends AbstractI18n {
    @NotNull
    public static final I18n INSTANCE = new I18n();
    private static final Logger log = LoggerFactory.getLogger(I18n.class);
    @NotNull
    private static final Lazy myBundle$delegate = LazyKt.lazy(I18n::myBundle_delegate$lambda$0);
    @NotNull
    private static final SortedMap<String, String> supportedLanguages;

    private I18n() {
    }

    private final ResourceBundle getMyBundle() {
        Lazy lazy = myBundle$delegate;
        return (ResourceBundle)lazy.getValue();
    }

    @Nullable
    public final String containsLanguage(@NotNull Locale locale) {
        Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
        for (String key : supportedLanguages.keySet()) {
            Locale e = LocaleUtils.toLocale((String)key);
            if (!Intrinsics.areEqual((Object)LocaleUtils.toLocale((String)key), (Object)locale) && (!StringsKt.equals((String)e.getLanguage(), (String)locale.getLanguage(), (boolean)true) || !StringsKt.equals((String)e.getCountry(), (String)locale.getCountry(), (boolean)true))) continue;
            return key;
        }
        return null;
    }

    public final boolean isChinaMainland() {
        Locale locale = Locale.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
        return StringUtils.equalsIgnoreCase((CharSequence)this.containsLanguage(locale), (CharSequence)"zh_CN");
    }

    @NotNull
    public final Map<String, String> getLanguages() {
        return supportedLanguages;
    }

    @Override
    @NotNull
    protected ResourceBundle getBundle() {
        ResourceBundle resourceBundle = this.getMyBundle();
        Intrinsics.checkNotNullExpressionValue((Object)resourceBundle, (String)"<get-myBundle>(...)");
        return resourceBundle;
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = log;
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"log");
        return logger;
    }

    private static final ResourceBundle myBundle_delegate$lambda$0() {
        ResourceBundle bundle = ResourceBundle.getBundle("i18n/messages", Locale.getDefault());
        if (log.isInfoEnabled()) {
            String string = bundle.getBaseBundleName();
            if (string == null) {
                string = "null";
            }
            log.info("I18n: {}", (Object)string);
        }
        return bundle;
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"en_US", (Object)"English"), TuplesKt.to((Object)"zh_CN", (Object)"\u7b80\u4f53\u4e2d\u6587"), TuplesKt.to((Object)"zh_TW", (Object)"\u7e41\u9ad4\u4e2d\u6587"), TuplesKt.to((Object)"ru_RU", (Object)"\u0420\u0443\u0441\u0441\u043a\u0438\u0439")};
        supportedLanguages = MapsKt.sortedMapOf((Pair[])pairArray);
    }
}

