/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.I18n;
import app.termora.WindowScope;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProviders;
import app.termora.actions.MultipleAction;
import app.termora.terminal.ColorPalette;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalColor;
import app.termora.terminal.TextStyle;
import app.termora.terminal.panel.FloatingToolbarPanel;
import app.termora.terminal.panel.TerminalDisplay;
import app.termora.terminal.panel.TerminalPaintListener;
import app.termora.terminal.panel.TerminalPanel;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.util.EventObject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lapp/termora/MultipleTerminalListener;", "Lapp/termora/terminal/panel/TerminalPaintListener;", "<init>", "()V", "after", "", "offset", "", "count", "g", "Ljava/awt/Graphics;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminalDisplay", "Lapp/termora/terminal/panel/TerminalDisplay;", "terminal", "Lapp/termora/terminal/Terminal;", "termora"})
public final class MultipleTerminalListener
implements TerminalPaintListener {
    @Override
    public void after(int offset, int count, @NotNull Graphics g, @NotNull TerminalPanel terminalPanel, @NotNull TerminalDisplay terminalDisplay, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminalDisplay, (String)"terminalDisplay");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        WindowScope windowScope = new AnActionEvent((Object)terminalPanel, "", new EventObject(terminalPanel)).getData(DataProviders.INSTANCE.getWindowScope());
        if (windowScope == null) {
            return;
        }
        WindowScope windowScope2 = windowScope;
        if (!MultipleAction.Companion.getInstance().isSelected(windowScope2)) {
            return;
        }
        Font oldFont = g.getFont();
        ColorPalette colorPalette = terminal.getTerminalModel().getColorPalette();
        String text = I18n.INSTANCE.getString("termora.tools.multiple");
        Font font = terminalDisplay.getDisplayFont-QwXzuJw(text, TextStyle.Companion.getDefault-c2YIwqY());
        int width = g.getFontMetrics(font).stringWidth(text);
        boolean finding = terminal.getTerminalModel().getData(TerminalPanel.Companion.getFinding(), false);
        FloatingToolbarPanel floatingToolbarPanel = terminalPanel.getData(FloatingToolbarPanel.Companion.getFloatingToolbar());
        boolean floatingToolBar = floatingToolbarPanel != null ? floatingToolbarPanel.isVisible() : false;
        int y = g.getFontMetrics().getAscent();
        if (finding) {
            y += g.getFontMetrics().getHeight() + g.getFontMetrics().getAscent() / 2;
        }
        if (floatingToolBar) {
            y += g.getFontMetrics().getHeight() + g.getFontMetrics().getAscent() / 2;
        }
        g.setFont(font);
        g.setColor(new Color(colorPalette.getColor(TerminalColor.Normal.INSTANCE.getRED())));
        g.drawString(text, terminalDisplay.getWidth() - width - terminalPanel.getAverageCharWidth() / 2, y);
        g.setFont(oldFont);
    }
}

