/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.spec.OAEPParameterSpec;
import javax.crypto.spec.PSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\b\u0010\u000e\u001a\u00020\u000fH\u0002J\u000e\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\r2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0016\u0010\u0016\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0007J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00072\u0006\u0010\u0019\u001a\u00020\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lapp/termora/RSA;", "", "<init>", "()V", "TRANSFORMATION", "", "encrypt", "", "publicKey", "Ljava/security/PublicKey;", "data", "decrypt", "privateKey", "Ljava/security/PrivateKey;", "getOAEPParameterSpec", "Ljavax/crypto/spec/OAEPParameterSpec;", "generatePublic", "generatePrivate", "generateKeyPair", "Ljava/security/KeyPair;", "keySize", "", "sign", "verify", "", "signature", "termora"})
public final class RSA {
    @NotNull
    public static final RSA INSTANCE = new RSA();
    @NotNull
    private static final String TRANSFORMATION = "RSA/ECB/OAEPWithSHA-256AndMGF1Padding";

    private RSA() {
    }

    @NotNull
    public final byte[] encrypt(@NotNull PublicKey publicKey, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, (Key)publicKey, this.getOAEPParameterSpec());
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    @NotNull
    public final byte[] decrypt(@NotNull PrivateKey privateKey, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, (Key)privateKey, this.getOAEPParameterSpec());
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    @NotNull
    public final byte[] encrypt(@NotNull PrivateKey privateKey, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(1, (Key)privateKey, this.getOAEPParameterSpec());
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    @NotNull
    public final byte[] decrypt(@NotNull PublicKey publicKey, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        cipher.init(2, (Key)publicKey, this.getOAEPParameterSpec());
        byte[] byArray = cipher.doFinal(data);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"doFinal(...)");
        return byArray;
    }

    private final OAEPParameterSpec getOAEPParameterSpec() {
        return new OAEPParameterSpec("SHA-256", "MGF1", MGF1ParameterSpec.SHA256, PSource.PSpecified.DEFAULT);
    }

    @NotNull
    public final PublicKey generatePublic(@NotNull byte[] publicKey) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        PublicKey publicKey2 = KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(publicKey));
        Intrinsics.checkNotNullExpressionValue((Object)publicKey2, (String)"generatePublic(...)");
        return publicKey2;
    }

    @NotNull
    public final PrivateKey generatePrivate(@NotNull byte[] privateKey) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        PrivateKey privateKey2 = KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(privateKey));
        Intrinsics.checkNotNullExpressionValue((Object)privateKey2, (String)"generatePrivate(...)");
        return privateKey2;
    }

    @NotNull
    public final KeyPair generateKeyPair(int keySize) {
        KeyPairGenerator generator2 = KeyPairGenerator.getInstance("RSA");
        generator2.initialize(keySize);
        KeyPair keyPair = generator2.generateKeyPair();
        Intrinsics.checkNotNullExpressionValue((Object)keyPair, (String)"generateKeyPair(...)");
        return keyPair;
    }

    @NotNull
    public final byte[] sign(@NotNull PrivateKey privateKey, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)privateKey, (String)"privateKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Signature rsa = Signature.getInstance("SHA256withRSA");
        rsa.initSign(privateKey);
        rsa.update(data);
        byte[] byArray = rsa.sign();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"sign(...)");
        return byArray;
    }

    public final boolean verify(@NotNull PublicKey publicKey, @NotNull byte[] data, @NotNull byte[] signature) {
        Intrinsics.checkNotNullParameter((Object)publicKey, (String)"publicKey");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
        Signature rsa = Signature.getInstance("SHA256withRSA");
        rsa.initVerify(publicKey);
        rsa.update(data);
        return rsa.verify(signature);
    }
}

