/*
 * Decompiled with CFR 0.152.
 */
package app.termora.account;

import app.termora.Application;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.DynamicIcon;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.OptionPane;
import app.termora.OptionsPane;
import app.termora.ScopeKt;
import app.termora.account.Account;
import app.termora.account.AccountExtension;
import app.termora.account.AccountManager;
import app.termora.account.AccountOption;
import app.termora.account.AccountProperties;
import app.termora.account.LoginServerDialog;
import app.termora.account.PullService;
import app.termora.account.PushService;
import app.termora.account.ServerSignedExtension;
import app.termora.account.Subscription;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.database.DatabaseManager;
import app.termora.plugin.Extension;
import app.termora.plugin.internal.extension.DynamicExtensionHandler;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.net.URI;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.jdesktop.swingx.JXHyperlink;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0002J\b\u0010\u001c\u001a\u00020\u001bH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\u0010\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020\u001bH\u0002J\b\u0010#\u001a\u00020\u001bH\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020!H\u0016J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020\u001eH\u0016J\b\u0010*\u001a\u00020+H\u0016J\b\u0010,\u001a\u00020(H\u0016R\u001c\u0010\u0006\u001a\n \b*\u0004\u0018\u00010\u00070\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lapp/termora/account/AccountOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "Lapp/termora/Disposable;", "<init>", "()V", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "databaseManager", "Lapp/termora/database/DatabaseManager;", "getDatabaseManager", "()Lapp/termora/database/DatabaseManager;", "accountManager", "Lapp/termora/account/AccountManager;", "getAccountManager", "()Lapp/termora/account/AccountManager;", "accountProperties", "Lapp/termora/account/AccountProperties;", "getAccountProperties", "()Lapp/termora/account/AccountProperties;", "userInfoPanel", "lastSynchronizationOnLabel", "Ljavax/swing/JLabel;", "initView", "", "initEvents", "getCenterComponent", "Ljavax/swing/JComponent;", "createActionPanel", "isFreePlan", "", "onLogin", "refreshUserInfoPanel", "getIcon", "Ljavax/swing/Icon;", "isSelected", "getTitle", "", "getJComponent", "getAnchor", "Lapp/termora/OptionsPane$Anchor;", "getIdentifier", "termora"})
@SourceDebugExtension(value={"SMAP\nAccountOption.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AccountOption.kt\napp/termora/account/AccountOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,255:1\n1#2:256\n*E\n"})
public final class AccountOption
extends JPanel
implements OptionsPane.Option,
Disposable {
    @NotNull
    private final JPanel userInfoPanel = new JPanel(new BorderLayout());
    @NotNull
    private final JLabel lastSynchronizationOnLabel = new JLabel();

    public AccountOption() {
        super(new BorderLayout());
        this.initView();
        this.initEvents();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    private final DatabaseManager getDatabaseManager() {
        return DatabaseManager.Companion.getInstance();
    }

    private final AccountManager getAccountManager() {
        return AccountManager.Companion.getInstance();
    }

    private final AccountProperties getAccountProperties() {
        return AccountProperties.Companion.getInstance();
    }

    private final void initView() {
        this.refreshUserInfoPanel();
        this.add((Component)this.userInfoPanel, "Center");
    }

    private final void initEvents() {
        Disposable it = DynamicExtensionHandler.Companion.getInstance().register(ServerSignedExtension.class, (Extension)new ServerSignedExtension(this){
            final /* synthetic */ AccountOption this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSignedChanged(boolean oldSigned, boolean newSigned) {
                AccountOption.access$refreshUserInfoPanel(this.this$0);
            }
        });
        boolean bl = false;
        Disposer.register(this, it);
        it = DynamicExtensionHandler.Companion.getInstance().register(AccountExtension.class, (Extension)new AccountExtension(this){
            final /* synthetic */ AccountOption this$0;
            {
                this.this$0 = $receiver;
            }

            public void onAccountChanged(Account oldAccount, Account newAccount) {
                Intrinsics.checkNotNullParameter((Object)oldAccount, (String)"oldAccount");
                Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
                if (!Intrinsics.areEqual((Object)oldAccount.getId(), (Object)newAccount.getId())) {
                    AccountOption.access$refreshUserInfoPanel(this.this$0);
                }
            }
        });
        boolean bl2 = false;
        Disposer.register(this, it);
    }

    private final JComponent getCenterComponent() {
        String string;
        FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
        int rows = 0;
        rows = 1;
        int step = 2;
        Subscription subscription = this.getAccountManager().getSubscription();
        boolean isFreePlan = this.getAccountManager().isFreePlan();
        boolean isLocally = this.getAccountManager().isLocally();
        String validTo = isFreePlan ? "-" : (subscription.getEndAt() >= Long.MAX_VALUE ? I18n.INSTANCE.getString("termora.settings.account.lifetime") : DateFormatUtils.format((Date)new Date(subscription.getEndAt()), (String)I18n.INSTANCE.getString("termora.date-format")));
        String lastSynchronizationOn = isFreePlan ? "-" : DateFormatUtils.format((Date)new Date(this.getAccountManager().getLastSynchronizationOn()), (String)I18n.INSTANCE.getString("termora.date-format"));
        String server = this.getAccountManager().getServer();
        String email = this.getAccountManager().getEmail();
        if (isLocally) {
            server = I18n.INSTANCE.getString("termora.settings.account.locally");
            email = I18n.INSTANCE.getString("termora.settings.account.locally");
        }
        Box planBox = Box.createHorizontalBox();
        planBox.add(new JLabel(isLocally ? "-" : subscription.getPlan().name()));
        if (isFreePlan && !isLocally) {
            planBox.add(Box.createHorizontalStrut(16));
            String string2 = I18n.INSTANCE.getString("termora.settings.account.upgrade");
            JXHyperlink upgrade2 = new JXHyperlink((Action)((Object)new AnAction(string2){

                protected void actionPerformed(AnActionEvent evt) {
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    if (I18n.INSTANCE.isChinaMainland()) {
                        URI uRI = URI.create("https://www.termora.cn/pricing?version=" + Application.INSTANCE.getVersion());
                        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                        Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
                    } else {
                        URI uRI = URI.create("https://www.termora.app/pricing?version=" + Application.INSTANCE.getVersion());
                        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                        Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
                    }
                }
            }));
            upgrade2.setFocusable(false);
            planBox.add((Component)upgrade2);
        }
        Box serverBox = Box.createHorizontalBox();
        serverBox.add(new JLabel(server));
        if (!isLocally) {
            serverBox.add(Box.createHorizontalStrut(8));
            if (!this.getAccountManager().isSigned()) {
                string = I18n.INSTANCE.getString("termora.settings.account.verify");
                DynamicIcon dynamicIcon = Icons.INSTANCE.getError();
                JXHyperlink upgrade3 = new JXHyperlink((Action)((Object)new AnAction(string, dynamicIcon){

                    protected void actionPerformed(AnActionEvent evt) {
                        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                        URI uRI = URI.create("https://www.termora.app?version=" + Application.INSTANCE.getVersion());
                        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"create(...)");
                        Application.browse$default(Application.INSTANCE, uRI, false, 2, null);
                    }
                }));
                upgrade3.setFocusable(false);
                v0 = serverBox.add((Component)upgrade3);
            } else {
                v0 = serverBox.add(new JLabel((Icon)((Object)Icons.INSTANCE.getSuccess())));
            }
        }
        this.lastSynchronizationOnLabel.setText(lastSynchronizationOn);
        String $this$getCenterComponent_u24lambda_u240 = string = FormBuilder.create().layout(layout).debug(false).add(I18n.INSTANCE.getString("termora.settings.account.server") + ":", new Object[0]).xy(1, rows).add((Component)serverBox).xy(3, rows);
        boolean bl = false;
        String $this$getCenterComponent_u24lambda_u241 = string = string.add(I18n.INSTANCE.getString("termora.settings.account") + ":", new Object[0]).xy(1, rows += step).add(email, new Object[0]).xy(3, rows);
        boolean bl2 = false;
        String $this$getCenterComponent_u24lambda_u242 = string = string.add(I18n.INSTANCE.getString("termora.settings.account.subscription") + ":", new Object[0]).xy(1, rows += step).add((Component)planBox).xy(3, rows);
        boolean bl3 = false;
        String $this$getCenterComponent_u24lambda_u243 = string = string.add(I18n.INSTANCE.getString("termora.settings.account.valid-to") + ":", new Object[0]).xy(1, rows += step).add(validTo, new Object[0]).xy(3, rows);
        boolean bl4 = false;
        String $this$getCenterComponent_u24lambda_u244 = string = string.add(I18n.INSTANCE.getString("termora.settings.account.synchronization-on") + ":", new Object[0]).xy(1, rows += step).add((Component)this.lastSynchronizationOnLabel).xy(3, rows);
        boolean bl5 = false;
        String $this$getCenterComponent_u24lambda_u245 = string = string.add((Component)this.createActionPanel(isFreePlan)).xyw(1, rows += step, 3);
        boolean bl6 = false;
        rows += step;
        JPanel jPanel = string.build();
        Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
        return jPanel;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent createActionPanel(boolean isFreePlan) {
        Box actionBox = Box.createHorizontalBox();
        actionBox.add(Box.createHorizontalGlue());
        Set actions = new LinkedHashSet();
        if (this.getAccountManager().isLocally()) {
            var4_4 = I18n.INSTANCE.getString("termora.settings.account.login") + "...";
            Iterator iterator2 = var4_4 = new JXHyperlink((Action)((Object)new AnAction(this, (String)((Object)var4_4)){
                final /* synthetic */ AccountOption this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                protected void actionPerformed(AnActionEvent evt) {
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    AccountOption.access$onLogin(this.this$0);
                }
            }));
            var7_6 = actions;
            boolean bl = false;
            $this$createActionPanel_u24lambda_u240.setFocusable(false);
            v0 = var7_6.add(var4_4);
        } else {
            void $this$createActionPanel_u24lambda_u242;
            Iterator $this$createActionPanel_u24lambda_u241;
            if (!isFreePlan) {
                var4_4 = I18n.INSTANCE.getString("termora.settings.account.sync-now");
                $this$createActionPanel_u24lambda_u240 = var4_4 = new JXHyperlink((Action)((Object)new AnAction(this, (String)((Object)var4_4)){
                    final /* synthetic */ AccountOption this$0;
                    {
                        this.this$0 = $receiver;
                        super($super_call_param$1);
                    }

                    protected void actionPerformed(AnActionEvent evt) {
                        Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                        AccountOption.access$getAccountProperties(this.this$0).setNextSynchronizationSince(0L);
                        PullService.Companion.getInstance().trigger();
                        PushService.Companion.getInstance().trigger();
                        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, this, null){
                            int label;
                            final /* synthetic */ AccountOption this$0;
                            final /* synthetic */ createActionPanel.3 this$1;
                            {
                                this.this$0 = $receiver;
                                this.this$1 = $receiver2;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        AccountOption.access$getAccountManager(this.this$0).refreshAccount();
                                        this.label = 1;
                                        v0 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, this.this$0, null){
                                            int label;
                                            final /* synthetic */ createActionPanel.3 this$0;
                                            final /* synthetic */ AccountOption this$1;
                                            {
                                                this.this$0 = $receiver;
                                                this.this$1 = $receiver2;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.this$0.setEnabled(false);
                                                        AccountOption.access$getLastSynchronizationOnLabel$p(this.this$1).setText(DateFormatUtils.format((Date)new Date(System.currentTimeMillis()), (String)I18n.INSTANCE.getString("termora.date-format")));
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v0 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl15
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        this.label = 2;
                                        v1 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)1500, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                                        if (v1 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl23
                                    }
                                    case 2: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v1 = $result;
lbl23:
                                        // 2 sources

                                        this.label = 3;
                                        v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$1, null){
                                            int label;
                                            final /* synthetic */ createActionPanel.3 this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        this.this$0.setEnabled(true);
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (v2 == var2_2) {
                                            return var2_2;
                                        }
                                        ** GOTO lbl31
                                    }
                                    case 3: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v2 = $result;
lbl31:
                                        // 2 sources

                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                            }

                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (int)2, null);
                    }
                }));
                var7_6 = actions;
                boolean bl = false;
                $this$createActionPanel_u24lambda_u241.setFocusable(false);
                var7_6.add(var4_4);
            }
            var4_4 = I18n.INSTANCE.getString("termora.settings.account.logout");
            $this$createActionPanel_u24lambda_u241 = var4_4 = new JXHyperlink((Action)((Object)new AnAction(this, (String)((Object)var4_4)){
                final /* synthetic */ AccountOption this$0;
                {
                    this.this$0 = $receiver;
                    super($super_call_param$1);
                }

                protected void actionPerformed(AnActionEvent evt) {
                    Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                    boolean hasUnsyncedData = !((Collection)AccountOption.access$getDatabaseManager(this.this$0).unsyncedData()).isEmpty();
                    String message = hasUnsyncedData ? "termora.settings.account.unsynced-logout-confirm" : "termora.settings.account.logout-confirm";
                    int option = OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, AccountOption.access$getOwner(this.this$0), I18n.INSTANCE.getString(message), null, 2, 3, null, null, null, null, 484, null);
                    if (option != 0) {
                        return;
                    }
                    AccountManager.Companion.getInstance().logout$termora();
                }
            }));
            var7_6 = actions;
            boolean bl = false;
            $this$createActionPanel_u24lambda_u242.setFocusable(false);
            v0 = var7_6.add(var4_4);
        }
        for (JComponent component : actions) {
            actionBox.add(component);
            if (Intrinsics.areEqual((Object)CollectionsKt.last((Iterable)actions), (Object)component)) continue;
            actionBox.add(Box.createHorizontalStrut(8));
        }
        actionBox.add(Box.createHorizontalGlue());
        Intrinsics.checkNotNull((Object)actionBox);
        return actionBox;
    }

    private final void onLogin() {
        Window window = this.getOwner();
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"<get-owner>(...)");
        LoginServerDialog dialog2 = new LoginServerDialog(window);
        dialog2.setVisible(true);
    }

    private final void refreshUserInfoPanel() {
        this.userInfoPanel.removeAll();
        this.userInfoPanel.add((Component)this.getCenterComponent(), "Center");
        this.userInfoPanel.revalidate();
        this.userInfoPanel.repaint();
    }

    @Override
    @NotNull
    public Icon getIcon(boolean isSelected) {
        return (Icon)((Object)Icons.INSTANCE.getUser());
    }

    @Override
    @NotNull
    public String getTitle() {
        return I18n.INSTANCE.getString("termora.settings.account");
    }

    @Override
    @NotNull
    public JComponent getJComponent() {
        return this;
    }

    @Override
    @NotNull
    public OptionsPane.Anchor getAnchor() {
        return OptionsPane.Anchor.First.INSTANCE;
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "Account";
    }

    public static final /* synthetic */ void access$refreshUserInfoPanel(AccountOption $this) {
        $this.refreshUserInfoPanel();
    }

    public static final /* synthetic */ void access$onLogin(AccountOption $this) {
        $this.onLogin();
    }

    public static final /* synthetic */ AccountProperties access$getAccountProperties(AccountOption $this) {
        return $this.getAccountProperties();
    }

    public static final /* synthetic */ AccountManager access$getAccountManager(AccountOption $this) {
        return $this.getAccountManager();
    }

    public static final /* synthetic */ JLabel access$getLastSynchronizationOnLabel$p(AccountOption $this) {
        return $this.lastSynchronizationOnLabel;
    }

    public static final /* synthetic */ DatabaseManager access$getDatabaseManager(AccountOption $this) {
        return $this.getDatabaseManager();
    }

    public static final /* synthetic */ Window access$getOwner(AccountOption $this) {
        return $this.getOwner();
    }
}

