/*
 * Decompiled with CFR 0.152.
 */
package app.termora.account;

import app.termora.Application;
import app.termora.ApplicationRunnerExtension;
import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.ResponseException;
import app.termora.ScopeKt;
import app.termora.account.Account;
import app.termora.account.AccountExtension;
import app.termora.account.AccountHttp;
import app.termora.account.AccountProperties;
import app.termora.account.PullService$DataChange$;
import app.termora.account.PullService$DataChangesResponse$;
import app.termora.account.PullServiceExtension;
import app.termora.account.SyncService;
import app.termora.database.Data;
import app.termora.database.DatabaseChangedExtension;
import app.termora.plugin.Extension;
import app.termora.plugin.internal.extension.DynamicExtensionHandler;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.channels.Channel;
import kotlinx.coroutines.channels.ChannelKt;
import kotlinx.coroutines.channels.ChannelResult;
import kotlinx.coroutines.channels.SendChannel;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import kotlinx.serialization.json.JsonPrimitive;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u0003:\u0004!\"#$B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\bH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0010H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J \u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u0010H\u0002J\u0006\u0010\u001f\u001a\u00020\bJ\b\u0010 \u001a\u00020\bH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lapp/termora/account/PullService;", "Lapp/termora/account/SyncService;", "Lapp/termora/Disposable;", "Lapp/termora/ApplicationRunnerExtension;", "<init>", "()V", "channel", "Lkotlinx/coroutines/channels/Channel;", "", "accountProperties", "Lapp/termora/account/AccountProperties;", "getAccountProperties", "()Lapp/termora/account/AccountProperties;", "pulling", "Ljava/util/concurrent/atomic/AtomicBoolean;", "lastChangeHash", "", "pullChanges", "doPullChanges", "", "tryPull", "", "e", "Lapp/termora/account/PullService$DataChange;", "getChangeHash", "pull", "Lapp/termora/account/PullService$PullResult;", "id", "ownerId", "ownerType", "doPull", "trigger", "ready", "Companion", "PullResult", "DataChangesResponse", "DataChange", "termora"})
@SourceDebugExtension(value={"SMAP\nPullService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PullService.kt\napp/termora/account/PullService\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,423:1\n222#2:424\n222#2:426\n1#3:425\n*S KotlinDebug\n*F\n+ 1 PullService.kt\napp/termora/account/PullService\n*L\n132#1:424\n258#1:426\n*E\n"})
public final class PullService
extends SyncService
implements Disposable,
ApplicationRunnerExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Channel<Unit> channel;
    @NotNull
    private final AtomicBoolean pulling;
    @NotNull
    private String lastChangeHash;
    private static final Logger log = LoggerFactory.getLogger(PullService.class);

    private PullService() {
        Disposer.register(this, DynamicExtensionHandler.Companion.getInstance().register(AccountExtension.class, (Extension)new AccountExtension(){

            @Override
            public void onAccountChanged(Account oldAccount, Account newAccount) {
                Intrinsics.checkNotNullParameter((Object)oldAccount, (String)"oldAccount");
                Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
                if (!Intrinsics.areEqual((Object)oldAccount.getId(), (Object)newAccount.getId()) && !newAccount.isLocally()) {
                    lastChangeHash = "";
                }
                if (Intrinsics.areEqual((Object)oldAccount.getId(), (Object)newAccount.getId()) && !Intrinsics.areEqual(oldAccount.getTeams(), newAccount.getTeams())) {
                    this.getAccountProperties().setNextSynchronizationSince(0L);
                    this.trigger();
                    return;
                }
                if (oldAccount.isLocally() && !newAccount.isLocally()) {
                    this.trigger();
                }
            }
        }));
        this.channel = ChannelKt.Channel$default((int)-1, null, null, (int)6, null);
        this.pulling = new AtomicBoolean(false);
        this.lastChangeHash = "";
    }

    private final AccountProperties getAccountProperties() {
        return AccountProperties.Companion.getInstance();
    }

    private final void pullChanges() {
        int count;
        String hash;
        block11: {
            if (this.isFreePlan()) {
                return;
            }
            hash = null;
            try {
                hash = this.getChangeHash();
                if (StringsKt.isBlank((CharSequence)hash)) {
                    return;
                }
                if (Intrinsics.areEqual((Object)hash, (Object)this.lastChangeHash)) {
                    if (log.isDebugEnabled()) {
                        log.debug("\u6ca1\u6709\u6570\u636e\u53d8\u52a8");
                    }
                    return;
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug(e.getMessage(), (Throwable)e);
                }
                return;
            }
            if (!this.pulling.compareAndSet(false, true)) {
                return;
            }
            count = 0;
            try {
                PullServiceExtension.Companion.firePullStarted();
                count = this.doPullChanges();
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block11;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (!StringsKt.isBlank((CharSequence)hash)) {
            this.lastChangeHash = hash;
        }
        this.pulling.set(false);
        PullServiceExtension.Companion.firePullFinished(count);
    }

    /*
     * WARNING - void declaration
     */
    private final int doPullChanges() {
        DataChangesResponse response;
        if (log.isDebugEnabled()) {
            log.debug("\u5373\u5c06\u4ece\u4e91\u7aef\u62c9\u53d6\u53d8\u66f4");
        }
        long since = this.getAccountProperties().getNextSynchronizationSince();
        String after = "";
        long nextSince = since;
        int limit = 100;
        int count = 0;
        do {
            void this_$iv;
            Request request = new Request.Builder().get().url(this.getAccountManager().getServer() + "/v1/data/changes?since=" + nextSince + "&after=" + after + "&limit=" + limit).build();
            String text = AccountHttp.execute$default(AccountHttp.INSTANCE, null, request, 1, null);
            Json json = Application.INSTANCE.getOhMyJson();
            String string$iv = text;
            boolean $i$f$decodeFromString = false;
            this_$iv.getSerializersModule();
            response = (DataChangesResponse)this_$iv.decodeFromString((DeserializationStrategy)DataChangesResponse.Companion.serializer(), string$iv);
            if (response.getChanges().isEmpty()) break;
            for (DataChange e : response.getChanges()) {
                if (!this.tryPull(e)) continue;
                ++count;
            }
            after = response.getAfter();
            nextSince = response.getSince();
        } while (response.getChanges().size() >= limit);
        this.getAccountProperties().setNextSynchronizationSince(nextSince);
        this.getAccountProperties().setLastSynchronizationOn(System.currentTimeMillis());
        if (log.isDebugEnabled()) {
            log.debug("\u4ece\u4e91\u7aef\u62c9\u53d6\u53d8\u66f4\u7ed3\u675f\uff0c\u53d8\u66f4\u6761\u6570: {}", (Object)count);
        }
        return count;
    }

    private final boolean tryPull(DataChange e) {
        block9: {
            Data data = this.getData(e.getObjectId());
            if (data == null && e.getDeleted()) {
                return false;
            }
            if (data != null && e.getDeleted() && data.getDeleted()) {
                return false;
            }
            if (data == null || data.getVersion() != e.getVersion() || e.getDeleted() != data.getDeleted()) {
                if (log.isDebugEnabled()) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = e.getObjectId();
                    Data data2 = data;
                    objectArray[1] = data2 != null ? Long.valueOf(data2.getVersion()) : "\u4e0d\u5b58\u5728";
                    objectArray[2] = e.getVersion();
                    log.debug("\u6570\u636e: {}, \u672c\u5730\u7248\u672c: {}, \u4e91\u7aef\u7248\u672c: {} \u89e6\u53d1\u540c\u6b65", objectArray);
                }
                try {
                    if (this.pull(e.getObjectId(), e.getOwnerId(), e.getOwnerType()) == PullResult.Changed) {
                        return true;
                    }
                    break block9;
                }
                catch (Exception e2) {
                    if (log.isErrorEnabled()) {
                        log.error(e2.getMessage(), (Throwable)e2);
                    }
                    break block9;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("\u6570\u636e: {} \u672c\u5730\u7248\u672c\u4e0e\u4e91\u7aef\u7248\u672c\u4e00\u81f4", (Object)e.getObjectId());
            }
        }
        return false;
    }

    private final String getChangeHash() {
        Response response;
        Request request = new Request.Builder().head().url(this.getAccountManager().getServer() + "/v1/data/changes").build();
        Response $this$getChangeHash_u24lambda_u240 = response = AccountHttp.INSTANCE.getClient().newCall(request).execute();
        boolean bl = false;
        $this$getChangeHash_u24lambda_u240.close();
        Response response2 = response;
        if (!response2.isSuccessful()) {
            IOUtils.closeQuietly((Closeable)((Closeable)response2));
            throw new ResponseException(response2.code(), response2);
        }
        String string = Response.header$default((Response)response2, (String)"X-Hash", null, (int)2, null);
        if (string == null) {
            string = "";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final PullResult pull(String id, String ownerId, String ownerType) {
        PullResult pullResult;
        Lock lock = this.getSyncLock();
        lock.lock();
        try {
            boolean bl = false;
            pullResult = this.doPull(id, ownerId, ownerType);
        }
        finally {
            lock.unlock();
        }
        return pullResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final PullResult doPull(String id, String ownerId, String ownerType) {
        Boolean deleted;
        void this_$iv;
        Response it;
        Request request = new Request.Builder().url(this.getAccountManager().getServer() + "/v1/data/" + id + "?ownerId=" + ownerId + "&ownerType=" + ownerType).get().build();
        Response response = AccountHttp.INSTANCE.getClient().newCall(request).execute();
        if (log.isDebugEnabled()) {
            log.debug("\u62c9\u53d6\u6570\u636e: {} \u6210\u529f, \u54cd\u5e94\u7801: {}", (Object)id, (Object)response.code());
        }
        if (!response.isSuccessful()) {
            IOUtils.closeQuietly((Closeable)((Closeable)response));
        }
        if (response.code() == 404) {
            if (log.isWarnEnabled()) {
                log.warn("\u6570\u636e: {} \u4e91\u7aef\u4e0d\u5b58\u5728\uff0c\u672c\u5730\u6570\u636e\u5c06\u4f1a\u5220\u9664", (Object)id);
            }
            SyncService.updateData$default(this, id, true, null, true, 4, null);
            return PullResult.Changed;
        }
        if (response.code() == 403) {
            if (log.isWarnEnabled()) {
                log.warn("\u6570\u636e: {} \u6ca1\u6709\u6743\u9650\u62c9\u53d6\uff0c\u672c\u5730\u6570\u636e\u5c06\u4f1a\u5220\u9664", (Object)id);
            }
            SyncService.updateData$default(this, id, true, null, true, 4, null);
            return PullResult.Changed;
        }
        if (!response.isSuccessful()) {
            throw new ResponseException(response.code(), response);
        }
        Object object = (Closeable)response;
        Throwable throwable = null;
        try {
            Object it2;
            it = (Response)object;
            boolean bl = false;
            Closeable closeable = (Closeable)response.body();
            Throwable throwable2 = null;
            try {
                it2 = (ResponseBody)closeable;
                boolean bl2 = false;
                ResponseBody responseBody = it2;
                it2 = responseBody != null ? responseBody.string() : null;
            }
            catch (Throwable bl2) {
                throwable2 = bl2;
                throw bl2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
            }
            it = it2;
        }
        catch (Throwable bl) {
            throwable = bl;
            throw bl;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        Response text = it;
        object = (CharSequence)text;
        if (object == null || StringsKt.isBlank((CharSequence)object)) {
            throw new ResponseException(response.code(), "response body is empty", response);
        }
        throwable = Application.INSTANCE.getOhMyJson();
        Response string$iv = text;
        boolean $i$f$decodeFromString = false;
        this_$iv.getSerializersModule();
        JsonObject json = (JsonObject)this_$iv.decodeFromString((DeserializationStrategy)JsonObject.Companion.serializer(), (String)string$iv);
        JsonElement jsonElement = (JsonElement)json.get((Object)"id");
        String id2 = jsonElement != null && (jsonElement = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement)) != null ? jsonElement.getContent() : null;
        JsonElement jsonElement2 = (JsonElement)json.get((Object)"ownerId");
        String ownerId2 = jsonElement2 != null && (jsonElement2 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement2)) != null ? jsonElement2.getContent() : null;
        JsonElement jsonElement3 = (JsonElement)json.get((Object)"ownerType");
        String ownerType2 = jsonElement3 != null && (jsonElement3 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement3)) != null ? jsonElement3.getContent() : null;
        JsonElement jsonElement4 = (JsonElement)json.get((Object)"data");
        String data = jsonElement4 != null && (jsonElement4 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement4)) != null ? jsonElement4.getContent() : null;
        JsonElement jsonElement5 = (JsonElement)json.get((Object)"type");
        String type = jsonElement5 != null && (jsonElement5 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement5)) != null ? jsonElement5.getContent() : null;
        JsonElement jsonElement6 = (JsonElement)json.get((Object)"version");
        Long version = jsonElement6 != null && (jsonElement6 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement6)) != null ? Long.valueOf(JsonElementKt.getLong((JsonPrimitive)jsonElement6)) : null;
        JsonElement jsonElement7 = (JsonElement)json.get((Object)"deleted");
        Boolean bl = jsonElement7 != null && (jsonElement7 = JsonElementKt.getJsonPrimitive((JsonElement)jsonElement7)) != null ? Boolean.valueOf(JsonElementKt.getBoolean((JsonPrimitive)jsonElement7)) : (deleted = null);
        if (id2 == null || ownerId2 == null || ownerType2 == null || data == null || version == null || deleted == null || type == null) {
            throw new IllegalStateException("Data.id " + id2 + " data error");
        }
        Data row = this.getData(id2);
        if (row == null) {
            if (deleted.booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u6570\u636e: {}, \u7c7b\u578b: {} \u4e91\u7aef\u5df2\u7ecf\u5220\u9664\uff0c\u672c\u5730\u4e5f\u4e0d\u5b58\u5728", (Object)id2, (Object)type);
                }
                return PullResult.Nothing;
            }
            if (log.isDebugEnabled()) {
                log.debug("\u6570\u636e: {}, \u7c7b\u578b: {} \u4ece\u4e91\u7aef\u62c9\u53d6\u6210\u529f\uff0c\u5373\u5c06\u4fdd\u5b58\u5230\u672c\u5730", (Object)id2, (Object)type);
            }
            this.getDatabaseManager().save(new Data(id2, ownerId2, ownerType2, type, this.decryptData(id2, data, ownerId2), version, true, false), DatabaseChangedExtension.Source.Sync);
            if (log.isInfoEnabled()) {
                log.info("\u6570\u636e: {}, \u7c7b\u578b: {} \u5df2\u4fdd\u5b58\u81f3\u672c\u5730", (Object)id2, (Object)type);
            }
        } else if (deleted.booleanValue() && !row.getDeleted()) {
            if (log.isDebugEnabled()) {
                log.debug("\u6570\u636e: {}, \u7c7b\u578b: {} \u4e91\u7aef\u5df2\u7ecf\u5220\u9664\uff0c\u672c\u5730\u5373\u5c06\u5220\u9664", (Object)id2, (Object)type);
            }
            this.getDatabaseManager().delete(id2, type, DatabaseChangedExtension.Source.Sync);
            if (log.isInfoEnabled()) {
                log.info("\u6570\u636e: {}, \u7c7b\u578b: {} \u5df2\u4ece\u672c\u5730\u5220\u9664", (Object)id2, (Object)type);
            }
        } else if (row.getVersion() > version) {
            if (log.isWarnEnabled()) {
                Object[] objectArray = new Object[]{id2, type, row.getVersion(), version};
                log.warn("\u6570\u636e: {}, \u7c7b\u578b: {}, \u672c\u5730\u7248\u672c: {}, \u4e91\u7aef\u7248\u672c: {}, \u672c\u5730\u7248\u672c\u9ad8\u4e8e\u4e91\u7aef\u7248\u672c\uff0c\u5373\u5c06\u5c06\u672c\u5730\u6570\u636e\u63a8\u9001\u81f3\u4e91\u7aef", objectArray);
            }
            if (!row.getSynced()) {
                SyncService.updateData$default(this, id2, false, row.getVersion(), null, 8, null);
            }
        } else if (row.getVersion() < version) {
            if (log.isDebugEnabled()) {
                Object[] objectArray = new Object[]{id2, type, row.getVersion(), version};
                log.debug("\u6570\u636e: {}, \u7c7b\u578b: {}, \u672c\u5730\u7248\u672c: {}, \u4e91\u7aef\u7248\u672c: {}, \u672c\u5730\u7248\u672c\u5c0f\u4e8e\u4e91\u7aef\u7248\u672c\uff0c\u5373\u5c06\u4fdd\u5b58\u5230\u672c\u5730", objectArray);
            }
            this.getDatabaseManager().save(new Data(id2, ownerId2, ownerType2, type, this.decryptData(id2, data, ownerId2), version, true, false), DatabaseChangedExtension.Source.Sync);
            if (log.isInfoEnabled()) {
                log.info("\u6570\u636e: {}, \u7c7b\u578b: {} \u5df2\u66f4\u65b0\u81f3\u6700\u65b0\u7248", (Object)id2, (Object)type);
            }
        } else {
            return PullResult.Nothing;
        }
        return PullResult.Changed;
    }

    public final void trigger() {
        ChannelResult.isSuccess-impl((Object)this.channel.trySend-JP2dKIU((Object)Unit.INSTANCE));
    }

    @Override
    public void ready() {
        BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ PullService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var2_2 = (CoroutineScope)this.L$0;
                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.L$0 = $this$launch;
                        this.label = 1;
                        v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)Random.Default.nextInt(500, 1500), (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                        if (v0 == var4_3) {
                            return var4_3;
                        }
                        ** GOTO lbl16
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl16:
                        // 4 sources

                        while (CoroutineScopeKt.isActive((CoroutineScope)$this$launch)) {
                            PullService.access$pullChanges(this.this$0);
                            this.L$0 = $this$launch;
                            this.label = 2;
                            v1 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)DurationKt.toDuration((int)Random.Default.nextInt(3, 10), (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super ChannelResult<? extends Unit>>, Object>(this.this$0, null){
                                int label;
                                final /* synthetic */ PullService this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(2, $completion);
                                }

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final Object invokeSuspend(Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            this.label = 1;
                                            Object object2 = PullService.access$getChannel$p(this.this$0).receiveCatching-JP2dKIU((Continuation)this);
                                            if (object2 != object) return ChannelResult.box-impl((Object)object2);
                                            return object;
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            Object object2 = ((ChannelResult)$result).unbox-impl();
                                            return ChannelResult.box-impl((Object)object2);
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super ChannelResult<Unit>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (Continuation)((Continuation)this));
                            if (v1 == var4_3) {
                                return var4_3;
                            }
                            ** GOTO lbl29
                        }
                        ** GOTO lbl34
                    }
                    case 2: {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl29:
                        // 2 sources

                        v2 = (ChannelResult)v1;
                        if (v2 != null) ** GOTO lbl32
                        ** GOTO lbl16
lbl32:
                        // 1 sources

                        result = v2.unbox-impl();
                        if (!ChannelResult.isFailure-impl((Object)result)) ** GOTO lbl16
lbl34:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
        Disposer.register(this, new Disposable(this){
            final /* synthetic */ PullService this$0;
            {
                this.this$0 = $receiver;
            }

            public void dispose() {
                SendChannel.DefaultImpls.close$default((SendChannel)((SendChannel)PullService.access$getChannel$p(this.this$0)), null, (int)1, null);
            }
        });
    }

    public /* synthetic */ PullService(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ void access$pullChanges(PullService $this) {
        $this.pullChanges();
    }

    public static final /* synthetic */ Channel access$getChannel$p(PullService $this) {
        return $this.channel;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/account/PullService$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/account/PullService;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PullService getInstance() {
            return (PullService)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(PullService.class), Companion::getInstance$lambda$0);
        }

        private static final PullService getInstance$lambda$0() {
            return new PullService(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 ,2\u00020\u0001:\u0002+,B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0004\b\n\u0010\u000bBI\b\u0010\u0012\u0006\u0010\f\u001a\u00020\r\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\n\u0010\u0010J\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00c6\u0003J;\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u001f\u001a\u00020\u00072\b\u0010 \u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010!\u001a\u00020\rH\u00d6\u0001J\t\u0010\"\u001a\u00020\u0003H\u00d6\u0001J%\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00002\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H\u0001\u00a2\u0006\u0002\b*R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0012\u00a8\u0006-"}, d2={"Lapp/termora/account/PullService$DataChange;", "", "objectId", "", "version", "", "deleted", "", "ownerId", "ownerType", "<init>", "(Ljava/lang/String;JZLjava/lang/String;Ljava/lang/String;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;JZLjava/lang/String;Ljava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getObjectId", "()Ljava/lang/String;", "getVersion", "()J", "getDeleted", "()Z", "getOwnerId", "getOwnerType", "component1", "component2", "component3", "component4", "component5", "copy", "equals", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$termora", "$serializer", "Companion", "termora"})
    private static final class DataChange {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String objectId;
        private final long version;
        private final boolean deleted;
        @NotNull
        private final String ownerId;
        @NotNull
        private final String ownerType;

        public DataChange(@NotNull String objectId, long version, boolean deleted, @NotNull String ownerId, @NotNull String ownerType) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
            Intrinsics.checkNotNullParameter((Object)ownerType, (String)"ownerType");
            this.objectId = objectId;
            this.version = version;
            this.deleted = deleted;
            this.ownerId = ownerId;
            this.ownerType = ownerType;
        }

        @NotNull
        public final String getObjectId() {
            return this.objectId;
        }

        public final long getVersion() {
            return this.version;
        }

        public final boolean getDeleted() {
            return this.deleted;
        }

        @NotNull
        public final String getOwnerId() {
            return this.ownerId;
        }

        @NotNull
        public final String getOwnerType() {
            return this.ownerType;
        }

        @NotNull
        public final String component1() {
            return this.objectId;
        }

        public final long component2() {
            return this.version;
        }

        public final boolean component3() {
            return this.deleted;
        }

        @NotNull
        public final String component4() {
            return this.ownerId;
        }

        @NotNull
        public final String component5() {
            return this.ownerType;
        }

        @NotNull
        public final DataChange copy(@NotNull String objectId, long version, boolean deleted, @NotNull String ownerId, @NotNull String ownerType) {
            Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
            Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
            Intrinsics.checkNotNullParameter((Object)ownerType, (String)"ownerType");
            return new DataChange(objectId, version, deleted, ownerId, ownerType);
        }

        public static /* synthetic */ DataChange copy$default(DataChange dataChange, String string, long l, boolean bl, String string2, String string3, int n, Object object) {
            if ((n & 1) != 0) {
                string = dataChange.objectId;
            }
            if ((n & 2) != 0) {
                l = dataChange.version;
            }
            if ((n & 4) != 0) {
                bl = dataChange.deleted;
            }
            if ((n & 8) != 0) {
                string2 = dataChange.ownerId;
            }
            if ((n & 0x10) != 0) {
                string3 = dataChange.ownerType;
            }
            return dataChange.copy(string, l, bl, string2, string3);
        }

        @NotNull
        public String toString() {
            return "DataChange(objectId=" + this.objectId + ", version=" + this.version + ", deleted=" + this.deleted + ", ownerId=" + this.ownerId + ", ownerType=" + this.ownerType + ")";
        }

        public int hashCode() {
            int result2 = this.objectId.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.version);
            result2 = result2 * 31 + Boolean.hashCode(this.deleted);
            result2 = result2 * 31 + this.ownerId.hashCode();
            result2 = result2 * 31 + this.ownerType.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DataChange)) {
                return false;
            }
            DataChange dataChange = (DataChange)other;
            if (!Intrinsics.areEqual((Object)this.objectId, (Object)dataChange.objectId)) {
                return false;
            }
            if (this.version != dataChange.version) {
                return false;
            }
            if (this.deleted != dataChange.deleted) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.ownerId, (Object)dataChange.ownerId)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.ownerType, (Object)dataChange.ownerType);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$termora(DataChange self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.objectId);
            output.encodeLongElement(serialDesc, 1, self.version);
            output.encodeBooleanElement(serialDesc, 2, self.deleted);
            output.encodeStringElement(serialDesc, 3, self.ownerId);
            output.encodeStringElement(serialDesc, 4, self.ownerType);
        }

        public /* synthetic */ DataChange(int seen0, String objectId, long version, boolean deleted, String ownerId, String ownerType, SerializationConstructorMarker serializationConstructorMarker) {
            if (31 != (0x1F & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)31, (SerialDescriptor)DataChange$$serializer.INSTANCE.getDescriptor());
            }
            this.objectId = objectId;
            this.version = version;
            this.deleted = deleted;
            this.ownerId = ownerId;
            this.ownerType = ownerType;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lapp/termora/account/PullService$DataChange$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lapp/termora/account/PullService$DataChange;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<DataChange> serializer() {
                return (KSerializer)DataChange$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0083\b\u0018\u0000 (2\u00020\u0001:\u0002'(B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0004\b\t\u0010\nB=\b\u0010\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0004\b\t\u0010\u000fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J-\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\fH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u00002\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0001\u00a2\u0006\u0002\b&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006)"}, d2={"Lapp/termora/account/PullService$DataChangesResponse;", "", "after", "", "since", "", "changes", "", "Lapp/termora/account/PullService$DataChange;", "<init>", "(Ljava/lang/String;JLjava/util/List;)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;JLjava/util/List;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getAfter", "()Ljava/lang/String;", "getSince", "()J", "getChanges", "()Ljava/util/List;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$termora", "$serializer", "Companion", "termora"})
    private static final class DataChangesResponse {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String after;
        private final long since;
        @NotNull
        private final List<DataChange> changes;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public DataChangesResponse(@NotNull String after, long since, @NotNull List<DataChange> changes) {
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            this.after = after;
            this.since = since;
            this.changes = changes;
        }

        @NotNull
        public final String getAfter() {
            return this.after;
        }

        public final long getSince() {
            return this.since;
        }

        @NotNull
        public final List<DataChange> getChanges() {
            return this.changes;
        }

        @NotNull
        public final String component1() {
            return this.after;
        }

        public final long component2() {
            return this.since;
        }

        @NotNull
        public final List<DataChange> component3() {
            return this.changes;
        }

        @NotNull
        public final DataChangesResponse copy(@NotNull String after, long since, @NotNull List<DataChange> changes) {
            Intrinsics.checkNotNullParameter((Object)after, (String)"after");
            Intrinsics.checkNotNullParameter(changes, (String)"changes");
            return new DataChangesResponse(after, since, changes);
        }

        public static /* synthetic */ DataChangesResponse copy$default(DataChangesResponse dataChangesResponse, String string, long l, List list, int n, Object object) {
            if ((n & 1) != 0) {
                string = dataChangesResponse.after;
            }
            if ((n & 2) != 0) {
                l = dataChangesResponse.since;
            }
            if ((n & 4) != 0) {
                list = dataChangesResponse.changes;
            }
            return dataChangesResponse.copy(string, l, list);
        }

        @NotNull
        public String toString() {
            return "DataChangesResponse(after=" + this.after + ", since=" + this.since + ", changes=" + this.changes + ")";
        }

        public int hashCode() {
            int result2 = this.after.hashCode();
            result2 = result2 * 31 + Long.hashCode(this.since);
            result2 = result2 * 31 + ((Object)this.changes).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DataChangesResponse)) {
                return false;
            }
            DataChangesResponse dataChangesResponse = (DataChangesResponse)other;
            if (!Intrinsics.areEqual((Object)this.after, (Object)dataChangesResponse.after)) {
                return false;
            }
            if (this.since != dataChangesResponse.since) {
                return false;
            }
            return Intrinsics.areEqual(this.changes, dataChangesResponse.changes);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$termora(DataChangesResponse self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeStringElement(serialDesc, 0, self.after);
            output.encodeLongElement(serialDesc, 1, self.since);
            output.encodeSerializableElement(serialDesc, 2, (SerializationStrategy)lazyArray[2].getValue(), self.changes);
        }

        public /* synthetic */ DataChangesResponse(int seen0, String after, long since, List changes, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)DataChangesResponse$$serializer.INSTANCE.getDescriptor());
            }
            this.after = after;
            this.since = since;
            this.changes = changes;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{null, null, LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)DataChange$$serializer.INSTANCE))};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lapp/termora/account/PullService$DataChangesResponse$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lapp/termora/account/PullService$DataChangesResponse;", "termora"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<DataChangesResponse> serializer() {
                return (KSerializer)DataChangesResponse$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/account/PullService$PullResult;", "", "<init>", "(Ljava/lang/String;I)V", "Nothing", "Changed", "termora"})
    private static final class PullResult
    extends Enum<PullResult> {
        public static final /* enum */ PullResult Nothing = new PullResult();
        public static final /* enum */ PullResult Changed = new PullResult();
        private static final /* synthetic */ PullResult[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static PullResult[] values() {
            return (PullResult[])$VALUES.clone();
        }

        public static PullResult valueOf(String value) {
            return Enum.valueOf(PullResult.class, value);
        }

        @NotNull
        public static EnumEntries<PullResult> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = pullResultArray = new PullResult[]{PullResult.Nothing, PullResult.Changed};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

