/*
 * Decompiled with CFR 0.152.
 */
package app.termora.keymgr;

import app.termora.DialogWrapper;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.account.AccountManager;
import app.termora.account.AccountOwner;
import app.termora.account.Team;
import app.termora.database.OwnerType;
import app.termora.keymgr.KeyManagerPanel;
import app.termora.keymgr.OhKeyPair;
import com.formdev.flatlaf.extras.components.FlatTabbedPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0012H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0014J\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lapp/termora/keymgr/KeyManagerDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "selectMode", "", "size", "Ljava/awt/Dimension;", "accountOwner", "Lapp/termora/account/AccountOwner;", "<init>", "(Ljava/awt/Window;ZLjava/awt/Dimension;Lapp/termora/account/AccountOwner;)V", "ok", "getOk", "()Z", "setOk", "(Z)V", "createCenterPanel", "Ljavax/swing/JComponent;", "createSouthPanel", "doOKAction", "", "getLasOhKeyPair", "Lapp/termora/keymgr/OhKeyPair;", "termora"})
public final class KeyManagerDialog
extends DialogWrapper {
    private final boolean selectMode;
    @Nullable
    private final AccountOwner accountOwner;
    private boolean ok;

    public KeyManagerDialog(@NotNull Window owner, boolean selectMode, @NotNull Dimension size, @Nullable AccountOwner accountOwner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        super(owner);
        this.selectMode = selectMode;
        this.accountOwner = accountOwner;
        super.setSize(size.width, size.height);
        this.setModal(true);
        this.setTitle(I18n.INSTANCE.getString("termora.keymgr.title"));
        this.setLocationRelativeTo(null);
        this.init();
    }

    public /* synthetic */ KeyManagerDialog(Window window, boolean bl, Dimension dimension, AccountOwner accountOwner, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            dimension = new Dimension(UIManager.getInt("Dialog.width"), UIManager.getInt("Dialog.height"));
        }
        if ((n & 8) != 0) {
            accountOwner = null;
        }
        this(window, bl, dimension, accountOwner);
    }

    public final boolean getOk() {
        return this.ok;
    }

    public final void setOk(boolean bl) {
        this.ok = bl;
    }

    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        AccountManager accountManager = AccountManager.Companion.getInstance();
        FlatTabbedPane tabbed = new FlatTabbedPane();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"focusColor", (Object)new DynamicColor("TabbedPane.background")), TuplesKt.to((Object)"hoverColor", (Object)new DynamicColor("TabbedPane.background"))};
        tabbed.setStyleMap(MapsKt.mapOf((Pair[])pairArray));
        tabbed.setHasFullBorder(false);
        tabbed.setBorder((Border)BorderFactory.createMatteBorder(1, 0, 0, 0, DynamicColor.Companion.getBorderColor()));
        tabbed.setTabPlacement(1);
        if (this.accountOwner == null || this.accountOwner.getType() == OwnerType.User) {
            tabbed.addTab(I18n.INSTANCE.getString("termora.keymgr.my-keys"), (Icon)((Object)Icons.INSTANCE.getUser()), (Component)new KeyManagerPanel(new AccountOwner(accountManager.getAccountId(), accountManager.getEmail(), OwnerType.User)));
        }
        if (this.accountOwner != null && accountManager.hasTeamFeature()) {
            for (Team team : accountManager.getTeams()) {
                if (!Intrinsics.areEqual((Object)team.getId(), (Object)this.accountOwner.getId())) continue;
                tabbed.addTab(team.getName(), (Icon)((Object)Icons.INSTANCE.getCwmUsers()), (Component)new KeyManagerPanel(new AccountOwner(team.getId(), team.getName(), OwnerType.Team)));
                return (JComponent)tabbed;
            }
        }
        if (accountManager.hasTeamFeature()) {
            for (Team team : accountManager.getTeams()) {
                tabbed.addTab(team.getName(), (Icon)((Object)Icons.INSTANCE.getCwmUsers()), (Component)new KeyManagerPanel(new AccountOwner(team.getId(), team.getName(), OwnerType.Team)));
            }
        }
        return (JComponent)tabbed;
    }

    @Override
    @Nullable
    protected JComponent createSouthPanel() {
        return this.selectMode ? super.createSouthPanel() : null;
    }

    @Override
    protected void doOKAction() {
        this.ok = true;
        super.doOKAction();
    }

    @Nullable
    public final OhKeyPair getLasOhKeyPair() {
        return null;
    }
}

