/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.local;

import app.termora.Host;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.OptionPane;
import app.termora.PtyConnectorFactory;
import app.termora.PtyHostTerminalTab;
import app.termora.TerminalTab;
import app.termora.WindowScope;
import app.termora.terminal.PtyConnector;
import app.termora.terminal.PtyConnectorDelegate;
import app.termora.terminal.PtyProcessConnector;
import app.termora.terminal.TerminalSize;
import com.pty4j.PtyProcess;
import java.awt.Window;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.optionals.OptionalsKt;
import org.apache.commons.io.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u00a8\u0006\u0014"}, d2={"Lapp/termora/plugin/internal/local/LocalTerminalTab;", "Lapp/termora/PtyHostTerminalTab;", "windowScope", "Lapp/termora/WindowScope;", "host", "Lapp/termora/Host;", "<init>", "(Lapp/termora/WindowScope;Lapp/termora/Host;)V", "openPtyConnector", "Lapp/termora/terminal/PtyConnector;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getIcon", "Ljavax/swing/Icon;", "willBeClose", "", "createReconnectTerminalTab", "Lapp/termora/TerminalTab;", "getPtyProcessConnector", "Lapp/termora/terminal/PtyProcessConnector;", "Companion", "termora"})
public final class LocalTerminalTab
extends PtyHostTerminalTab {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final Logger log = LoggerFactory.getLogger(LocalTerminalTab.class);

    public LocalTerminalTab(@NotNull WindowScope windowScope, @NotNull Host host) {
        Intrinsics.checkNotNullParameter((Object)windowScope, (String)"windowScope");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        super(windowScope, host, null, 4, null);
    }

    @Override
    @Nullable
    public Object openPtyConnector(@NotNull Continuation<? super PtyConnector> $completion) {
        TerminalSize winSize = this.getTerminalPanel().winSize();
        PtyConnectorFactory ptyConnectorFactory = PtyConnectorFactory.Companion.getInstance();
        int n = winSize.getRows();
        int n2 = winSize.getCols();
        Map<String, String> map = this.getHost().getOptions().envs();
        Charset charset = Charsets.toCharset((String)this.getHost().getOptions().getEncoding(), (Charset)StandardCharsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"toCharset(...)");
        PtyConnector ptyConnector = ptyConnectorFactory.createPtyConnector(n, n2, map, charset);
        return ptyConnector;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return (Icon)((Object)Icons.INSTANCE.getTerminal());
    }

    @Override
    public boolean willBeClose() {
        int consoleProcessCount;
        block6: {
            PtyProcessConnector ptyProcessConnector = this.getPtyProcessConnector();
            if (ptyProcessConnector == null) {
                return true;
            }
            PtyProcessConnector ptyProcessConnector2 = ptyProcessConnector;
            PtyProcess process = ptyProcessConnector2.getProcess();
            consoleProcessCount = 0;
            try {
                Optional<ProcessHandle> optional = ProcessHandle.of(process.pid());
                Intrinsics.checkNotNullExpressionValue(optional, (String)"of(...)");
                ProcessHandle processHandle = (ProcessHandle)OptionalsKt.getOrNull(optional);
                if (processHandle != null) {
                    consoleProcessCount = (int)processHandle.children().count();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block6;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        if (consoleProcessCount < 1) {
            return true;
        }
        Window window = SwingUtilities.getWindowAncestor(this.getTerminalPanel());
        if (window == null) {
            return true;
        }
        OptionPane optionPane = OptionPane.INSTANCE;
        Window owner = window;
        String string = I18n.INSTANCE.getString("termora.tabbed.local-tab.close-prompt");
        return OptionPane.showConfirmDialog$default(optionPane, owner, string, null, 2, 1, null, null, null, null, 484, null) == 0;
    }

    @Override
    @NotNull
    protected TerminalTab createReconnectTerminalTab() {
        return new LocalTerminalTab(this.getWindowScope(), this.getHost());
    }

    private final PtyProcessConnector getPtyProcessConnector() {
        PtyConnector p = this.getPtyConnector();
        while (p != null) {
            if (p instanceof PtyProcessConnector) {
                return (PtyProcessConnector)p;
            }
            if (!(p instanceof PtyConnectorDelegate)) continue;
            p = ((PtyConnectorDelegate)p).getPtyConnector();
        }
        return null;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lapp/termora/plugin/internal/local/LocalTerminalTab$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "termora"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

