/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.ssh;

import app.termora.Application;
import app.termora.Authentication;
import app.termora.AuthenticationType;
import app.termora.CryptoKt;
import app.termora.Host;
import app.termora.HostManager;
import app.termora.I18n;
import app.termora.OptionPane;
import app.termora.ProxyType;
import app.termora.RequestAuthenticationDialog;
import app.termora.Tunneling;
import app.termora.TunnelingType;
import app.termora.keyboardinteractive.TerminalUserInteraction;
import app.termora.keymgr.OhKeyPairKeyPairProvider;
import app.termora.plugin.internal.ssh.SshAgentFactory;
import app.termora.terminal.TerminalSize;
import app.termora.x11.X11ChannelFactory;
import com.formdev.flatlaf.FlatLaf;
import com.formdev.flatlaf.util.FontUtils;
import com.formdev.flatlaf.util.SystemInfo;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.channel.ChannelExec;
import org.apache.sshd.client.channel.ChannelShell;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.future.AuthFuture;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.client.kex.DHGClient;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ModifiedServerKeyAcceptor;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.client.session.SessionFactory;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.PtyChannelConfiguration;
import org.apache.sshd.common.channel.PtyChannelConfigurationHolder;
import org.apache.sshd.common.cipher.CipherNone;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.config.keys.KeyRandomArt;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.global.KeepAliveHandler;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoServiceEventListener;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.kex.DHFactory;
import org.apache.sshd.common.kex.KeyExchangeFactory;
import org.apache.sshd.common.keyprovider.KeyIdentityProvider;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.core.CoreModuleProperties;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.forward.RejectAllForwardingFilter;
import org.eclipse.jgit.internal.transport.sshd.JGitClientSession;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.PageantConnector;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.UnixDomainSocketConnector;
import org.eclipse.jgit.internal.transport.sshd.proxy.AbstractClientProxyConnector;
import org.eclipse.jgit.internal.transport.sshd.proxy.HttpClientConnector;
import org.eclipse.jgit.internal.transport.sshd.proxy.Socks5ClientConnector;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.sshd.IdentityPasswordProvider;
import org.eclipse.jgit.transport.sshd.KeyPasswordProvider;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00042345B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u001eJ\u0016\u0010 \u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"J\u000e\u0010#\u001a\u00020$2\u0006\u0010\u0019\u001a\u00020\u001aJ\"\u0010%\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010!\u001a\u00020\"2\b\b\u0002\u0010&\u001a\u00020$H\u0002J\u001e\u0010'\u001a\u00020(2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010)\u001a\u00020*J\u0016\u0010+\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010,\u001a\u00020-J\u000e\u0010+\u001a\u00020\"2\u0006\u0010\u0016\u001a\u00020\u0006J\"\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u00100\u001a\u0002012\u0006\u0010,\u001a\u00020-H\u0002R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR#\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u00066"}, d2={"Lapp/termora/plugin/internal/ssh/SshClients;", "", "<init>", "()V", "HOST_KEY", "Lorg/apache/sshd/common/AttributeRepository$AttributeKey;", "Lapp/termora/Host;", "getHOST_KEY", "()Lorg/apache/sshd/common/AttributeRepository$AttributeKey;", "hostManager", "Lapp/termora/HostManager;", "getHostManager", "()Lapp/termora/HostManager;", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLog", "()Lorg/slf4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "openShell", "Lorg/apache/sshd/client/channel/ChannelShell;", "host", "size", "Lapp/termora/terminal/TerminalSize;", "session", "Lorg/apache/sshd/client/session/ClientSession;", "execChannel", "Lkotlin/Pair;", "", "", "command", "openSession", "client", "Lorg/apache/sshd/client/SshClient;", "isMiddleware", "", "doOpenSession", "middleware", "openTunneling", "Lorg/apache/sshd/common/util/net/SshdSocketAddress;", "tunneling", "Lapp/termora/Tunneling;", "openClient", "owner", "Ljava/awt/Window;", "ask", "Lapp/termora/plugin/internal/ssh/SshClients$AskUserInfo;", "entry", "Lorg/apache/sshd/client/config/hosts/HostConfigEntry;", "AskUserInfo", "MyDialogServerKeyVerifier", "DialogServerKeyVerifier", "MyJGitSshClient", "termora"})
@SourceDebugExtension(value={"SMAP\nSshClients.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshClients.kt\napp/termora/plugin/internal/ssh/SshClients\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,737:1\n1208#2,2:738\n1236#2,4:740\n*S KotlinDebug\n*F\n+ 1 SshClients.kt\napp/termora/plugin/internal/ssh/SshClients\n*L\n171#1:738,2\n171#1:740,4\n*E\n"})
public final class SshClients {
    @NotNull
    public static final SshClients INSTANCE = new SshClients();
    @NotNull
    private static final AttributeRepository.AttributeKey<Host> HOST_KEY = new AttributeRepository.AttributeKey();
    @NotNull
    private static final Lazy log$delegate = LazyKt.lazy(SshClients::log_delegate$lambda$0);

    private SshClients() {
    }

    @NotNull
    public final AttributeRepository.AttributeKey<Host> getHOST_KEY() {
        return HOST_KEY;
    }

    private final HostManager getHostManager() {
        return HostManager.Companion.getInstance();
    }

    private final Logger getLog() {
        Lazy lazy = log$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public final ChannelShell openShell(@NotNull Host host, @NotNull TerminalSize size, @NotNull ClientSession session2) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Object object = host.getOptions().getExtras().get("timeout");
        Duration timeout = Duration.ofSeconds(object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 60L);
        PtyChannelConfiguration configuration = new PtyChannelConfiguration();
        configuration.setPtyColumns(size.getCols());
        configuration.setPtyLines(size.getRows());
        configuration.setPtyType("xterm-256color");
        Map env = new LinkedHashMap();
        env.put("TERM", configuration.getPtyType());
        env.putAll(host.getOptions().envs());
        ChannelShell channel = session2.createShellChannel((PtyChannelConfigurationHolder)configuration, env);
        String string = host.getOptions().getExtras().get("forwardAgent");
        channel.setAgentForwarding(string != null ? Boolean.parseBoolean(string) : false);
        if (host.getOptions().getEnableX11Forwarding() && channel instanceof app.termora.x11.ChannelShell) {
            ((app.termora.x11.ChannelShell)channel).setXForwarding(true);
        }
        if (!((OpenFuture)channel.open().verify(timeout)).await()) {
            throw new SshException("Failed to open Shell");
        }
        Intrinsics.checkNotNull((Object)channel);
        return channel;
    }

    @NotNull
    public final Pair<Integer, String> execChannel(@NotNull ClientSession session2, @NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Duration timeout = Duration.ofSeconds(60L);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ChannelExec channel = session2.createExecChannel(command);
        channel.setOut((OutputStream)baos);
        if (((OpenFuture)channel.open().verify(timeout)).await(timeout)) {
            channel.waitFor((Collection)EnumSet.of((Enum)ClientChannelEvent.CLOSED), timeout);
        }
        IOUtils.closeQuietly((Closeable)((Closeable)channel));
        if (channel.getExitStatus() == null) {
            return new Pair((Object)-1, (Object)baos.toString());
        }
        return new Pair((Object)channel.getExitStatus(), (Object)baos.toString());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ClientSession openSession(@NotNull Host host, @NotNull SshClient client) {
        void $this$associateByTo$iv$iv;
        Host h;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Host host2 = this.getHostManager().getHost(host.getId());
        if (host2 == null) {
            host2 = host;
        }
        if ((h = host2).getOptions().getJumpHosts().isEmpty()) {
            return SshClients.doOpenSession$default(this, h, client, false, 4, null);
        }
        List jumpHosts = new ArrayList();
        Iterable $this$associateBy$iv = HostManager.Companion.getInstance().hosts();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            Host host3 = (Host)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(it.getId(), element$iv$iv);
        }
        Map hosts = destination$iv$iv;
        for (String jumpHostId : h.getOptions().getJumpHosts()) {
            Host e = (Host)hosts.get(jumpHostId);
            if (e == null) {
                if (!this.getLog().isWarnEnabled()) continue;
                this.getLog().warn("Failed to find jump host: " + jumpHostId);
                continue;
            }
            jumpHosts.add(e);
        }
        jumpHosts.add(h);
        List sessions = new ArrayList();
        int n = jumpHosts.size();
        for (int i = 0; i < n; ++i) {
            Host currentHost = (Host)jumpHosts.get(i);
            sessions.add(this.doOpenSession(currentHost, client, i != 0));
            if (i >= jumpHosts.size() - 1) continue;
            Host nextHost = (Host)jumpHosts.get(i + 1);
            SshdSocketAddress address = ((ClientSession)CollectionsKt.last((List)sessions)).startLocalPortForwarding(SshdSocketAddress.LOCALHOST_ADDRESS, new SshdSocketAddress(nextHost.getHost(), nextHost.getPort()));
            if (this.getLog().isInfoEnabled()) {
                this.getLog().info("jump host: " + currentHost.getHost() + ":" + currentHost.getPort() + " , next host: " + nextHost.getHost() + ":" + nextHost.getPort() + " , local address: " + address.getHostName() + ":" + address.getPort());
            }
            String string = address.getHostName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHostName(...)");
            jumpHosts.set(i + 1, Host.copy$default(nextHost, null, null, null, string, address.getPort(), null, null, null, null, null, null, 0L, null, null, null, null, false, 0L, 0L, 524263, null));
        }
        return (ClientSession)CollectionsKt.last((List)sessions);
    }

    public final boolean isMiddleware(@NotNull ClientSession session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        if (session2 instanceof JGitClientSession) {
            String string = (String)((JGitClientSession)session2).getHostConfigEntry().getProperties().get("Middleware");
            boolean bl = string != null ? Boolean.parseBoolean(string) : false;
            if (bl) {
                return true;
            }
        }
        return false;
    }

    private final ClientSession doOpenSession(Host host, SshClient client, boolean middleware) {
        Object object;
        HostConfigEntry entry = new HostConfigEntry();
        entry.setPort(host.getPort());
        entry.setUsername(host.getUsername());
        entry.setHostName(host.getHost());
        entry.setProperty("Middleware", String.valueOf(middleware));
        entry.setProperty("Host", host.getId());
        if (host.getAuthentication().getType() == AuthenticationType.SSHAgent) {
            Object file;
            if (SystemInfo.isMacOS) {
                String[] stringArray = new String[]{"config", "ssh-agent.sock"};
                file = FileUtils.getFile((File)Application.INSTANCE.getBaseDataDir(), (String[])stringArray);
                if (((File)file).exists()) {
                    entry.setProperty("IdentityAgent", ((File)file).getAbsolutePath());
                }
            }
            if ((file = (CharSequence)entry.getProperty("IdentityAgent")) == null || StringsKt.isBlank((CharSequence)file)) {
                String string = !StringsKt.isBlank((CharSequence)host.getAuthentication().getPassword()) ? entry.setProperty("IdentityAgent", host.getAuthentication().getPassword()) : (SystemInfo.isWindows ? entry.setProperty("IdentityAgent", PageantConnector.DESCRIPTOR.getIdentityAgent()) : entry.setProperty("IdentityAgent", UnixDomainSocketConnector.DESCRIPTOR.getIdentityAgent()));
            }
        }
        Duration timeout = Duration.ofSeconds((object = host.getOptions().getExtras().get("timeout")) != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 60L);
        ClientSession session2 = (ClientSession)((ConnectFuture)client.connect(entry).verify(timeout)).getSession();
        if (host.getAuthentication().getType() == AuthenticationType.Password) {
            if (StringUtils.isNotBlank((CharSequence)host.getAuthentication().getPassword())) {
                session2.addPasswordIdentity(host.getAuthentication().getPassword());
            }
        } else if (host.getAuthentication().getType() == AuthenticationType.PublicKey) {
            session2.setKeyIdentityProvider((KeyIdentityProvider)new OhKeyPairKeyPairProvider(host.getAuthentication().getPassword()));
        }
        if (host.getOptions().getEnableX11Forwarding()) {
            String[] stringArray = new String[]{":"};
            List segments = StringsKt.split$default((CharSequence)host.getOptions().getX11Forwarding(), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (segments.size() == 2) {
                String x11Host = (String)segments.get(0);
                Integer x11Port = StringsKt.toIntOrNull((String)((String)segments.get(1)));
                if (x11Port != null) {
                    CoreModuleProperties.X11_BIND_HOST.set((PropertyResolver)session2, (Object)x11Host);
                    CoreModuleProperties.X11_BASE_PORT.set((PropertyResolver)session2, (Object)(6000 + x11Port));
                }
            }
        }
        try {
            if (!((AuthFuture)session2.auth().verify(timeout)).await(timeout)) {
                throw new SshException("Authentication failed");
            }
        }
        catch (Exception e) {
            if (!(e instanceof SshException) || ((SshException)e).getDisconnectCode() != 14) {
                throw e;
            }
            Window window = (Window)client.getProperties().get("owner");
            if (window == null) {
                throw e;
            }
            Window owner = window;
            AskUserInfo askUserInfo = this.ask(host, entry, owner);
            if (askUserInfo == null) {
                throw e;
            }
            AskUserInfo askUserInfo2 = askUserInfo;
            if (askUserInfo2.getAuthentication().getType() == AuthenticationType.No) {
                throw e;
            }
            Authentication authentication = askUserInfo2.getAuthentication();
            String string = askUserInfo2.getUsername();
            return SshClients.doOpenSession$default(this, Host.copy$default(host, null, null, null, null, 0, string, null, authentication, null, null, null, 0L, null, null, null, null, false, 0L, 0L, 524127, null), client, false, 4, null);
        }
        session2.setAttribute(HOST_KEY, (Object)host);
        Intrinsics.checkNotNull((Object)session2);
        return session2;
    }

    static /* synthetic */ ClientSession doOpenSession$default(SshClients sshClients, Host host, SshClient sshClient, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return sshClients.doOpenSession(host, sshClient, bl);
    }

    @NotNull
    public final SshdSocketAddress openTunneling(@NotNull ClientSession session2, @NotNull Host host, @NotNull Tunneling tunneling) {
        SshdSocketAddress sshdSocketAddress;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)tunneling, (String)"tunneling");
        SshdSocketAddress sshdSocketAddress2 = tunneling.getType() == TunnelingType.Local ? session2.startLocalPortForwarding(new SshdSocketAddress(tunneling.getSourceHost(), tunneling.getSourcePort()), new SshdSocketAddress(tunneling.getDestinationHost(), tunneling.getDestinationPort())) : (tunneling.getType() == TunnelingType.Remote ? session2.startRemotePortForwarding(new SshdSocketAddress(tunneling.getSourceHost(), tunneling.getSourcePort()), new SshdSocketAddress(tunneling.getDestinationHost(), tunneling.getDestinationPort())) : (sshdSocketAddress = tunneling.getType() == TunnelingType.Dynamic ? session2.startDynamicPortForwarding(new SshdSocketAddress(tunneling.getSourceHost(), tunneling.getSourcePort())) : SshdSocketAddress.LOCALHOST_ADDRESS));
        if (this.getLog().isInfoEnabled()) {
            Object[] objectArray = new Object[]{host.getName(), tunneling.getName(), sshdSocketAddress.getHostName(), sshdSocketAddress.getPort()};
            this.getLog().info("SSH [{}] started {} port forwarding. host: {} , port: {}", objectArray);
        }
        Intrinsics.checkNotNull((Object)sshdSocketAddress);
        return sshdSocketAddress;
    }

    @NotNull
    public final SshClient openClient(@NotNull Host host, @NotNull Window owner) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        Host host2 = this.getHostManager().getHost(host.getId());
        if (host2 == null) {
            host2 = host;
        }
        Host h = host2;
        SshClient client = this.openClient(h);
        client.setUserInteraction((UserInteraction)new TerminalUserInteraction(owner));
        client.setServerKeyVerifier((ServerKeyVerifier)new DialogServerKeyVerifier(owner));
        Map map = client.getProperties();
        Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getProperties(...)");
        Map map2 = map;
        map2.put("owner", owner);
        return client;
    }

    @NotNull
    public final SshClient openClient(@NotNull Host host) {
        JGitSshClient sshClient;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter((Object)host, (String)"host");
                ClientBuilder builder2 = ClientBuilder.builder();
                ((ClientBuilder)builder2.globalRequestHandlers(CollectionsKt.listOf((Object)KeepAliveHandler.INSTANCE))).factory(SshClients::openClient$lambda$0);
                List list = ClientBuilder.setUpDefaultKeyExchanges((boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"setUpDefaultKeyExchanges(...)");
                List keyExchangeFactories = CollectionsKt.toMutableList((Collection)list);
                Object[] objectArray = new KeyExchangeFactory[]{DHGClient.newFactory((DHFactory)((DHFactory)BuiltinDHFactories.dhg1)), DHGClient.newFactory((DHFactory)((DHFactory)BuiltinDHFactories.dhg14)), DHGClient.newFactory((DHFactory)((DHFactory)BuiltinDHFactories.dhgex))};
                keyExchangeFactories.addAll(CollectionsKt.listOf((Object[])objectArray));
                builder2.keyExchangeFactories(keyExchangeFactories);
                List list2 = ClientBuilder.setUpDefaultCompressionFactories((boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"setUpDefaultCompressionFactories(...)");
                List compressionFactories = CollectionsKt.toMutableList((Collection)list2);
                Object[] objectArray2 = new BuiltinCompressions[]{BuiltinCompressions.none, BuiltinCompressions.zlib, BuiltinCompressions.delayedZlib};
                for (Object compression : CollectionsKt.listOf((Object[])objectArray2)) {
                    if (compressionFactories.contains(compression)) continue;
                    compressionFactories.add(compression);
                }
                builder2.compressionFactories(compressionFactories);
                List list3 = ClientBuilder.setUpDefaultSignatureFactories((boolean)true);
                Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"setUpDefaultSignatureFactories(...)");
                List signatureFactories = CollectionsKt.toMutableList((Collection)list3);
                for (BuiltinSignatures signature : EntriesMappings.entries$0) {
                    if (signatureFactories.contains(signature)) continue;
                    signatureFactories.add(signature);
                }
                builder2.signatureFactories(signatureFactories);
                ClientBuilder clientBuilder = host.getTunnelings().isEmpty() && host.getOptions().getJumpHosts().isEmpty() ? (ClientBuilder)builder2.forwardingFilter((ForwardingFilter)RejectAllForwardingFilter.INSTANCE) : (ClientBuilder)builder2.forwardingFilter((ForwardingFilter)AcceptAllForwardingFilter.INSTANCE);
                builder2.hostConfigEntryResolver(HostConfigEntryResolver.EMPTY);
                List channelFactories = new ArrayList();
                List list4 = ClientBuilder.DEFAULT_CHANNEL_FACTORIES;
                Intrinsics.checkNotNullExpressionValue((Object)list4, (String)"DEFAULT_CHANNEL_FACTORIES");
                channelFactories.addAll(list4);
                channelFactories.add(X11ChannelFactory.Companion.getINSTANCE());
                builder2.channelFactories(channelFactories);
                AbstractFactoryManager abstractFactoryManager = builder2.build();
                Intrinsics.checkNotNull((Object)abstractFactoryManager, (String)"null cannot be cast to non-null type org.eclipse.jgit.internal.transport.sshd.JGitSshClient");
                sshClient = (JGitSshClient)abstractFactoryManager;
                sshClient.setKeyIdentityProvider(SshClients::openClient$lambda$1);
                if (host.getAuthentication().getType() == AuthenticationType.SSHAgent) break block7;
                String string = host.getOptions().getExtras().get("forwardAgent");
                boolean bl = string != null ? Boolean.parseBoolean(string) : false;
                if (!bl) break block8;
            }
            ConnectorFactory connectorFactory = ConnectorFactory.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)connectorFactory, (String)"getDefault(...)");
            sshClient.setAgentFactory((org.apache.sshd.agent.SshAgentFactory)new SshAgentFactory(connectorFactory, null));
        }
        if (host.getAuthentication().getType() == AuthenticationType.PublicKey || host.getAuthentication().getType() == AuthenticationType.SSHAgent) {
            var8_8 = new String[]{"publickey", "password", "keyboard-interactive"};
            CoreModuleProperties.PREFERRED_AUTHS.set((PropertyResolver)sshClient, (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])var8_8), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        } else {
            var8_8 = new String[]{"password", "publickey", "keyboard-interactive"};
            CoreModuleProperties.PREFERRED_AUTHS.set((PropertyResolver)sshClient, (Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])var8_8), (CharSequence)",", null, null, (int)0, null, null, (int)62, null));
        }
        int heartbeatInterval = Math.max(host.getOptions().getHeartbeatInterval(), 3);
        Object object = host.getOptions().getExtras().get("timeout");
        Duration timeout = Duration.ofSeconds(object != null && (object = StringsKt.toLongOrNull((String)object)) != null ? (Long)object : 60L);
        CoreModuleProperties.HEARTBEAT_INTERVAL.set((PropertyResolver)sshClient, (Object)Duration.ofSeconds(heartbeatInterval));
        CoreModuleProperties.ALLOW_DHG1_KEX_FALLBACK.set((PropertyResolver)sshClient, (Object)true);
        CoreModuleProperties.IO_CONNECT_TIMEOUT.set((PropertyResolver)sshClient, (Object)timeout);
        sshClient.setKeyPasswordProviderFactory(SshClients::openClient$lambda$2);
        sshClient.start();
        return (SshClient)sshClient;
    }

    private final AskUserInfo ask(Host host, HostConfigEntry entry, Window owner) {
        AtomicReference<Object> ref = new AtomicReference<Object>(null);
        SwingUtilities.invokeAndWait(() -> SshClients.ask$lambda$0(owner, host, ref, entry));
        return ref.get();
    }

    private static final Logger log_delegate$lambda$0() {
        return LoggerFactory.getLogger(SshClients.class);
    }

    private static final SshClient openClient$lambda$0() {
        return (SshClient)new MyJGitSshClient();
    }

    private static final Iterable openClient$lambda$1(SessionContext it) {
        return new ArrayList();
    }

    private static final KeyPasswordProvider openClient$lambda$2() {
        return (KeyPasswordProvider)new IdentityPasswordProvider(CredentialsProvider.getDefault());
    }

    private static final void ask$lambda$0(Window $owner, Host $host, AtomicReference $ref, HostConfigEntry $entry) {
        RequestAuthenticationDialog dialog2 = new RequestAuthenticationDialog($owner, $host);
        dialog2.setLocationRelativeTo($owner);
        Authentication authentication = dialog2.getAuthentication();
        $ref.set(new AskUserInfo(dialog2.getUsername(), authentication));
        if (dialog2.isRemembered()) {
            String hostId = $entry.getProperty("Host", $host.getId());
            HostManager hostManager = INSTANCE.getHostManager();
            Intrinsics.checkNotNull((Object)hostId);
            Host h = hostManager.getHost(hostId);
            if (h != null) {
                Host host = h;
                String string = dialog2.getUsername();
                HostManager.addHost$default(INSTANCE.getHostManager(), Host.copy$default(host, null, null, null, null, 0, string, null, authentication, null, null, null, 0L, null, null, null, null, false, 0L, 0L, 524127, null), null, 2, null);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lapp/termora/plugin/internal/ssh/SshClients$AskUserInfo;", "", "username", "", "authentication", "Lapp/termora/Authentication;", "<init>", "(Ljava/lang/String;Lapp/termora/Authentication;)V", "getUsername", "()Ljava/lang/String;", "getAuthentication", "()Lapp/termora/Authentication;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "termora"})
    private static final class AskUserInfo {
        @NotNull
        private final String username;
        @NotNull
        private final Authentication authentication;

        public AskUserInfo(@NotNull String username, @NotNull Authentication authentication) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
            this.username = username;
            this.authentication = authentication;
        }

        @NotNull
        public final String getUsername() {
            return this.username;
        }

        @NotNull
        public final Authentication getAuthentication() {
            return this.authentication;
        }

        @NotNull
        public final String component1() {
            return this.username;
        }

        @NotNull
        public final Authentication component2() {
            return this.authentication;
        }

        @NotNull
        public final AskUserInfo copy(@NotNull String username, @NotNull Authentication authentication) {
            Intrinsics.checkNotNullParameter((Object)username, (String)"username");
            Intrinsics.checkNotNullParameter((Object)authentication, (String)"authentication");
            return new AskUserInfo(username, authentication);
        }

        public static /* synthetic */ AskUserInfo copy$default(AskUserInfo askUserInfo, String string, Authentication authentication, int n, Object object) {
            if ((n & 1) != 0) {
                string = askUserInfo.username;
            }
            if ((n & 2) != 0) {
                authentication = askUserInfo.authentication;
            }
            return askUserInfo.copy(string, authentication);
        }

        @NotNull
        public String toString() {
            return "AskUserInfo(username=" + this.username + ", authentication=" + this.authentication + ")";
        }

        public int hashCode() {
            int result2 = this.username.hashCode();
            result2 = result2 * 31 + this.authentication.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AskUserInfo)) {
                return false;
            }
            AskUserInfo askUserInfo = (AskUserInfo)other;
            if (!Intrinsics.areEqual((Object)this.username, (Object)askUserInfo.username)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.authentication, (Object)askUserInfo.authentication);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005JD\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0010\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\u0011H\u0014\u00a8\u0006\u0013"}, d2={"Lapp/termora/plugin/internal/ssh/SshClients$DialogServerKeyVerifier;", "Lorg/apache/sshd/client/keyverifier/KnownHostsServerKeyVerifier;", "owner", "Ljava/awt/Window;", "<init>", "(Ljava/awt/Window;)V", "updateKnownHostsFile", "Lorg/apache/sshd/client/config/hosts/KnownHostEntry;", "clientSession", "Lorg/apache/sshd/client/session/ClientSession;", "remoteAddress", "Ljava/net/SocketAddress;", "serverKey", "Ljava/security/PublicKey;", "file", "Ljava/nio/file/Path;", "knownHosts", "", "Lorg/apache/sshd/client/keyverifier/KnownHostsServerKeyVerifier$HostEntryPair;", "termora"})
    private static final class DialogServerKeyVerifier
    extends KnownHostsServerKeyVerifier {
        public DialogServerKeyVerifier(@NotNull Window owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            String[] stringArray = new String[]{"known_hosts"};
            super((ServerKeyVerifier)new MyDialogServerKeyVerifier(owner), Paths.get(Application.INSTANCE.getBaseDataDir().getAbsolutePath(), stringArray));
            ServerKeyVerifier serverKeyVerifier = this.getDelegateVerifier();
            Intrinsics.checkNotNull((Object)serverKeyVerifier, (String)"null cannot be cast to non-null type org.apache.sshd.client.keyverifier.ModifiedServerKeyAcceptor");
            this.setModifiedServerKeyAcceptor((ModifiedServerKeyAcceptor)serverKeyVerifier);
        }

        @Nullable
        protected KnownHostEntry updateKnownHostsFile(@Nullable ClientSession clientSession, @Nullable SocketAddress remoteAddress, @Nullable PublicKey serverKey, @Nullable Path file, @Nullable Collection<? extends KnownHostsServerKeyVerifier.HostEntryPair> knownHosts) {
            if (clientSession instanceof JGitClientSession && INSTANCE.isMiddleware(clientSession)) {
                return null;
            }
            return super.updateKnownHostsFile(clientSession, remoteAddress, serverKey, file, knownHosts);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class EntriesMappings {
        public static final /* synthetic */ EnumEntries<BuiltinSignatures> entries$0;

        static {
            entries$0 = EnumEntriesKt.enumEntries((Enum[])((Enum[])BuiltinSignatures.values()));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J:\u0010\u000f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0016J&\u0010\u0014\u001a\u00020\u00152\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u000eH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lapp/termora/plugin/internal/ssh/SshClients$MyDialogServerKeyVerifier;", "Lorg/apache/sshd/client/keyverifier/ServerKeyVerifier;", "Lorg/apache/sshd/client/keyverifier/ModifiedServerKeyAcceptor;", "owner", "Ljava/awt/Window;", "<init>", "(Ljava/awt/Window;)V", "verifyServerKey", "", "clientSession", "Lorg/apache/sshd/client/session/ClientSession;", "remoteAddress", "Ljava/net/SocketAddress;", "serverKey", "Ljava/security/PublicKey;", "acceptModifiedServerKey", "entry", "Lorg/apache/sshd/client/config/hosts/KnownHostEntry;", "expected", "actual", "ask", "", "termora"})
    @SourceDebugExtension(value={"SMAP\nSshClients.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshClients.kt\napp/termora/plugin/internal/ssh/SshClients$MyDialogServerKeyVerifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,737:1\n1#2:738\n*E\n"})
    private static final class MyDialogServerKeyVerifier
    implements ServerKeyVerifier,
    ModifiedServerKeyAcceptor {
        @NotNull
        private final Window owner;

        public MyDialogServerKeyVerifier(@NotNull Window owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            this.owner = owner;
        }

        public boolean verifyServerKey(@NotNull ClientSession clientSession, @NotNull SocketAddress remoteAddress, @NotNull PublicKey serverKey) {
            Intrinsics.checkNotNullParameter((Object)clientSession, (String)"clientSession");
            Intrinsics.checkNotNullParameter((Object)remoteAddress, (String)"remoteAddress");
            Intrinsics.checkNotNullParameter((Object)serverKey, (String)"serverKey");
            return true;
        }

        public boolean acceptModifiedServerKey(@Nullable ClientSession clientSession, @Nullable SocketAddress remoteAddress, @Nullable KnownHostEntry entry, @Nullable PublicKey expected, @Nullable PublicKey actual) {
            AtomicBoolean result2 = new AtomicBoolean(false);
            SwingUtilities.invokeAndWait(() -> MyDialogServerKeyVerifier.acceptModifiedServerKey$lambda$0(result2, this, remoteAddress, expected, actual));
            return result2.get();
        }

        private final int ask(SocketAddress remoteAddress, PublicKey expected, PublicKey actual) {
            String formMargin = "7dlu";
            FormLayout layout = new FormLayout("default:grow", "pref, 12dlu, pref, 4dlu, pref, 2dlu, pref, " + formMargin + ", pref, " + formMargin + ", pref, pref, 12dlu, pref");
            Color errorColor = FlatLaf.isLafDark() ? UIManager.getColor("Component.warning.focusedBorderColor") : UIManager.getColor("Component.error.focusedBorderColor");
            Font font = FontUtils.getCompositeFont((String)"JetBrains Mono", (int)0, (int)12);
            Box artBox = Box.createHorizontalBox();
            artBox.add(Box.createHorizontalGlue());
            Box expectedBox = Box.createVerticalBox();
            String string = new KeyRandomArt(expected).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            for (Object line : StringsKt.lines((CharSequence)string)) {
                JLabel label = new JLabel((String)line);
                label.setFont(font);
                expectedBox.add(label);
            }
            artBox.add(expectedBox);
            artBox.add(Box.createHorizontalGlue());
            Box actualBox = Box.createVerticalBox();
            String string2 = new KeyRandomArt(actual).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            for (String line : StringsKt.lines((CharSequence)string2)) {
                JLabel label = new JLabel(line);
                label.setForeground(errorColor);
                label.setFont(font);
                actualBox.add(label);
            }
            artBox.add(actualBox);
            artBox.add(Box.createHorizontalGlue());
            int rows = 0;
            rows = 1;
            int step = 2;
            String address = StringsKt.replace$default((String)String.valueOf(remoteAddress), (String)"/", (String)"", (boolean)false, (int)4, null);
            Object object = new Object[]{address};
            FormBuilder $this$ask_u24lambda_u240 = object = FormBuilder.create().layout(layout).add("<html><b>" + I18n.INSTANCE.getString("termora.host.modified-server-key.title", (Object[])object) + "</b></html>", new Object[0]).xy(1, rows);
            boolean bl = false;
            FormBuilder $this$ask_u24lambda_u241 = object = object.add(I18n.INSTANCE.getString("termora.host.modified-server-key.thumbprint") + ":", new Object[0]).xy(1, rows += step);
            boolean bl2 = false;
            FormBuilder $this$ask_u24lambda_u242 = object = object.add("  " + I18n.INSTANCE.getString("termora.host.modified-server-key.expected") + ": " + KeyUtils.getFingerPrint((PublicKey)expected), new Object[0]).xy(1, rows += step);
            boolean bl3 = false;
            FormBuilder $this$ask_u24lambda_u243 = object = object.add("<html>&nbsp;&nbsp;" + I18n.INSTANCE.getString("termora.host.modified-server-key.actual") + ": <font color=rgb(" + errorColor.getRed() + "," + errorColor.getGreen() + "," + errorColor.getBlue() + ")>" + KeyUtils.getFingerPrint((PublicKey)actual) + "</font></html>", new Object[0]).xy(1, rows += step);
            boolean bl4 = false;
            FormBuilder $this$ask_u24lambda_u244 = object = object.addSeparator("", new Object[0]).xy(1, rows += step);
            boolean bl5 = false;
            FormBuilder $this$ask_u24lambda_u245 = object = object.add((Component)artBox).xy(1, rows += step);
            boolean bl6 = false;
            FormBuilder $this$ask_u24lambda_u246 = object = object.addSeparator("", new Object[0]).xy(1, rows += step);
            boolean bl7 = false;
            FormBuilder $this$ask_u24lambda_u247 = object = object.add(I18n.INSTANCE.getString("termora.host.modified-server-key.are-you-sure"), new Object[0]).xy(1, ++rows);
            boolean bl8 = false;
            rows += step;
            JPanel panel2 = object.build();
            object = OptionPane.INSTANCE;
            Window window = this.owner;
            Intrinsics.checkNotNull((Object)panel2);
            JPanel jPanel = panel2;
            return OptionPane.showConfirmDialog$default((OptionPane)object, window, jPanel, "SSH Security Warning", 2, 2, null, null, null, null, 480, null);
        }

        private static final void acceptModifiedServerKey$lambda$0(AtomicBoolean $result, MyDialogServerKeyVerifier this$0, SocketAddress $remoteAddress, PublicKey $expected, PublicKey $actual) {
            $result.set(this$0.ask($remoteAddress, $expected, $actual) == 0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0014J\b\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\bH\u0016R\u000e\u0010\u0004\u001a\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lapp/termora/plugin/internal/ssh/SshClients$MyJGitSshClient;", "Lorg/eclipse/jgit/internal/transport/sshd/JGitSshClient;", "<init>", "()V", "sshClient", "clientProxyConnectors", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lorg/apache/sshd/client/session/ClientProxyConnector;", "createConnector", "Lorg/apache/sshd/common/io/IoConnector;", "createSessionFactory", "Lorg/apache/sshd/client/session/SessionFactory;", "setClientProxyConnector", "", "proxyConnector", "Companion", "MyIoConnector", "termora"})
    @SourceDebugExtension(value={"SMAP\nSshClients.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshClients.kt\napp/termora/plugin/internal/ssh/SshClients$MyJGitSshClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,737:1\n1#2:738\n*E\n"})
    private static final class MyJGitSshClient
    extends JGitSshClient {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final MyJGitSshClient sshClient = this;
        @NotNull
        private final ConcurrentHashMap<String, ClientProxyConnector> clientProxyConnectors = new ConcurrentHashMap();
        @NotNull
        private static final Lazy<AttributeRepository.AttributeKey<HostConfigEntry>> HOST_CONFIG_ENTRY$delegate = LazyKt.lazy(MyJGitSshClient::HOST_CONFIG_ENTRY_delegate$lambda$0);
        @NotNull
        private static final String CLIENT_PROXY_CONNECTOR = "ClientProxyConnectorId";

        @NotNull
        protected IoConnector createConnector() {
            IoConnector ioConnector = super.createConnector();
            Intrinsics.checkNotNullExpressionValue((Object)ioConnector, (String)"createConnector(...)");
            return new MyIoConnector(this, ioConnector);
        }

        @NotNull
        protected SessionFactory createSessionFactory() {
            MyJGitSshClient myJGitSshClient = this.sshClient;
            return new SessionFactory(this, myJGitSshClient){
                final /* synthetic */ MyJGitSshClient this$0;
                {
                    this.this$0 = $receiver;
                    super((ClientFactoryManager)$super_call_param$1);
                }

                protected ClientSessionImpl doCreateSession(IoSession ioSession) {
                    Intrinsics.checkNotNullParameter((Object)ioSession, (String)"ioSession");
                    MyJGitSshClient myJGitSshClient = MyJGitSshClient.access$getSshClient$p(this.this$0);
                    return (ClientSessionImpl)new JGitClientSession(ioSession, this.this$0, myJGitSshClient){
                        final /* synthetic */ MyJGitSshClient this$0;
                        {
                            this.this$0 = $receiver;
                            super((ClientFactoryManager)$super_call_param$1, $ioSession);
                        }

                        public ClientProxyConnector getClientProxyConnector() {
                            HostConfigEntry hostConfigEntry = (HostConfigEntry)this.getAttribute(Companion.access$getHOST_CONFIG_ENTRY(MyJGitSshClient.Companion));
                            if (hostConfigEntry == null) {
                                return null;
                            }
                            HostConfigEntry entry = hostConfigEntry;
                            String string = entry.getProperty("ClientProxyConnectorId");
                            if (string == null) {
                                return null;
                            }
                            String clientProxyConnectorId = string;
                            ClientProxyConnector clientProxyConnector = (ClientProxyConnector)MyJGitSshClient.access$getClientProxyConnectors$p(MyJGitSshClient.access$getSshClient$p(this.this$0)).get(clientProxyConnectorId);
                            if (clientProxyConnector != null) {
                                this.addSessionListener(new SessionListener(this.this$0, clientProxyConnectorId){
                                    final /* synthetic */ MyJGitSshClient this$0;
                                    final /* synthetic */ String $clientProxyConnectorId;
                                    {
                                        this.this$0 = $receiver;
                                        this.$clientProxyConnectorId = $clientProxyConnectorId;
                                    }

                                    public void sessionClosed(Session session2) {
                                        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
                                        MyJGitSshClient.access$getClientProxyConnectors$p(this.this$0).remove(this.$clientProxyConnectorId);
                                    }
                                });
                            }
                            return clientProxyConnector;
                        }

                        public ChannelShell createShellChannel(PtyChannelConfigurationHolder ptyConfig, Map<String, ?> env) {
                            if (this.inCipher instanceof CipherNone || this.outCipher instanceof CipherNone) {
                                throw new IllegalStateException("Interactive channels are not supported with none cipher");
                            }
                            app.termora.x11.ChannelShell channel = new app.termora.x11.ChannelShell(ptyConfig, env);
                            long id = this.getConnectionService().registerChannel((Channel)channel);
                            if (this.log.isDebugEnabled()) {
                                Object[] objectArray = new Object[]{this, id, ptyConfig};
                                this.log.debug("createShellChannel({}) created id={} - PTY={}", objectArray);
                            }
                            return channel;
                        }
                    };
                }
            };
        }

        public void setClientProxyConnector(@Nullable ClientProxyConnector proxyConnector) {
            throw new UnsupportedOperationException();
        }

        private static final AttributeRepository.AttributeKey HOST_CONFIG_ENTRY_delegate$lambda$0() {
            Field field;
            Field $this$HOST_CONFIG_ENTRY_delegate_u24lambda_u240_u240 = field = JGitSshClient.class.getDeclaredField("HOST_CONFIG_ENTRY");
            boolean bl = false;
            $this$HOST_CONFIG_ENTRY_delegate_u24lambda_u240_u240.setAccessible(true);
            Object object = field.get(null);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type org.apache.sshd.common.AttributeRepository.AttributeKey<org.apache.sshd.client.config.hosts.HostConfigEntry>");
            return (AttributeRepository.AttributeKey)object;
        }

        public static final /* synthetic */ MyJGitSshClient access$getSshClient$p(MyJGitSshClient $this) {
            return $this.sshClient;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lapp/termora/plugin/internal/ssh/SshClients$MyJGitSshClient$Companion;", "", "<init>", "()V", "HOST_CONFIG_ENTRY", "Lorg/apache/sshd/common/AttributeRepository$AttributeKey;", "Lorg/apache/sshd/client/config/hosts/HostConfigEntry;", "getHOST_CONFIG_ENTRY", "()Lorg/apache/sshd/common/AttributeRepository$AttributeKey;", "HOST_CONFIG_ENTRY$delegate", "Lkotlin/Lazy;", "CLIENT_PROXY_CONNECTOR", "", "termora"})
        public static final class Companion {
            private Companion() {
            }

            private final AttributeRepository.AttributeKey<HostConfigEntry> getHOST_CONFIG_ENTRY() {
                Lazy lazy = HOST_CONFIG_ENTRY$delegate;
                return (AttributeRepository.AttributeKey)lazy.getValue();
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u000eH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0012\u0010\u0014\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0013H\u0016J\u0014\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0016J$\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cH\u0016J \u0010 \u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u001a\u0010%\u001a\u0004\u0018\u00010&2\u0006\u0010#\u001a\u00020$2\u0006\u0010'\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lapp/termora/plugin/internal/ssh/SshClients$MyJGitSshClient$MyIoConnector;", "Lorg/apache/sshd/common/io/IoConnector;", "sshClient", "Lapp/termora/plugin/internal/ssh/SshClients$MyJGitSshClient;", "ioConnector", "<init>", "(Lapp/termora/plugin/internal/ssh/SshClients$MyJGitSshClient;Lorg/apache/sshd/common/io/IoConnector;)V", "close", "Lorg/apache/sshd/common/future/CloseFuture;", "immediately", "", "addCloseFutureListener", "", "listener", "Lorg/apache/sshd/common/future/SshFutureListener;", "removeCloseFutureListener", "isClosed", "isClosing", "getIoServiceEventListener", "Lorg/apache/sshd/common/io/IoServiceEventListener;", "setIoServiceEventListener", "getManagedSessions", "", "", "Lorg/apache/sshd/common/io/IoSession;", "connect", "Lorg/apache/sshd/common/io/IoConnectFuture;", "targetAddress", "Ljava/net/SocketAddress;", "context", "Lorg/apache/sshd/common/AttributeRepository;", "localAddress", "configureProxy", "entry", "Lorg/apache/sshd/client/config/hosts/HostConfigEntry;", "host", "Lapp/termora/Host;", "getClientProxyConnector", "Lorg/eclipse/jgit/internal/transport/sshd/proxy/AbstractClientProxyConnector;", "remoteAddress", "Ljava/net/InetSocketAddress;", "termora"})
        @SourceDebugExtension(value={"SMAP\nSshClients.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SshClients.kt\napp/termora/plugin/internal/ssh/SshClients$MyJGitSshClient$MyIoConnector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,737:1\n1#2:738\n*E\n"})
        private static final class MyIoConnector
        implements IoConnector {
            @NotNull
            private final MyJGitSshClient sshClient;
            @NotNull
            private final IoConnector ioConnector;

            public MyIoConnector(@NotNull MyJGitSshClient sshClient, @NotNull IoConnector ioConnector) {
                Intrinsics.checkNotNullParameter((Object)((Object)sshClient), (String)"sshClient");
                Intrinsics.checkNotNullParameter((Object)ioConnector, (String)"ioConnector");
                this.sshClient = sshClient;
                this.ioConnector = ioConnector;
            }

            @NotNull
            public CloseFuture close(boolean immediately) {
                CloseFuture closeFuture = this.ioConnector.close(immediately);
                Intrinsics.checkNotNullExpressionValue((Object)closeFuture, (String)"close(...)");
                return closeFuture;
            }

            public void addCloseFutureListener(@Nullable SshFutureListener<CloseFuture> listener2) {
                this.ioConnector.addCloseFutureListener(listener2);
            }

            public void removeCloseFutureListener(@Nullable SshFutureListener<CloseFuture> listener2) {
                this.ioConnector.removeCloseFutureListener(listener2);
            }

            public boolean isClosed() {
                return this.ioConnector.isClosed();
            }

            public boolean isClosing() {
                return this.ioConnector.isClosing();
            }

            @NotNull
            public IoServiceEventListener getIoServiceEventListener() {
                IoServiceEventListener ioServiceEventListener = this.ioConnector.getIoServiceEventListener();
                Intrinsics.checkNotNullExpressionValue((Object)ioServiceEventListener, (String)"getIoServiceEventListener(...)");
                return ioServiceEventListener;
            }

            public void setIoServiceEventListener(@Nullable IoServiceEventListener listener2) {
                this.ioConnector.setIoServiceEventListener(listener2);
            }

            @NotNull
            public Map<Long, IoSession> getManagedSessions() {
                Map map = this.ioConnector.getManagedSessions();
                Intrinsics.checkNotNullExpressionValue((Object)map, (String)"getManagedSessions(...)");
                return map;
            }

            @NotNull
            public IoConnectFuture connect(@NotNull SocketAddress targetAddress, @Nullable AttributeRepository context, @Nullable SocketAddress localAddress) {
                HostConfigEntry entry;
                Intrinsics.checkNotNullParameter((Object)targetAddress, (String)"targetAddress");
                SocketAddress tAddress = targetAddress;
                AttributeRepository attributeRepository = context;
                HostConfigEntry hostConfigEntry = entry = attributeRepository != null ? (HostConfigEntry)attributeRepository.getAttribute(Companion.getHOST_CONFIG_ENTRY()) : null;
                if (entry != null) {
                    Host host;
                    HostManager hostManager = INSTANCE.getHostManager();
                    String string = entry.getProperty("Host");
                    if (string == null) {
                        string = "";
                    }
                    if ((host = hostManager.getHost(string)) != null) {
                        tAddress = this.configureProxy(entry, host, tAddress);
                    }
                }
                IoConnectFuture ioConnectFuture = this.ioConnector.connect(tAddress, context, localAddress);
                Intrinsics.checkNotNullExpressionValue((Object)ioConnectFuture, (String)"connect(...)");
                return ioConnectFuture;
            }

            private final SocketAddress configureProxy(HostConfigEntry entry, Host host, SocketAddress targetAddress) {
                if (host.getProxy().getType() == ProxyType.No) {
                    return targetAddress;
                }
                InetSocketAddress inetSocketAddress = targetAddress instanceof InetSocketAddress ? (InetSocketAddress)targetAddress : null;
                if (inetSocketAddress == null) {
                    return targetAddress;
                }
                InetSocketAddress address = inetSocketAddress;
                if (Intrinsics.areEqual((Object)address.getHostString(), (Object)"127.0.0.1")) {
                    return targetAddress;
                }
                AbstractClientProxyConnector abstractClientProxyConnector = this.getClientProxyConnector(host, address);
                if (abstractClientProxyConnector == null) {
                    return targetAddress;
                }
                AbstractClientProxyConnector clientProxyConnector = abstractClientProxyConnector;
                String id = CryptoKt.randomUUID();
                entry.setProperty(MyJGitSshClient.CLIENT_PROXY_CONNECTOR, id);
                ((Map)this.sshClient.clientProxyConnectors).put(id, clientProxyConnector);
                return new InetSocketAddress(host.getProxy().getHost(), host.getProxy().getPort());
            }

            private final AbstractClientProxyConnector getClientProxyConnector(Host host, InetSocketAddress remoteAddress) {
                if (host.getProxy().getType() == ProxyType.HTTP) {
                    char[] cArray;
                    CharSequence charSequence;
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(host.getProxy().getHost(), host.getProxy().getPort());
                    InetSocketAddress inetSocketAddress2 = remoteAddress;
                    CharSequence charSequence2 = host.getProxy().getUsername();
                    if (StringsKt.isBlank((CharSequence)charSequence2)) {
                        InetSocketAddress inetSocketAddress3 = inetSocketAddress2;
                        InetSocketAddress inetSocketAddress4 = inetSocketAddress;
                        boolean bl = false;
                        Object var7_11 = null;
                        inetSocketAddress = inetSocketAddress4;
                        inetSocketAddress2 = inetSocketAddress3;
                        charSequence = var7_11;
                    } else {
                        charSequence = charSequence2;
                    }
                    String string = (String)charSequence;
                    if (StringsKt.isBlank((CharSequence)host.getProxy().getPassword())) {
                        cArray = null;
                    } else {
                        char[] cArray2 = host.getProxy().getPassword().toCharArray();
                        cArray = cArray2;
                        Intrinsics.checkNotNullExpressionValue((Object)cArray2, (String)"toCharArray(...)");
                    }
                    char[] cArray3 = cArray;
                    String string2 = string;
                    InetSocketAddress inetSocketAddress5 = inetSocketAddress2;
                    InetSocketAddress inetSocketAddress6 = inetSocketAddress;
                    return (AbstractClientProxyConnector)new HttpClientConnector(inetSocketAddress6, inetSocketAddress5, string2, cArray3);
                }
                if (host.getProxy().getType() == ProxyType.SOCKS5) {
                    char[] cArray;
                    CharSequence charSequence;
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(host.getProxy().getHost(), host.getProxy().getPort());
                    InetSocketAddress inetSocketAddress7 = remoteAddress;
                    CharSequence charSequence3 = host.getProxy().getUsername();
                    if (StringsKt.isBlank((CharSequence)charSequence3)) {
                        InetSocketAddress inetSocketAddress8 = inetSocketAddress7;
                        InetSocketAddress inetSocketAddress9 = inetSocketAddress;
                        boolean bl = false;
                        Object var7_12 = null;
                        inetSocketAddress = inetSocketAddress9;
                        inetSocketAddress7 = inetSocketAddress8;
                        charSequence = var7_12;
                    } else {
                        charSequence = charSequence3;
                    }
                    String string = (String)charSequence;
                    if (StringsKt.isBlank((CharSequence)host.getProxy().getPassword())) {
                        cArray = null;
                    } else {
                        char[] cArray4 = host.getProxy().getPassword().toCharArray();
                        cArray = cArray4;
                        Intrinsics.checkNotNullExpressionValue((Object)cArray4, (String)"toCharArray(...)");
                    }
                    char[] cArray5 = cArray;
                    String string3 = string;
                    InetSocketAddress inetSocketAddress10 = inetSocketAddress7;
                    InetSocketAddress inetSocketAddress11 = inetSocketAddress;
                    return (AbstractClientProxyConnector)new Socks5ClientConnector(inetSocketAddress11, inetSocketAddress10, string3, cArray5);
                }
                return null;
            }
        }
    }
}

