/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.DynamicColor;
import app.termora.Icons;
import app.termora.terminal.DataKey;
import app.termora.terminal.DataListener;
import app.termora.terminal.FindHighlighter;
import app.termora.terminal.FindKind;
import app.termora.terminal.FindModel;
import app.termora.terminal.HighlighterRange;
import app.termora.terminal.MarkupModel;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.panel.TerminalFindPanel;
import app.termora.terminal.panel.TerminalPanel;
import com.formdev.flatlaf.extras.components.FlatTextField;
import com.formdev.flatlaf.extras.components.FlatToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Collection;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u0010\u0010\u001a\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\"H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR*\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lapp/termora/terminal/panel/TerminalFindPanel;", "Ljavax/swing/JPanel;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/Terminal;)V", "markupModel", "Lapp/termora/terminal/MarkupModel;", "getMarkupModel", "()Lapp/termora/terminal/MarkupModel;", "value", "", "Lapp/termora/terminal/FindKind;", "kinds", "getKinds", "()Ljava/util/List;", "textField", "Lcom/formdev/flatlaf/extras/components/FlatTextField;", "getTextField", "()Lcom/formdev/flatlaf/extras/components/FlatTextField;", "index", "", "prev", "Ljavax/swing/JButton;", "next", "label", "Ljavax/swing/JLabel;", "matchCase", "Ljavax/swing/JToggleButton;", "init", "", "search", "", "termora"})
public final class TerminalFindPanel
extends JPanel {
    @NotNull
    private final TerminalPanel terminalPanel;
    @NotNull
    private final Terminal terminal;
    @NotNull
    private List<? extends FindKind> kinds;
    @NotNull
    private final FlatTextField textField;
    private int index;
    @NotNull
    private final JButton prev;
    @NotNull
    private final JButton next;
    @NotNull
    private final JLabel label;
    @NotNull
    private final JToggleButton matchCase;

    public TerminalFindPanel(@NotNull TerminalPanel terminalPanel, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        super(new BorderLayout());
        this.terminalPanel = terminalPanel;
        this.terminal = terminal;
        this.kinds = CollectionsKt.emptyList();
        this.textField = new FlatTextField();
        this.index = -1;
        this.prev = new JButton((Icon)((Object)Icons.INSTANCE.getUp()));
        this.next = new JButton((Icon)((Object)Icons.INSTANCE.getDown()));
        this.label = new JLabel();
        this.matchCase = new JToggleButton((Icon)((Object)Icons.INSTANCE.getMatchCase()), false);
        this.init();
    }

    private final MarkupModel getMarkupModel() {
        return this.terminal.getMarkupModel();
    }

    @NotNull
    public final List<FindKind> getKinds() {
        return this.kinds;
    }

    @NotNull
    public final FlatTextField getTextField() {
        return this.textField;
    }

    /*
     * WARNING - void declaration
     */
    private final void init() {
        void $this$init_u24lambda_u243;
        JButton jButton;
        this.textField.setShowClearButton(true);
        this.textField.setFocusTraversalKeysEnabled(false);
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.setPadding(new Insets(0, 4, 0, 0));
        this.textField.setBackground((Color)new DynamicColor("window"));
        FlatToolBar box = new FlatToolBar();
        box.add((Component)this.label);
        box.add(Box.createHorizontalStrut(4));
        box.add((Component)this.matchCase);
        box.add(Box.createHorizontalStrut(2));
        this.textField.setTrailingComponent((JComponent)box);
        this.prev.addActionListener(arg_0 -> TerminalFindPanel.init$lambda$0(this, arg_0));
        this.next.addActionListener(arg_0 -> TerminalFindPanel.init$lambda$1(this, arg_0));
        this.label.setEnabled(false);
        this.matchCase.addActionListener(arg_0 -> TerminalFindPanel.init$lambda$2(this, arg_0));
        this.textField.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ TerminalFindPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void insertUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.changedUpdate(e);
            }

            public void removeUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.changedUpdate(e);
            }

            public void changedUpdate(DocumentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                TerminalFindPanel.access$search(this.this$0);
            }
        });
        FlatToolBar toolBar = new FlatToolBar();
        toolBar.add((Component)this.textField);
        toolBar.add((Component)this.prev);
        toolBar.add((Component)this.next);
        JButton jButton2 = jButton = new JButton((Icon)((Object)Icons.INSTANCE.getClose()));
        FlatToolBar flatToolBar = toolBar;
        boolean bl = false;
        $this$init_u24lambda_u243.addActionListener(arg_0 -> TerminalFindPanel.init$lambda$3$0(this, arg_0));
        flatToolBar.add((Component)jButton);
        this.add((Component)toolBar, "Center");
        this.textField.addKeyListener((KeyListener)new KeyAdapter(this){
            final /* synthetic */ TerminalFindPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (e.getKeyCode() == 27) {
                    TerminalFindPanel.access$getTerminalPanel$p(this.this$0).hideFind();
                } else if (e.getKeyCode() == 10) {
                    TerminalFindPanel.access$next(this.this$0, true);
                }
            }
        });
        this.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, DynamicColor.Companion.getBorderColor()));
        DataListener dataListener2 = new DataListener(this){
            final /* synthetic */ TerminalFindPanel this$0;
            {
                this.this$0 = $receiver;
            }

            public void onChanged(DataKey<?> key, Object data) {
                Intrinsics.checkNotNullParameter(key, (String)"key");
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                if (Intrinsics.areEqual(key, TerminalModel.Companion.getResize())) {
                    TerminalFindPanel.access$search(this.this$0);
                }
            }
        };
        this.addComponentListener(new ComponentAdapter(this, dataListener2){
            final /* synthetic */ TerminalFindPanel this$0;
            final /* synthetic */ init.dataListener.1 $dataListener;
            {
                this.this$0 = $receiver;
                this.$dataListener = $dataListener;
            }

            public void componentShown(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                SwingUtilities.invokeLater(() -> init.7.componentShown$lambda$0(this.this$0));
                TerminalFindPanel.access$getTerminal$p(this.this$0).getTerminalModel().addDataListener(this.$dataListener);
            }

            public void componentHidden(ComponentEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                this.this$0.getTextField().setText("");
                TerminalFindPanel.access$search(this.this$0);
                TerminalFindPanel.access$getTerminal$p(this.this$0).getTerminalModel().removeDataListener(this.$dataListener);
            }

            private static final void componentShown$lambda$0(TerminalFindPanel this$0) {
                this$0.getTextField().requestFocusInWindow();
            }
        });
    }

    private final void search() {
        this.textField.setOutline(null);
        this.label.setText("");
        this.index = -1;
        this.getMarkupModel().removeAllHighlighters(2);
        this.terminal.getSelectionModel().clearSelection();
        FindModel findModel = this.terminal.getFindModel();
        String string = this.textField.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        this.kinds = findModel.find(string, !this.matchCase.isSelected());
        for (FindKind findKind : this.kinds) {
            this.getMarkupModel().addHighlighter(new FindHighlighter(new HighlighterRange(findKind.getStartPosition(), findKind.getEndPosition()), this.terminal));
        }
        if (this.kinds.isEmpty()) {
            String string2 = this.textField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
            if (((CharSequence)string2).length() > 0) {
                this.textField.setOutline((Object)"error");
            }
        } else {
            this.label.setText("1/" + this.kinds.size());
        }
        this.next.setEnabled(!((Collection)this.kinds).isEmpty());
        this.prev.setEnabled(!((Collection)this.kinds).isEmpty());
        this.terminalPanel.repaintImmediate();
    }

    private final void next(boolean next) {
        if (this.kinds.isEmpty()) {
            return;
        }
        if (next) {
            if (this.index + 1 >= this.kinds.size()) {
                this.index = 0;
            } else {
                var2_2 = this.index;
                this.index = var2_2 + 1;
            }
        } else if (this.index - 1 <= 0) {
            this.index = this.kinds.size() - 1;
        } else {
            var2_2 = this.index;
            this.index = var2_2 + -1;
        }
        FindKind kind = this.kinds.get(this.index);
        this.terminal.getScrollingModel().scrollToRow(kind.getStartPosition().getY());
        this.terminal.getSelectionModel().setSelection(kind.getStartPosition(), kind.getEndPosition());
        this.label.setText(this.index + 1 + "/" + this.kinds.size());
    }

    private static final void init$lambda$0(TerminalFindPanel this$0, ActionEvent it) {
        this$0.next(false);
    }

    private static final void init$lambda$1(TerminalFindPanel this$0, ActionEvent it) {
        this$0.next(true);
    }

    private static final void init$lambda$2(TerminalFindPanel this$0, ActionEvent it) {
        this$0.search();
    }

    private static final void init$lambda$3$0(TerminalFindPanel this$0, ActionEvent it) {
        this$0.terminalPanel.hideFind();
    }

    public static final /* synthetic */ void access$search(TerminalFindPanel $this) {
        $this.search();
    }

    public static final /* synthetic */ TerminalPanel access$getTerminalPanel$p(TerminalFindPanel $this) {
        return $this.terminalPanel;
    }

    public static final /* synthetic */ void access$next(TerminalFindPanel $this, boolean next) {
        $this.next(next);
    }

    public static final /* synthetic */ Terminal access$getTerminal$p(TerminalFindPanel $this) {
        return $this.terminal;
    }
}

