/*
 * Decompiled with CFR 0.152.
 */
package app.termora.terminal.panel;

import app.termora.ScopeKt;
import app.termora.terminal.ColorPalette;
import app.termora.terminal.FindKind;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalColor;
import app.termora.terminal.panel.TerminalFindPanel;
import app.termora.terminal.panel.TerminalPanel;
import com.formdev.flatlaf.ui.FlatScrollBarUI;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ScrollBarUI;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.swing.SwingDispatcherKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002\u001f B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0016H\u0002J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006!"}, d2={"Lapp/termora/terminal/panel/TerminalScrollBar;", "Ljavax/swing/JScrollBar;", "terminalPanel", "Lapp/termora/terminal/panel/TerminalPanel;", "terminalFindPanel", "Lapp/termora/terminal/panel/TerminalFindPanel;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/panel/TerminalPanel;Lapp/termora/terminal/panel/TerminalFindPanel;Lapp/termora/terminal/Terminal;)V", "colorPalette", "Lapp/termora/terminal/ColorPalette;", "getColorPalette", "()Lapp/termora/terminal/ColorPalette;", "myUI", "Lapp/termora/terminal/panel/TerminalScrollBar$MyScrollBarUI;", "owner", "Ljava/awt/Window;", "kotlin.jvm.PlatformType", "getOwner", "()Ljava/awt/Window;", "setUI", "", "ui", "Ljavax/swing/plaf/ScrollBarUI;", "initEvents", "drawFindMap", "g", "Ljava/awt/Graphics;", "trackBounds", "Ljava/awt/Rectangle;", "MyScrollBarUI", "PreviewMouseAdapter", "termora"})
public final class TerminalScrollBar
extends JScrollBar {
    @NotNull
    private final TerminalPanel terminalPanel;
    @NotNull
    private final TerminalFindPanel terminalFindPanel;
    @NotNull
    private final Terminal terminal;
    @NotNull
    private final MyScrollBarUI myUI;

    public TerminalScrollBar(@NotNull TerminalPanel terminalPanel, @NotNull TerminalFindPanel terminalFindPanel, @NotNull Terminal terminal) {
        Intrinsics.checkNotNullParameter((Object)terminalPanel, (String)"terminalPanel");
        Intrinsics.checkNotNullParameter((Object)terminalFindPanel, (String)"terminalFindPanel");
        Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
        this.terminalPanel = terminalPanel;
        this.terminalFindPanel = terminalFindPanel;
        this.terminal = terminal;
        this.myUI = new MyScrollBarUI();
        this.setUI((ScrollBarUI)((Object)this.myUI));
        this.initEvents();
    }

    private final ColorPalette getColorPalette() {
        return this.terminal.getTerminalModel().getColorPalette();
    }

    private final Window getOwner() {
        return SwingUtilities.getWindowAncestor(this);
    }

    @Override
    public void setUI(@NotNull ScrollBarUI ui) {
        Intrinsics.checkNotNullParameter((Object)ui, (String)"ui");
        super.setUI((ScrollBarUI)((Object)this.myUI));
    }

    private final void initEvents() {
        PreviewMouseAdapter previewMouseAdapter = new PreviewMouseAdapter();
        this.addMouseMotionListener(previewMouseAdapter);
        this.addMouseListener(previewMouseAdapter);
    }

    private final void drawFindMap(Graphics g, Rectangle trackBounds) {
        if (!this.terminalPanel.getFindMap()) {
            return;
        }
        List<FindKind> kinds = this.terminalFindPanel.getKinds();
        if (kinds.isEmpty()) {
            return;
        }
        int averageCharWidth = this.terminalPanel.getAverageCharWidth() * 2;
        int count = Math.max(this.terminal.getDocument().getLineCount(), this.terminal.getTerminalModel().getRows());
        int lineHeight = Math.max((int)Math.ceil(1.0 * (double)trackBounds.height / (double)count), 1);
        LinkedHashSet<Integer> rows = new LinkedHashSet<Integer>();
        for (FindKind kind : kinds) {
            rows.add(kind.getStartPosition().getY());
            rows.add(kind.getEndPosition().getY());
        }
        g.setColor(new Color(this.getColorPalette().getColor(TerminalColor.Find.INSTANCE.getBACKGROUND())));
        Iterator iterator2 = rows.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
        Iterator<FindKind> iterator3 = iterator2;
        while (iterator3.hasNext()) {
            int row = ((Number)((Object)iterator3.next())).intValue();
            double n = (double)row * 1.0 / (double)count;
            int y = Math.max((int)Math.ceil((double)trackBounds.height * n) - lineHeight, 0);
            g.fillRect(trackBounds.width - averageCharWidth, y, averageCharWidth, lineHeight);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\b\u0010\f\u001a\u00020\u000bH\u0016\u00a8\u0006\r"}, d2={"Lapp/termora/terminal/panel/TerminalScrollBar$MyScrollBarUI;", "Lcom/formdev/flatlaf/ui/FlatScrollBarUI;", "<init>", "(Lapp/termora/terminal/panel/TerminalScrollBar;)V", "paintTrack", "", "g", "Ljava/awt/Graphics;", "c", "Ljavax/swing/JComponent;", "trackBounds", "Ljava/awt/Rectangle;", "getThumbBounds", "termora"})
    private final class MyScrollBarUI
    extends FlatScrollBarUI {
        protected void paintTrack(@NotNull Graphics g, @NotNull JComponent c, @NotNull Rectangle trackBounds) {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)trackBounds, (String)"trackBounds");
            super.paintTrack(g, c, trackBounds);
            TerminalScrollBar.this.drawFindMap(g, trackBounds);
        }

        @NotNull
        public Rectangle getThumbBounds() {
            Rectangle rectangle = super.getThumbBounds();
            Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getThumbBounds(...)");
            return rectangle;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lapp/termora/terminal/panel/TerminalScrollBar$PreviewMouseAdapter;", "Ljava/awt/event/MouseAdapter;", "<init>", "(Lapp/termora/terminal/panel/TerminalScrollBar;)V", "job", "Lkotlinx/coroutines/Job;", "mouseMoved", "", "e", "Ljava/awt/event/MouseEvent;", "doMouseMoved", "mouseExited", "termora"})
    private final class PreviewMouseAdapter
    extends MouseAdapter {
        @Nullable
        private Job job;

        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!TerminalScrollBar.this.terminal.getScrollingModel().canVerticalScroll()) {
                this.mouseExited(e);
                return;
            }
            if (TerminalScrollBar.this.myUI.getThumbBounds().contains(e.getPoint())) {
                this.mouseExited(e);
                return;
            }
            if (TerminalScrollBar.this.terminalPanel.isShowingPreview$termora()) {
                this.doMouseMoved(e);
            } else {
                Job job2 = this.job;
                if (job2 != null) {
                    Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
                }
                this.job = BuildersKt.launch$default((CoroutineScope)ScopeKt.getSwingCoroutineScope(), (CoroutineContext)((CoroutineContext)SwingDispatcherKt.getSwing((Dispatchers)Dispatchers.INSTANCE)), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, e, null){
                    int label;
                    final /* synthetic */ PreviewMouseAdapter this$0;
                    final /* synthetic */ MouseEvent $e;
                    {
                        this.this$0 = $receiver;
                        this.$e = $e;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object $result) {
                        var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                this.label = 1;
                                v0 = DelayKt.delay-VtjQ1oo((long)DurationKt.toDuration((int)250, (DurationUnit)DurationUnit.MILLISECONDS), (Continuation)((Continuation)this));
                                if (v0 == var2_2) {
                                    return var2_2;
                                }
                                ** GOTO lbl14
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl14:
                                // 2 sources

                                PreviewMouseAdapter.access$doMouseMoved(this.this$0, this.$e);
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
            }
        }

        private final void doMouseMoved(MouseEvent e) {
            if (!TerminalScrollBar.this.getOwner().isFocused()) {
                return;
            }
            TerminalPanel terminalPanel = TerminalScrollBar.this.terminalPanel;
            Point point = e.getLocationOnScreen();
            Intrinsics.checkNotNullExpressionValue((Object)point, (String)"getLocationOnScreen(...)");
            terminalPanel.showPreview$termora(point);
        }

        @Override
        public void mouseExited(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Job job2 = this.job;
            if (job2 != null) {
                Job.DefaultImpls.cancel$default((Job)job2, null, (int)1, null);
            }
            TerminalScrollBar.this.terminalPanel.hidePreview$termora();
        }

        public static final /* synthetic */ void access$doMouseMoved(PreviewMouseAdapter $this, MouseEvent e) {
            $this.doMouseMoved(e);
        }
    }
}

