/*
 * Decompiled with CFR 0.152.
 */
package app.termora.transfer;

import app.termora.ApplicationKt;
import app.termora.I18n;
import app.termora.transfer.ChangePermissionTransfer;
import app.termora.transfer.CommandTransfer;
import app.termora.transfer.DeleteTransfer;
import app.termora.transfer.Transfer;
import app.termora.transfer.TransferIndeterminate;
import app.termora.transfer.TransferTableModel;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001)B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010#\u001a\u00020!J\u000e\u0010$\u001a\u00020%2\u0006\u0010\u0010\u001a\u00020\u0011J\u0012\u0010&\u001a\u00020%2\n\u0010'\u001a\u00060\u0013j\u0002`\u0014J\u000e\u0010(\u001a\u00020!2\u0006\u0010\u0010\u001a\u00020\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n\u0018\u00010\u0013j\u0004\u0018\u0001`\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006*"}, d2={"Lapp/termora/transfer/TransferTreeTableNode;", "Lorg/jdesktop/swingx/treetable/DefaultMutableTreeTableNode;", "transfer", "Lapp/termora/transfer/Transfer;", "<init>", "(Lapp/termora/transfer/Transfer;)V", "filesize", "Ljava/util/concurrent/atomic/AtomicLong;", "getFilesize", "()Ljava/util/concurrent/atomic/AtomicLong;", "transferred", "getTransferred", "counter", "Lapp/termora/transfer/TransferTableModel$SlidingWindowByteCounter;", "getCounter", "()Lapp/termora/transfer/TransferTableModel$SlidingWindowByteCounter;", "state", "Lapp/termora/transfer/TransferTreeTableNode$State;", "exception", "Ljava/lang/Exception;", "Lkotlin/Exception;", "getColumnCount", "", "getTransfer", "()Lapp/termora/transfer/Transfer;", "getValueAt", "", "column", "formatPath", "", "path", "Ljava/nio/file/Path;", "target", "", "formatStatus", "waitingChildrenCompleted", "changeState", "", "setException", "e", "tryChangeState", "State", "termora"})
public final class TransferTreeTableNode
extends DefaultMutableTreeTableNode {
    @NotNull
    private final AtomicLong filesize;
    @NotNull
    private final AtomicLong transferred;
    @NotNull
    private final TransferTableModel.SlidingWindowByteCounter counter;
    @NotNull
    private State state;
    @Nullable
    private Exception exception;

    public TransferTreeTableNode(@NotNull Transfer transfer2) {
        Intrinsics.checkNotNullParameter((Object)transfer2, (String)"transfer");
        super((Object)transfer2);
        this.filesize = new AtomicLong(transfer2.size());
        this.transferred = new AtomicLong(0L);
        this.counter = new TransferTableModel.SlidingWindowByteCounter();
        this.state = State.Ready;
    }

    @NotNull
    public final AtomicLong getFilesize() {
        return this.filesize;
    }

    @NotNull
    public final AtomicLong getTransferred() {
        return this.transferred;
    }

    @NotNull
    public final TransferTableModel.SlidingWindowByteCounter getCounter() {
        return this.counter;
    }

    public int getColumnCount() {
        return 8;
    }

    @NotNull
    public final Transfer getTransfer() {
        Object object = this.getUserObject();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type app.termora.transfer.Transfer");
        return (Transfer)object;
    }

    @Nullable
    public Object getValueAt(int column) {
        long filesize = this.getTransfer().isDirectory() ? this.filesize.get() : this.getTransfer().size();
        long totalBytesTransferred = this.transferred.get();
        State state = this.waitingChildrenCompleted() ? State.Processing : this.state();
        boolean isProcessing = state == State.Processing || this.getTransfer() instanceof DeleteTransfer && this.getTransfer().isDirectory() && (this.state() == State.Processing || this.state() == State.Ready);
        long speed = this.counter.getLastSecondBytes();
        long estimatedTime = Math.max(isProcessing && speed > 0L ? (filesize - totalBytesTransferred) / speed : 0L, 0L);
        boolean indeterminate = this.getTransfer() instanceof TransferIndeterminate;
        String formatSize = ApplicationKt.formatBytes(totalBytesTransferred) + " / " + ApplicationKt.formatBytes(filesize);
        String formatEstimatedTime = indeterminate ? "-" : (isProcessing ? ApplicationKt.formatSeconds(estimatedTime) : "-");
        return switch (column) {
            case 0 -> PathsKt.getName((Path)this.getTransfer().source());
            case 1 -> this.formatStatus(state);
            case 4 -> this.formatPath(this.getTransfer().source(), false);
            case 5 -> this.formatPath(this.getTransfer().target(), true);
            case 3 -> {
                if (indeterminate) {
                    yield "-";
                }
                yield formatSize;
            }
            case 6 -> {
                if (indeterminate) {
                    yield "-";
                }
                if (isProcessing) {
                    yield ApplicationKt.formatBytes(speed) + "/s";
                }
                yield "-";
            }
            case 7 -> formatEstimatedTime;
            case 2 -> this;
            default -> "";
        };
    }

    private final String formatPath(Path path, boolean target) {
        if (target) {
            Transfer transfer2 = this.getTransfer();
            if (transfer2 instanceof DeleteTransfer) {
                return I18n.INSTANCE.getString("termora.transport.sftp.status.deleting");
            }
            if (transfer2 instanceof CommandTransfer) {
                Transfer transfer3 = this.getTransfer();
                Intrinsics.checkNotNull((Object)transfer3, (String)"null cannot be cast to non-null type app.termora.transfer.CommandTransfer");
                return ((CommandTransfer)transfer3).getCommand();
            }
            if (transfer2 instanceof ChangePermissionTransfer) {
                Transfer transfer4 = this.getTransfer();
                Intrinsics.checkNotNull((Object)transfer4, (String)"null cannot be cast to non-null type app.termora.transfer.ChangePermissionTransfer");
                Set<PosixFilePermission> permissions = ((ChangePermissionTransfer)transfer4).getPermissions();
                return I18n.INSTANCE.getString("termora.transport.table.permissions") + " -> " + PosixFilePermissions.toString(permissions);
            }
        }
        if (Intrinsics.areEqual((Object)path.getFileSystem(), (Object)FileSystems.getDefault())) {
            return ((Object)path.toAbsolutePath()).toString();
        }
        return ((Object)path.toAbsolutePath()).toString();
    }

    private final String formatStatus(State state) {
        Exception e;
        if ((this.getTransfer() instanceof DeleteTransfer || this.getTransfer() instanceof CommandTransfer) && state == State.Processing) {
            return I18n.INSTANCE.getString("termora.transport.sftp.status.deleting");
        }
        if (state == State.Failed && (e = this.exception) != null) {
            String message = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return I18n.INSTANCE.getString("termora.transport.sftp.status.failed") + ": " + message;
        }
        return switch (WhenMappings.$EnumSwitchMapping$0[state.ordinal()]) {
            case 1 -> I18n.INSTANCE.getString("termora.transport.sftp.status.transporting");
            case 2 -> I18n.INSTANCE.getString("termora.transport.sftp.status.waiting");
            case 3 -> I18n.INSTANCE.getString("termora.transport.sftp.status.done");
            case 4 -> I18n.INSTANCE.getString("termora.transport.sftp.status.failed");
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public final State state() {
        return this.state;
    }

    public final boolean waitingChildrenCompleted() {
        if (!this.getTransfer().isDirectory()) {
            return false;
        }
        if (this.state == State.Processing) {
            return true;
        }
        return this.state == State.Done && (this.getTransfer().scanning() || this.getChildCount() > 0);
    }

    public final void changeState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        if (this.state == State.Done || this.state == State.Failed) {
            throw new IllegalStateException();
        }
        if (this.state == State.Processing && state == State.Ready) {
            throw new IllegalStateException();
        }
        this.state = state;
    }

    public final void setException(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.exception = e;
    }

    public final boolean tryChangeState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        if (this.state == State.Done || this.state == State.Failed) {
            return false;
        }
        if (this.state == State.Processing && state == State.Ready) {
            return false;
        }
        this.state = state;
        return true;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/transfer/TransferTreeTableNode$State;", "", "<init>", "(Ljava/lang/String;I)V", "Ready", "Processing", "Failed", "Done", "termora"})
    public static final class State
    extends Enum<State> {
        public static final /* enum */ State Ready = new State();
        public static final /* enum */ State Processing = new State();
        public static final /* enum */ State Failed = new State();
        public static final /* enum */ State Done = new State();
        private static final /* synthetic */ State[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String value) {
            return Enum.valueOf(State.class, value);
        }

        @NotNull
        public static EnumEntries<State> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = stateArray = new State[]{State.Ready, State.Processing, State.Failed, State.Done};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[State.values().length];
            try {
                nArray[State.Processing.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Ready.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Done.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[State.Failed.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

