/*
 * Decompiled with CFR 0.152.
 */
package zmodem;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import zmodem.xfer.util.CRC16;
import zmodem.xfer.util.CRC8;
import zmodem.xfer.util.XCRC;
import zmodem.xfer.zm.util.Modem;

public class YModem {
    private Modem modem;

    public YModem(InputStream inputStream, OutputStream outputStream) {
        this.modem = new Modem(inputStream, outputStream);
    }

    public void send(Path file) throws IOException {
        try (DataInputStream dataStream = new DataInputStream(Files.newInputStream(file, new OpenOption[0]));){
            boolean useCRC16 = this.modem.waitReceiverRequest();
            XCRC crc = useCRC16 ? new CRC16() : new CRC8();
            BasicFileAttributes readAttributes = Files.readAttributes(file, BasicFileAttributes.class, new LinkOption[0]);
            String fileNameString = file.getFileName().toString() + "\u0000" + Long.valueOf(Files.size(file)).toString() + " " + Long.toOctalString(readAttributes.lastModifiedTime().toMillis() / 1000L);
            byte[] fileNameBytes = Arrays.copyOf(fileNameString.getBytes(), 128);
            this.modem.sendBlock(0, Arrays.copyOf(fileNameBytes, 128), 128, crc);
            this.modem.waitReceiverRequest();
            byte[] block = new byte[1024];
            this.modem.sendDataBlocks(dataStream, 1, crc, block);
            this.modem.sendEOT();
        }
    }

    public void batchSend(Path ... files) throws IOException {
        for (Path file : files) {
            this.send(file);
        }
        this.sendBatchStop();
    }

    private void sendBatchStop() throws IOException {
        boolean useCRC16 = this.modem.waitReceiverRequest();
        XCRC crc = useCRC16 ? new CRC16() : new CRC8();
        byte[] bytes = new byte[128];
        this.modem.sendBlock(0, bytes, bytes.length, crc);
    }

    public Path receiveSingleFileInDirectory(Path directory) throws IOException {
        return this.receive(directory, true);
    }

    public void receiveFilesInDirectory(Path directory) throws IOException {
        while (this.receive(directory, true) != null) {
        }
    }

    public Path receive(Path path) throws IOException {
        return this.receive(path, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Path receive(Path path, boolean inDirectory) throws IOException {
        try (FilterOutputStream dataOutput = null;){
            Path filePath;
            CRC16 crc = new CRC16();
            int errorCount = 0;
            while (true) {
                int character = this.modem.requestTransmissionStart(true);
                try {
                    byte[] block = this.modem.readBlock(0, character == 1, crc);
                    if (!inDirectory) {
                        filePath = path;
                    } else {
                        StringBuilder sb = new StringBuilder();
                        if (block[0] == 0) {
                            this.modem.sendByte((byte)6);
                            Path path2 = null;
                            return path2;
                        }
                        for (int i = 0; i < block.length && block[i] != 0; ++i) {
                            sb.append((char)block[i]);
                        }
                        filePath = path.resolve(sb.toString());
                    }
                    dataOutput = new DataOutputStream(Files.newOutputStream(filePath, new OpenOption[0]));
                    this.modem.sendByte((byte)6);
                }
                catch (Modem.InvalidBlockException e) {
                    if (++errorCount == 10) {
                        this.modem.interruptTransmission();
                        throw new IOException("Transmission aborted, error count exceeded max");
                    }
                    this.modem.sendByte((byte)21);
                    continue;
                }
                catch (Modem.RepeatedBlockException | Modem.SynchronizationLostException e) {
                    this.modem.interruptTransmission();
                    throw new IOException("Fatal transmission error", e);
                }
                break;
            }
            this.modem.receive(filePath, true);
            return filePath;
        }
    }
}

