/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.jdbc.transactions;

import kotlin.ExceptionsKt;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.DatabaseApi;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.api.ExposedSavepoint;
import org.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import org.jetbrains.exposed.v1.core.transactions.TransactionManagerApi;
import org.jetbrains.exposed.v1.jdbc.Database;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.statements.api.ExposedConnection;
import org.jetbrains.exposed.v1.jdbc.transactions.JdbcTransactionInterface;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 32\u00020\u0001:\u000234B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012 \b\u0002\u0010\u0004\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\b\u0010)\u001a\u00020*H\u0016J&\u0010+\u001a\u00020&2\b\b\u0002\u0010,\u001a\u00020\f2\b\b\u0002\u0010-\u001a\u00020\u001e2\n\b\u0002\u0010.\u001a\u0004\u0018\u00010&J\n\u0010/\u001a\u0004\u0018\u00010&H\u0016J\u0012\u00100\u001a\u00020\b2\b\u00101\u001a\u0004\u0018\u000102H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u00020\fX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u00020\f8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u00020\u001eX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(\u00a8\u00065"}, d2={"Lorg/jetbrains/exposed/v1/jdbc/transactions/TransactionManager;", "Lorg/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;", "db", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "setupTxConnection", "Lkotlin/Function2;", "Lorg/jetbrains/exposed/v1/jdbc/statements/api/ExposedConnection;", "Lorg/jetbrains/exposed/v1/jdbc/transactions/JdbcTransactionInterface;", "", "<init>", "(Lorg/jetbrains/exposed/v1/jdbc/Database;Lkotlin/jvm/functions/Function2;)V", "defaultMaxAttempts", "", "getDefaultMaxAttempts", "()I", "setDefaultMaxAttempts", "(I)V", "defaultMinRetryDelay", "", "getDefaultMinRetryDelay", "()J", "setDefaultMinRetryDelay", "(J)V", "defaultMaxRetryDelay", "getDefaultMaxRetryDelay", "setDefaultMaxRetryDelay", "defaultIsolationLevel", "getDefaultIsolationLevel", "setDefaultIsolationLevel", "loadDataSourceIsolationLevel", "", "defaultReadOnly", "getDefaultReadOnly", "()Z", "setDefaultReadOnly", "(Z)V", "threadLocal", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "getThreadLocal", "()Ljava/lang/ThreadLocal;", "toString", "", "newTransaction", "isolation", "readOnly", "outerTransaction", "currentOrNull", "bindTransactionToThread", "transaction", "Lorg/jetbrains/exposed/v1/core/Transaction;", "Companion", "ThreadLocalTransaction", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nTransactionManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TransactionManager.kt\norg/jetbrains/exposed/v1/jdbc/transactions/TransactionManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,510:1\n1#2:511\n*E\n"})
public final class TransactionManager
implements TransactionManagerApi {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Database db;
    @Nullable
    private final Function2<ExposedConnection<?>, JdbcTransactionInterface, Unit> setupTxConnection;
    private volatile int defaultMaxAttempts;
    private volatile long defaultMinRetryDelay;
    private volatile long defaultMaxRetryDelay;
    private volatile int defaultIsolationLevel;
    private boolean loadDataSourceIsolationLevel;
    private volatile boolean defaultReadOnly;
    @NotNull
    private final ThreadLocal<JdbcTransaction> threadLocal;

    public TransactionManager(@NotNull Database db, @Nullable Function2<? super ExposedConnection<?>, ? super JdbcTransactionInterface, Unit> setupTxConnection) {
        Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
        this.db = db;
        this.setupTxConnection = setupTxConnection;
        this.defaultMaxAttempts = this.db.getConfig().getDefaultMaxAttempts();
        this.defaultMinRetryDelay = this.db.getConfig().getDefaultMinRetryDelay();
        this.defaultMaxRetryDelay = this.db.getConfig().getDefaultMaxRetryDelay();
        this.defaultIsolationLevel = this.db.getConfig().getDefaultIsolationLevel();
        this.defaultReadOnly = this.db.getConfig().getDefaultReadOnly();
        this.threadLocal = new ThreadLocal();
    }

    public /* synthetic */ TransactionManager(Database database, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            function2 = null;
        }
        this(database, function2);
    }

    public int getDefaultMaxAttempts() {
        return this.defaultMaxAttempts;
    }

    public void setDefaultMaxAttempts(int n) {
        this.defaultMaxAttempts = n;
    }

    public long getDefaultMinRetryDelay() {
        return this.defaultMinRetryDelay;
    }

    public void setDefaultMinRetryDelay(long l) {
        this.defaultMinRetryDelay = l;
    }

    public long getDefaultMaxRetryDelay() {
        return this.defaultMaxRetryDelay;
    }

    public void setDefaultMaxRetryDelay(long l) {
        this.defaultMaxRetryDelay = l;
    }

    public final int getDefaultIsolationLevel() {
        if (this.defaultIsolationLevel == -1) {
            if (this.db.getConnectsViaDataSource$exposed_jdbc()) {
                this.loadDataSourceIsolationLevel = true;
            }
            this.defaultIsolationLevel = Database.Companion.getDefaultIsolationLevel(this.db);
        } else if (this.db.getConnectsViaDataSource$exposed_jdbc() && this.loadDataSourceIsolationLevel && this.db.getDataSourceIsolationLevel$exposed_jdbc() != -1) {
            this.loadDataSourceIsolationLevel = false;
            this.defaultIsolationLevel = this.db.getDataSourceIsolationLevel$exposed_jdbc();
        }
        return this.defaultIsolationLevel;
    }

    public final void setDefaultIsolationLevel(int n) {
        this.defaultIsolationLevel = n;
    }

    public boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(boolean bl) {
        this.defaultReadOnly = bl;
    }

    @NotNull
    public final ThreadLocal<JdbcTransaction> getThreadLocal() {
        return this.threadLocal;
    }

    @NotNull
    public String toString() {
        return "JdbcTransactionManager[" + this.hashCode() + "](db=" + (Object)((Object)this.db) + ')';
    }

    @NotNull
    public final JdbcTransaction newTransaction(int isolation, boolean readOnly, @Nullable JdbcTransaction outerTransaction) {
        JdbcTransaction transaction;
        JdbcTransaction jdbcTransaction;
        JdbcTransaction jdbcTransaction2;
        block3: {
            Object object;
            block2: {
                jdbcTransaction2 = outerTransaction;
                if (jdbcTransaction2 == null) break block2;
                JdbcTransaction it = object = jdbcTransaction2;
                boolean bl = false;
                jdbcTransaction2 = !this.db.getUseNestedTransactions() ? object : null;
                if (jdbcTransaction2 != null) break block3;
            }
            object = this.db;
            JdbcTransaction jdbcTransaction3 = outerTransaction;
            boolean it = jdbcTransaction3 != null ? jdbcTransaction3.getReadOnly() : readOnly;
            JdbcTransaction jdbcTransaction4 = outerTransaction;
            int n = jdbcTransaction4 != null ? jdbcTransaction4.getTransactionIsolation() : isolation;
            Function2<ExposedConnection<?>, JdbcTransactionInterface, Unit> function2 = this.setupTxConnection;
            ThreadLocal<JdbcTransaction> threadLocal = this.threadLocal;
            boolean bl = this.loadDataSourceIsolationLevel;
            JdbcTransaction jdbcTransaction5 = new JdbcTransaction(new ThreadLocalTransaction((Database)((Object)object), function2, n, it, threadLocal, outerTransaction, bl));
            jdbcTransaction2 = jdbcTransaction5;
        }
        JdbcTransaction $this$newTransaction_u24lambda_u241 = jdbcTransaction = (transaction = jdbcTransaction2);
        boolean bl = false;
        this.bindTransactionToThread($this$newTransaction_u24lambda_u241);
        return jdbcTransaction;
    }

    public static /* synthetic */ JdbcTransaction newTransaction$default(TransactionManager transactionManager, int n, boolean bl, JdbcTransaction jdbcTransaction, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = transactionManager.getDefaultIsolationLevel();
        }
        if ((n2 & 2) != 0) {
            bl = transactionManager.getDefaultReadOnly();
        }
        if ((n2 & 4) != 0) {
            jdbcTransaction = null;
        }
        return transactionManager.newTransaction(n, bl, jdbcTransaction);
    }

    @Nullable
    public JdbcTransaction currentOrNull() {
        return this.threadLocal.get();
    }

    public void bindTransactionToThread(@Nullable Transaction transaction) {
        if (transaction != null) {
            this.threadLocal.set((JdbcTransaction)transaction);
        } else {
            this.threadLocal.remove();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00122\b\u0010\r\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0015\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0012J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u0004\u0018\u00010\u0017J\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u001dR(\u0010\u0006\u001a\u0004\u0018\u00010\u00052\b\u0010\u0004\u001a\u0004\u0018\u00010\u00058F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0011\u0010\u000e\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/exposed/v1/jdbc/transactions/TransactionManager$Companion;", "", "<init>", "()V", "value", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "defaultDatabase", "getDefaultDatabase", "()Lorg/jetbrains/exposed/v1/jdbc/Database;", "setDefaultDatabase", "(Lorg/jetbrains/exposed/v1/jdbc/Database;)V", "registerManager", "", "database", "manager", "Lorg/jetbrains/exposed/v1/core/transactions/TransactionManagerApi;", "closeAndUnregister", "managerFor", "Lorg/jetbrains/exposed/v1/jdbc/transactions/TransactionManager;", "getManager", "()Lorg/jetbrains/exposed/v1/jdbc/transactions/TransactionManager;", "resetCurrent", "currentOrNew", "Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "isolation", "", "currentOrNull", "current", "isInitialized", "", "exposed-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final synchronized Database getDefaultDatabase() {
            DatabaseApi databaseApi = CoreTransactionManager.INSTANCE.getDefaultDatabaseOrFirst();
            return databaseApi instanceof Database ? (Database)databaseApi : null;
        }

        public final synchronized void setDefaultDatabase(@Nullable Database value) {
            CoreTransactionManager.INSTANCE.setDefaultDatabase((DatabaseApi)value);
        }

        public final synchronized void registerManager(@NotNull Database database, @NotNull TransactionManagerApi manager) {
            Intrinsics.checkNotNullParameter((Object)((Object)database), (String)"database");
            Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
            CoreTransactionManager.INSTANCE.registerDatabaseManager((DatabaseApi)database, manager);
        }

        public final synchronized void closeAndUnregister(@NotNull Database database) {
            Intrinsics.checkNotNullParameter((Object)((Object)database), (String)"database");
            CoreTransactionManager.INSTANCE.closeAndUnregisterDatabase((DatabaseApi)database);
        }

        @Nullable
        public final TransactionManager managerFor(@Nullable Database database) {
            TransactionManagerApi transactionManagerApi;
            return database != null ? ((transactionManagerApi = CoreTransactionManager.INSTANCE.getDatabaseManager((DatabaseApi)database)) instanceof TransactionManager ? (TransactionManager)transactionManagerApi : null) : this.getManager();
        }

        @NotNull
        public final TransactionManager getManager() {
            TransactionManagerApi transactionManagerApi = CoreTransactionManager.INSTANCE.getCurrentThreadManager();
            Intrinsics.checkNotNull((Object)transactionManagerApi, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.jdbc.transactions.TransactionManager");
            return (TransactionManager)transactionManagerApi;
        }

        public final void resetCurrent(@Nullable TransactionManager manager) {
            CoreTransactionManager.INSTANCE.resetCurrentThreadManager((TransactionManagerApi)manager);
        }

        @NotNull
        public final JdbcTransaction currentOrNew(int isolation) {
            JdbcTransaction jdbcTransaction = this.currentOrNull();
            if (jdbcTransaction == null) {
                jdbcTransaction = TransactionManager.newTransaction$default(this.getManager(), isolation, false, null, 6, null);
            }
            return jdbcTransaction;
        }

        @Nullable
        public final JdbcTransaction currentOrNull() {
            return this.getManager().currentOrNull();
        }

        @NotNull
        public final JdbcTransaction current() {
            JdbcTransaction jdbcTransaction = this.currentOrNull();
            if (jdbcTransaction == null) {
                throw new IllegalStateException("No transaction in context.".toString());
            }
            return jdbcTransaction;
        }

        public final boolean isInitialized() {
            return CoreTransactionManager.INSTANCE.getDefaultDatabaseOrFirst() != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u001e\u0010\u0004\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\b\u0010&\u001a\u00020\u0007H\u0016J\b\u0010'\u001a\u00020\u0007H\u0016J\b\u0010(\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0004\u001a\u001a\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0006\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u000f\u001a\u0004\u0018\u00010\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001d\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u001f0\u00060\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010 \u001a\u0006\u0012\u0002\b\u00030\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u0004\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010)\u001a\u00020*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,\u00a8\u0006-"}, d2={"Lorg/jetbrains/exposed/v1/jdbc/transactions/TransactionManager$ThreadLocalTransaction;", "Lorg/jetbrains/exposed/v1/jdbc/transactions/JdbcTransactionInterface;", "db", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "setupTxConnection", "Lkotlin/Function2;", "Lorg/jetbrains/exposed/v1/jdbc/statements/api/ExposedConnection;", "", "transactionIsolation", "", "readOnly", "", "threadLocal", "Ljava/lang/ThreadLocal;", "Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "outerTransaction", "loadDataSourceIsolationLevel", "<init>", "(Lorg/jetbrains/exposed/v1/jdbc/Database;Lkotlin/jvm/functions/Function2;IZLjava/lang/ThreadLocal;Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;Z)V", "getDb", "()Lorg/jetbrains/exposed/v1/jdbc/Database;", "getTransactionIsolation", "()I", "getReadOnly", "()Z", "getThreadLocal", "()Ljava/lang/ThreadLocal;", "getOuterTransaction", "()Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "connectionLazy", "Lkotlin/Lazy;", "", "connection", "getConnection", "()Lorg/jetbrains/exposed/v1/jdbc/statements/api/ExposedConnection;", "useSavePoints", "savepoint", "Lorg/jetbrains/exposed/v1/core/statements/api/ExposedSavepoint;", "commit", "rollback", "close", "savepointName", "", "getSavepointName", "()Ljava/lang/String;", "exposed-jdbc"})
    private static final class ThreadLocalTransaction
    implements JdbcTransactionInterface {
        @NotNull
        private final Database db;
        @Nullable
        private final Function2<ExposedConnection<?>, JdbcTransactionInterface, Unit> setupTxConnection;
        private final int transactionIsolation;
        private final boolean readOnly;
        @NotNull
        private final ThreadLocal<JdbcTransaction> threadLocal;
        @Nullable
        private final JdbcTransaction outerTransaction;
        private final boolean loadDataSourceIsolationLevel;
        @NotNull
        private final Lazy<ExposedConnection<? extends Object>> connectionLazy;
        private final boolean useSavePoints;
        @Nullable
        private ExposedSavepoint savepoint;

        public ThreadLocalTransaction(@NotNull Database db, @Nullable Function2<? super ExposedConnection<?>, ? super JdbcTransactionInterface, Unit> setupTxConnection, int transactionIsolation, boolean readOnly, @NotNull ThreadLocal<JdbcTransaction> threadLocal, @Nullable JdbcTransaction outerTransaction, boolean loadDataSourceIsolationLevel) {
            Intrinsics.checkNotNullParameter((Object)((Object)db), (String)"db");
            Intrinsics.checkNotNullParameter(threadLocal, (String)"threadLocal");
            this.db = db;
            this.setupTxConnection = setupTxConnection;
            this.transactionIsolation = transactionIsolation;
            this.readOnly = readOnly;
            this.threadLocal = threadLocal;
            this.outerTransaction = outerTransaction;
            this.loadDataSourceIsolationLevel = loadDataSourceIsolationLevel;
            this.connectionLazy = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> ThreadLocalTransaction.connectionLazy$lambda$2(this));
            this.useSavePoints = this.getOuterTransaction() != null && this.getDb().getUseNestedTransactions();
            this.savepoint = this.useSavePoints ? this.getConnection().setSavepoint(this.getSavepointName()) : null;
        }

        @Override
        @NotNull
        public Database getDb() {
            return this.db;
        }

        @Override
        public int getTransactionIsolation() {
            return this.transactionIsolation;
        }

        public boolean getReadOnly() {
            return this.readOnly;
        }

        @NotNull
        public final ThreadLocal<JdbcTransaction> getThreadLocal() {
            return this.threadLocal;
        }

        @Override
        @Nullable
        public JdbcTransaction getOuterTransaction() {
            return this.outerTransaction;
        }

        @Override
        @NotNull
        public ExposedConnection<?> getConnection() {
            return (ExposedConnection)this.connectionLazy.getValue();
        }

        @Override
        public void commit() {
            if (this.connectionLazy.isInitialized() && !this.useSavePoints) {
                this.getConnection().commit();
            }
        }

        @Override
        public void rollback() {
            if (this.connectionLazy.isInitialized() && !this.getConnection().isClosed()) {
                if (this.useSavePoints && this.savepoint != null) {
                    ExposedConnection<?> exposedConnection = this.getConnection();
                    ExposedSavepoint exposedSavepoint = this.savepoint;
                    Intrinsics.checkNotNull((Object)exposedSavepoint);
                    exposedConnection.rollback(exposedSavepoint);
                    this.savepoint = this.getConnection().setSavepoint(this.getSavepointName());
                } else {
                    this.getConnection().rollback();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            try {
                if (!this.useSavePoints) {
                    if (this.connectionLazy.isInitialized()) {
                        this.getConnection().close();
                    }
                } else {
                    ExposedSavepoint exposedSavepoint = this.savepoint;
                    if (exposedSavepoint != null) {
                        ExposedSavepoint it = exposedSavepoint;
                        boolean bl = false;
                        this.getConnection().releaseSavepoint(it);
                        this.savepoint = null;
                    }
                }
            }
            finally {
                this.threadLocal.set(this.getOuterTransaction());
            }
        }

        private final String getSavepointName() {
            int nestedLevel = 0;
            JdbcTransaction currenTransaction = this.getOuterTransaction();
            while (true) {
                JdbcTransaction jdbcTransaction = currenTransaction;
                if ((jdbcTransaction != null ? jdbcTransaction.getOuterTransaction() : null) == null) break;
                ++nestedLevel;
                currenTransaction = currenTransaction.getOuterTransaction();
            }
            return "Exposed_savepoint_" + nestedLevel;
        }

        private static final ExposedConnection connectionLazy$lambda$2(ThreadLocalTransaction this$0) {
            Object object = this$0.getOuterTransaction();
            if (object == null || (object = ((JdbcTransaction)object).getConnection()) == null) {
                Object object2 = this$0.getDb().getConnector().invoke();
                ExposedConnection $this$connectionLazy_u24lambda_u242_u24lambda_u241 = (ExposedConnection)object2;
                boolean bl = false;
                try {
                    Function2<ExposedConnection<?>, JdbcTransactionInterface, Unit> function2 = this$0.setupTxConnection;
                    if (function2 != null) {
                        function2.invoke((Object)$this$connectionLazy_u24lambda_u242_u24lambda_u241, (Object)this$0);
                    } else {
                        ExposedConnection $this$connectionLazy_u24lambda_u242_u24lambda_u241_u24lambda_u240 = $this$connectionLazy_u24lambda_u242_u24lambda_u241;
                        boolean bl2 = false;
                        if (this$0.getDb().getConnectsViaDataSource$exposed_jdbc() && this$0.loadDataSourceIsolationLevel && this$0.getDb().getDataSourceIsolationLevel$exposed_jdbc() == -1) {
                            this$0.getDb().setDataSourceIsolationLevel$exposed_jdbc($this$connectionLazy_u24lambda_u242_u24lambda_u241_u24lambda_u240.getTransactionIsolation());
                            this$0.getDb().setDataSourceReadOnly$exposed_jdbc($this$connectionLazy_u24lambda_u242_u24lambda_u241_u24lambda_u240.getReadOnly());
                        } else if (!this$0.getDb().getConnectsViaDataSource$exposed_jdbc() || this$0.getDb().getDataSourceIsolationLevel$exposed_jdbc() != this$0.getTransactionIsolation() || this$0.getDb().getDataSourceReadOnly$exposed_jdbc() != this$0.getReadOnly()) {
                            $this$connectionLazy_u24lambda_u242_u24lambda_u241_u24lambda_u240.setTransactionIsolation(this$0.getTransactionIsolation());
                            $this$connectionLazy_u24lambda_u242_u24lambda_u241_u24lambda_u240.setReadOnly(this$0.getReadOnly());
                        }
                        $this$connectionLazy_u24lambda_u242_u24lambda_u241_u24lambda_u240.setAutoCommit(false);
                    }
                }
                catch (Exception e) {
                    try {
                        $this$connectionLazy_u24lambda_u242_u24lambda_u241.close();
                    }
                    catch (Exception closeException) {
                        ExceptionsKt.addSuppressed((Throwable)e, (Throwable)closeException);
                    }
                    throw e;
                }
                object = (ExposedConnection)object2;
            }
            return object;
        }
    }
}

