/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.crypt;

import java.security.Key;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.crypt.Encryptor;
import org.springframework.security.crypto.encrypt.AesBytesEncryptor;
import org.springframework.security.crypto.keygen.BytesKeyGenerator;
import org.springframework.security.crypto.keygen.KeyGenerators;
import org.springframework.security.crypto.util.EncodingUtils;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0005H\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u0016\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016J\u000e\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u001c\u001a\u00020\u0016J\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0016R\u0018\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0018\u0010\u000e\u001a\n \f*\u0004\u0018\u00010\u000f0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/exposed/v1/crypt/Algorithms;", "", "<init>", "()V", "base64EncodedLength", "", "byteSize", "paddingLen", "len", "blockSize", "base64Decoder", "Ljava/util/Base64$Decoder;", "kotlin.jvm.PlatformType", "Ljava/util/Base64$Decoder;", "base64Encoder", "Ljava/util/Base64$Encoder;", "Ljava/util/Base64$Encoder;", "AES_256_GCM_BLOCK_LENGTH", "AES_256_GCM_TAG_LENGTH", "AES_256_PBE_GCM", "Lorg/jetbrains/exposed/v1/crypt/Encryptor;", "password", "", "salt", "AES_256_CBC_BLOCK_LENGTH", "AES_256_PBE_CBC", "BLOW_FISH_BLOCK_LENGTH", "BLOW_FISH", "key", "TRIPLE_DES_KEY_LENGTH", "TRIPLE_DES_BLOCK_LENGTH", "TRIPLE_DES", "secretKey", "exposed-crypt"})
public final class Algorithms {
    @NotNull
    public static final Algorithms INSTANCE = new Algorithms();
    private static final Base64.Decoder base64Decoder = Base64.getDecoder();
    private static final Base64.Encoder base64Encoder = Base64.getEncoder();
    private static final int AES_256_GCM_BLOCK_LENGTH = 16;
    private static final int AES_256_GCM_TAG_LENGTH = 16;
    private static final int AES_256_CBC_BLOCK_LENGTH = 16;
    private static final int BLOW_FISH_BLOCK_LENGTH = 8;
    private static final int TRIPLE_DES_KEY_LENGTH = 24;
    private static final int TRIPLE_DES_BLOCK_LENGTH = 8;

    private Algorithms() {
    }

    private final int base64EncodedLength(int byteSize) {
        return (int)Math.ceil((double)byteSize / (double)3) * 4;
    }

    private final int paddingLen(int len, int blockSize) {
        return len % blockSize == 0 ? 0 : blockSize - len % blockSize;
    }

    @NotNull
    public final Encryptor AES_256_PBE_GCM(@NotNull CharSequence password, @NotNull CharSequence salt) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        AesBytesEncryptor $this$AES_256_PBE_GCM_u24lambda_u243 = new AesBytesEncryptor(((Object)password).toString(), salt, KeyGenerators.secureRandom((int)16), AesBytesEncryptor.CipherAlgorithm.GCM);
        boolean bl = false;
        return new Encryptor((Function1<? super String, String>)((Function1)arg_0 -> Algorithms.AES_256_PBE_GCM$lambda$3$lambda$0($this$AES_256_PBE_GCM_u24lambda_u243, arg_0)), (Function1<? super String, String>)((Function1)arg_0 -> Algorithms.AES_256_PBE_GCM$lambda$3$lambda$1($this$AES_256_PBE_GCM_u24lambda_u243, arg_0)), (Function1<? super Integer, Integer>)((Function1)Algorithms::AES_256_PBE_GCM$lambda$3$lambda$2));
    }

    @NotNull
    public final Encryptor AES_256_PBE_CBC(@NotNull CharSequence password, @NotNull CharSequence salt) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        AesBytesEncryptor $this$AES_256_PBE_CBC_u24lambda_u247 = new AesBytesEncryptor(((Object)password).toString(), salt, KeyGenerators.secureRandom((int)16));
        boolean bl = false;
        return new Encryptor((Function1<? super String, String>)((Function1)arg_0 -> Algorithms.AES_256_PBE_CBC$lambda$7$lambda$4($this$AES_256_PBE_CBC_u24lambda_u247, arg_0)), (Function1<? super String, String>)((Function1)arg_0 -> Algorithms.AES_256_PBE_CBC$lambda$7$lambda$5($this$AES_256_PBE_CBC_u24lambda_u247, arg_0)), (Function1<? super Integer, Integer>)((Function1)Algorithms::AES_256_PBE_CBC$lambda$7$lambda$6));
    }

    @NotNull
    public final Encryptor BLOW_FISH(@NotNull CharSequence key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        String string = ((Object)key).toString();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        SecretKeySpec ks = new SecretKeySpec(byArray, "Blowfish");
        return new Encryptor((Function1<? super String, String>)((Function1)arg_0 -> Algorithms.BLOW_FISH$lambda$8(ks, arg_0)), (Function1<? super String, String>)((Function1)arg_0 -> Algorithms.BLOW_FISH$lambda$9(ks, arg_0)), (Function1<? super Integer, Integer>)((Function1)Algorithms::BLOW_FISH$lambda$10));
    }

    @NotNull
    public final Encryptor TRIPLE_DES(@NotNull CharSequence secretKey) {
        Intrinsics.checkNotNullParameter((Object)secretKey, (String)"secretKey");
        String string = ((Object)secretKey).toString();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        if (byArray.length != 24) {
            throw new IllegalArgumentException("secretKey must have 24 bytes");
        }
        String string2 = ((Object)secretKey).toString();
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
        SecretKeySpec ks = new SecretKeySpec(byArray2, "TripleDES");
        BytesKeyGenerator ivGenerator = KeyGenerators.secureRandom((int)8);
        return new Encryptor((Function1<? super String, String>)((Function1)arg_0 -> Algorithms.TRIPLE_DES$lambda$11(ivGenerator, ks, arg_0)), (Function1<? super String, String>)((Function1)arg_0 -> Algorithms.TRIPLE_DES$lambda$12(ks, arg_0)), (Function1<? super Integer, Integer>)((Function1)Algorithms::TRIPLE_DES$lambda$13));
    }

    private static final String AES_256_PBE_GCM$lambda$3$lambda$0(AesBytesEncryptor $this_run, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string2 = base64Encoder.encodeToString($this_run.encrypt(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    private static final String AES_256_PBE_GCM$lambda$3$lambda$1(AesBytesEncryptor $this_run, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        byte[] byArray = $this_run.decrypt(base64Decoder.decode(it));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decrypt(...)");
        byte[] byArray2 = byArray;
        return new String(byArray2, Charsets.UTF_8);
    }

    private static final int AES_256_PBE_GCM$lambda$3$lambda$2(int inputLen) {
        return INSTANCE.base64EncodedLength(16 + inputLen + 16);
    }

    private static final String AES_256_PBE_CBC$lambda$7$lambda$4(AesBytesEncryptor $this_run, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string = it;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String string2 = base64Encoder.encodeToString($this_run.encrypt(byArray));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    private static final String AES_256_PBE_CBC$lambda$7$lambda$5(AesBytesEncryptor $this_run, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        byte[] byArray = $this_run.decrypt(base64Decoder.decode(it));
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decrypt(...)");
        byte[] byArray2 = byArray;
        return new String(byArray2, Charsets.UTF_8);
    }

    private static final int AES_256_PBE_CBC$lambda$7$lambda$6(int inputLen) {
        int paddingSize = 16 - inputLen % 16;
        return INSTANCE.base64EncodedLength(16 + inputLen + paddingSize);
    }

    private static final String BLOW_FISH$lambda$8(SecretKeySpec $ks, String plainText) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Cipher cipher = Cipher.getInstance("Blowfish");
        cipher.init(1, $ks);
        String string = plainText;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] encryptedBytes = cipher.doFinal(byArray);
        String string2 = base64Encoder.encodeToString(encryptedBytes);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    private static final String BLOW_FISH$lambda$9(SecretKeySpec $ks, String encryptedText) {
        Intrinsics.checkNotNullParameter((Object)encryptedText, (String)"encryptedText");
        Cipher cipher = Cipher.getInstance("Blowfish");
        cipher.init(2, $ks);
        byte[] decryptedBytes = cipher.doFinal(base64Decoder.decode(encryptedText));
        Intrinsics.checkNotNull((Object)decryptedBytes);
        return new String(decryptedBytes, Charsets.UTF_8);
    }

    private static final int BLOW_FISH$lambda$10(int it) {
        return INSTANCE.base64EncodedLength(it + INSTANCE.paddingLen(it, 8));
    }

    private static final String TRIPLE_DES$lambda$11(BytesKeyGenerator $ivGenerator, SecretKeySpec $ks, String plainText) {
        Intrinsics.checkNotNullParameter((Object)plainText, (String)"plainText");
        Cipher cipher = Cipher.getInstance("TripleDES/CBC/PKCS5Padding");
        byte[] iv = $ivGenerator.generateKey();
        cipher.init(1, (Key)$ks, new IvParameterSpec(iv));
        String string = plainText;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] encryptedBytes = cipher.doFinal(byArray);
        byte[][] byArrayArray = new byte[][]{iv, encryptedBytes};
        String string2 = base64Encoder.encodeToString(EncodingUtils.concatenate((byte[][])byArrayArray));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"encodeToString(...)");
        return string2;
    }

    private static final String TRIPLE_DES$lambda$12(SecretKeySpec $ks, String encryptedText) {
        Intrinsics.checkNotNullParameter((Object)encryptedText, (String)"encryptedText");
        Cipher cipher = Cipher.getInstance("TripleDES/CBC/PKCS5Padding");
        String string = encryptedText;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        byte[] decodedBytes = base64Decoder.decode(byArray);
        byte[] iv = EncodingUtils.subArray((byte[])decodedBytes, (int)0, (int)8);
        cipher.init(2, (Key)$ks, new IvParameterSpec(iv));
        byte[] decryptedBytes = cipher.doFinal(EncodingUtils.subArray((byte[])decodedBytes, (int)8, (int)decodedBytes.length));
        Intrinsics.checkNotNull((Object)decryptedBytes);
        return new String(decryptedBytes, Charsets.UTF_8);
    }

    private static final int TRIPLE_DES$lambda$13(int it) {
        return INSTANCE.base64EncodedLength(8 + it + INSTANCE.paddingLen(it, 8));
    }
}

