/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core;

import java.nio.ByteBuffer;
import java.sql.Array;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnType;
import org.jetbrains.exposed.v1.core.DatabaseApi;
import org.jetbrains.exposed.v1.core.Version;
import org.jetbrains.exposed.v1.core.statements.api.RowApi;
import org.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import org.jetbrains.exposed.v1.core.vendors.DataTypeProvider;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.H2Dialect;
import org.jetbrains.exposed.v1.core.vendors.MariaDBDialect;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u0000 \u00112\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u0010\u0010\u000b\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0002H\u0016J\u001a\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/exposed/v1/core/UUIDColumnType;", "Lorg/jetbrains/exposed/v1/core/ColumnType;", "Ljava/util/UUID;", "<init>", "()V", "sqlType", "", "valueFromDB", "value", "", "notNullValueToDB", "nonNullValueToString", "readObject", "rs", "Lorg/jetbrains/exposed/v1/core/statements/api/RowApi;", "index", "", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nColumnType.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ColumnType.kt\norg/jetbrains/exposed/v1/core/UUIDColumnType\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1449:1\n1#2:1450\n*E\n"})
public final class UUIDColumnType
extends ColumnType<UUID> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Regex uuidRegexp = new Regex("[0-9A-F]{8}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{4}-[0-9A-F]{12}", RegexOption.IGNORE_CASE);

    public UUIDColumnType() {
        super(false, 1, null);
    }

    @Override
    @NotNull
    public String sqlType() {
        return DatabaseDialectKt.getCurrentDialect().getDataTypeProvider().uuidType();
    }

    @Override
    @NotNull
    public UUID valueFromDB(@NotNull Object value) {
        CharSequence charSequence;
        UUID uUID;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof UUID) {
            uUID = (UUID)value;
        } else if (value instanceof byte[]) {
            ByteBuffer b = ByteBuffer.wrap((byte[])value);
            boolean bl = false;
            uUID = new UUID(b.getLong(), b.getLong());
        } else if (value instanceof String && uuidRegexp.matches(charSequence = (CharSequence)value)) {
            UUID uUID2 = UUID.fromString((String)value);
            uUID = uUID2;
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(...)");
        } else if (value instanceof String) {
            charSequence = (String)value;
            byte[] byArray = ((String)charSequence).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            ByteBuffer b = ByteBuffer.wrap(byArray);
            boolean bl = false;
            uUID = new UUID(b.getLong(), b.getLong());
        } else if (value instanceof ByteBuffer) {
            ByteBuffer b = (ByteBuffer)value;
            boolean bl = false;
            uUID = new UUID(b.getLong(), b.getLong());
        } else {
            throw new IllegalStateException(("Unexpected value of type UUID: " + value + " of " + Reflection.getOrCreateKotlinClass(value.getClass()).getQualifiedName()).toString());
        }
        return uUID;
    }

    @Override
    @NotNull
    public Object notNullValueToDB(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        Object object = databaseDialect instanceof H2Dialect ? (H2Dialect)databaseDialect : null;
        if (object == null || (object = ((H2Dialect)object).getOriginalDataTypeProvider()) == null) {
            object = DatabaseDialectKt.getCurrentDialect().getDataTypeProvider();
        }
        return ((DataTypeProvider)object).uuidToDB(value);
    }

    @Override
    @NotNull
    public String nonNullValueToString(@NotNull UUID value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return "" + '\'' + value + '\'';
    }

    @Override
    @Nullable
    public Object readObject(@NotNull RowApi rs, int index) {
        Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
        DatabaseApi db = CoreTransactionManager.INSTANCE.currentTransaction().getDb();
        if (DatabaseDialectKt.getCurrentDialect() instanceof MariaDBDialect && !Version.covers$default(db.getVersion(), 10, 0, 0, 6, null)) {
            return rs.getObject(index, Array.class);
        }
        return super.readObject(rs, index);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/exposed/v1/core/UUIDColumnType$Companion;", "", "<init>", "()V", "uuidRegexp", "Lkotlin/text/Regex;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

