/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.statements;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.IColumnType;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.Statement;
import org.jetbrains.exposed.v1.core.statements.api.ResultApi;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B-\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0010\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0001\u00a2\u0006\u0004\b\t\u0010\nJ&\u0010\u0011\u001a \u0012\u001c\u0012\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00150\u00130\u00120\u0012H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001b\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\b\u001a\u0006\u0012\u0002\b\u00030\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/exposed/v1/core/statements/ReturningStatement;", "Lorg/jetbrains/exposed/v1/core/statements/Statement;", "Lorg/jetbrains/exposed/v1/core/statements/api/ResultApi;", "table", "Lorg/jetbrains/exposed/v1/core/Table;", "returningExpressions", "", "Lorg/jetbrains/exposed/v1/core/Expression;", "mainStatement", "<init>", "(Lorg/jetbrains/exposed/v1/core/Table;Ljava/util/List;Lorg/jetbrains/exposed/v1/core/statements/Statement;)V", "getTable", "()Lorg/jetbrains/exposed/v1/core/Table;", "getReturningExpressions", "()Ljava/util/List;", "getMainStatement", "()Lorg/jetbrains/exposed/v1/core/statements/Statement;", "arguments", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/v1/core/IColumnType;", "", "prepareSQL", "", "transaction", "Lorg/jetbrains/exposed/v1/core/Transaction;", "prepared", "", "exposed-core"})
public class ReturningStatement
extends Statement<ResultApi> {
    @NotNull
    private final Table table;
    @NotNull
    private final List<Expression<?>> returningExpressions;
    @NotNull
    private final Statement<?> mainStatement;

    public ReturningStatement(@NotNull Table table, @NotNull List<? extends Expression<?>> returningExpressions, @NotNull Statement<?> mainStatement) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(returningExpressions, (String)"returningExpressions");
        Intrinsics.checkNotNullParameter(mainStatement, (String)"mainStatement");
        super(mainStatement.getType(), CollectionsKt.listOf((Object)table));
        this.table = table;
        this.returningExpressions = returningExpressions;
        this.mainStatement = mainStatement;
    }

    @NotNull
    public final Table getTable() {
        return this.table;
    }

    @NotNull
    public final List<Expression<?>> getReturningExpressions() {
        return this.returningExpressions;
    }

    @NotNull
    public final Statement<?> getMainStatement() {
        return this.mainStatement;
    }

    @Override
    @NotNull
    public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
        return this.mainStatement.arguments();
    }

    @Override
    @NotNull
    public String prepareSQL(@NotNull Transaction transaction, boolean prepared) {
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String mainSql = this.mainStatement.prepareSQL(transaction, prepared);
        return transaction.getDb().getDialect().getFunctionProvider().returning(mainSql, this.returningExpressions, transaction);
    }
}

