/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.core.vendors;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.Alias;
import org.jetbrains.exposed.v1.core.Column;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.ExpressionKt;
import org.jetbrains.exposed.v1.core.IColumnType;
import org.jetbrains.exposed.v1.core.Join;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.QueryBuilder;
import org.jetbrains.exposed.v1.core.StringColumnType;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.transactions.CoreTransactionManager;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialect;
import org.jetbrains.exposed.v1.core.vendors.DatabaseDialectKt;
import org.jetbrains.exposed.v1.core.vendors.FunctionProvider;
import org.jetbrains.exposed.v1.core.vendors.MysqlDialect;
import org.jetbrains.exposed.v1.core.vendors.MysqlFunctionProvider;
import org.jetbrains.exposed.v1.exceptions.ExceptionsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\b\u0010\u0018\u0000 Y2\u00020\u0001:\u0004VWXYB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0016\u00a2\u0006\u0002\u0010\bJ6\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\u0005*\b\u0012\u0004\u0012\u0002H\f0\r2\u0006\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016J2\u0010\u0011\u001a\u00020\u0012\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\f0\r2\u0006\u0010\u0016\u001a\u00020\u0005H\u0016J@\u0010\u0017\u001a\u00020\u0012\"\n\b\u0000\u0010\f*\u0004\u0018\u00010\u00052\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\f0\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\r2\u0006\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JQ\u0010\u001a\u001a\u00020\u0012\"\u0004\b\u0000\u0010\f2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\f0\r2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001d\"\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u000b2\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010!J>\u0010\"\u001a\u00020\u00122\n\u0010#\u001a\u0006\u0012\u0002\b\u00030\r2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030\r2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00052\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016JK\u0010%\u001a\u00020\u00122\n\u0010\u001b\u001a\u0006\u0012\u0002\b\u00030\r2\u0012\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u001d\"\u00020\u00052\b\u0010&\u001a\u0004\u0018\u00010\u00052\n\u0010\u001f\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010'J:\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*2\u0010\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030-0,2\u0006\u0010\u001b\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u000bH\u0016J(\u00101\u001a\u00020\u00122\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\r2\n\u00102\u001a\u0006\u0012\u0002\b\u00030 2\u0006\u00103\u001a\u00020\u0014H\u0016J:\u00107\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*2\u0010\u0010+\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030-0,2\u0006\u0010\u0015\u001a\u00020\u00052\u0006\u0010.\u001a\u00020/H\u0016J9\u00109\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020*2\b\u0010:\u001a\u0004\u0018\u00010\u00052\b\u0010;\u001a\u0004\u0018\u00010\u00072\u0006\u0010.\u001a\u00020/H\u0016\u00a2\u0006\u0002\u0010<JW\u0010=\u001a\u00020\u00052\u0006\u0010>\u001a\u00020?2\u001e\u0010@\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030-\u0012\u0006\u0012\u0004\u0018\u00010B0A0,2\b\u0010;\u001a\u0004\u0018\u00010\u00072\u000e\u0010:\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010.\u001a\u00020/H\u0016\u00a2\u0006\u0002\u0010CJ\u0082\u0001\u0010D\u001a\u00020\u00052\u0006\u0010)\u001a\u00020*2\u001e\u0010E\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030-\u0012\u0006\u0012\u0004\u0018\u00010B0A0,2\u0006\u0010\u001b\u001a\u00020\u00052\u001e\u0010F\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030-\u0012\u0006\u0012\u0004\u0018\u00010B0A0,2\u0010\u0010G\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030-0,2\u000e\u0010:\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\u0006\u0010.\u001a\u00020/H\u0016JM\u00109\u001a\u00020\u00052\u0006\u00108\u001a\u00020\u000b2\u0006\u0010>\u001a\u00020?2\f\u0010H\u001a\b\u0012\u0004\u0012\u00020*0,2\u000e\u0010:\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n2\b\u0010;\u001a\u0004\u0018\u00010\u00072\u0006\u0010.\u001a\u00020/H\u0016\u00a2\u0006\u0002\u0010IJ\u0018\u0010J\u001a\u00020\u00122\u0006\u0010K\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010L\u001a\u00020\u000b2\u0006\u0010M\u001a\u00020NH\u0016J$\u0010O\u001a\u00020\u0012\"\u0004\b\u0000\u0010\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u0002H\f0\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J'\u0010P\u001a\u00020\u00052\b\u0010Q\u001a\u0004\u0018\u00010\u00072\u0006\u0010R\u001a\u00020S2\u0006\u0010T\u001a\u00020\u000bH\u0016\u00a2\u0006\u0002\u0010UR\u0014\u00104\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106\u00a8\u0006Z"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/MysqlFunctionProvider;", "Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider;", "<init>", "()V", "random", "", "seed", "", "(Ljava/lang/Integer;)Ljava/lang/String;", "match", "Lorg/jetbrains/exposed/v1/core/Op;", "", "T", "Lorg/jetbrains/exposed/v1/core/Expression;", "pattern", "mode", "Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider$MatchMode;", "locate", "", "queryBuilder", "Lorg/jetbrains/exposed/v1/core/QueryBuilder;", "expr", "substring", "regexp", "expr1", "caseSensitive", "jsonExtract", "expression", "path", "", "toScalar", "jsonType", "Lorg/jetbrains/exposed/v1/core/IColumnType;", "(Lorg/jetbrains/exposed/v1/core/Expression;[Ljava/lang/String;ZLorg/jetbrains/exposed/v1/core/IColumnType;Lorg/jetbrains/exposed/v1/core/QueryBuilder;)V", "jsonContains", "target", "candidate", "jsonExists", "optional", "(Lorg/jetbrains/exposed/v1/core/Expression;[Ljava/lang/String;Ljava/lang/String;Lorg/jetbrains/exposed/v1/core/IColumnType;Lorg/jetbrains/exposed/v1/core/QueryBuilder;)V", "replace", "table", "Lorg/jetbrains/exposed/v1/core/Table;", "columns", "", "Lorg/jetbrains/exposed/v1/core/Column;", "transaction", "Lorg/jetbrains/exposed/v1/core/Transaction;", "prepared", "cast", "type", "builder", "DEFAULT_VALUE_EXPRESSION", "getDEFAULT_VALUE_EXPRESSION", "()Ljava/lang/String;", "insert", "ignore", "delete", "where", "limit", "(ZLorg/jetbrains/exposed/v1/core/Table;Ljava/lang/String;Ljava/lang/Integer;Lorg/jetbrains/exposed/v1/core/Transaction;)Ljava/lang/String;", "update", "targets", "Lorg/jetbrains/exposed/v1/core/Join;", "columnsAndValues", "Lkotlin/Pair;", "", "(Lorg/jetbrains/exposed/v1/core/Join;Ljava/util/List;Ljava/lang/Integer;Lorg/jetbrains/exposed/v1/core/Op;Lorg/jetbrains/exposed/v1/core/Transaction;)Ljava/lang/String;", "upsert", "data", "onUpdate", "keyColumns", "targetTables", "(ZLorg/jetbrains/exposed/v1/core/Join;Ljava/util/List;Lorg/jetbrains/exposed/v1/core/Op;Ljava/lang/Integer;Lorg/jetbrains/exposed/v1/core/Transaction;)Ljava/lang/String;", "insertValue", "columnName", "isUpsertAliasSupported", "dialect", "Lorg/jetbrains/exposed/v1/core/vendors/DatabaseDialect;", "time", "queryLimitAndOffset", "size", "offset", "", "alreadyOrdered", "(Ljava/lang/Integer;JZ)Ljava/lang/String;", "MATCH", "MysqlMatchMode", "CharColumnType", "Companion", "exposed-core"})
@SourceDebugExtension(value={"SMAP\nMysqlDialect.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlDialect.kt\norg/jetbrains/exposed/v1/core/vendors/MysqlFunctionProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,421:1\n1#2:422\n*E\n"})
public class MysqlFunctionProvider
extends FunctionProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String DEFAULT_VALUE_EXPRESSION;
    @NotNull
    private static final MysqlFunctionProvider INSTANCE = new MysqlFunctionProvider();

    public MysqlFunctionProvider() {
        this.DEFAULT_VALUE_EXPRESSION = "() VALUES ()";
    }

    @Override
    @NotNull
    public String random(@Nullable Integer seed) {
        StringBuilder stringBuilder = new StringBuilder().append("RAND(");
        Integer n = seed;
        String string = n != null ? n.toString() : null;
        if (string == null) {
            string = "";
        }
        return stringBuilder.append(string).append(')').toString();
    }

    @Override
    @NotNull
    public <T extends String> Op<Boolean> match(@NotNull Expression<T> $this$match, @NotNull String pattern, @Nullable FunctionProvider.MatchMode mode) {
        Intrinsics.checkNotNullParameter($this$match, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        FunctionProvider.MatchMode matchMode = mode;
        if (matchMode == null) {
            matchMode = MysqlMatchMode.STRICT;
        }
        return new MATCH($this$match, pattern, matchMode);
    }

    @Override
    public <T extends String> void locate(@NotNull QueryBuilder queryBuilder, @NotNull Expression<T> expr, @NotNull String substring) {
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)substring, (String)"substring");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> MysqlFunctionProvider.locate$lambda$0(substring, expr, arg_0)));
    }

    @Override
    public <T extends String> void regexp(@NotNull Expression<T> expr1, @NotNull Expression<String> pattern, boolean caseSensitive, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr1, (String)"expr1");
        Intrinsics.checkNotNullParameter(pattern, (String)"pattern");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        DatabaseDialect databaseDialect = DatabaseDialectKt.getCurrentDialect();
        Intrinsics.checkNotNull((Object)databaseDialect, (String)"null cannot be cast to non-null type org.jetbrains.exposed.v1.core.vendors.MysqlDialect");
        if (((MysqlDialect)databaseDialect).isMysql8$exposed_core()) {
            super.regexp(expr1, pattern, caseSensitive, queryBuilder);
        } else {
            queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> MysqlFunctionProvider.regexp$lambda$1(expr1, pattern, arg_0)));
        }
    }

    @Override
    public <T> void jsonExtract(@NotNull Expression<T> expression, @NotNull String[] path, boolean toScalar, @NotNull IColumnType<?> jsonType, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(jsonType, (String)"jsonType");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> MysqlFunctionProvider.jsonExtract$lambda$3(toScalar, expression, path, arg_0)));
    }

    @Override
    public void jsonContains(@NotNull Expression<?> target, @NotNull Expression<?> candidate, @Nullable String path, @NotNull IColumnType<?> jsonType, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(candidate, (String)"candidate");
        Intrinsics.checkNotNullParameter(jsonType, (String)"jsonType");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> MysqlFunctionProvider.jsonContains$lambda$5(target, candidate, path, arg_0)));
    }

    @Override
    public void jsonExists(@NotNull Expression<?> expression, @NotNull String[] path, @Nullable String optional, @NotNull IColumnType<?> jsonType, @NotNull QueryBuilder queryBuilder) {
        String oneOrAll;
        String string;
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(jsonType, (String)"jsonType");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        String string2 = optional;
        if (string2 != null) {
            String string3 = string2.toLowerCase(Locale.ROOT);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toLowerCase(...)");
        } else {
            string = oneOrAll = null;
        }
        if (!Intrinsics.areEqual((Object)oneOrAll, (Object)"one") && !Intrinsics.areEqual((Object)oneOrAll, (Object)"all")) {
            ExceptionsKt.throwUnsupportedException(CoreTransactionManager.INSTANCE.currentTransaction(), "MySQL requires a single optional argument: 'one' or 'all'");
            throw new KotlinNothingValueException();
        }
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> MysqlFunctionProvider.jsonExists$lambda$7(expression, oneOrAll, path, arg_0)));
    }

    @Override
    @NotNull
    public String replace(@NotNull Table table, @NotNull List<? extends Column<?>> columns, @NotNull String expression, @NotNull Transaction transaction, boolean prepared) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String insertStatement = super.insert(false, table, columns, expression, transaction);
        return StringsKt.replace$default((String)insertStatement, (String)"INSERT", (String)"REPLACE", (boolean)false, (int)4, null);
    }

    @Override
    public void cast(@NotNull Expression<?> expr, @NotNull IColumnType<?> type, @NotNull QueryBuilder builder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        if (type instanceof StringColumnType) {
            super.cast(expr, CharColumnType.INSTANCE, builder);
        } else {
            super.cast(expr, type, builder);
        }
    }

    @Override
    @NotNull
    public String getDEFAULT_VALUE_EXPRESSION() {
        return this.DEFAULT_VALUE_EXPRESSION;
    }

    @Override
    @NotNull
    public String insert(boolean ignore, @NotNull Table table, @NotNull List<? extends Column<?>> columns, @NotNull String expr, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(columns, (String)"columns");
        Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String def = super.insert(false, table, columns, expr, transaction);
        return ignore ? StringsKt.replaceFirst$default((String)def, (String)"INSERT", (String)"INSERT IGNORE", (boolean)false, (int)4, null) : def;
    }

    @Override
    @NotNull
    public String delete(boolean ignore, @NotNull Table table, @Nullable String where, @Nullable Integer limit, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        String def = super.delete(false, table, where, limit, transaction);
        return ignore ? StringsKt.replaceFirst$default((String)def, (String)"DELETE", (String)"DELETE IGNORE", (boolean)false, (int)4, null) : def;
    }

    @Override
    @NotNull
    public String update(@NotNull Join targets, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> columnsAndValues, @Nullable Integer limit, @Nullable Op<Boolean> where, @NotNull Transaction transaction) {
        QueryBuilder $this$update_u24lambda_u2410;
        block1: {
            Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
            Intrinsics.checkNotNullParameter(columnsAndValues, (String)"columnsAndValues");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            if (limit != null) {
                ExceptionsKt.throwUnsupportedException(transaction, "MySQL doesn't support LIMIT in UPDATE with join clause.");
                throw new KotlinNothingValueException();
            }
            $this$update_u24lambda_u2410 = new QueryBuilder(true);
            boolean bl = false;
            $this$update_u24lambda_u2410.unaryPlus("UPDATE ");
            targets.describe(transaction, $this$update_u24lambda_u2410);
            $this$update_u24lambda_u2410.unaryPlus(" SET ");
            ExpressionKt.appendTo$default(columnsAndValues, $this$update_u24lambda_u2410, null, null, null, (arg_0, arg_1) -> MysqlFunctionProvider.update$lambda$10$lambda$8(transaction, arg_0, arg_1), 14, null);
            Op<Boolean> op = where;
            if (op == null) break block1;
            Op<Boolean> it = op;
            boolean bl2 = false;
            $this$update_u24lambda_u2410.unaryPlus(" WHERE ");
            $this$update_u24lambda_u2410.unaryPlus((Expression)it);
        }
        return $this$update_u24lambda_u2410.toString();
    }

    @Override
    @NotNull
    public String upsert(@NotNull Table table, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> data, @NotNull String expression, @NotNull List<? extends Pair<? extends Column<?>, ? extends Object>> onUpdate, @NotNull List<? extends Column<?>> keyColumns, @Nullable Op<Boolean> where, @NotNull Transaction transaction) {
        Intrinsics.checkNotNullParameter((Object)table, (String)"table");
        Intrinsics.checkNotNullParameter(data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter(onUpdate, (String)"onUpdate");
        Intrinsics.checkNotNullParameter(keyColumns, (String)"keyColumns");
        Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
        if (!((Collection)keyColumns).isEmpty()) {
            ExceptionsKt.throwUnsupportedException(transaction, "MySQL doesn't support specifying conflict keys in UPSERT clause");
            throw new KotlinNothingValueException();
        }
        if (where != null) {
            ExceptionsKt.throwUnsupportedException(transaction, "MySQL doesn't support WHERE in UPSERT clause");
            throw new KotlinNothingValueException();
        }
        QueryBuilder $this$upsert_u24lambda_u2412 = new QueryBuilder(true);
        boolean bl = false;
        $this$upsert_u24lambda_u2412.unaryPlus(this.insert(false, table, (List)CollectionsKt.unzip((Iterable)data).getFirst(), expression, transaction));
        if (this.isUpsertAliasSupported(transaction.getDb().getDialect())) {
            $this$upsert_u24lambda_u2412.unaryPlus(" AS NEW");
        }
        $this$upsert_u24lambda_u2412.unaryPlus(" ON DUPLICATE KEY UPDATE ");
        QueryBuilder.appendTo$default($this$upsert_u24lambda_u2412, onUpdate, null, null, null, (arg_0, arg_1) -> MysqlFunctionProvider.upsert$lambda$12$lambda$11(transaction, arg_0, arg_1), 7, null);
        return $this$upsert_u24lambda_u2412.toString();
    }

    @Override
    @NotNull
    public String delete(boolean ignore, @NotNull Join targets, @NotNull List<? extends Table> targetTables, @Nullable Op<Boolean> where, @Nullable Integer limit, @NotNull Transaction transaction) {
        QueryBuilder $this$delete_u24lambda_u2415;
        block2: {
            Intrinsics.checkNotNullParameter((Object)targets, (String)"targets");
            Intrinsics.checkNotNullParameter(targetTables, (String)"targetTables");
            Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
            if (limit != null) {
                ExceptionsKt.throwUnsupportedException(transaction, DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support LIMIT in DELETE from join relation");
                throw new KotlinNothingValueException();
            }
            $this$delete_u24lambda_u2415 = new QueryBuilder(true);
            boolean bl = false;
            $this$delete_u24lambda_u2415.unaryPlus("DELETE ");
            if (ignore) {
                $this$delete_u24lambda_u2415.unaryPlus("IGNORE ");
            }
            QueryBuilder.appendTo$default($this$delete_u24lambda_u2415, targetTables, null, null, null, (arg_0, arg_1) -> MysqlFunctionProvider.delete$lambda$15$lambda$13(transaction, arg_0, arg_1), 7, null);
            $this$delete_u24lambda_u2415.unaryPlus(" FROM ");
            targets.describe(transaction, $this$delete_u24lambda_u2415);
            Op<Boolean> op = where;
            if (op == null) break block2;
            Op<Boolean> it = op;
            boolean bl2 = false;
            $this$delete_u24lambda_u2415.unaryPlus(" WHERE ");
            $this$delete_u24lambda_u2415.unaryPlus((Expression)it);
        }
        return $this$delete_u24lambda_u2415.toString();
    }

    @Override
    public void insertValue(@NotNull String columnName, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> MysqlFunctionProvider.insertValue$lambda$16(this, columnName, arg_0)));
    }

    public boolean isUpsertAliasSupported(@NotNull DatabaseDialect dialect) {
        Intrinsics.checkNotNullParameter((Object)dialect, (String)"dialect");
        return dialect instanceof MysqlDialect ? ((MysqlDialect)dialect).getFullVersion$exposed_core().compareTo("8.0.19") >= 0 : false;
    }

    @Override
    public <T> void time(@NotNull Expression<T> expr, @NotNull QueryBuilder queryBuilder) {
        Intrinsics.checkNotNullParameter(expr, (String)"expr");
        Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
        queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> MysqlFunctionProvider.time$lambda$17(expr, arg_0)));
    }

    @Override
    @NotNull
    public String queryLimitAndOffset(@Nullable Integer size, long offset, boolean alreadyOrdered) {
        if (size == null && offset > 0L) {
            ExceptionsKt.throwUnsupportedException(CoreTransactionManager.INSTANCE.currentTransaction(), DatabaseDialectKt.getCurrentDialect().getName() + " doesn't support OFFSET clause without LIMIT");
            throw new KotlinNothingValueException();
        }
        return super.queryLimitAndOffset(size, offset, alreadyOrdered);
    }

    private static final Unit locate$lambda$0(String $substring, Expression $expr, QueryBuilder $this$queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        Object[] objectArray = new Object[]{"LOCATE('", $substring, "',", $expr, ")"};
        ExpressionKt.append($this$queryBuilder, objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit regexp$lambda$1(Expression $expr1, Expression $pattern, QueryBuilder $this$queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        Object[] objectArray = new Object[]{$expr1, " REGEXP ", $pattern};
        ExpressionKt.append($this$queryBuilder, objectArray);
        return Unit.INSTANCE;
    }

    private static final Unit jsonExtract$lambda$3(boolean $toScalar, Expression $expression, String[] $path, QueryBuilder $this$queryBuilder) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        if ($toScalar) {
            $this$queryBuilder.append("JSON_UNQUOTE(");
        }
        Object[] objectArray2 = new Object[]{"JSON_EXTRACT(", $expression, ", "};
        ExpressionKt.append($this$queryBuilder, objectArray2);
        QueryBuilder queryBuilder = $this$queryBuilder;
        objectArray2 = $path;
        if (objectArray2.length == 0) {
            QueryBuilder queryBuilder2 = queryBuilder;
            boolean bl = false;
            String[] stringArray = new String[]{""};
            objectArray = stringArray;
            queryBuilder = queryBuilder2;
        } else {
            objectArray = objectArray2;
        }
        QueryBuilder.appendTo$default(queryBuilder, objectArray, null, null, null, (Function2)jsonExtract.1.2.INSTANCE, 7, null);
        $this$queryBuilder.append(')' + ($toScalar ? ")" : ""));
        return Unit.INSTANCE;
    }

    private static final Unit jsonContains$lambda$5(Expression $target, Expression $candidate, String $path, QueryBuilder $this$queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        Object[] objectArray = new Object[]{"JSON_CONTAINS(", $target, ", ", $candidate};
        ExpressionKt.append($this$queryBuilder, objectArray);
        String string = $path;
        if (string != null) {
            String it = string;
            boolean bl = false;
            $this$queryBuilder.append(", '$" + it + '\'');
        }
        $this$queryBuilder.append(")");
        return Unit.INSTANCE;
    }

    private static final Unit jsonExists$lambda$7(Expression $expression, String $oneOrAll, String[] $path, QueryBuilder $this$queryBuilder) {
        Object[] objectArray;
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        Object[] objectArray2 = new Object[]{"JSON_CONTAINS_PATH(", $expression, ", "};
        ExpressionKt.append($this$queryBuilder, objectArray2);
        $this$queryBuilder.append('\'' + $oneOrAll + "', ");
        QueryBuilder queryBuilder = $this$queryBuilder;
        objectArray2 = $path;
        if (objectArray2.length == 0) {
            QueryBuilder queryBuilder2 = queryBuilder;
            boolean bl = false;
            String[] stringArray = new String[]{""};
            objectArray = stringArray;
            queryBuilder = queryBuilder2;
        } else {
            objectArray = objectArray2;
        }
        QueryBuilder.appendTo$default(queryBuilder, objectArray, null, null, null, (Function2)jsonExists.1.2.INSTANCE, 7, null);
        $this$queryBuilder.append(")");
        return Unit.INSTANCE;
    }

    private static final Unit update$lambda$10$lambda$8(Transaction $transaction, QueryBuilder $this$appendTo, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)$this$appendTo, (String)"$this$appendTo");
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        Column col = (Column)pair.component1();
        Object value = pair.component2();
        $this$appendTo.append($transaction.fullIdentity(col) + '=');
        $this$appendTo.registerArgument(col, value);
        return Unit.INSTANCE;
    }

    private static final Unit upsert$lambda$12$lambda$11(Transaction $transaction, QueryBuilder $this$appendTo, Pair pair) {
        Intrinsics.checkNotNullParameter((Object)$this$appendTo, (String)"$this$appendTo");
        Intrinsics.checkNotNullParameter((Object)pair, (String)"<destruct>");
        Column columnToUpdate = (Column)pair.component1();
        Object updateExpression = pair.component2();
        $this$appendTo.append($transaction.identity(columnToUpdate) + '=');
        $this$appendTo.registerArgument(columnToUpdate, updateExpression);
        return Unit.INSTANCE;
    }

    private static final Unit delete$lambda$15$lambda$13(Transaction $transaction, QueryBuilder $this$appendTo, Table target) {
        Intrinsics.checkNotNullParameter((Object)$this$appendTo, (String)"$this$appendTo");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof Alias) {
            $this$appendTo.unaryPlus(((Alias)target).getAlias());
        } else {
            target.describe($transaction, $this$appendTo);
        }
        return Unit.INSTANCE;
    }

    private static final Unit insertValue$lambda$16(MysqlFunctionProvider this$0, String $columnName, QueryBuilder $this$queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        QueryBuilder queryBuilder = this$0.isUpsertAliasSupported(DatabaseDialectKt.getCurrentDialect()) ? $this$queryBuilder.unaryPlus("NEW." + $columnName) : $this$queryBuilder.unaryPlus("VALUES(" + $columnName + ')');
        return Unit.INSTANCE;
    }

    private static final Unit time$lambda$17(Expression $expr, QueryBuilder $this$queryBuilder) {
        Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
        Object[] objectArray = new Object[]{"SUBSTRING_INDEX(", $expr, ", ' ', -1)"};
        ExpressionKt.append($this$queryBuilder, objectArray);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/MysqlFunctionProvider$CharColumnType;", "Lorg/jetbrains/exposed/v1/core/StringColumnType;", "<init>", "()V", "sqlType", "", "exposed-core"})
    private static final class CharColumnType
    extends StringColumnType {
        @NotNull
        public static final CharColumnType INSTANCE = new CharColumnType();

        private CharColumnType() {
            super(null, 1, null);
        }

        @Override
        @NotNull
        public String sqlType() {
            return "CHAR";
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/MysqlFunctionProvider$Companion;", "", "<init>", "()V", "INSTANCE", "Lorg/jetbrains/exposed/v1/core/vendors/MysqlFunctionProvider;", "getINSTANCE$exposed_core", "()Lorg/jetbrains/exposed/v1/core/vendors/MysqlFunctionProvider;", "exposed-core"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final MysqlFunctionProvider getINSTANCE$exposed_core() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u0015\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/MysqlFunctionProvider$MATCH;", "Lorg/jetbrains/exposed/v1/core/Op;", "", "expr", "Lorg/jetbrains/exposed/v1/core/Expression;", "pattern", "", "mode", "Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider$MatchMode;", "<init>", "(Lorg/jetbrains/exposed/v1/core/Expression;Ljava/lang/String;Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider$MatchMode;)V", "getExpr", "()Lorg/jetbrains/exposed/v1/core/Expression;", "getPattern", "()Ljava/lang/String;", "getMode", "()Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider$MatchMode;", "toQueryBuilder", "", "queryBuilder", "Lorg/jetbrains/exposed/v1/core/QueryBuilder;", "exposed-core"})
    private static final class MATCH
    extends Op<Boolean> {
        @NotNull
        private final Expression<?> expr;
        @NotNull
        private final String pattern;
        @NotNull
        private final FunctionProvider.MatchMode mode;

        public MATCH(@NotNull Expression<?> expr, @NotNull String pattern, @NotNull FunctionProvider.MatchMode mode) {
            Intrinsics.checkNotNullParameter(expr, (String)"expr");
            Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
            Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
            this.expr = expr;
            this.pattern = pattern;
            this.mode = mode;
        }

        @NotNull
        public final Expression<?> getExpr() {
            return this.expr;
        }

        @NotNull
        public final String getPattern() {
            return this.pattern;
        }

        @NotNull
        public final FunctionProvider.MatchMode getMode() {
            return this.mode;
        }

        @Override
        public void toQueryBuilder(@NotNull QueryBuilder queryBuilder) {
            Intrinsics.checkNotNullParameter((Object)queryBuilder, (String)"queryBuilder");
            queryBuilder.invoke((Function1<? super QueryBuilder, Unit>)((Function1)arg_0 -> MATCH.toQueryBuilder$lambda$0(this, arg_0)));
        }

        private static final Unit toQueryBuilder$lambda$0(MATCH this$0, QueryBuilder $this$queryBuilder) {
            Intrinsics.checkNotNullParameter((Object)$this$queryBuilder, (String)"$this$queryBuilder");
            Object[] objectArray = new Object[]{"MATCH(", this$0.expr, ") AGAINST ('", this$0.pattern, "' ", this$0.mode.mode(), ")"};
            ExpressionKt.append($this$queryBuilder, objectArray);
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0081\u0002\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000b\u001a\u00020\u0004H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/exposed/v1/core/vendors/MysqlFunctionProvider$MysqlMatchMode;", "Lorg/jetbrains/exposed/v1/core/vendors/FunctionProvider$MatchMode;", "", "operator", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getOperator", "()Ljava/lang/String;", "STRICT", "NATURAL_LANGUAGE", "mode", "exposed-core"})
    private static final class MysqlMatchMode
    extends Enum<MysqlMatchMode>
    implements FunctionProvider.MatchMode {
        @NotNull
        private final String operator;
        public static final /* enum */ MysqlMatchMode STRICT = new MysqlMatchMode("IN BOOLEAN MODE");
        public static final /* enum */ MysqlMatchMode NATURAL_LANGUAGE = new MysqlMatchMode("IN NATURAL LANGUAGE MODE");
        private static final /* synthetic */ MysqlMatchMode[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private MysqlMatchMode(String operator) {
            this.operator = operator;
        }

        @NotNull
        public final String getOperator() {
            return this.operator;
        }

        @Override
        @NotNull
        public String mode() {
            return this.operator;
        }

        public static MysqlMatchMode[] values() {
            return (MysqlMatchMode[])$VALUES.clone();
        }

        public static MysqlMatchMode valueOf(String value) {
            return Enum.valueOf(MysqlMatchMode.class, value);
        }

        @NotNull
        public static EnumEntries<MysqlMatchMode> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = mysqlMatchModeArray = new MysqlMatchMode[]{MysqlMatchMode.STRICT, MysqlMatchMode.NATURAL_LANGUAGE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

