/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.exposed.v1.jdbc;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.CompositeSqlLogger;
import org.jetbrains.exposed.v1.core.IColumnType;
import org.jetbrains.exposed.v1.core.SQLLogKt;
import org.jetbrains.exposed.v1.core.SqlLogger;
import org.jetbrains.exposed.v1.core.Transaction;
import org.jetbrains.exposed.v1.core.statements.GlobalStatementInterceptor;
import org.jetbrains.exposed.v1.core.statements.Statement;
import org.jetbrains.exposed.v1.core.statements.StatementContext;
import org.jetbrains.exposed.v1.core.statements.StatementInterceptor;
import org.jetbrains.exposed.v1.core.statements.StatementResult;
import org.jetbrains.exposed.v1.core.statements.StatementType;
import org.jetbrains.exposed.v1.core.statements.api.ResultApi;
import org.jetbrains.exposed.v1.exceptions.LongQueryException;
import org.jetbrains.exposed.v1.jdbc.Database;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.statements.BlockingExecutable;
import org.jetbrains.exposed.v1.jdbc.statements.BlockingExecutableKt;
import org.jetbrains.exposed.v1.jdbc.statements.api.ExposedConnection;
import org.jetbrains.exposed.v1.jdbc.statements.api.JdbcPreparedStatementApi;
import org.jetbrains.exposed.v1.jdbc.statements.jdbc.JdbcResult;
import org.jetbrains.exposed.v1.jdbc.transactions.JdbcTransactionInterface;
import org.jetbrains.exposed.v1.jdbc.transactions.JdbcTransactionInterfaceKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ca\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0016\u0018\u0000 t2\u00020\u00012\u00020\u0002:\u0001tB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u00109\u001a\u00020:H\u0016J\b\u0010;\u001a\u00020:H\u0016J\u000e\u0010<\u001a\u00020'2\u0006\u0010=\u001a\u000205J\u000e\u0010>\u001a\u00020'2\u0006\u0010=\u001a\u000205J\u0018\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u00122\u0006\u0010B\u001a\u00020@H\u0002JE\u0010C\u001a\u0004\u0018\u00010:2\b\b\u0001\u0010B\u001a\u00020@2 \b\u0002\u0010D\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030G\u0012\u0006\u0012\u0004\u0018\u00010H0F0E2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010J\u00a2\u0006\u0002\u0010KJe\u0010C\u001a\u0004\u0018\u0001HL\"\b\b\u0000\u0010L*\u00020H2\b\b\u0001\u0010B\u001a\u00020@2 \b\u0002\u0010D\u001a\u001a\u0012\u0016\u0012\u0014\u0012\b\u0012\u0006\u0012\u0002\b\u00030G\u0012\u0006\u0012\u0004\u0018\u00010H0F0E2\n\b\u0002\u0010I\u001a\u0004\u0018\u00010J2\u0014\u0010M\u001a\u0010\u0012\u0004\u0012\u00020O\u0012\u0006\u0012\u0004\u0018\u0001HL0N\u00a2\u0006\u0002\u0010PJ%\u0010C\u001a\u0004\u0018\u0001HL\"\u0004\b\u0000\u0010L2\u0010\u0010B\u001a\f\u0012\u0004\u0012\u0002HL\u0012\u0002\b\u00030Q\u00a2\u0006\u0002\u0010RJ\u0014\u0010S\u001a\u00020:2\f\u0010T\u001a\b\u0012\u0004\u0012\u00020@0UJP\u0010C\u001a\u0004\u0018\u0001HV\"\u0004\b\u0000\u0010L\"\u0004\b\u0001\u0010V2\u0010\u0010B\u001a\f\u0012\u0004\u0012\u0002HL\u0012\u0002\b\u00030Q2#\u0010W\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u0002HL0!\u0012\u0004\u0012\u0002HL\u0012\u0004\u0012\u0002HV0X\u00a2\u0006\u0002\bY\u00a2\u0006\u0002\u0010ZJJ\u0010[\u001a\u0004\u0018\u0001HV\"\u0004\b\u0000\u0010V2\u0010\u0010\\\u001a\f\u0012\u0004\u0012\u00020]\u0012\u0002\b\u00030Q2#\u0010W\u001a\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u00020]0!\u0012\u0004\u0012\u00020O\u0012\u0004\u0012\u0002HV0X\u00a2\u0006\u0002\bY\u00a2\u0006\u0002\u0010ZJ\u001f\u0010[\u001a\u00020O2\u0010\u0010\\\u001a\f\u0012\u0004\u0012\u00020]\u0012\u0002\b\u00030QH\u0000\u00a2\u0006\u0002\b^J\u0006\u0010_\u001a\u00020:J\u001f\u0010`\u001a\u00020a2\u0012\u0010b\u001a\n\u0012\u0006\b\u0001\u0012\u00020d0c\"\u00020d\u00a2\u0006\u0002\u0010eJ\r\u0010f\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\bgJ\t\u0010h\u001a\u00020:H\u0096\u0001R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR$\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u000b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR \u0010 \u001a\b\u0012\u0002\b\u0003\u0018\u00010!X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020'X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010)\"\u0004\b*\u0010+R\u001a\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001b0-X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u0010\u000e\"\u0004\b2\u0010\u0010R$\u00103\u001a\u0012\u0012\u0004\u0012\u00020504j\b\u0012\u0004\u0012\u000205`6X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u0016\u0010i\u001a\u0006\u0012\u0002\b\u00030jX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bk\u0010lR\u0014\u0010m\u001a\u0004\u0018\u00010\u0000X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bn\u0010oR\u0012\u0010p\u001a\u00020'X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bq\u0010)R\u0012\u0010r\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\bs\u0010\u000e\u00a8\u0006u"}, d2={"Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "Lorg/jetbrains/exposed/v1/core/Transaction;", "Lorg/jetbrains/exposed/v1/jdbc/transactions/JdbcTransactionInterface;", "transactionImpl", "<init>", "(Lorg/jetbrains/exposed/v1/jdbc/transactions/JdbcTransactionInterface;)V", "db", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "getDb", "()Lorg/jetbrains/exposed/v1/jdbc/Database;", "value", "", "maxAttempts", "getMaxAttempts", "()I", "setMaxAttempts", "(I)V", "minRetryDelay", "", "getMinRetryDelay", "()J", "setMinRetryDelay", "(J)V", "maxRetryDelay", "getMaxRetryDelay", "setMaxRetryDelay", "currentStatement", "Lorg/jetbrains/exposed/v1/jdbc/statements/api/JdbcPreparedStatementApi;", "getCurrentStatement", "()Lorg/jetbrains/exposed/v1/jdbc/statements/api/JdbcPreparedStatementApi;", "setCurrentStatement", "(Lorg/jetbrains/exposed/v1/jdbc/statements/api/JdbcPreparedStatementApi;)V", "explainStatement", "Lorg/jetbrains/exposed/v1/core/statements/Statement;", "getExplainStatement$exposed_jdbc", "()Lorg/jetbrains/exposed/v1/core/statements/Statement;", "setExplainStatement$exposed_jdbc", "(Lorg/jetbrains/exposed/v1/core/statements/Statement;)V", "blockStatementExecution", "", "getBlockStatementExecution$exposed_jdbc", "()Z", "setBlockStatementExecution$exposed_jdbc", "(Z)V", "executedStatements", "", "getExecutedStatements$exposed_jdbc", "()Ljava/util/List;", "openResultSetsCount", "getOpenResultSetsCount$exposed_jdbc", "setOpenResultSetsCount$exposed_jdbc", "interceptors", "Ljava/util/ArrayList;", "Lorg/jetbrains/exposed/v1/core/statements/StatementInterceptor;", "Lkotlin/collections/ArrayList;", "getInterceptors$exposed_jdbc", "()Ljava/util/ArrayList;", "commit", "", "rollback", "registerInterceptor", "interceptor", "unregisterInterceptor", "describeStatement", "", "delta", "stmt", "exec", "args", "", "Lkotlin/Pair;", "Lorg/jetbrains/exposed/v1/core/IColumnType;", "", "explicitStatementType", "Lorg/jetbrains/exposed/v1/core/statements/StatementType;", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/v1/core/statements/StatementType;)Lkotlin/Unit;", "T", "transform", "Lkotlin/Function1;", "Ljava/sql/ResultSet;", "(Ljava/lang/String;Ljava/lang/Iterable;Lorg/jetbrains/exposed/v1/core/statements/StatementType;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Lorg/jetbrains/exposed/v1/jdbc/statements/BlockingExecutable;", "(Lorg/jetbrains/exposed/v1/jdbc/statements/BlockingExecutable;)Ljava/lang/Object;", "execInBatch", "stmts", "", "R", "body", "Lkotlin/Function2;", "Lkotlin/ExtensionFunctionType;", "(Lorg/jetbrains/exposed/v1/jdbc/statements/BlockingExecutable;Lkotlin/jvm/functions/Function2;)Ljava/lang/Object;", "execQuery", "query", "Lorg/jetbrains/exposed/v1/core/statements/api/ResultApi;", "execQuery$exposed_jdbc", "closeExecutedStatements", "addLogger", "Lorg/jetbrains/exposed/v1/core/CompositeSqlLogger;", "logger", "", "Lorg/jetbrains/exposed/v1/core/SqlLogger;", "([Lorg/jetbrains/exposed/v1/core/SqlLogger;)Lorg/jetbrains/exposed/v1/core/CompositeSqlLogger;", "getRetryInterval", "getRetryInterval$exposed_jdbc", "close", "connection", "Lorg/jetbrains/exposed/v1/jdbc/statements/api/ExposedConnection;", "getConnection", "()Lorg/jetbrains/exposed/v1/jdbc/statements/api/ExposedConnection;", "outerTransaction", "getOuterTransaction", "()Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction;", "readOnly", "getReadOnly", "transactionIsolation", "getTransactionIsolation", "Companion", "exposed-jdbc"})
@SourceDebugExtension(value={"SMAP\nJdbcTransaction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdbcTransaction.kt\norg/jetbrains/exposed/v1/jdbc/JdbcTransaction\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,305:1\n1#2:306\n1869#3,2:307\n1869#3,2:309\n1869#3,2:311\n1869#3,2:313\n1869#3,2:315\n1869#3,2:317\n1869#3,2:319\n1869#3,2:321\n1869#3,2:330\n1563#3:332\n1634#3,3:333\n1869#3,2:336\n384#4,7:323\n*S KotlinDebug\n*F\n+ 1 JdbcTransaction.kt\norg/jetbrains/exposed/v1/jdbc/JdbcTransaction\n*L\n74#1:307,2\n78#1:309,2\n84#1:311,2\n85#1:313,2\n90#1:315,2\n91#1:317,2\n93#1:319,2\n94#1:321,2\n273#1:330,2\n215#1:332\n215#1:333,3\n299#1:336,2\n222#1:323,7\n*E\n"})
public class JdbcTransaction
extends Transaction
implements JdbcTransactionInterface {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final JdbcTransactionInterface transactionImpl;
    @NotNull
    private final Database db;
    private int maxAttempts;
    private long minRetryDelay;
    private long maxRetryDelay;
    @Nullable
    private JdbcPreparedStatementApi currentStatement;
    @Nullable
    private Statement<?> explainStatement;
    private boolean blockStatementExecution;
    @NotNull
    private final List<JdbcPreparedStatementApi> executedStatements;
    private int openResultSetsCount;
    @NotNull
    private final ArrayList<StatementInterceptor> interceptors;
    @NotNull
    private static final ArrayList<GlobalStatementInterceptor> globalInterceptors = new ArrayList();

    public JdbcTransaction(@NotNull JdbcTransactionInterface transactionImpl) {
        Intrinsics.checkNotNullParameter((Object)transactionImpl, (String)"transactionImpl");
        this.transactionImpl = transactionImpl;
        this.db = this.transactionImpl.getDb();
        this.maxAttempts = JdbcTransactionInterfaceKt.getTransactionManager(this.db).getDefaultMaxAttempts();
        this.minRetryDelay = JdbcTransactionInterfaceKt.getTransactionManager(this.db).getDefaultMinRetryDelay();
        this.maxRetryDelay = JdbcTransactionInterfaceKt.getTransactionManager(this.db).getDefaultMaxRetryDelay();
        this.executedStatements = new ArrayList();
        this.interceptors = new ArrayList();
        SqlLogger[] sqlLoggerArray = new SqlLogger[]{this.db.getConfig().getSqlLogger()};
        this.addLogger(sqlLoggerArray);
    }

    @Override
    @NotNull
    public final Database getDb() {
        return this.db;
    }

    public final int getMaxAttempts() {
        return this.maxAttempts;
    }

    public final void setMaxAttempts(int value) {
        if (!(value > 0)) {
            boolean bl = false;
            String string = "maxAttempts must be set to perform at least 1 attempt.";
            throw new IllegalArgumentException(string.toString());
        }
        this.maxAttempts = value;
    }

    public final long getMinRetryDelay() {
        return this.minRetryDelay;
    }

    public final void setMinRetryDelay(long l) {
        this.minRetryDelay = l;
    }

    public final long getMaxRetryDelay() {
        return this.maxRetryDelay;
    }

    public final void setMaxRetryDelay(long l) {
        this.maxRetryDelay = l;
    }

    @Nullable
    public final JdbcPreparedStatementApi getCurrentStatement() {
        return this.currentStatement;
    }

    public final void setCurrentStatement(@Nullable JdbcPreparedStatementApi jdbcPreparedStatementApi) {
        this.currentStatement = jdbcPreparedStatementApi;
    }

    @Nullable
    public final Statement<?> getExplainStatement$exposed_jdbc() {
        return this.explainStatement;
    }

    public final void setExplainStatement$exposed_jdbc(@Nullable Statement<?> statement) {
        this.explainStatement = statement;
    }

    public final boolean getBlockStatementExecution$exposed_jdbc() {
        return this.blockStatementExecution;
    }

    public final void setBlockStatementExecution$exposed_jdbc(boolean bl) {
        this.blockStatementExecution = bl;
    }

    @NotNull
    public final List<JdbcPreparedStatementApi> getExecutedStatements$exposed_jdbc() {
        return this.executedStatements;
    }

    public final int getOpenResultSetsCount$exposed_jdbc() {
        return this.openResultSetsCount;
    }

    public final void setOpenResultSetsCount$exposed_jdbc(int n) {
        this.openResultSetsCount = n;
    }

    @NotNull
    public final ArrayList<StatementInterceptor> getInterceptors$exposed_jdbc() {
        return this.interceptors;
    }

    @Override
    public void commit() {
        GlobalStatementInterceptor it;
        HashMap dataToStore = new HashMap();
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            dataToStore.putAll(it.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            it.beforeCommit((Transaction)this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            dataToStore.putAll(it.keepUserDataInTransactionStoreOnCommit((Map)this.getUserdata()));
            it.beforeCommit((Transaction)this);
        }
        this.transactionImpl.commit();
        this.getUserdata().clear();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit((Transaction)this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterCommit((Transaction)this);
        }
        this.getUserdata().putAll(dataToStore);
    }

    @Override
    public void rollback() {
        GlobalStatementInterceptor it;
        Iterable $this$forEach$iv = globalInterceptors;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback((Transaction)this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.beforeRollback((Transaction)this);
        }
        this.transactionImpl.rollback();
        $this$forEach$iv = globalInterceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback((Transaction)this);
        }
        $this$forEach$iv = this.interceptors;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (StatementInterceptor)element$iv;
            boolean bl = false;
            it.afterRollback((Transaction)this);
        }
        this.getUserdata().clear();
    }

    public final boolean registerInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        return this.interceptors.add(interceptor);
    }

    public final boolean unregisterInterceptor(@NotNull StatementInterceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        return this.interceptors.remove(interceptor);
    }

    private final String describeStatement(long delta, String stmt) {
        return "" + '[' + delta + "ms] " + StringsKt.take((String)stmt, (int)1024) + "\n\n";
    }

    @Nullable
    public final Unit exec(@Language(value="sql") @NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> args, @Nullable StatementType explicitStatementType) {
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        return (Unit)this.exec(stmt, args, explicitStatementType, JdbcTransaction::exec$lambda$9);
    }

    public static /* synthetic */ Unit exec$default(JdbcTransaction jdbcTransaction, String string, Iterable iterable, StatementType statementType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return jdbcTransaction.exec(string, iterable, statementType);
    }

    @Nullable
    public final <T> T exec(@Language(value="sql") @NotNull String stmt, @NotNull Iterable<? extends Pair<? extends IColumnType<?>, ? extends Object>> args, @Nullable StatementType explicitStatementType, @NotNull Function1<? super ResultSet, ? extends T> transform) {
        Intrinsics.checkNotNullParameter((Object)stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        if (((CharSequence)stmt).length() == 0) {
            return null;
        }
        StatementType statementType = explicitStatementType;
        if (statementType == null) {
            Object v1;
            block4: {
                Iterable iterable = (Iterable)StatementType.getEntries();
                for (Object t : iterable) {
                    StatementType it = (StatementType)t;
                    boolean bl = false;
                    if (!StringsKt.startsWith((String)((Object)StringsKt.trim((CharSequence)stmt)).toString(), (String)it.name(), (boolean)true)) continue;
                    v1 = t;
                    break block4;
                }
                v1 = null;
            }
            if ((statementType = (StatementType)v1) == null) {
                statementType = StatementType.OTHER;
            }
        }
        StatementType type = statementType;
        List list = CollectionsKt.emptyList();
        return this.exec(new BlockingExecutable<T, Statement<? extends T>>(type, transform, stmt, args, list){
            final /* synthetic */ StatementType $type;
            final /* synthetic */ Function1<ResultSet, T> $transform;
            final /* synthetic */ String $stmt;
            final /* synthetic */ Iterable<Pair<IColumnType<?>, Object>> $args;
            {
                this.$type = $type;
                this.$transform = $transform;
                this.$stmt = $stmt;
                this.$args = $args;
                super($type, $super_call_param$1);
            }

            public Statement<T> getStatement() {
                return this;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public T executeInternal(JdbcPreparedStatementApi $this$executeInternal, JdbcTransaction transaction) {
                Intrinsics.checkNotNullParameter((Object)$this$executeInternal, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                switch (exec.WhenMappings.$EnumSwitchMapping$0[this.$type.ordinal()]) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        v0 = $this$executeInternal.executeQuery();
                        break;
                    }
                    case 5: {
                        $this$firstOrNull$iv = $this$executeInternal.executeMultiple();
                        $i$f$firstOrNull = false;
                        for (T element$iv : $this$firstOrNull$iv) {
                            it = (StatementResult)element$iv;
                            $i$a$-firstOrNull-JdbcTransaction$exec$2$executeInternal$result$result$1 = false;
                            if (!(it instanceof StatementResult.Object)) continue;
                            v1 = element$iv;
                            ** GOTO lbl17
                        }
                        v1 = null;
lbl17:
                        // 2 sources

                        result = v1;
                        v2 = result instanceof StatementResult.Object != false ? (StatementResult.Object)result : null;
                        if (v2 != null) {
                            v0 = v2.getResultSet();
                            break;
                        }
                        v0 = null;
                        break;
                    }
                    default: {
                        $this$executeInternal.executeUpdate();
                        v0 = result = (ResultApi)$this$executeInternal.getResultSet();
                    }
                }
                if ((v3 = result instanceof JdbcResult != false ? (JdbcResult)result : null) != null && (v3 = v3.getResult()) != null) {
                    var4_13 = (AutoCloseable)v3;
                    var5_3 = this.$transform;
                    var6_5 = null;
                    try {
                        it = (ResultSet)var4_13;
                        $i$a$-use-JdbcTransaction$exec$2$executeInternal$1 = false;
                        var7_6 = var5_3.invoke((Object)it);
                        v4 = var7_6;
                    }
                    catch (Throwable var8_9) {
                        var6_5 = var8_9;
                        throw var8_9;
                    }
                    finally {
                        AutoCloseableKt.closeFinally((AutoCloseable)var4_13, (Throwable)var6_5);
                    }
                } else {
                    v4 = null;
                }
                return (T)v4;
            }

            public String prepareSQL(Transaction transaction, boolean prepared2) {
                Intrinsics.checkNotNullParameter((Object)transaction, (String)"transaction");
                return this.$stmt;
            }

            /*
             * WARNING - void declaration
             */
            public Iterable<Iterable<Pair<IColumnType<?>, Object>>> arguments() {
                void $this$mapTo$iv$iv;
                Iterable<Pair<IColumnType<?>, Object>> $this$map$iv = this.$args;
                boolean $i$f$map = false;
                Iterable<Pair<IColumnType<?>, Object>> iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    IColumnType iColumnType;
                    Pair pair = (Pair)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    IColumnType columnType = (IColumnType)pair.component1();
                    Object value = pair.component2();
                    IColumnType $this$arguments_u24lambda_u243_u24lambda_u242 = iColumnType = columnType;
                    boolean bl2 = false;
                    $this$arguments_u24lambda_u243_u24lambda_u242.setNullable(true);
                    collection.add(TuplesKt.to((Object)iColumnType, (Object)value));
                }
                return CollectionsKt.listOf((Object)((List)destination$iv$iv));
            }

            public JdbcPreparedStatementApi prepared(JdbcTransaction transaction, String sql) {
                return BlockingExecutable.DefaultImpls.prepared(this, transaction, sql);
            }

            public boolean isAlwaysBatch() {
                return BlockingExecutable.DefaultImpls.isAlwaysBatch(this);
            }

            public T execute(JdbcTransaction transaction) {
                return BlockingExecutable.DefaultImpls.execute(this, transaction);
            }
        });
    }

    public static /* synthetic */ Object exec$default(JdbcTransaction jdbcTransaction, String string, Iterable iterable, StatementType statementType, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: exec");
        }
        if ((n & 2) != 0) {
            iterable = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            statementType = null;
        }
        return jdbcTransaction.exec(string, iterable, statementType, function1);
    }

    @Nullable
    public final <T> T exec(@NotNull BlockingExecutable<? extends T, ?> stmt) {
        Intrinsics.checkNotNullParameter(stmt, (String)"stmt");
        return (T)this.exec(stmt, JdbcTransaction::exec$lambda$11);
    }

    public final void execInBatch(@NotNull List<String> stmts) {
        Intrinsics.checkNotNullParameter(stmts, (String)"stmts");
        this.getConnection().executeInBatch(stmts);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final <T, R> R exec(@NotNull BlockingExecutable<? extends T, ?> stmt, @NotNull Function2<? super Statement<? extends T>, ? super T, ? extends R> body) {
        Object object;
        Intrinsics.checkNotNullParameter(stmt, (String)"stmt");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        int n = this.getStatementCount();
        this.setStatementCount(n + 1);
        long start = System.nanoTime();
        Pair<? extends T, List<StatementContext>> answer = BlockingExecutableKt.executeIn(stmt, this);
        long it2 = System.nanoTime() - start;
        boolean bl = false;
        long delta = TimeUnit.NANOSECONDS.toMillis(it2);
        Lazy lazySQL = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, () -> JdbcTransaction.exec$lambda$14(answer, this));
        this.setDuration(this.getDuration() + delta);
        if (this.getDebug()) {
            Object object2;
            void $this$getOrPut$iv;
            this.getStatements().append(this.describeStatement(delta, (String)lazySQL.getValue()));
            Map it2 = this.getStatementStats();
            Object key$iv = lazySQL.getValue();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl2 = false;
                Pair answer$iv = TuplesKt.to((Object)0, (Object)0L);
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            Pair pair = (Pair)object2;
            boolean bl3 = false;
            int count = ((Number)pair.component1()).intValue();
            long time = ((Number)pair.component2()).longValue();
            ((Map)this.getStatementStats()).put(lazySQL.getValue(), TuplesKt.to((Object)(count + 1), (Object)(time + delta)));
        }
        Long l = this.getWarnLongQueriesDuration();
        if (delta > (l != null ? l : Long.MAX_VALUE)) {
            SQLLogKt.getExposedLogger().warn("Long query: " + this.describeStatement(delta, (String)lazySQL.getValue()), (Throwable)new LongQueryException());
        }
        Object object3 = answer.getFirst();
        if (object3 != null) {
            Object it3 = object3;
            boolean bl4 = false;
            object = body.invoke(stmt.getStatement(), it3);
        } else {
            object = null;
        }
        return (R)object;
    }

    @Nullable
    public final <R> R execQuery(@NotNull BlockingExecutable<? extends ResultApi, ?> query, @NotNull Function2<? super Statement<? extends ResultApi>, ? super ResultSet, ? extends R> body) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        Intrinsics.checkNotNullParameter(body, (String)"body");
        return this.exec(query, (arg_0, arg_1) -> JdbcTransaction.execQuery$lambda$18(body, arg_0, arg_1));
    }

    @NotNull
    public final ResultSet execQuery$exposed_jdbc(@NotNull BlockingExecutable<? extends ResultApi, ?> query) {
        Intrinsics.checkNotNullParameter(query, (String)"query");
        ResultSet resultSet = (ResultSet)this.execQuery(query, JdbcTransaction::execQuery$lambda$19);
        if (resultSet == null) {
            throw new IllegalStateException("A ResultSet was expected, but none was retrieved from the database".toString());
        }
        return resultSet;
    }

    public final void closeExecutedStatements() {
        Iterable $this$forEach$iv = this.executedStatements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JdbcPreparedStatementApi it = (JdbcPreparedStatementApi)element$iv;
            boolean bl = false;
            it.closeIfPossible();
        }
        this.openResultSetsCount = 0;
        this.executedStatements.clear();
    }

    @NotNull
    public final CompositeSqlLogger addLogger(SqlLogger ... logger) {
        CompositeSqlLogger compositeSqlLogger;
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        CompositeSqlLogger $this$addLogger_u24lambda_u2421 = compositeSqlLogger = super.addLogger(Arrays.copyOf(logger, logger.length));
        boolean bl = false;
        this.registerInterceptor((StatementInterceptor)$this$addLogger_u24lambda_u2421);
        return compositeSqlLogger;
    }

    public final long getRetryInterval$exposed_jdbc() {
        return this.maxAttempts > 0 ? Math.max((this.maxRetryDelay - this.minRetryDelay) / (long)(this.maxAttempts + 1), 1L) : 0L;
    }

    public boolean getReadOnly() {
        return this.transactionImpl.getReadOnly();
    }

    @Override
    @Nullable
    public JdbcTransaction getOuterTransaction() {
        return this.transactionImpl.getOuterTransaction();
    }

    @Override
    public int getTransactionIsolation() {
        return this.transactionImpl.getTransactionIsolation();
    }

    @Override
    @NotNull
    public ExposedConnection<?> getConnection() {
        return this.transactionImpl.getConnection();
    }

    @Override
    public void close() {
        this.transactionImpl.close();
    }

    private static final Unit exec$lambda$9(ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Object exec$lambda$11(Statement $this$exec, Object it) {
        Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
        return it;
    }

    /*
     * WARNING - void declaration
     */
    private static final String exec$lambda$14(Pair $answer, JdbcTransaction this$0) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = (Iterable)$answer.getSecond();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StatementContext statementContext = (StatementContext)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.sql((Transaction)this$0));
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.distinct((Iterable)((List)destination$iv$iv)), null, null, null, (int)0, null, null, (int)63, null);
    }

    private static final Object execQuery$lambda$18(Function2 $body, Statement $this$exec, ResultApi it) {
        Intrinsics.checkNotNullParameter((Object)$this$exec, (String)"$this$exec");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return $body.invoke((Object)$this$exec, (Object)((JdbcResult)it).getResult());
    }

    private static final ResultSet execQuery$lambda$19(Statement $this$execQuery, ResultSet it) {
        Intrinsics.checkNotNullParameter((Object)$this$execQuery, (String)"$this$execQuery");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }

    static {
        ServiceLoader<GlobalStatementInterceptor> serviceLoader = ServiceLoader.load(GlobalStatementInterceptor.class, GlobalStatementInterceptor.class.getClassLoader());
        Intrinsics.checkNotNullExpressionValue(serviceLoader, (String)"load(...)");
        Iterable $this$forEach$iv = serviceLoader;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GlobalStatementInterceptor it = (GlobalStatementInterceptor)element$iv;
            boolean bl = false;
            globalInterceptors.add(it);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R!\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/exposed/v1/jdbc/JdbcTransaction$Companion;", "", "<init>", "()V", "globalInterceptors", "Ljava/util/ArrayList;", "Lorg/jetbrains/exposed/v1/core/statements/GlobalStatementInterceptor;", "Lkotlin/collections/ArrayList;", "getGlobalInterceptors", "()Ljava/util/ArrayList;", "exposed-jdbc"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ArrayList<GlobalStatementInterceptor> getGlobalInterceptors() {
            return globalInterceptors;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

