/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.actions.TerminalFocusModeAction;
import app.termora.database.DatabaseManager;
import app.termora.terminal.ColorPalette;
import app.termora.terminal.ColorPaletteImpl;
import app.termora.terminal.ColorTheme;
import app.termora.terminal.DataKey;
import app.termora.terminal.DefaultColorTheme;
import app.termora.terminal.Terminal;
import app.termora.terminal.TerminalColor;
import app.termora.terminal.TerminalListener;
import app.termora.terminal.TerminalModel;
import app.termora.terminal.TerminalModelImpl;
import app.termora.terminal.VisualTerminal;
import app.termora.terminal.panel.TerminalPanel;
import app.termora.tlog.TerminalLoggerDataListener;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClasses;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\u0018\u0000 \n2\u00020\u0001:\u0005\n\u000b\f\r\u000eB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\u0006J\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\tR\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lapp/termora/TerminalFactory;", "Lapp/termora/Disposable;", "<init>", "()V", "terminals", "", "Lapp/termora/terminal/Terminal;", "createTerminal", "getTerminals", "", "Companion", "MyVisualTerminal", "MyTerminalModel", "FlatLafColorTheme", "MyColorPalette", "termora"})
public final class TerminalFactory
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Terminal> terminals = new ArrayList();

    private TerminalFactory() {
    }

    @NotNull
    public final Terminal createTerminal() {
        MyVisualTerminal terminal = new MyVisualTerminal();
        terminal.getTerminalModel().addDataListener(new TerminalLoggerDataListener(terminal));
        terminal.addTerminalListener(new TerminalListener(this){
            final /* synthetic */ TerminalFactory this$0;
            {
                this.this$0 = $receiver;
            }

            public void onClose(Terminal terminal) {
                Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
                TerminalFactory.access$getTerminals$p(this.this$0).remove(terminal);
            }
        });
        this.terminals.add(terminal);
        return terminal;
    }

    @NotNull
    public final List<Terminal> getTerminals() {
        return this.terminals;
    }

    public /* synthetic */ TerminalFactory(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ List access$getTerminals$p(TerminalFactory $this) {
        return $this.terminals;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lapp/termora/TerminalFactory$Companion;", "", "<init>", "()V", "getInstance", "Lapp/termora/TerminalFactory;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TerminalFactory getInstance() {
            return (TerminalFactory)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(TerminalFactory.class), Companion::getInstance$lambda$0);
        }

        private static final TerminalFactory getInstance$lambda$0() {
            return new TerminalFactory(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lapp/termora/TerminalFactory$FlatLafColorTheme;", "Lapp/termora/terminal/ColorTheme;", "<init>", "()V", "toRGB", "", "Ljava/awt/Color;", "getColor", "color", "Lapp/termora/terminal/TerminalColor;", "termora"})
    public static final class FlatLafColorTheme
    implements ColorTheme {
        private final int toRGB(Color $this$toRGB) {
            return 65536 * $this$toRGB.getRed() + 256 * $this$toRGB.getGreen() + $this$toRGB.getBlue();
        }

        @Override
        public int getColor(@NotNull TerminalColor color) {
            int n;
            int c;
            Intrinsics.checkNotNullParameter((Object)color, (String)"color");
            LookAndFeel laf = UIManager.getLookAndFeel();
            if (laf instanceof ColorTheme && (c = ((ColorTheme)((Object)laf)).getColor(color)) != Integer.MAX_VALUE) {
                return c;
            }
            TerminalColor terminalColor = color;
            if (Intrinsics.areEqual((Object)terminalColor, (Object)TerminalColor.Basic.INSTANCE.getFOREGROUND())) {
                Color color2 = UIManager.getColor("windowText");
                Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getColor(...)");
                n = this.toRGB(color2);
            } else if (Intrinsics.areEqual((Object)terminalColor, (Object)TerminalColor.Basic.INSTANCE.getBACKGROUND())) {
                Color color3 = UIManager.getColor("window");
                Intrinsics.checkNotNullExpressionValue((Object)color3, (String)"getColor(...)");
                n = this.toRGB(color3);
            } else if (Intrinsics.areEqual((Object)terminalColor, (Object)TerminalColor.Basic.INSTANCE.getSELECTION_FOREGROUND())) {
                Color color4 = UIManager.getColor("textHighlightText");
                Intrinsics.checkNotNullExpressionValue((Object)color4, (String)"getColor(...)");
                n = this.toRGB(color4);
            } else if (Intrinsics.areEqual((Object)terminalColor, (Object)TerminalColor.Basic.INSTANCE.getSELECTION_BACKGROUND())) {
                Color color5 = UIManager.getColor("textHighlight");
                Intrinsics.checkNotNullExpressionValue((Object)color5, (String)"getColor(...)");
                n = this.toRGB(color5);
            } else if (Intrinsics.areEqual((Object)terminalColor, (Object)TerminalColor.Cursor.INSTANCE.getBACKGROUND())) {
                n = this.getColor(TerminalColor.Basic.INSTANCE.getFOREGROUND());
            } else if (Intrinsics.areEqual((Object)terminalColor, (Object)TerminalColor.Find.INSTANCE.getBACKGROUND())) {
                Color color6 = UIManager.getColor("Component.warning.focusedBorderColor");
                Intrinsics.checkNotNullExpressionValue((Object)color6, (String)"getColor(...)");
                n = this.toRGB(color6);
            } else if (Intrinsics.areEqual((Object)terminalColor, (Object)TerminalColor.Find.INSTANCE.getFOREGROUND())) {
                Color color7 = UIManager.getColor("windowText");
                Intrinsics.checkNotNullExpressionValue((Object)color7, (String)"getColor(...)");
                n = this.toRGB(color7);
            } else if (Intrinsics.areEqual((Object)terminalColor, (Object)TerminalColor.Basic.INSTANCE.getHYPERLINK())) {
                Color color8 = UIManager.getColor("Hyperlink.linkColor");
                n = color8 != null ? this.toRGB(color8) : this.getColor(TerminalColor.Basic.INSTANCE.getSELECTION_FOREGROUND());
            } else {
                n = DefaultColorTheme.Companion.getInstance().getColor(color);
            }
            return n;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lapp/termora/TerminalFactory$MyColorPalette;", "Lapp/termora/terminal/ColorPaletteImpl;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "colorTheme", "Lapp/termora/TerminalFactory$FlatLafColorTheme;", "getColorTheme", "()Lapp/termora/TerminalFactory$FlatLafColorTheme;", "colorTheme$delegate", "Lkotlin/Lazy;", "getTheme", "Lapp/termora/terminal/ColorTheme;", "termora"})
    public static final class MyColorPalette
    extends ColorPaletteImpl {
        @NotNull
        private final Lazy colorTheme$delegate;

        public MyColorPalette(@NotNull Terminal terminal) {
            Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
            super(terminal);
            this.colorTheme$delegate = LazyKt.lazy(MyColorPalette::colorTheme_delegate$lambda$0);
        }

        private final FlatLafColorTheme getColorTheme() {
            Lazy lazy = this.colorTheme$delegate;
            return (FlatLafColorTheme)lazy.getValue();
        }

        @Override
        @NotNull
        public ColorTheme getTheme() {
            return this.getColorTheme();
        }

        private static final FlatLafColorTheme colorTheme_delegate$lambda$0() {
            return new FlatLafColorTheme();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\b\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J%\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u0017H\u0016\u00a2\u0006\u0002\u0010\u0018J-\u0010\u0013\u001a\u0002H\u0014\"\b\b\u0000\u0010\u0014*\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\u00140\u00172\u0006\u0010\u0019\u001a\u0002H\u0014H\u0016\u00a2\u0006\u0002\u0010\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0016R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u0014\u0010\f\u001a\u00020\r8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lapp/termora/TerminalFactory$MyTerminalModel;", "Lapp/termora/terminal/TerminalModelImpl;", "terminal", "Lapp/termora/terminal/Terminal;", "<init>", "(Lapp/termora/terminal/Terminal;)V", "colorPalette", "Lapp/termora/TerminalFactory$MyColorPalette;", "getColorPalette", "()Lapp/termora/TerminalFactory$MyColorPalette;", "colorPalette$delegate", "Lkotlin/Lazy;", "config", "Lapp/termora/database/DatabaseManager$Terminal;", "getConfig", "()Lapp/termora/database/DatabaseManager$Terminal;", "Lapp/termora/terminal/ColorPalette;", "bell", "", "getData", "T", "", "key", "Lapp/termora/terminal/DataKey;", "(Lapp/termora/terminal/DataKey;)Ljava/lang/Object;", "defaultValue", "(Lapp/termora/terminal/DataKey;Ljava/lang/Object;)Ljava/lang/Object;", "getMaxRows", "", "termora"})
    public static class MyTerminalModel
    extends TerminalModelImpl {
        @NotNull
        private final Lazy colorPalette$delegate;

        public MyTerminalModel(@NotNull Terminal terminal) {
            Intrinsics.checkNotNullParameter((Object)terminal, (String)"terminal");
            super(terminal);
            this.colorPalette$delegate = LazyKt.lazy(() -> MyTerminalModel.colorPalette_delegate$lambda$0(terminal));
            this.setData(DataKey.Companion.getCursorStyle(), this.getConfig().getCursor());
            this.setData(TerminalPanel.Companion.getDebug(), this.getConfig().getDebug());
        }

        @Override
        private final MyColorPalette getColorPalette() {
            Lazy lazy = this.colorPalette$delegate;
            return (MyColorPalette)lazy.getValue();
        }

        private final DatabaseManager.Terminal getConfig() {
            return DatabaseManager.Companion.getInstance().getTerminal();
        }

        @Override
        @NotNull
        public ColorPalette getColorPalette() {
            return this.getColorPalette();
        }

        @Override
        public void bell() {
            if (this.getConfig().getBeep()) {
                super.bell();
            }
        }

        @Override
        @NotNull
        public <T> T getData(@NotNull DataKey<T> key) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            if (Intrinsics.areEqual(key, TerminalPanel.Companion.getSelectCopy())) {
                return (T)((Object)this.getConfig().getSelectCopy());
            }
            return super.getData(key);
        }

        @Override
        @NotNull
        public <T> T getData(@NotNull DataKey<T> key, @NotNull T defaultValue) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            if (Intrinsics.areEqual(key, TerminalPanel.Companion.getSelectCopy())) {
                return (T)((Object)this.getConfig().getSelectCopy());
            }
            if (Intrinsics.areEqual(key, TerminalPanel.Companion.getFocusMode())) {
                return (T)KClasses.cast(key.getClazz(), (Object)TerminalFocusModeAction.Companion.getInstance().isSelected());
            }
            return super.getData(key, defaultValue);
        }

        @Override
        public int getMaxRows() {
            return this.getConfig().getMaxRows();
        }

        private static final MyColorPalette colorPalette_delegate$lambda$0(Terminal $terminal) {
            return new MyColorPalette($terminal);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0006\u001a\u00020\nH\u0016R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lapp/termora/TerminalFactory$MyVisualTerminal;", "Lapp/termora/terminal/VisualTerminal;", "<init>", "()V", "terminalModel", "Lapp/termora/TerminalFactory$MyTerminalModel;", "getTerminalModel", "()Lapp/termora/TerminalFactory$MyTerminalModel;", "terminalModel$delegate", "Lkotlin/Lazy;", "Lapp/termora/terminal/TerminalModel;", "termora"})
    public static class MyVisualTerminal
    extends VisualTerminal {
        @NotNull
        private final Lazy terminalModel$delegate = LazyKt.lazy(() -> MyVisualTerminal.terminalModel_delegate$lambda$0(this));

        @Override
        private final MyTerminalModel getTerminalModel() {
            Lazy lazy = this.terminalModel$delegate;
            return (MyTerminalModel)lazy.getValue();
        }

        @Override
        @NotNull
        public TerminalModel getTerminalModel() {
            return this.getTerminalModel();
        }

        private static final MyTerminalModel terminalModel_delegate$lambda$0(MyVisualTerminal this$0) {
            return new MyTerminalModel(this$0);
        }
    }
}

