/*
 * Decompiled with CFR 0.152.
 */
package app.termora;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import javax.swing.JComponent;

public class VerticalFlowLayout
implements LayoutManager,
Serializable {
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    int alisgn;
    int newAlign;
    protected int hgap;
    protected int vgap;

    public VerticalFlowLayout() {
        this(1, 5, 5);
    }

    public VerticalFlowLayout(int align) {
        this(align, 5, 5);
    }

    public VerticalFlowLayout(int align, int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        this.setAlignment(align);
    }

    public int getAlignment() {
        return this.newAlign;
    }

    public void setAlignment(int align) {
        this.newAlign = align;
    }

    public int getHgap() {
        return this.hgap;
    }

    public void setHgap(int hgap) {
        this.hgap = hgap;
    }

    public int getVgap() {
        return this.vgap;
    }

    public void setVgap(int vgap) {
        this.vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            Boolean firstVisibleComponent = true;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getPreferredSize();
                firstVisibleComponent = this.dialWithDim4PreferredLayoutSize(dim, d, firstVisibleComponent);
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    protected boolean dialWithDim4PreferredLayoutSize(Dimension dim, Dimension d, boolean firstVisibleComponent) {
        dim.width = Math.max(dim.width, d.width);
        if (firstVisibleComponent) {
            firstVisibleComponent = false;
        } else {
            dim.height += this.vgap;
        }
        dim.height += d.height;
        return firstVisibleComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension minimumLayoutSize(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Dimension dim = new Dimension(0, 0);
            int nmembers = target.getComponentCount();
            boolean firstVisibleComponent = true;
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = m.getMinimumSize();
                firstVisibleComponent = this.dialWithDim4MinimumLayoutSize(dim, d, i, firstVisibleComponent);
            }
            Insets insets = target.getInsets();
            dim.width += insets.left + insets.right + this.hgap * 2;
            dim.height += insets.top + insets.bottom + this.vgap * 2;
            return dim;
        }
    }

    protected boolean dialWithDim4MinimumLayoutSize(Dimension dim, Dimension d, int i, boolean firstVisibleComponent) {
        dim.width = Math.max(dim.width, d.width);
        if (i > 0) {
            dim.height += this.vgap;
        }
        dim.height += d.height;
        return firstVisibleComponent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveComponents(Container target, int x, int y, int width, int height, int rowStart, int rowEnd, boolean ltr) {
        Object object = target.getTreeLock();
        synchronized (object) {
            switch (this.newAlign) {
                case 0: {
                    y += ltr ? 0 : height;
                    break;
                }
                case 1: {
                    y += height / 2;
                    break;
                }
                case 2: {
                    y += ltr ? height : 0;
                }
            }
            for (int i = rowStart; i < rowEnd; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                if (ltr) {
                    m.setLocation(x + (width - m.getWidth()) / 2, y);
                } else {
                    m.setLocation(x + (width - m.getWidth()) / 2, target.getHeight() - y - m.getHeight());
                }
                y += m.getHeight() + this.vgap;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container target) {
        Object object = target.getTreeLock();
        synchronized (object) {
            Insets insets = target.getInsets();
            int maxlen = this.getMaxLen4LayoutContainer(target, insets);
            int nmembers = target.getComponentCount();
            int x = this.getX4LayoutContainer(insets);
            int y = this.getY4LayoutContainer(insets);
            int roww = 0;
            int start2 = 0;
            boolean ltr = target.getComponentOrientation().isLeftToRight();
            for (int i = 0; i < nmembers; ++i) {
                Component m = target.getComponent(i);
                if (!m.isVisible()) continue;
                Dimension d = this.getPreferredSize(target, m);
                if (target instanceof JComponent) {
                    JComponent t = (JComponent)target;
                    m.setSize(t.getWidth(), d.height);
                    d.width = m.getWidth();
                } else {
                    m.setSize(d.width, d.height);
                }
                int[] rs = this.dealWithDim4LayoutContainer(target, insets, d, x, y, roww, start2, maxlen, i, ltr);
                x = rs[0];
                y = rs[1];
                roww = rs[2];
                start2 = rs[3];
            }
            this.dealWithMC4LayoutContainer(target, insets, x, y, roww, start2, maxlen, nmembers, ltr);
        }
    }

    protected Dimension getPreferredSize(Container target, Component m) {
        return m.getPreferredSize();
    }

    protected void dealWithMC4LayoutContainer(Container target, Insets insets, int x, int y, int roww, int start2, int maxlen, int nmembers, boolean ltr) {
        this.moveComponents(target, x, insets.top + this.vgap, roww, maxlen - y, start2, nmembers, ltr);
    }

    protected int[] dealWithDim4LayoutContainer(Container target, Insets insets, Dimension d, int x, int y, int roww, int start2, int maxlen, int i, boolean ltr) {
        if (y == 0 || y + d.height <= maxlen) {
            if (y > 0) {
                y += this.vgap;
            }
            y += d.height;
            roww = Math.max(roww, d.width);
        } else {
            this.moveComponents(target, x, insets.top + this.vgap, roww, maxlen - y, start2, i, ltr);
            y = d.height;
            x += this.hgap + roww;
            roww = d.width;
            start2 = i;
        }
        return new int[]{x, y, roww, start2};
    }

    protected int getMaxLen4LayoutContainer(Container target, Insets insets) {
        return target.getHeight() - (insets.top + insets.bottom + this.vgap * 2);
    }

    protected int getX4LayoutContainer(Insets insets) {
        return insets.left + this.hgap;
    }

    protected int getY4LayoutContainer(Insets insets) {
        return 0;
    }

    public String toString() {
        String str = "";
        switch (this.newAlign) {
            case 0: {
                str = ",align=top";
                break;
            }
            case 1: {
                str = ",align=center";
                break;
            }
            case 2: {
                str = ",align=bottom";
            }
        }
        return this.getClass().getName() + "[hgap=" + this.hgap + ",vgap=" + this.vgap + str + "]";
    }
}

