/*
 * Decompiled with CFR 0.152.
 */
package app.termora.database;

import app.termora.Application;
import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.Disposer;
import app.termora.Host;
import app.termora.HostManager;
import app.termora.I18n;
import app.termora.account.Account;
import app.termora.account.AccountExtension;
import app.termora.account.AccountManager;
import app.termora.account.AccountOwner;
import app.termora.account.Team;
import app.termora.database.Data;
import app.termora.database.DataEntity;
import app.termora.database.DatabaseChangedExtension;
import app.termora.database.DatabasePropertiesChangedExtension;
import app.termora.database.DatabaseSecret;
import app.termora.database.IDataType;
import app.termora.database.OwnerType;
import app.termora.database.SettingEntity;
import app.termora.database.UnsafeSettingEntity;
import app.termora.highlight.KeywordHighlight;
import app.termora.highlight.KeywordHighlightManager;
import app.termora.keymap.Keymap;
import app.termora.keymap.KeymapManager;
import app.termora.keymgr.KeyManager;
import app.termora.keymgr.OhKeyPair;
import app.termora.macro.Macro;
import app.termora.macro.MacroManager;
import app.termora.plugin.Extension;
import app.termora.plugin.internal.extension.DynamicExtensionHandler;
import app.termora.snippet.Snippet;
import app.termora.snippet.SnippetManager;
import app.termora.terminal.CursorStyle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.modules.SerializersModule;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.v1.core.ColumnSet;
import org.jetbrains.exposed.v1.core.Expression;
import org.jetbrains.exposed.v1.core.ExpressionWithColumnType;
import org.jetbrains.exposed.v1.core.FieldSet;
import org.jetbrains.exposed.v1.core.Op;
import org.jetbrains.exposed.v1.core.OpBuilderKt;
import org.jetbrains.exposed.v1.core.ResultRow;
import org.jetbrains.exposed.v1.core.Table;
import org.jetbrains.exposed.v1.core.statements.InsertStatement;
import org.jetbrains.exposed.v1.core.statements.StatementType;
import org.jetbrains.exposed.v1.core.statements.UpdateStatement;
import org.jetbrains.exposed.v1.jdbc.Database;
import org.jetbrains.exposed.v1.jdbc.JdbcTransaction;
import org.jetbrains.exposed.v1.jdbc.QueriesKt;
import org.jetbrains.exposed.v1.jdbc.Query;
import org.jetbrains.exposed.v1.jdbc.QueryKt;
import org.jetbrains.exposed.v1.jdbc.SchemaUtils;
import org.jetbrains.exposed.v1.jdbc.transactions.TransactionManager;
import org.jetbrains.exposed.v1.jdbc.transactions.TransactionManagerKt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000 D2\u00020\u0001:\bDEFGHIJKB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010*\u001a\u00020+H\u0002J\u001f\u0010,\u001a\b\u0012\u0004\u0012\u0002H.0-\"\u0006\b\u0000\u0010.\u0018\u00012\u0006\u0010/\u001a\u000200H\u0086\bJ'\u0010,\u001a\b\u0012\u0004\u0012\u0002H.0-\"\u0006\b\u0000\u0010.\u0018\u00012\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020#H\u0086\bJ\u0010\u0010,\u001a\u0004\u0018\u0001022\u0006\u00103\u001a\u00020#J\f\u00104\u001a\b\u0012\u0004\u0012\u0002020-J\u0015\u00105\u001a\u0004\u0018\u0001062\u0006\u00103\u001a\u00020#\u00a2\u0006\u0002\u00107J\u0014\u00108\u001a\b\u0012\u0004\u0012\u0002020-2\u0006\u0010/\u001a\u000200J\u001c\u00108\u001a\b\u0012\u0004\u0012\u0002020-2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020#J\u0018\u00109\u001a\u00020+2\u0006\u0010,\u001a\u0002022\b\b\u0002\u0010:\u001a\u00020;J\u0018\u0010<\u001a\u00020+2\u0006\u0010,\u001a\u0002022\b\b\u0002\u0010:\u001a\u00020;J \u0010=\u001a\u00020+2\u0006\u00103\u001a\u00020#2\u0006\u0010/\u001a\u00020#2\b\b\u0002\u0010:\u001a\u00020;J\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020#\u0012\u0004\u0012\u00020#0%J\u0016\u0010?\u001a\u00020+2\u0006\u0010@\u001a\u00020#2\u0006\u0010A\u001a\u00020#J\u0010\u0010B\u001a\u0004\u0018\u00010#2\u0006\u0010@\u001a\u00020#J\b\u0010C\u001a\u00020+H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\u00020\r8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0011\u001a\u0004\b\u0019\u0010\u001aR\u001b\u0010\u001c\u001a\u00020\u001d8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\u0011\u001a\u0004\b\u001e\u0010\u001fRN\u0010!\u001aB\u0012\f\u0012\n $*\u0004\u0018\u00010#0#\u0012\f\u0012\n $*\u0004\u0018\u00010#0# $* \u0012\f\u0012\n $*\u0004\u0018\u00010#0#\u0012\f\u0012\n $*\u0004\u0018\u00010#0#\u0018\u00010%0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010&\u001a\u00020'8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010)\u00a8\u0006L"}, d2={"Lapp/termora/database/DatabaseManager;", "Lapp/termora/Disposable;", "<init>", "()V", "database", "Lorg/jetbrains/exposed/v1/jdbc/Database;", "getDatabase", "()Lorg/jetbrains/exposed/v1/jdbc/Database;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "properties", "Lapp/termora/database/DatabaseManager$Properties;", "getProperties", "()Lapp/termora/database/DatabaseManager$Properties;", "properties$delegate", "Lkotlin/Lazy;", "terminal", "Lapp/termora/database/DatabaseManager$Terminal;", "getTerminal", "()Lapp/termora/database/DatabaseManager$Terminal;", "terminal$delegate", "appearance", "Lapp/termora/database/DatabaseManager$Appearance;", "getAppearance", "()Lapp/termora/database/DatabaseManager$Appearance;", "appearance$delegate", "sftp", "Lapp/termora/database/DatabaseManager$SFTP;", "getSftp", "()Lapp/termora/database/DatabaseManager$SFTP;", "sftp$delegate", "map", "", "", "kotlin.jvm.PlatformType", "", "accountManager", "Lapp/termora/account/AccountManager;", "getAccountManager", "()Lapp/termora/account/AccountManager;", "registerDynamicExtensions", "", "data", "", "T", "type", "Lapp/termora/database/IDataType;", "ownerId", "Lapp/termora/database/Data;", "id", "unsyncedData", "version", "", "(Ljava/lang/String;)Ljava/lang/Long;", "rawData", "saveAndIncrementVersion", "source", "Lapp/termora/database/DatabaseChangedExtension$Source;", "save", "delete", "getSettings", "setSetting", "name", "value", "getSetting", "dispose", "Companion", "AccountDataTransferExtension", "AccountTeamChangedExtension", "IProperties", "Terminal", "Properties", "Appearance", "SFTP", "termora"})
@SourceDebugExtension(value={"SMAP\nDatabaseManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseManager.kt\napp/termora/database/DatabaseManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Json.kt\nkotlinx/serialization/json/Json\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,806:1\n117#1,4:808\n122#1,6:813\n1#2:807\n222#3:812\n222#3:819\n774#4:820\n865#4,2:821\n827#4:823\n855#4,2:824\n*S KotlinDebug\n*F\n+ 1 DatabaseManager.kt\napp/termora/database/DatabaseManager\n*L\n110#1:808,4\n110#1:813,6\n110#1:812\n120#1:819\n157#1:820\n157#1:821,2\n158#1:823\n158#1:824,2\n*E\n"})
public final class DatabaseManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Database database;
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();
    @NotNull
    private final Lazy properties$delegate = LazyKt.lazy(() -> DatabaseManager.properties_delegate$lambda$0(this));
    @NotNull
    private final Lazy terminal$delegate = LazyKt.lazy(() -> DatabaseManager.terminal_delegate$lambda$0(this));
    @NotNull
    private final Lazy appearance$delegate = LazyKt.lazy(() -> DatabaseManager.appearance_delegate$lambda$0(this));
    @NotNull
    private final Lazy sftp$delegate = LazyKt.lazy(() -> DatabaseManager.sftp_delegate$lambda$0(this));
    private final Map<String, String> map = Collections.synchronizedMap(new LinkedHashMap());
    @NotNull
    private static final Logger log;

    private DatabaseManager() {
        String[] stringArray = new String[]{"config", "termora.db"};
        File databaseFile = FileUtils.getFile((File)Application.INSTANCE.getBaseDataDir(), (String[])stringArray);
        FileUtils.forceMkdirParent((File)databaseFile);
        boolean isExists = databaseFile.exists();
        this.database = Database.Companion.connect$default((Database.Companion)Database.Companion, (String)("jdbc:sqlite:" + databaseFile.getAbsolutePath()), (String)"org.sqlite.JDBC", (String)"sa", null, null, null, null, null, (int)248, null);
        if (!isExists) {
            TransactionManagerKt.transaction((Database)this.database, DatabaseManager::_init_$lambda$0);
        }
        TransactionManagerKt.transaction((Database)this.database, arg_0 -> DatabaseManager._init_$lambda$1(this, arg_0));
        if (!isExists) {
            TransactionManagerKt.transaction((Database)this.database, DatabaseManager::_init_$lambda$2);
        }
        Thread.ofVirtual().start(() -> DatabaseManager._init_$lambda$3(this));
        this.registerDynamicExtensions();
    }

    @NotNull
    public final Database getDatabase() {
        return this.database;
    }

    @NotNull
    public final ReentrantLock getLock() {
        return this.lock;
    }

    @NotNull
    public final Properties getProperties() {
        Lazy lazy = this.properties$delegate;
        return (Properties)lazy.getValue();
    }

    @NotNull
    public final Terminal getTerminal() {
        Lazy lazy = this.terminal$delegate;
        return (Terminal)lazy.getValue();
    }

    @NotNull
    public final Appearance getAppearance() {
        Lazy lazy = this.appearance$delegate;
        return (Appearance)lazy.getValue();
    }

    @NotNull
    public final SFTP getSftp() {
        Lazy lazy = this.sftp$delegate;
        return (SFTP)lazy.getValue();
    }

    private final AccountManager getAccountManager() {
        return AccountManager.Companion.getInstance();
    }

    private final void registerDynamicExtensions() {
        Disposable it = DynamicExtensionHandler.Companion.getInstance().register(AccountExtension.class, (Extension)new AccountDataTransferExtension());
        boolean bl = false;
        Disposer.register(this, it);
        it = DynamicExtensionHandler.Companion.getInstance().register(AccountExtension.class, (Extension)new AccountTeamChangedExtension());
        boolean bl2 = false;
        Disposer.register(this, it);
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> List<T> data(IDataType type) {
        List list$iv;
        block3: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            boolean $i$f$data = false;
            DatabaseManager databaseManager = this;
            IDataType iDataType = type;
            String ownerId$iv = "";
            boolean $i$f$data2 = false;
            list$iv = new ArrayList();
            try {
                void type$iv;
                void this_$iv;
                for (Data data$iv : this_$iv.rawData((IDataType)type$iv, ownerId$iv)) {
                    void this_$iv$iv;
                    Json json = Application.INSTANCE.getOhMyJson();
                    String string$iv$iv = data$iv.getData();
                    boolean $i$f$decodeFromString = false;
                    SerializersModule serializersModule = this_$iv$iv.getSerializersModule();
                    Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                    MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                    list$iv.add(this_$iv$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), string$iv$iv));
                }
            }
            catch (Exception e$iv) {
                if (!Companion.getLog().isWarnEnabled()) break block3;
                Companion.getLog().warn(e$iv.getMessage(), (Throwable)e$iv);
            }
        }
        return list$iv;
    }

    /*
     * WARNING - void declaration
     */
    public final /* synthetic */ <T> List<T> data(IDataType type, String ownerId) {
        List list;
        block3: {
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
            boolean $i$f$data = false;
            list = new ArrayList();
            try {
                for (Data data : this.rawData(type, ownerId)) {
                    void this_$iv;
                    Json json = Application.INSTANCE.getOhMyJson();
                    String string$iv = data.getData();
                    boolean $i$f$decodeFromString = false;
                    SerializersModule serializersModule = this_$iv.getSerializersModule();
                    Intrinsics.reifiedOperationMarker((int)6, (String)"T");
                    MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
                    list.add(this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, null), string$iv));
                }
            }
            catch (Exception e) {
                if (!Companion.getLog().isWarnEnabled()) break block3;
                Companion.getLog().warn(e.getMessage(), (Throwable)e);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Data data(@NotNull String id) {
        Data data;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            data = (Data)TransactionManagerKt.transaction((Database)this.database, arg_0 -> DatabaseManager.data$lambda$0$0(id, arg_0));
        }
        finally {
            lock.unlock();
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final List<Data> unsyncedData() {
        List list = new ArrayList();
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean $i$a$-withLock-DatabaseManager$unsyncedData$22 = false;
            TransactionManagerKt.transaction((Database)this.database, arg_0 -> DatabaseManager.unsyncedData$lambda$0$0(list, arg_0));
            Unit $i$a$-withLock-DatabaseManager$unsyncedData$22 = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        if (!this.getAccountManager().isLocally()) {
            void $this$filterNotTo$iv$iv;
            Data it;
            Iterable $this$filterTo$iv$iv;
            Set<String> ownerIds = this.getAccountManager().getOwnerIds();
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Data)element$iv$iv;
                boolean bl = false;
                if (!ownerIds.contains(it.getOwnerId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$filterNot$iv = (List)destination$iv$iv;
            boolean $i$f$filterNot = false;
            $this$filterTo$iv$iv = $this$filterNot$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                it = (Data)element$iv$iv;
                boolean bl = false;
                if (AccountManager.Companion.isLocally(it.getOwnerId())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Long version(@NotNull String id) {
        Long l;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            l = ((Number)TransactionManagerKt.transaction((Database)this.database, arg_0 -> DatabaseManager.version$lambda$0$0(id, arg_0))).longValue();
        }
        finally {
            lock.unlock();
        }
        return l;
    }

    @NotNull
    public final List<Data> rawData(@NotNull IDataType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return this.rawData(type, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<Data> rawData(@NotNull IDataType type, @NotNull String ownerId) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)ownerId, (String)"ownerId");
        List list = new ArrayList();
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            TransactionManagerKt.transaction((Database)this.database, arg_0 -> DatabaseManager.rawData$lambda$0$0(ownerId, list, type, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void saveAndIncrementVersion(@NotNull Data data, @NotNull DatabaseChangedExtension.Source source) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Data oldData = this.data(data.getId());
        if (oldData != null) {
            if (oldData.getDeleted()) {
                return;
            }
            Lock lock = this.lock;
            lock.lock();
            try {
                boolean bl = false;
                int n = ((Number)TransactionManagerKt.transaction((Database)this.database, arg_0 -> DatabaseManager.saveAndIncrementVersion$lambda$0$0(data, oldData, arg_0))).intValue();
            }
            finally {
                lock.unlock();
            }
            DatabaseChangedExtension.Companion.fireDataChanged(data.getId(), data.getType(), DatabaseChangedExtension.Action.Changed, source);
        } else {
            this.save(data, source);
        }
    }

    public static /* synthetic */ void saveAndIncrementVersion$default(DatabaseManager databaseManager, Data data, DatabaseChangedExtension.Source source, int n, Object object) {
        if ((n & 2) != 0) {
            source = DatabaseChangedExtension.Source.User;
        }
        databaseManager.saveAndIncrementVersion(data, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull Data data, @NotNull DatabaseChangedExtension.Source source) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Ref.ObjectRef action2 = new Ref.ObjectRef();
        action2.element = DatabaseChangedExtension.Action.Changed;
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            TransactionManagerKt.transaction((Database)this.database, arg_0 -> DatabaseManager.save$lambda$0$0(action2, data, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        DatabaseChangedExtension.Companion.fireDataChanged(data.getId(), data.getType(), (DatabaseChangedExtension.Action)((Object)action2.element), source);
    }

    public static /* synthetic */ void save$default(DatabaseManager databaseManager, Data data, DatabaseChangedExtension.Source source, int n, Object object) {
        if ((n & 2) != 0) {
            source = DatabaseChangedExtension.Source.User;
        }
        databaseManager.save(data, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void delete(@NotNull String id, @NotNull String type, @NotNull DatabaseChangedExtension.Source source) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)((Object)source), (String)"source");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            int n = ((Number)TransactionManagerKt.transaction((Database)this.database, arg_0 -> DatabaseManager.delete$lambda$0$0(id, this, arg_0))).intValue();
        }
        finally {
            lock.unlock();
        }
        DatabaseChangedExtension.Companion.fireDataChanged(id, type, DatabaseChangedExtension.Action.Removed, source);
    }

    public static /* synthetic */ void delete$default(DatabaseManager databaseManager, String string, String string2, DatabaseChangedExtension.Source source, int n, Object object) {
        if ((n & 4) != 0) {
            source = DatabaseChangedExtension.Source.User;
        }
        databaseManager.delete(string, string2, source);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, String> getSettings() {
        Map map = new LinkedHashMap();
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            TransactionManagerKt.transaction((Database)this.database, arg_0 -> DatabaseManager.getSettings$lambda$0$0(map, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setSetting(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            TransactionManagerKt.transaction((Database)this.database, arg_0 -> DatabaseManager.setSetting$lambda$0$0(name, value, arg_0));
            Map<String, String> map = this.map;
            Intrinsics.checkNotNullExpressionValue(map, (String)"map");
            map.put(name, value);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String getSetting(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.map.containsKey(name)) {
            return this.map.get(name);
        }
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            TransactionManagerKt.transaction((Database)this.database, arg_0 -> DatabaseManager.getSetting$lambda$0$0(this, name, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return this.map.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            TransactionManager.Companion.closeAndUnregister(this.database);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    private static final Properties properties_delegate$lambda$0(DatabaseManager this$0) {
        return new Properties(this$0);
    }

    private static final Terminal terminal_delegate$lambda$0(DatabaseManager this$0) {
        return new Terminal(this$0);
    }

    private static final Appearance appearance_delegate$lambda$0(DatabaseManager this$0) {
        return new Appearance(this$0);
    }

    private static final SFTP sftp_delegate$lambda$0(DatabaseManager this$0) {
        return new SFTP(this$0);
    }

    private static final Unit _init_$lambda$0(JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        UnsafeSettingEntity[] unsafeSettingEntityArray = new UnsafeSettingEntity[]{UnsafeSettingEntity.INSTANCE};
        SchemaUtils.create$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])unsafeSettingEntityArray, (boolean)false, (int)2, null);
        return Unit.INSTANCE;
    }

    private static final DatabaseSecret _init_$lambda$1(DatabaseManager this$0, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        return DatabaseSecret.Companion.getInstance(this$0.database);
    }

    private static final Unit _init_$lambda$2(JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Table[] tableArray = new Table[]{DataEntity.INSTANCE, SettingEntity.INSTANCE};
        SchemaUtils.create$default((SchemaUtils)SchemaUtils.INSTANCE, (Table[])tableArray, (boolean)false, (int)2, null);
        return JdbcTransaction.exec$default((JdbcTransaction)$this$transaction, (String)"PRAGMA db_version = 1", null, (StatementType)StatementType.UPDATE, (int)2, null);
    }

    private static final void _init_$lambda$3(DatabaseManager this$0) {
        this$0.map.putAll(this$0.getSettings());
    }

    private static final Data data$lambda$0$0(String $id, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        ResultRow resultRow = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)DataEntity.INSTANCE)).where(() -> DatabaseManager.data$lambda$0$0$0($id))));
        return resultRow != null ? Data.Companion.toData(resultRow) : null;
    }

    private static final Op data$lambda$0$0$0(String $id) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getId()), (Object)$id);
    }

    private static final Unit unsyncedData$lambda$0$0(List $list, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        List rows = CollectionsKt.toList((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)DataEntity.INSTANCE)).where(DatabaseManager::unsyncedData$lambda$0$0$0)));
        for (ResultRow row : rows) {
            $list.add(Data.Companion.toData(row));
        }
        return Unit.INSTANCE;
    }

    private static final Op unsyncedData$lambda$0$0$0() {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getSynced()), (Object)false);
    }

    private static final long version$lambda$0$0(String $id, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        ResultRow resultRow = (ResultRow)CollectionsKt.firstOrNull((Iterable)((Iterable)QueriesKt.select((ColumnSet)((ColumnSet)DataEntity.INSTANCE), (Expression)((Expression)DataEntity.INSTANCE.getVersion()), (Expression[])new Expression[0]).where(() -> DatabaseManager.version$lambda$0$0$0($id))));
        return resultRow != null ? ((Number)resultRow.get((Expression)DataEntity.INSTANCE.getVersion())).longValue() : 0L;
    }

    private static final Op version$lambda$0$0$0(String $id) {
        return OpBuilderKt.and((Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getId()), (Object)$id)), (Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getDeleted()), (Object)false)));
    }

    private static final Unit rawData$lambda$0$0(String $ownerId, List $list, IDataType $type, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Query query = QueriesKt.selectAll((FieldSet)((FieldSet)DataEntity.INSTANCE)).where(() -> DatabaseManager.rawData$lambda$0$0$0($type));
        if (!StringsKt.isBlank((CharSequence)$ownerId)) {
            QueryKt.andWhere((Query)query, () -> DatabaseManager.rawData$lambda$0$0$1($ownerId));
        }
        for (ResultRow row : query) {
            try {
                $list.add(Data.Companion.toData(row));
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) continue;
                log.warn(e.getMessage(), (Throwable)e);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Op rawData$lambda$0$0$0(IDataType $type) {
        return OpBuilderKt.and((Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getType()), (Object)$type.dataType())), (Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getDeleted()), (Object)false)));
    }

    private static final Op rawData$lambda$0$0$1(String $ownerId) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getOwnerId()), (Object)$ownerId);
    }

    private static final int saveAndIncrementVersion$lambda$0$0(Data $data, Data $oldData, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        return QueriesKt.update$default((Table)DataEntity.INSTANCE, () -> DatabaseManager.saveAndIncrementVersion$lambda$0$0$0($data), null, (arg_0, arg_1) -> DatabaseManager.saveAndIncrementVersion$lambda$0$0$1($data, $oldData, arg_0, arg_1), (int)2, null);
    }

    private static final Op saveAndIncrementVersion$lambda$0$0$0(Data $data) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getId()), (Object)$data.getId());
    }

    private static final Unit saveAndIncrementVersion$lambda$0$0$1(Data $data, Data $oldData, DataEntity $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(DataEntity.INSTANCE.getData(), (Object)$data.getData());
        it.set(DataEntity.INSTANCE.getVersion(), (Object)($oldData.getVersion() + 1L));
        it.set(DataEntity.INSTANCE.getSynced(), (Object)false);
        return Unit.INSTANCE;
    }

    private static final Unit save$lambda$0$0(Ref.ObjectRef $action, Data $data, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        boolean exists = CollectionsKt.any((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)DataEntity.INSTANCE)).where(() -> DatabaseManager.save$lambda$0$0$0($data))));
        if (exists) {
            QueriesKt.update$default((Table)DataEntity.INSTANCE, () -> DatabaseManager.save$lambda$0$0$1($data), null, (arg_0, arg_1) -> DatabaseManager.save$lambda$0$0$2($data, arg_0, arg_1), (int)2, null);
            $action.element = DatabaseChangedExtension.Action.Changed;
        } else {
            QueriesKt.insert((Table)DataEntity.INSTANCE, (arg_0, arg_1) -> DatabaseManager.save$lambda$0$0$3($data, arg_0, arg_1));
            $action.element = DatabaseChangedExtension.Action.Added;
        }
        return Unit.INSTANCE;
    }

    private static final Op save$lambda$0$0$0(Data $data) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getId()), (Object)$data.getId());
    }

    private static final Op save$lambda$0$0$1(Data $data) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getId()), (Object)$data.getId());
    }

    private static final Unit save$lambda$0$0$2(Data $data, DataEntity $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(DataEntity.INSTANCE.getData(), (Object)$data.getData());
        it.set(DataEntity.INSTANCE.getVersion(), (Object)$data.getVersion());
        it.set(DataEntity.INSTANCE.getSynced(), (Object)$data.getSynced());
        it.set(DataEntity.INSTANCE.getDeleted(), (Object)$data.getDeleted());
        return Unit.INSTANCE;
    }

    private static final Unit save$lambda$0$0$3(Data $data, DataEntity $this$insert, InsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$insert), (String)"$this$insert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(DataEntity.INSTANCE.getId(), (Object)$data.getId());
        it.set(DataEntity.INSTANCE.getOwnerId(), (Object)$data.getOwnerId());
        it.set(DataEntity.INSTANCE.getOwnerType(), (Object)$data.getOwnerType());
        it.set(DataEntity.INSTANCE.getType(), (Object)$data.getType());
        it.set(DataEntity.INSTANCE.getData(), (Object)$data.getData());
        it.set(DataEntity.INSTANCE.getSynced(), (Object)$data.getSynced());
        it.set(DataEntity.INSTANCE.getDeleted(), (Object)$data.getDeleted());
        it.set(DataEntity.INSTANCE.getVersion(), (Object)$data.getVersion());
        return Unit.INSTANCE;
    }

    private static final int delete$lambda$0$0(String $id, DatabaseManager this$0, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        return QueriesKt.update$default((Table)DataEntity.INSTANCE, () -> DatabaseManager.delete$lambda$0$0$0($id), null, (arg_0, arg_1) -> DatabaseManager.delete$lambda$0$0$1(this$0, arg_0, arg_1), (int)2, null);
    }

    private static final Op delete$lambda$0$0$0(String $id) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getId()), (Object)$id);
    }

    private static final Unit delete$lambda$0$0$1(DatabaseManager this$0, DataEntity $this$update, UpdateStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$update), (String)"$this$update");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(DataEntity.INSTANCE.getDeleted(), (Object)true);
        it.set(DataEntity.INSTANCE.getSynced(), (Object)this$0.getAccountManager().isLocally());
        it.set(DataEntity.INSTANCE.getData(), (Object)"");
        return Unit.INSTANCE;
    }

    private static final Unit getSettings$lambda$0$0(Map $map, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        for (ResultRow row : CollectionsKt.toList((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)SettingEntity.INSTANCE))))) {
            $map.put(row.get((Expression)SettingEntity.INSTANCE.getName()), row.get((Expression)SettingEntity.INSTANCE.getValue()));
        }
        return Unit.INSTANCE;
    }

    private static final InsertStatement setSetting$lambda$0$0(String $name, String $value, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        for (ResultRow row : CollectionsKt.toList((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)SettingEntity.INSTANCE)).where(() -> DatabaseManager.setSetting$lambda$0$0$0($name))))) {
            QueriesKt.deleteWhere$default((Table)SettingEntity.INSTANCE, null, arg_0 -> DatabaseManager.setSetting$lambda$0$0$1(row, arg_0), (int)1, null);
        }
        return QueriesKt.insert((Table)SettingEntity.INSTANCE, (arg_0, arg_1) -> DatabaseManager.setSetting$lambda$0$0$2($name, $value, arg_0, arg_1));
    }

    private static final Op setSetting$lambda$0$0$0(String $name) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)SettingEntity.INSTANCE.getName()), (Object)$name);
    }

    private static final Op setSetting$lambda$0$0$1(ResultRow $row, SettingEntity $this$deleteWhere) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$deleteWhere), (String)"$this$deleteWhere");
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)SettingEntity.INSTANCE.getId()), (Object)$row.get((Expression)SettingEntity.INSTANCE.getId()));
    }

    private static final Unit setSetting$lambda$0$0$2(String $name, String $value, SettingEntity $this$insert, InsertStatement it) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$insert), (String)"$this$insert");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.set(SettingEntity.INSTANCE.getName(), (Object)$name);
        it.set(SettingEntity.INSTANCE.getValue(), (Object)$value);
        return Unit.INSTANCE;
    }

    private static final Unit getSetting$lambda$0$0(DatabaseManager this$0, String $name, JdbcTransaction $this$transaction) {
        Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
        Map<String, String> map = this$0.map;
        Intrinsics.checkNotNullExpressionValue(map, (String)"map");
        Map<String, String> map2 = map;
        ResultRow resultRow = (ResultRow)CollectionsKt.singleOrNull((List)CollectionsKt.toList((Iterable)((Iterable)QueriesKt.selectAll((FieldSet)((FieldSet)SettingEntity.INSTANCE)).where(() -> DatabaseManager.getSetting$lambda$0$0$0($name)))));
        resultRow = resultRow != null ? (String)resultRow.getOrNull((Expression)SettingEntity.INSTANCE.getValue()) : null;
        map2.put($name, (String)resultRow);
        return Unit.INSTANCE;
    }

    private static final Op getSetting$lambda$0$0$0(String $name) {
        return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)SettingEntity.INSTANCE.getName()), (Object)$name);
    }

    public /* synthetic */ DatabaseManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    static {
        Logger logger = LoggerFactory.getLogger(DatabaseManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        log = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0007H\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0010"}, d2={"Lapp/termora/database/DatabaseManager$AccountDataTransferExtension;", "Lapp/termora/account/AccountExtension;", "<init>", "(Lapp/termora/database/DatabaseManager;)V", "onAccountChanged", "", "oldAccount", "Lapp/termora/account/Account;", "newAccount", "silentDelete", "id", "", "transferData", "account", "ordered", "", "termora"})
    private final class AccountDataTransferExtension
    implements AccountExtension {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAccountChanged(@NotNull Account oldAccount, @NotNull Account newAccount) {
            Intrinsics.checkNotNullParameter((Object)oldAccount, (String)"oldAccount");
            Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
            if (oldAccount.isLocally() && newAccount.isLocally()) {
                return;
            }
            if (Intrinsics.areEqual((Object)oldAccount.getId(), (Object)newAccount.getId())) {
                return;
            }
            if (oldAccount.isLocally() && !newAccount.isLocally()) {
                this.transferData(newAccount);
            }
            if (!oldAccount.isLocally()) {
                Lock lock = DatabaseManager.this.getLock();
                DatabaseManager databaseManager = DatabaseManager.this;
                lock.lock();
                try {
                    boolean bl = false;
                    TransactionManagerKt.transaction((Database)databaseManager.getDatabase(), arg_0 -> AccountDataTransferExtension.onAccountChanged$lambda$0$0(oldAccount, arg_0));
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void silentDelete(String id) {
            Lock lock = DatabaseManager.this.getLock();
            DatabaseManager databaseManager = DatabaseManager.this;
            lock.lock();
            try {
                boolean bl = false;
                int n = ((Number)TransactionManagerKt.transaction((Database)databaseManager.getDatabase(), arg_0 -> AccountDataTransferExtension.silentDelete$lambda$0$0(id, arg_0))).intValue();
            }
            finally {
                lock.unlock();
            }
        }

        private final void transferData(Account account) {
            HostManager hostManager = HostManager.Companion.getInstance();
            SnippetManager snippetManager = SnippetManager.Companion.getInstance();
            MacroManager macroManager = MacroManager.Companion.getInstance();
            KeymapManager keymapManager = KeymapManager.Companion.getInstance();
            KeyManager keyManager = KeyManager.Companion.getInstance();
            KeywordHighlightManager highlightManager = KeywordHighlightManager.Companion.getInstance();
            AccountOwner accountOwner = new AccountOwner(account.getId(), account.getEmail(), OwnerType.User);
            for (Host host : hostManager.hosts()) {
                if (host.getDeleted() || !StringsKt.isBlank((CharSequence)host.getOwnerType()) && !Intrinsics.areEqual((Object)host.getOwnerType(), (Object)"User") || !AccountManager.Companion.isLocally(host.getOwnerId())) continue;
                this.silentDelete(host.getId());
                HostManager.addHost$default(hostManager, Host.copy$default(host, null, null, null, null, 0, null, null, null, null, null, null, 0L, null, accountOwner.getId(), null, accountOwner.getType().name(), false, 0L, 0L, 483327, null), null, 2, null);
            }
            for (Snippet snippet : snippetManager.snippets()) {
                if (snippet.getDeleted()) continue;
                this.silentDelete(snippet.getId());
                snippetManager.addSnippet(snippet);
            }
            for (Macro macro : macroManager.getMacros()) {
                this.silentDelete(macro.getId());
                macroManager.addMacro(macro);
            }
            for (Keymap keymap : keymapManager.getKeymaps()) {
                this.silentDelete(keymap.getId());
                keymapManager.addKeymap(keymap);
            }
            for (OhKeyPair keypair : keyManager.getOhKeyPairs()) {
                this.silentDelete(keypair.getId());
                keyManager.addOhKeyPair(keypair, accountOwner);
            }
            for (KeywordHighlight e : highlightManager.getKeywordHighlights()) {
                this.silentDelete(e.getId());
                highlightManager.addKeywordHighlight(e, accountOwner);
            }
        }

        @Override
        public long ordered() {
            return 0L;
        }

        private static final Unit onAccountChanged$lambda$0$0(Account $oldAccount, JdbcTransaction $this$transaction) {
            Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
            QueriesKt.deleteWhere$default((Table)DataEntity.INSTANCE, null, arg_0 -> AccountDataTransferExtension.onAccountChanged$lambda$0$0$0($oldAccount, arg_0), (int)1, null);
            for (Team team : $oldAccount.getTeams()) {
                QueriesKt.deleteWhere$default((Table)DataEntity.INSTANCE, null, arg_0 -> AccountDataTransferExtension.onAccountChanged$lambda$0$0$1(team, arg_0), (int)1, null);
            }
            DatabaseChangedExtension.Companion.fireDataChanged$default(DatabaseChangedExtension.Companion, "", "", DatabaseChangedExtension.Action.Removed, null, 8, null);
            return Unit.INSTANCE;
        }

        private static final Op onAccountChanged$lambda$0$0$0(Account $oldAccount, DataEntity $this$deleteWhere) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$deleteWhere), (String)"$this$deleteWhere");
            return OpBuilderKt.and((Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getOwnerId()), (Object)$oldAccount.getId())), (Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getOwnerType()), (Object)"User")));
        }

        private static final Op onAccountChanged$lambda$0$0$1(Team $team, DataEntity $this$deleteWhere) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$deleteWhere), (String)"$this$deleteWhere");
            return OpBuilderKt.and((Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getOwnerId()), (Object)$team.getId())), (Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getOwnerType()), (Object)"Team")));
        }

        private static final int silentDelete$lambda$0$0(String $id, JdbcTransaction $this$transaction) {
            Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
            return QueriesKt.deleteWhere$default((Table)DataEntity.INSTANCE, null, arg_0 -> AccountDataTransferExtension.silentDelete$lambda$0$0$0($id, arg_0), (int)1, null);
        }

        private static final Op silentDelete$lambda$0$0$0(String $id, DataEntity $this$deleteWhere) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$deleteWhere), (String)"$this$deleteWhere");
            return OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getId()), (Object)$id);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lapp/termora/database/DatabaseManager$AccountTeamChangedExtension;", "Lapp/termora/account/AccountExtension;", "<init>", "(Lapp/termora/database/DatabaseManager;)V", "onAccountChanged", "", "oldAccount", "Lapp/termora/account/Account;", "newAccount", "ordered", "", "termora"})
    private final class AccountTeamChangedExtension
    implements AccountExtension {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onAccountChanged(@NotNull Account oldAccount, @NotNull Account newAccount) {
            Intrinsics.checkNotNullParameter((Object)oldAccount, (String)"oldAccount");
            Intrinsics.checkNotNullParameter((Object)newAccount, (String)"newAccount");
            if (oldAccount.isLocally() && newAccount.isLocally()) {
                return;
            }
            if (Intrinsics.areEqual((Object)oldAccount.getId(), (Object)newAccount.getId()) && !Intrinsics.areEqual(oldAccount.getTeams(), newAccount.getTeams())) {
                for (Team team : oldAccount.getTeams()) {
                    Lock lock = DatabaseManager.this.getLock();
                    DatabaseManager databaseManager = DatabaseManager.this;
                    lock.lock();
                    try {
                        boolean bl = false;
                        int n = ((Number)TransactionManagerKt.transaction((Database)databaseManager.getDatabase(), arg_0 -> AccountTeamChangedExtension.onAccountChanged$lambda$0$0(team, arg_0))).intValue();
                    }
                    finally {
                        lock.unlock();
                    }
                }
            }
        }

        @Override
        public long ordered() {
            return -1L;
        }

        private static final int onAccountChanged$lambda$0$0(Team $team, JdbcTransaction $this$transaction) {
            Intrinsics.checkNotNullParameter((Object)$this$transaction, (String)"$this$transaction");
            return QueriesKt.deleteWhere$default((Table)DataEntity.INSTANCE, null, arg_0 -> AccountTeamChangedExtension.onAccountChanged$lambda$0$0$0($team, arg_0), (int)1, null);
        }

        private static final Op onAccountChanged$lambda$0$0$0(Team $team, DataEntity $this$deleteWhere) {
            Intrinsics.checkNotNullParameter((Object)((Object)$this$deleteWhere), (String)"$this$deleteWhere");
            return OpBuilderKt.and((Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getOwnerId()), (Object)$team.getId())), (Expression)((Expression)OpBuilderKt.eq((ExpressionWithColumnType)((ExpressionWithColumnType)DataEntity.INSTANCE.getOwnerType()), (Object)"Team")));
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b \n\u0002\u0010\u0006\n\u0002\b\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR+\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000e\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\fR+\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR+\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00178F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001d\u0010\u001e\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR+\u0010\u001f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\"\u0010\u000e\u001a\u0004\b \u0010\n\"\u0004\b!\u0010\fR+\u0010#\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010\u000e\u001a\u0004\b$\u0010\n\"\u0004\b%\u0010\fR+\u0010'\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00178F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010\u001e\u001a\u0004\b(\u0010\u001a\"\u0004\b)\u0010\u001cR+\u0010+\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u00178F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b.\u0010\u001e\u001a\u0004\b,\u0010\u001a\"\u0004\b-\u0010\u001cR+\u0010/\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b2\u0010\u000e\u001a\u0004\b0\u0010\n\"\u0004\b1\u0010\fR+\u00103\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b6\u00107\u001a\u0004\b4\u0010\n\"\u0004\b5\u0010\fR+\u00109\u001a\u0002082\u0006\u0010\u0006\u001a\u0002088F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b>\u0010?\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=\u00a8\u0006@"}, d2={"Lapp/termora/database/DatabaseManager$Appearance;", "Lapp/termora/database/DatabaseManager$IProperties;", "databaseManager", "Lapp/termora/database/DatabaseManager;", "<init>", "(Lapp/termora/database/DatabaseManager;)V", "<set-?>", "", "theme", "getTheme", "()Ljava/lang/String;", "setTheme", "(Ljava/lang/String;)V", "theme$delegate", "Lapp/termora/database/DatabaseManager$IProperties$StringPropertyDelegate;", "layout", "getLayout", "setLayout", "layout$delegate", "tabOrder", "getTabOrder", "setTabOrder", "tabOrder$delegate", "", "followSystem", "getFollowSystem", "()Z", "setFollowSystem", "(Z)V", "followSystem$delegate", "Lapp/termora/database/DatabaseManager$IProperties$BooleanPropertyDelegate;", "darkTheme", "getDarkTheme", "setDarkTheme", "darkTheme$delegate", "lightTheme", "getLightTheme", "setLightTheme", "lightTheme$delegate", "backgroundRunning", "getBackgroundRunning", "setBackgroundRunning", "backgroundRunning$delegate", "confirmTabClose", "getConfirmTabClose", "setConfirmTabClose", "confirmTabClose$delegate", "backgroundImage", "getBackgroundImage", "setBackgroundImage", "backgroundImage$delegate", "language", "getLanguage", "setLanguage", "language$delegate", "Lapp/termora/database/DatabaseManager$IProperties$StringPropertyLazyDelegate;", "", "opacity", "getOpacity", "()D", "setOpacity", "(D)V", "opacity$delegate", "Lapp/termora/database/DatabaseManager$IProperties$DoublePropertyDelegate;", "termora"})
    public static final class Appearance
    extends IProperties {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final IProperties.StringPropertyDelegate theme$delegate;
        @NotNull
        private final IProperties.StringPropertyDelegate layout$delegate;
        @NotNull
        private final IProperties.StringPropertyDelegate tabOrder$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate followSystem$delegate;
        @NotNull
        private final IProperties.StringPropertyDelegate darkTheme$delegate;
        @NotNull
        private final IProperties.StringPropertyDelegate lightTheme$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate backgroundRunning$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate confirmTabClose$delegate;
        @NotNull
        private final IProperties.StringPropertyDelegate backgroundImage$delegate;
        @NotNull
        private final IProperties.StringPropertyLazyDelegate language$delegate;
        @NotNull
        private final IProperties.DoublePropertyDelegate opacity$delegate;

        public Appearance(@NotNull DatabaseManager databaseManager) {
            Intrinsics.checkNotNullParameter((Object)databaseManager, (String)"databaseManager");
            super(databaseManager, "Setting.Appearance");
            this.theme$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("Light");
            this.layout$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("Screen");
            this.tabOrder$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("Hide");
            this.followSystem$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(true);
            this.darkTheme$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("Dark");
            this.lightTheme$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("Light");
            this.backgroundRunning$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(false);
            this.confirmTabClose$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(false);
            this.backgroundImage$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("");
            this.language$delegate = (IProperties)this.new IProperties.StringPropertyLazyDelegate((Function0<String>)((Function0)Appearance::language_delegate$lambda$0));
            this.opacity$delegate = (IProperties)this.new IProperties.DoublePropertyDelegate(1.0);
        }

        @NotNull
        public final String getTheme() {
            return (String)this.theme$delegate.getValue(this, $$delegatedProperties[0]);
        }

        public final void setTheme(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.theme$delegate.setValue(this, $$delegatedProperties[0], string);
        }

        @NotNull
        public final String getLayout() {
            return (String)this.layout$delegate.getValue(this, $$delegatedProperties[1]);
        }

        public final void setLayout(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.layout$delegate.setValue(this, $$delegatedProperties[1], string);
        }

        @NotNull
        public final String getTabOrder() {
            return (String)this.tabOrder$delegate.getValue(this, $$delegatedProperties[2]);
        }

        public final void setTabOrder(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.tabOrder$delegate.setValue(this, $$delegatedProperties[2], string);
        }

        public final boolean getFollowSystem() {
            return (Boolean)this.followSystem$delegate.getValue(this, $$delegatedProperties[3]);
        }

        public final void setFollowSystem(boolean bl) {
            this.followSystem$delegate.setValue(this, $$delegatedProperties[3], bl);
        }

        @NotNull
        public final String getDarkTheme() {
            return (String)this.darkTheme$delegate.getValue(this, $$delegatedProperties[4]);
        }

        public final void setDarkTheme(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.darkTheme$delegate.setValue(this, $$delegatedProperties[4], string);
        }

        @NotNull
        public final String getLightTheme() {
            return (String)this.lightTheme$delegate.getValue(this, $$delegatedProperties[5]);
        }

        public final void setLightTheme(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.lightTheme$delegate.setValue(this, $$delegatedProperties[5], string);
        }

        public final boolean getBackgroundRunning() {
            return (Boolean)this.backgroundRunning$delegate.getValue(this, $$delegatedProperties[6]);
        }

        public final void setBackgroundRunning(boolean bl) {
            this.backgroundRunning$delegate.setValue(this, $$delegatedProperties[6], bl);
        }

        public final boolean getConfirmTabClose() {
            return (Boolean)this.confirmTabClose$delegate.getValue(this, $$delegatedProperties[7]);
        }

        public final void setConfirmTabClose(boolean bl) {
            this.confirmTabClose$delegate.setValue(this, $$delegatedProperties[7], bl);
        }

        @NotNull
        public final String getBackgroundImage() {
            return (String)this.backgroundImage$delegate.getValue(this, $$delegatedProperties[8]);
        }

        public final void setBackgroundImage(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.backgroundImage$delegate.setValue(this, $$delegatedProperties[8], string);
        }

        @NotNull
        public final String getLanguage() {
            return (String)this.language$delegate.getValue(this, $$delegatedProperties[9]);
        }

        public final void setLanguage(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.language$delegate.setValue(this, $$delegatedProperties[9], string);
        }

        public final double getOpacity() {
            return ((Number)this.opacity$delegate.getValue(this, $$delegatedProperties[10])).doubleValue();
        }

        public final void setOpacity(double d) {
            this.opacity$delegate.setValue(this, $$delegatedProperties[10], d);
        }

        private static final String language_delegate$lambda$0() {
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault(...)");
            String string = I18n.INSTANCE.containsLanguage(locale);
            if (string == null) {
                String string2 = Locale.US.toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            }
            return string;
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "theme", "getTheme()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "layout", "getLayout()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "tabOrder", "getTabOrder()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "followSystem", "getFollowSystem()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "darkTheme", "getDarkTheme()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "lightTheme", "getLightTheme()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "backgroundRunning", "getBackgroundRunning()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "confirmTabClose", "getConfirmTabClose()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "backgroundImage", "getBackgroundImage()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "language", "getLanguage()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Appearance.class, "opacity", "getOpacity()D", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lapp/termora/database/DatabaseManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "getLog", "()Lorg/slf4j/Logger;", "getInstance", "Lapp/termora/database/DatabaseManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final DatabaseManager getInstance() {
            return (DatabaseManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(DatabaseManager.class), Companion::getInstance$lambda$0);
        }

        private static final DatabaseManager getInstance$lambda$0() {
            return new DatabaseManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\f\b&\u0018\u00002\u00020\u0001:\t\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0014J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005H\u0014J\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000RT\u0010\b\u001aB\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005 \n* \u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005\u0012\f\u0012\n \n*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u000b0\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001d"}, d2={"Lapp/termora/database/DatabaseManager$IProperties;", "", "databaseManager", "Lapp/termora/database/DatabaseManager;", "name", "", "<init>", "(Lapp/termora/database/DatabaseManager;Ljava/lang/String;)V", "map", "", "kotlin.jvm.PlatformType", "", "getMap", "()Ljava/util/Map;", "getString", "key", "putString", "", "value", "getProperties", "PropertyLazyDelegate", "PropertyDelegate", "StringPropertyDelegate", "IntPropertyDelegate", "DoublePropertyDelegate", "LongPropertyDelegate", "BooleanPropertyDelegate", "StringPropertyLazyDelegate", "CursorStylePropertyDelegate", "termora"})
    public static abstract class IProperties {
        @NotNull
        private final DatabaseManager databaseManager;
        @NotNull
        private final String name;

        public IProperties(@NotNull DatabaseManager databaseManager, @NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)databaseManager, (String)"databaseManager");
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            this.databaseManager = databaseManager;
            this.name = name;
        }

        private final Map<String, String> getMap() {
            return this.databaseManager.map;
        }

        @Nullable
        protected String getString(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return this.databaseManager.getSetting(this.name + "." + key);
        }

        protected void putString(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            this.databaseManager.setSetting(this.name + "." + key, value);
            DatabasePropertiesChangedExtension.Companion.onPropertyChanged(this.name, key, value);
        }

        @NotNull
        public final Map<String, String> getProperties() {
            Map properties = new LinkedHashMap();
            for (Map.Entry<String, String> e : this.getMap().entrySet()) {
                String string;
                String string2 = e.getKey();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"<get-key>(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)(this.name + "."), (boolean)false, (int)2, null)) continue;
                Map map = properties;
                String string3 = e.getKey();
                if (e.getValue() == null) continue;
                map.put(string3, string);
            }
            return properties;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lapp/termora/database/DatabaseManager$IProperties$BooleanPropertyDelegate;", "Lapp/termora/database/DatabaseManager$IProperties$PropertyDelegate;", "", "Lapp/termora/database/DatabaseManager$IProperties;", "defaultValue", "<init>", "(Lapp/termora/database/DatabaseManager$IProperties;Z)V", "convertValue", "value", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "termora"})
        protected final class BooleanPropertyDelegate
        extends PropertyDelegate<Boolean> {
            public BooleanPropertyDelegate(boolean defaultValue) {
                super(defaultValue);
            }

            @Override
            @NotNull
            public Boolean convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Boolean bl = StringsKt.toBooleanStrictOrNull((String)value);
                return bl != null ? bl.booleanValue() : ((Boolean)this.getInitializer().invoke()).booleanValue();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0084\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lapp/termora/database/DatabaseManager$IProperties$CursorStylePropertyDelegate;", "Lapp/termora/database/DatabaseManager$IProperties$PropertyDelegate;", "Lapp/termora/terminal/CursorStyle;", "Lapp/termora/database/DatabaseManager$IProperties;", "defaultValue", "<init>", "(Lapp/termora/database/DatabaseManager$IProperties;Lapp/termora/terminal/CursorStyle;)V", "convertValue", "value", "", "termora"})
        protected final class CursorStylePropertyDelegate
        extends PropertyDelegate<CursorStyle> {
            public CursorStylePropertyDelegate(CursorStyle defaultValue) {
                Intrinsics.checkNotNullParameter((Object)((Object)defaultValue), (String)"defaultValue");
                super(defaultValue);
            }

            @Override
            @NotNull
            public CursorStyle convertValue(@NotNull String value) {
                CursorStyle cursorStyle;
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                try {
                    cursorStyle = CursorStyle.valueOf(value);
                }
                catch (Exception exception) {
                    cursorStyle = (CursorStyle)((Object)this.getInitializer().invoke());
                }
                return cursorStyle;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lapp/termora/database/DatabaseManager$IProperties$DoublePropertyDelegate;", "Lapp/termora/database/DatabaseManager$IProperties$PropertyDelegate;", "", "Lapp/termora/database/DatabaseManager$IProperties;", "defaultValue", "<init>", "(Lapp/termora/database/DatabaseManager$IProperties;D)V", "convertValue", "value", "", "(Ljava/lang/String;)Ljava/lang/Double;", "termora"})
        protected final class DoublePropertyDelegate
        extends PropertyDelegate<Double> {
            public DoublePropertyDelegate(double defaultValue) {
                super(defaultValue);
            }

            @Override
            @NotNull
            public Double convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Double d = StringsKt.toDoubleOrNull((String)value);
                return d != null ? d.doubleValue() : ((Number)this.getInitializer().invoke()).doubleValue();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lapp/termora/database/DatabaseManager$IProperties$IntPropertyDelegate;", "Lapp/termora/database/DatabaseManager$IProperties$PropertyDelegate;", "", "Lapp/termora/database/DatabaseManager$IProperties;", "defaultValue", "<init>", "(Lapp/termora/database/DatabaseManager$IProperties;I)V", "convertValue", "value", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "termora"})
        protected final class IntPropertyDelegate
        extends PropertyDelegate<Integer> {
            public IntPropertyDelegate(int defaultValue) {
                super(defaultValue);
            }

            @Override
            @NotNull
            public Integer convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Integer n = StringsKt.toIntOrNull((String)value);
                return n != null ? n.intValue() : ((Number)this.getInitializer().invoke()).intValue();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lapp/termora/database/DatabaseManager$IProperties$LongPropertyDelegate;", "Lapp/termora/database/DatabaseManager$IProperties$PropertyDelegate;", "", "Lapp/termora/database/DatabaseManager$IProperties;", "defaultValue", "<init>", "(Lapp/termora/database/DatabaseManager$IProperties;J)V", "convertValue", "value", "", "(Ljava/lang/String;)Ljava/lang/Long;", "termora"})
        protected final class LongPropertyDelegate
        extends PropertyDelegate<Long> {
            public LongPropertyDelegate(long defaultValue) {
                super(defaultValue);
            }

            @Override
            @NotNull
            public Long convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Long l = StringsKt.toLongOrNull((String)value);
                return l != null ? l.longValue() : ((Number)this.getInitializer().invoke()).longValue();
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00a4\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\f\u0012\u0004\u0012\u0002H\u00010\u0002R\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0004\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lapp/termora/database/DatabaseManager$IProperties$PropertyDelegate;", "T", "Lapp/termora/database/DatabaseManager$IProperties$PropertyLazyDelegate;", "Lapp/termora/database/DatabaseManager$IProperties;", "defaultValue", "<init>", "(Lapp/termora/database/DatabaseManager$IProperties;Ljava/lang/Object;)V", "Ljava/lang/Object;", "termora"})
        protected abstract class PropertyDelegate<T>
        extends PropertyLazyDelegate<T> {
            private final T defaultValue;

            public PropertyDelegate(T defaultValue) {
                super(() -> PropertyDelegate._init_$lambda$0(defaultValue));
                this.defaultValue = defaultValue;
            }

            private static final Object _init_$lambda$0(Object $defaultValue) {
                return $defaultValue;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00a4\u0004\u0018\u0000*\u0004\b\u0000\u0010\u00012\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0003\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J$\u0010\f\u001a\u00028\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u00032\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000fH\u0096\u0002\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00028\u00002\u0006\u0010\n\u001a\u00020\u0012H&\u00a2\u0006\u0002\u0010\u0013J,\u0010\u0014\u001a\u00020\u00152\b\u0010\r\u001a\u0004\u0018\u00010\u00032\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u000f2\u0006\u0010\n\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u0004\u0018\u00018\u0000X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lapp/termora/database/DatabaseManager$IProperties$PropertyLazyDelegate;", "T", "Lkotlin/properties/ReadWriteProperty;", "", "initializer", "Lkotlin/Function0;", "<init>", "(Lapp/termora/database/DatabaseManager$IProperties;Lkotlin/jvm/functions/Function0;)V", "getInitializer", "()Lkotlin/jvm/functions/Function0;", "value", "Ljava/lang/Object;", "getValue", "thisRef", "property", "Lkotlin/reflect/KProperty;", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;)Ljava/lang/Object;", "convertValue", "", "(Ljava/lang/String;)Ljava/lang/Object;", "setValue", "", "(Ljava/lang/Object;Lkotlin/reflect/KProperty;Ljava/lang/Object;)V", "termora"})
        protected abstract class PropertyLazyDelegate<T>
        implements ReadWriteProperty<Object, T> {
            @NotNull
            private final Function0<T> initializer;
            @Nullable
            private T value;

            public PropertyLazyDelegate(Function0<? extends T> initializer) {
                Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
                this.initializer = initializer;
            }

            @NotNull
            protected final Function0<T> getInitializer() {
                return this.initializer;
            }

            public T getValue(@Nullable Object thisRef, @NotNull KProperty<?> property) {
                Intrinsics.checkNotNullParameter(property, (String)"property");
                if (this.value == null) {
                    String v = IProperties.this.getString(property.getName());
                    T t = this.value = v == null ? this.initializer.invoke() : this.convertValue(v);
                }
                if (this.value == null) {
                    this.value = this.initializer.invoke();
                }
                T t = this.value;
                Intrinsics.checkNotNull(t);
                return t;
            }

            public abstract T convertValue(@NotNull String var1);

            public void setValue(@Nullable Object thisRef, @NotNull KProperty<?> property, T value) {
                Intrinsics.checkNotNullParameter(property, (String)"property");
                this.value = value;
                IProperties.this.putString(property.getName(), String.valueOf(value));
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0084\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\u0002H\u0016\u00a8\u0006\t"}, d2={"Lapp/termora/database/DatabaseManager$IProperties$StringPropertyDelegate;", "Lapp/termora/database/DatabaseManager$IProperties$PropertyDelegate;", "", "Lapp/termora/database/DatabaseManager$IProperties;", "defaultValue", "<init>", "(Lapp/termora/database/DatabaseManager$IProperties;Ljava/lang/String;)V", "convertValue", "value", "termora"})
        protected final class StringPropertyDelegate
        extends PropertyDelegate<String> {
            public StringPropertyDelegate(String defaultValue) {
                Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
                super(defaultValue);
            }

            @Override
            @NotNull
            public String convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value;
            }
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0094\u0004\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001R\u00020\u0003B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\n"}, d2={"Lapp/termora/database/DatabaseManager$IProperties$StringPropertyLazyDelegate;", "Lapp/termora/database/DatabaseManager$IProperties$PropertyLazyDelegate;", "", "Lapp/termora/database/DatabaseManager$IProperties;", "initializer", "Lkotlin/Function0;", "<init>", "(Lapp/termora/database/DatabaseManager$IProperties;Lkotlin/jvm/functions/Function0;)V", "convertValue", "value", "termora"})
        protected class StringPropertyLazyDelegate
        extends PropertyLazyDelegate<String> {
            public StringPropertyLazyDelegate(Function0<String> initializer) {
                Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
                super(initializer);
            }

            @Override
            @NotNull
            public String convertValue(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return value;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u0007H\u0016J\u0016\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lapp/termora/database/DatabaseManager$Properties;", "Lapp/termora/database/DatabaseManager$IProperties;", "databaseManager", "Lapp/termora/database/DatabaseManager;", "<init>", "(Lapp/termora/database/DatabaseManager;)V", "getString", "", "key", "defaultValue", "putString", "", "value", "termora"})
    public static final class Properties
    extends IProperties {
        public Properties(@NotNull DatabaseManager databaseManager) {
            Intrinsics.checkNotNullParameter((Object)databaseManager, (String)"databaseManager");
            super(databaseManager, "Setting.Properties");
        }

        @Override
        @Nullable
        public String getString(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            return super.getString(key);
        }

        @NotNull
        public final String getString(@NotNull String key, @NotNull String defaultValue) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            String string = this.getString(key);
            if (string == null) {
                string = defaultValue;
            }
            return string;
        }

        @Override
        public void putString(@NotNull String key, @NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super.putString(key, value);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR+\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000e\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\fR+\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u000e\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR+\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001a\u0010\u000e\u001a\u0004\b\u0018\u0010\n\"\u0004\b\u0019\u0010\fR+\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u001b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b!\u0010\"\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R+\u0010#\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u001b8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b&\u0010\"\u001a\u0004\b$\u0010\u001e\"\u0004\b%\u0010 \u00a8\u0006'"}, d2={"Lapp/termora/database/DatabaseManager$SFTP;", "Lapp/termora/database/DatabaseManager$IProperties;", "databaseManager", "Lapp/termora/database/DatabaseManager;", "<init>", "(Lapp/termora/database/DatabaseManager;)V", "<set-?>", "", "editCommand", "getEditCommand", "()Ljava/lang/String;", "setEditCommand", "(Ljava/lang/String;)V", "editCommand$delegate", "Lapp/termora/database/DatabaseManager$IProperties$StringPropertyDelegate;", "dbClickBehavior", "getDbClickBehavior", "setDbClickBehavior", "dbClickBehavior$delegate", "sftpCommand", "getSftpCommand", "setSftpCommand", "sftpCommand$delegate", "defaultDirectory", "getDefaultDirectory", "setDefaultDirectory", "defaultDirectory$delegate", "", "pinTab", "getPinTab", "()Z", "setPinTab", "(Z)V", "pinTab$delegate", "Lapp/termora/database/DatabaseManager$IProperties$BooleanPropertyDelegate;", "preserveModificationTime", "getPreserveModificationTime", "setPreserveModificationTime", "preserveModificationTime$delegate", "termora"})
    public static final class SFTP
    extends IProperties {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final IProperties.StringPropertyDelegate editCommand$delegate;
        @NotNull
        private final IProperties.StringPropertyDelegate dbClickBehavior$delegate;
        @NotNull
        private final IProperties.StringPropertyDelegate sftpCommand$delegate;
        @NotNull
        private final IProperties.StringPropertyDelegate defaultDirectory$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate pinTab$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate preserveModificationTime$delegate;

        public SFTP(@NotNull DatabaseManager databaseManager) {
            Intrinsics.checkNotNullParameter((Object)databaseManager, (String)"databaseManager");
            super(databaseManager, "Setting.SFTP");
            this.editCommand$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("");
            this.dbClickBehavior$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("Transfer");
            this.sftpCommand$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("");
            this.defaultDirectory$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("");
            this.pinTab$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(false);
            this.preserveModificationTime$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(false);
        }

        @NotNull
        public final String getEditCommand() {
            return (String)this.editCommand$delegate.getValue(this, $$delegatedProperties[0]);
        }

        public final void setEditCommand(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.editCommand$delegate.setValue(this, $$delegatedProperties[0], string);
        }

        @NotNull
        public final String getDbClickBehavior() {
            return (String)this.dbClickBehavior$delegate.getValue(this, $$delegatedProperties[1]);
        }

        public final void setDbClickBehavior(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.dbClickBehavior$delegate.setValue(this, $$delegatedProperties[1], string);
        }

        @NotNull
        public final String getSftpCommand() {
            return (String)this.sftpCommand$delegate.getValue(this, $$delegatedProperties[2]);
        }

        public final void setSftpCommand(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.sftpCommand$delegate.setValue(this, $$delegatedProperties[2], string);
        }

        @NotNull
        public final String getDefaultDirectory() {
            return (String)this.defaultDirectory$delegate.getValue(this, $$delegatedProperties[3]);
        }

        public final void setDefaultDirectory(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.defaultDirectory$delegate.setValue(this, $$delegatedProperties[3], string);
        }

        public final boolean getPinTab() {
            return (Boolean)this.pinTab$delegate.getValue(this, $$delegatedProperties[4]);
        }

        public final void setPinTab(boolean bl) {
            this.pinTab$delegate.setValue(this, $$delegatedProperties[4], bl);
        }

        public final boolean getPreserveModificationTime() {
            return (Boolean)this.preserveModificationTime$delegate.getValue(this, $$delegatedProperties[5]);
        }

        public final void setPreserveModificationTime(boolean bl) {
            this.preserveModificationTime$delegate.setValue(this, $$delegatedProperties[5], bl);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SFTP.class, "editCommand", "getEditCommand()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SFTP.class, "dbClickBehavior", "getDbClickBehavior()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SFTP.class, "sftpCommand", "getSftpCommand()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SFTP.class, "defaultDirectory", "getDefaultDirectory()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SFTP.class, "pinTab", "getPinTab()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(SFTP.class, "preserveModificationTime", "getPreserveModificationTime()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u001b\n\u0002\u0018\u0002\n\u0002\b\u0010\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R+\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR+\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0012\u0010\u000e\u001a\u0004\b\u0010\u0010\n\"\u0004\b\u0011\u0010\fR+\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR+\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00188F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR+\u0010 \u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u00188F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\u001f\u001a\u0004\b!\u0010\u001b\"\u0004\b\"\u0010\u001dR+\u0010%\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020$8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010+\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R+\u0010,\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020$8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b/\u0010+\u001a\u0004\b-\u0010'\"\u0004\b.\u0010)R+\u00100\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020$8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b3\u0010+\u001a\u0004\b1\u0010'\"\u0004\b2\u0010)R+\u00104\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020$8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b7\u0010+\u001a\u0004\b5\u0010'\"\u0004\b6\u0010)R+\u00108\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020$8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b;\u0010+\u001a\u0004\b9\u0010'\"\u0004\b:\u0010)R+\u0010<\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b?\u0010\u000e\u001a\u0004\b=\u0010\n\"\u0004\b>\u0010\fR+\u0010A\u001a\u00020@2\u0006\u0010\u0006\u001a\u00020@8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bF\u0010G\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER+\u0010H\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020$8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bK\u0010+\u001a\u0004\bI\u0010'\"\u0004\bJ\u0010)R+\u0010L\u001a\u00020$2\u0006\u0010\u0006\u001a\u00020$8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bO\u0010+\u001a\u0004\bM\u0010'\"\u0004\bN\u0010)\u00a8\u0006P"}, d2={"Lapp/termora/database/DatabaseManager$Terminal;", "Lapp/termora/database/DatabaseManager$IProperties;", "databaseManager", "Lapp/termora/database/DatabaseManager;", "<init>", "(Lapp/termora/database/DatabaseManager;)V", "<set-?>", "", "font", "getFont", "()Ljava/lang/String;", "setFont", "(Ljava/lang/String;)V", "font$delegate", "Lapp/termora/database/DatabaseManager$IProperties$StringPropertyDelegate;", "fallbackFont", "getFallbackFont", "setFallbackFont", "fallbackFont$delegate", "localShell", "getLocalShell", "setLocalShell", "localShell$delegate", "Lapp/termora/database/DatabaseManager$IProperties$StringPropertyLazyDelegate;", "", "fontSize", "getFontSize", "()I", "setFontSize", "(I)V", "fontSize$delegate", "Lapp/termora/database/DatabaseManager$IProperties$IntPropertyDelegate;", "maxRows", "getMaxRows", "setMaxRows", "maxRows$delegate", "", "debug", "getDebug", "()Z", "setDebug", "(Z)V", "debug$delegate", "Lapp/termora/database/DatabaseManager$IProperties$BooleanPropertyDelegate;", "beep", "getBeep", "setBeep", "beep$delegate", "hyperlink", "getHyperlink", "setHyperlink", "hyperlink$delegate", "cursorBlink", "getCursorBlink", "setCursorBlink", "cursorBlink$delegate", "selectCopy", "getSelectCopy", "setSelectCopy", "selectCopy$delegate", "rightClick", "getRightClick", "setRightClick", "rightClick$delegate", "Lapp/termora/terminal/CursorStyle;", "cursor", "getCursor", "()Lapp/termora/terminal/CursorStyle;", "setCursor", "(Lapp/termora/terminal/CursorStyle;)V", "cursor$delegate", "Lapp/termora/database/DatabaseManager$IProperties$CursorStylePropertyDelegate;", "autoCloseTabWhenDisconnected", "getAutoCloseTabWhenDisconnected", "setAutoCloseTabWhenDisconnected", "autoCloseTabWhenDisconnected$delegate", "floatingToolbar", "getFloatingToolbar", "setFloatingToolbar", "floatingToolbar$delegate", "termora"})
    public static final class Terminal
    extends IProperties {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final IProperties.StringPropertyDelegate font$delegate;
        @NotNull
        private final IProperties.StringPropertyDelegate fallbackFont$delegate;
        @NotNull
        private final IProperties.StringPropertyLazyDelegate localShell$delegate;
        @NotNull
        private final IProperties.IntPropertyDelegate fontSize$delegate;
        @NotNull
        private final IProperties.IntPropertyDelegate maxRows$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate debug$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate beep$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate hyperlink$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate cursorBlink$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate selectCopy$delegate;
        @NotNull
        private final IProperties.StringPropertyDelegate rightClick$delegate;
        @NotNull
        private final IProperties.CursorStylePropertyDelegate cursor$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate autoCloseTabWhenDisconnected$delegate;
        @NotNull
        private final IProperties.BooleanPropertyDelegate floatingToolbar$delegate;

        public Terminal(@NotNull DatabaseManager databaseManager) {
            Intrinsics.checkNotNullParameter((Object)databaseManager, (String)"databaseManager");
            super(databaseManager, "Setting.Terminal");
            this.font$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("JetBrains Mono");
            this.fallbackFont$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("");
            this.localShell$delegate = (IProperties)this.new IProperties.StringPropertyLazyDelegate((Function0<String>)((Function0)Terminal::localShell_delegate$lambda$0));
            this.fontSize$delegate = (IProperties)this.new IProperties.IntPropertyDelegate(14);
            this.maxRows$delegate = (IProperties)this.new IProperties.IntPropertyDelegate(5000);
            this.debug$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(false);
            this.beep$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(true);
            this.hyperlink$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(true);
            this.cursorBlink$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(false);
            this.selectCopy$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(false);
            this.rightClick$delegate = (IProperties)this.new IProperties.StringPropertyDelegate("Copy");
            this.cursor$delegate = (IProperties)this.new IProperties.CursorStylePropertyDelegate(CursorStyle.Block);
            this.autoCloseTabWhenDisconnected$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(false);
            this.floatingToolbar$delegate = (IProperties)this.new IProperties.BooleanPropertyDelegate(true);
        }

        @NotNull
        public final String getFont() {
            return (String)this.font$delegate.getValue(this, $$delegatedProperties[0]);
        }

        public final void setFont(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.font$delegate.setValue(this, $$delegatedProperties[0], string);
        }

        @NotNull
        public final String getFallbackFont() {
            return (String)this.fallbackFont$delegate.getValue(this, $$delegatedProperties[1]);
        }

        public final void setFallbackFont(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.fallbackFont$delegate.setValue(this, $$delegatedProperties[1], string);
        }

        @NotNull
        public final String getLocalShell() {
            return (String)this.localShell$delegate.getValue(this, $$delegatedProperties[2]);
        }

        public final void setLocalShell(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.localShell$delegate.setValue(this, $$delegatedProperties[2], string);
        }

        public final int getFontSize() {
            return ((Number)this.fontSize$delegate.getValue(this, $$delegatedProperties[3])).intValue();
        }

        public final void setFontSize(int n) {
            this.fontSize$delegate.setValue(this, $$delegatedProperties[3], n);
        }

        public final int getMaxRows() {
            return ((Number)this.maxRows$delegate.getValue(this, $$delegatedProperties[4])).intValue();
        }

        public final void setMaxRows(int n) {
            this.maxRows$delegate.setValue(this, $$delegatedProperties[4], n);
        }

        public final boolean getDebug() {
            return (Boolean)this.debug$delegate.getValue(this, $$delegatedProperties[5]);
        }

        public final void setDebug(boolean bl) {
            this.debug$delegate.setValue(this, $$delegatedProperties[5], bl);
        }

        public final boolean getBeep() {
            return (Boolean)this.beep$delegate.getValue(this, $$delegatedProperties[6]);
        }

        public final void setBeep(boolean bl) {
            this.beep$delegate.setValue(this, $$delegatedProperties[6], bl);
        }

        public final boolean getHyperlink() {
            return (Boolean)this.hyperlink$delegate.getValue(this, $$delegatedProperties[7]);
        }

        public final void setHyperlink(boolean bl) {
            this.hyperlink$delegate.setValue(this, $$delegatedProperties[7], bl);
        }

        public final boolean getCursorBlink() {
            return (Boolean)this.cursorBlink$delegate.getValue(this, $$delegatedProperties[8]);
        }

        public final void setCursorBlink(boolean bl) {
            this.cursorBlink$delegate.setValue(this, $$delegatedProperties[8], bl);
        }

        public final boolean getSelectCopy() {
            return (Boolean)this.selectCopy$delegate.getValue(this, $$delegatedProperties[9]);
        }

        public final void setSelectCopy(boolean bl) {
            this.selectCopy$delegate.setValue(this, $$delegatedProperties[9], bl);
        }

        @NotNull
        public final String getRightClick() {
            return (String)this.rightClick$delegate.getValue(this, $$delegatedProperties[10]);
        }

        public final void setRightClick(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.rightClick$delegate.setValue(this, $$delegatedProperties[10], string);
        }

        @NotNull
        public final CursorStyle getCursor() {
            return (CursorStyle)((Object)this.cursor$delegate.getValue(this, $$delegatedProperties[11]));
        }

        public final void setCursor(@NotNull CursorStyle cursorStyle) {
            Intrinsics.checkNotNullParameter((Object)((Object)cursorStyle), (String)"<set-?>");
            this.cursor$delegate.setValue(this, $$delegatedProperties[11], cursorStyle);
        }

        public final boolean getAutoCloseTabWhenDisconnected() {
            return (Boolean)this.autoCloseTabWhenDisconnected$delegate.getValue(this, $$delegatedProperties[12]);
        }

        public final void setAutoCloseTabWhenDisconnected(boolean bl) {
            this.autoCloseTabWhenDisconnected$delegate.setValue(this, $$delegatedProperties[12], bl);
        }

        public final boolean getFloatingToolbar() {
            return (Boolean)this.floatingToolbar$delegate.getValue(this, $$delegatedProperties[13]);
        }

        public final void setFloatingToolbar(boolean bl) {
            this.floatingToolbar$delegate.setValue(this, $$delegatedProperties[13], bl);
        }

        private static final String localShell_delegate$lambda$0() {
            return Application.INSTANCE.getDefaultShell();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "font", "getFont()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "fallbackFont", "getFallbackFont()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "localShell", "getLocalShell()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "fontSize", "getFontSize()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "maxRows", "getMaxRows()I", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "debug", "getDebug()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "beep", "getBeep()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "hyperlink", "getHyperlink()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "cursorBlink", "getCursorBlink()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "selectCopy", "getSelectCopy()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "rightClick", "getRightClick()Ljava/lang/String;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "cursor", "getCursor()Lapp/termora/terminal/CursorStyle;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "autoCloseTabWhenDisconnected", "getAutoCloseTabWhenDisconnected()Z", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(Terminal.class, "floatingToolbar", "getFloatingToolbar()Z", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

