/*
 * Decompiled with CFR 0.152.
 */
package app.termora.keymap;

import app.termora.ApplicationScope;
import app.termora.Disposable;
import app.termora.account.AccountManager;
import app.termora.database.Data;
import app.termora.database.DataType;
import app.termora.database.DatabaseManager;
import app.termora.keymap.Keymap;
import app.termora.keymap.MacOSKeymap;
import app.termora.keymap.WindowsKeymap;
import com.formdev.flatlaf.util.SystemInfo;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u0000 !2\u00020\u0001:\u0001!B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0016\u001a\u00020\u000fJ\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0019\u001a\u00020\u000eJ\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bJ\u000e\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u000fJ\u000e\u0010\u001f\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u000eR\u0014\u0010\u0004\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\rj\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\""}, d2={"Lapp/termora/keymap/KeymapManager;", "Lapp/termora/Disposable;", "<init>", "()V", "database", "Lapp/termora/database/DatabaseManager;", "getDatabase", "()Lapp/termora/database/DatabaseManager;", "properties", "Lapp/termora/database/DatabaseManager$Properties;", "getProperties", "()Lapp/termora/database/DatabaseManager$Properties;", "keymaps", "Ljava/util/LinkedHashMap;", "", "Lapp/termora/keymap/Keymap;", "Lkotlin/collections/LinkedHashMap;", "accountManager", "Lapp/termora/account/AccountManager;", "getAccountManager", "()Lapp/termora/account/AccountManager;", "activeKeymap", "getActiveKeymap", "()Ljava/lang/String;", "getKeymap", "name", "getKeymaps", "", "addKeymap", "", "keymap", "removeKeymap", "id", "Companion", "termora"})
@SourceDebugExtension(value={"SMAP\nKeymapManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KeymapManager.kt\napp/termora/keymap/KeymapManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,103:1\n1#2:104\n37#3,2:105\n*S KotlinDebug\n*F\n+ 1 KeymapManager.kt\napp/termora/keymap/KeymapManager\n*L\n95#1:105,2\n*E\n"})
public final class KeymapManager
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LinkedHashMap<String, Keymap> keymaps;
    private static final Logger log = LoggerFactory.getLogger(KeymapManager.class);

    private KeymapManager() {
        block5: {
            this.keymaps = new LinkedHashMap();
            try {
                for (Data data : this.getDatabase().rawData(DataType.Keymap)) {
                    try {
                        Keymap keymap;
                        if (Keymap.Companion.fromJSON(data.getData()) == null) continue;
                        ((Map)this.keymaps).put(keymap.getName(), keymap);
                    }
                    catch (Exception e) {
                        if (!log.isWarnEnabled()) continue;
                        log.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block5;
                log.error(e.getMessage(), (Throwable)e);
            }
        }
        Keymap it = MacOSKeymap.Companion.getInstance();
        boolean bl = false;
        ((Map)this.keymaps).put(it.getName(), it);
        it = WindowsKeymap.Companion.getInstance();
        boolean bl2 = false;
        ((Map)this.keymaps).put(it.getName(), it);
    }

    private final DatabaseManager getDatabase() {
        return DatabaseManager.Companion.getInstance();
    }

    private final DatabaseManager.Properties getProperties() {
        return DatabaseManager.Companion.getInstance().getProperties();
    }

    private final AccountManager getAccountManager() {
        return AccountManager.Companion.getInstance();
    }

    private final String getActiveKeymap() {
        return this.getProperties().getString("Keymap.Active");
    }

    @NotNull
    public final Keymap getActiveKeymap() {
        Keymap keymap;
        String name = this.getActiveKeymap();
        if (name != null && (keymap = this.getKeymap(name)) != null) {
            return keymap;
        }
        return SystemInfo.isMacOS ? (Keymap)MacOSKeymap.Companion.getInstance() : (Keymap)WindowsKeymap.Companion.getInstance();
    }

    @Nullable
    public final Keymap getKeymap(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.keymaps.get(name);
    }

    @NotNull
    public final List<Keymap> getKeymaps() {
        Collection<Keymap> collection = this.keymaps.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    public final void addKeymap(@NotNull Keymap keymap) {
        Intrinsics.checkNotNullParameter((Object)keymap, (String)"keymap");
        this.keymaps.putFirst(keymap.getName(), keymap);
        String accountId = this.getAccountManager().getAccountId();
        DatabaseManager.saveAndIncrementVersion$default(this.getDatabase(), new Data(keymap.getId(), accountId, "User", "Keymap", keymap.toJSON(), 0L, false, false, 224, null), null, 2, null);
    }

    public final void removeKeymap(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Set<String> set = this.keymaps.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Collection $this$toTypedArray$iv = set;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        for (String name : thisCollection$iv.toArray(new String[0])) {
            if (!Intrinsics.areEqual((Object)((Keymap)MapsKt.getValue((Map)this.keymaps, (Object)name)).getId(), (Object)id)) continue;
            this.keymaps.remove(name);
        }
        DatabaseManager.delete$default(this.getDatabase(), id, "Keymap", null, 4, null);
    }

    public /* synthetic */ KeymapManager(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bR\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lapp/termora/keymap/KeymapManager$Companion;", "", "<init>", "()V", "log", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getInstance", "Lapp/termora/keymap/KeymapManager;", "termora"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final KeymapManager getInstance() {
            return (KeymapManager)ApplicationScope.Companion.forApplicationScope().getOrCreate(Reflection.getOrCreateKotlinClass(KeymapManager.class), Companion::getInstance$lambda$0);
        }

        private static final KeymapManager getInstance$lambda$0() {
            return new KeymapManager(null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

