/*
 * Decompiled with CFR 0.152.
 */
package app.termora.macro;

import app.termora.CryptoKt;
import app.termora.DialogWrapper;
import app.termora.DynamicColor;
import app.termora.I18n;
import app.termora.OptionPane;
import app.termora.WindowScope;
import app.termora.actions.AnAction;
import app.termora.actions.AnActionEvent;
import app.termora.actions.DataProviders;
import app.termora.macro.Macro;
import app.termora.macro.MacroAction;
import app.termora.macro.MacroManager;
import com.formdev.flatlaf.util.SystemInfo;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jdesktop.swingx.action.ActionManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u0018H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\n\u0010\u001c\u001a\u0004\u0018\u00010\u001bH\u0014R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0010\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\b0\b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lapp/termora/macro/MacroDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "<init>", "(Ljava/awt/Window;)V", "model", "Ljavax/swing/DefaultListModel;", "Lapp/termora/macro/Macro;", "list", "Ljavax/swing/JList;", "kotlin.jvm.PlatformType", "macroManager", "Lapp/termora/macro/MacroManager;", "getMacroManager", "()Lapp/termora/macro/MacroManager;", "macroManager$delegate", "Lkotlin/Lazy;", "runBtn", "Ljavax/swing/JButton;", "editBtn", "copyBtn", "deleteBtn", "initView", "", "initEvents", "createCenterPanel", "Ljavax/swing/JComponent;", "createSouthPanel", "termora"})
@SourceDebugExtension(value={"SMAP\nMacroDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacroDialog.kt\napp/termora/macro/MacroDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,189:1\n1#2:190\n*E\n"})
public final class MacroDialog
extends DialogWrapper {
    @NotNull
    private final DefaultListModel<Macro> model;
    @NotNull
    private final JList<Macro> list;
    @NotNull
    private final Lazy macroManager$delegate;
    @NotNull
    private final JButton runBtn;
    @NotNull
    private final JButton editBtn;
    @NotNull
    private final JButton copyBtn;
    @NotNull
    private final JButton deleteBtn;

    public MacroDialog(@NotNull Window owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super(owner);
        this.model = new DefaultListModel();
        this.list = new JList(this.model);
        this.macroManager$delegate = LazyKt.lazy(MacroDialog::macroManager_delegate$lambda$0);
        this.runBtn = new JButton(I18n.INSTANCE.getString("termora.macro.run"));
        this.editBtn = new JButton(I18n.INSTANCE.getString("termora.keymgr.edit"));
        this.copyBtn = new JButton(I18n.INSTANCE.getString("termora.copy"));
        this.deleteBtn = new JButton(I18n.INSTANCE.getString("termora.remove"));
        this.setSize(new Dimension(UIManager.getInt("Dialog.width"), UIManager.getInt("Dialog.height")));
        this.setModal(true);
        this.setTitle(I18n.INSTANCE.getString("termora.macro.manager"));
        this.initView();
        this.initEvents();
        this.init();
        this.setLocationRelativeTo(owner);
    }

    private final MacroManager getMacroManager() {
        Lazy lazy = this.macroManager$delegate;
        return (MacroManager)lazy.getValue();
    }

    private final void initView() {
        this.copyBtn.setEnabled(false);
        this.runBtn.setEnabled(false);
        this.editBtn.setEnabled(false);
        this.deleteBtn.setEnabled(false);
        this.list.setFixedCellHeight(UIManager.getInt("Tree.rowHeight"));
        this.list.setSelectionMode(2);
        this.list.setCellRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof Macro) {
                    Color color = UIManager.getColor("TextField.placeholderForeground");
                    Component component = super.getListCellRendererComponent(list, "<html>" + ((Macro)value).getName() + " <font color=rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")>" + new String(((Macro)value).getMacroByteArray(), Charsets.UTF_8) + "</font></html>", index, isSelected, cellHasFocus);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                    return component;
                }
                Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                return component;
            }
        });
        this.model.addAll((Collection<Macro>)this.getMacroManager().getMacros());
    }

    private final void initEvents() {
        this.editBtn.addActionListener(arg_0 -> MacroDialog.initEvents$lambda$0(this, arg_0));
        this.deleteBtn.addActionListener(arg_0 -> MacroDialog.initEvents$lambda$1(this, arg_0));
        this.runBtn.addActionListener((ActionListener)((Object)new AnAction(this){
            final /* synthetic */ MacroDialog this$0;
            {
                this.this$0 = $receiver;
            }

            protected void actionPerformed(AnActionEvent evt) {
                Action macroAction;
                Intrinsics.checkNotNullParameter((Object)evt, (String)"evt");
                WindowScope windowScope = evt.getData(DataProviders.INSTANCE.getWindowScope());
                if (windowScope == null) {
                    return;
                }
                WindowScope windowScope2 = windowScope;
                int index = MacroDialog.access$getList$p(this.this$0).getSelectedIndex();
                if (index >= 0 && (macroAction = ActionManager.getInstance().getAction((Object)"MacroAction")) instanceof MacroAction) {
                    MacroAction macroAction2 = (MacroAction)((Object)macroAction);
                    E e = MacroDialog.access$getModel$p(this.this$0).getElementAt(index);
                    Intrinsics.checkNotNullExpressionValue(e, (String)"getElementAt(...)");
                    macroAction2.runMacro(windowScope2, (Macro)e);
                }
            }
        }));
        this.copyBtn.addActionListener(arg_0 -> MacroDialog.initEvents$lambda$2(this, arg_0));
        this.list.getSelectionModel().addListSelectionListener(arg_0 -> MacroDialog.initEvents$lambda$3(this, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected JComponent createCenterPanel() {
        FormBuilder formBuilder;
        void $this$createCenterPanel_u24lambda_u240;
        JScrollPane jScrollPane;
        JPanel panel2 = new JPanel(new BorderLayout());
        JScrollPane jScrollPane2 = jScrollPane = new JScrollPane(this.list);
        JPanel jPanel = panel2;
        boolean bl = false;
        $this$createCenterPanel_u24lambda_u240.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, DynamicColor.Companion.getBorderColor()));
        jPanel.add((Component)jScrollPane, "Center");
        int rows = 0;
        rows = 1;
        int step = 2;
        String formMargin = "4dlu";
        FormLayout layout = new FormLayout("default:grow", "pref, " + formMargin + ", pref, " + formMargin + ", pref, " + formMargin + ", pref");
        FormBuilder formBuilder2 = formBuilder = FormBuilder.create().layout(layout).padding(new EmptyBorder(0, 12, 0, 0)).add((Component)this.runBtn).xy(1, rows);
        jPanel = panel2;
        boolean bl2 = false;
        FormBuilder $this$createCenterPanel_u24lambda_u241 = formBuilder = formBuilder.add((Component)this.copyBtn).xy(1, rows += step);
        boolean bl3 = false;
        FormBuilder $this$createCenterPanel_u24lambda_u242 = formBuilder = formBuilder.add((Component)this.editBtn).xy(1, rows += step);
        boolean bl4 = false;
        FormBuilder $this$createCenterPanel_u24lambda_u243 = formBuilder = formBuilder.add((Component)this.deleteBtn).xy(1, rows += step);
        boolean bl5 = false;
        rows += step;
        jPanel.add((Component)formBuilder.build(), "East");
        panel2.setBorder(BorderFactory.createEmptyBorder(SystemInfo.isWindows || SystemInfo.isLinux ? 6 : 0, 12, 12, 12));
        return panel2;
    }

    @Override
    @Nullable
    protected JComponent createSouthPanel() {
        return null;
    }

    private static final MacroManager macroManager_delegate$lambda$0() {
        return MacroManager.Companion.getInstance();
    }

    private static final void initEvents$lambda$0(MacroDialog this$0, ActionEvent it) {
        int index = this$0.list.getSelectedIndex();
        if (index >= 0) {
            String text;
            Macro macro = this$0.model.getElementAt(index);
            String string = OptionPane.showInputDialog$default(OptionPane.INSTANCE, this$0, macro.getName(), macro.getName(), null, 8, null);
            if (string == null) {
                string = new String();
            }
            if (!StringsKt.isBlank((CharSequence)(text = string))) {
                Intrinsics.checkNotNull((Object)macro);
                Macro newMacro = Macro.copy$default(macro, null, null, text, 0L, 0L, 0L, 59, null);
                this$0.getMacroManager().addMacro(newMacro);
                this$0.model.setElementAt(newMacro, index);
            }
        }
    }

    private static final void initEvents$lambda$1(MacroDialog this$0, ActionEvent it) {
        if (this$0.list.getSelectionModel().getSelectedItemsCount() > 0 && OptionPane.showConfirmDialog$default(OptionPane.INSTANCE, SwingUtilities.getWindowAncestor(this$0), I18n.INSTANCE.getString("termora.keymgr.delete-warning"), null, 0, 2, null, null, null, null, 492, null) == 0) {
            int[] nArray = this$0.list.getSelectionModel().getSelectedIndices();
            Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedIndices(...)");
            Iterator iterator2 = ArraysKt.sortedDescending((int[])nArray).iterator();
            while (iterator2.hasNext()) {
                int e = ((Number)iterator2.next()).intValue();
                Macro macro = this$0.model.getElementAt(e);
                this$0.model.removeElementAt(e);
                this$0.getMacroManager().removeMacro(macro.getId());
            }
        }
    }

    private static final void initEvents$lambda$2(MacroDialog this$0, ActionEvent it) {
        if (this$0.list.getSelectionModel().getSelectedItemsCount() > 0) {
            long now = System.currentTimeMillis();
            int[] rows = this$0.list.getSelectionModel().getSelectedIndices();
            int n = rows.length;
            for (int i = 0; i < n; ++i) {
                Macro m = this$0.model.getElementAt(i);
                Intrinsics.checkNotNull((Object)m);
                Macro macro = Macro.copy$default(m, CryptoKt.randomUUID(), null, m.getName() + " " + this$0.copyBtn.getText(), now, now + (long)i, 0L, 34, null);
                this$0.model.addElement(macro);
                this$0.getMacroManager().addMacro(macro);
            }
        }
    }

    private static final void initEvents$lambda$3(MacroDialog this$0, ListSelectionEvent it) {
        this$0.editBtn.setEnabled(this$0.list.getSelectionModel().getSelectedItemsCount() > 0);
        this$0.deleteBtn.setEnabled(this$0.editBtn.isEnabled());
        this$0.runBtn.setEnabled(this$0.editBtn.isEnabled());
        this$0.copyBtn.setEnabled(this$0.editBtn.isEnabled());
    }

    public static final /* synthetic */ JList access$getList$p(MacroDialog $this) {
        return $this.list;
    }

    public static final /* synthetic */ DefaultListModel access$getModel$p(MacroDialog $this) {
        return $this.model;
    }
}

