/*
 * Decompiled with CFR 0.152.
 */
package app.termora.plugin.internal.ssh;

import app.termora.Authentication;
import app.termora.AuthenticationType;
import app.termora.DialogWrapper;
import app.termora.DocumentAdaptor;
import app.termora.DynamicColor;
import app.termora.FixedLengthTextArea;
import app.termora.Host;
import app.termora.HostManager;
import app.termora.I18n;
import app.termora.Icons;
import app.termora.IntSpinner;
import app.termora.LoginScript;
import app.termora.Options;
import app.termora.OptionsPane;
import app.termora.OutlineComboBox;
import app.termora.OutlinePasswordField;
import app.termora.OutlineTextField;
import app.termora.PortSpinner;
import app.termora.Proxy;
import app.termora.ProxyType;
import app.termora.SerialComm;
import app.termora.Tunneling;
import app.termora.TunnelingType;
import app.termora.account.AccountOwner;
import app.termora.highlight.KeywordHighlight;
import app.termora.keymgr.KeyManager;
import app.termora.keymgr.KeyManagerDialog;
import app.termora.keymgr.OhKeyPair;
import app.termora.plugin.internal.AltKeyModifier;
import app.termora.plugin.internal.BasicProxyOption;
import app.termora.plugin.internal.BasicTerminalOption;
import app.termora.plugin.internal.ssh.SSHHostOptionsPane;
import app.termora.plugin.internal.telnet.TelnetHostOptionsPane;
import app.termora.tree.Filter;
import app.termora.tree.HostTreeNode;
import app.termora.tree.NewHostTreeDialog;
import com.formdev.flatlaf.extras.components.FlatComboBox;
import com.formdev.flatlaf.ui.FlatTextBorder;
import com.formdev.flatlaf.util.SystemInfo;
import com.jgoodies.forms.builder.FormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.PageantConnector;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.UnixDomainSocketConnector;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.WinPipeConnector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0004$%&'B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019J\u0006\u0010\u001d\u001a\u00020\u0017J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0014\u0010\u001e\u001a\u00020\u00172\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00060\u0007R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00060\tR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000e\u001a\u00060\u000fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\u0011R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\u00020\u00138BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane;", "Lapp/termora/OptionsPane;", "accountOwner", "Lapp/termora/account/AccountOwner;", "<init>", "(Lapp/termora/account/AccountOwner;)V", "tunnelingOption", "Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$TunnelingOption;", "generalOption", "Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$GeneralOption;", "proxyOption", "Lapp/termora/plugin/internal/BasicProxyOption;", "terminalOption", "Lapp/termora/plugin/internal/BasicTerminalOption;", "jumpHostsOption", "Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$JumpHostsOption;", "sftpOption", "Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$SFTPOption;", "owner", "Ljava/awt/Window;", "getOwner", "()Ljava/awt/Window;", "setHostMode", "", "getHost", "Lapp/termora/Host;", "setHost", "", "host", "validateFields", "validateField", "textField", "Ljavax/swing/JTextField;", "setOutlineError", "comboBox", "Ljavax/swing/JComboBox;", "GeneralOption", "SFTPOption", "TunnelingOption", "JumpHostsOption", "termora"})
@SourceDebugExtension(value={"SMAP\nSSHHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SSHHostOptionsPane.kt\napp/termora/plugin/internal/ssh/SSHHostOptionsPane\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1077:1\n1563#2:1078\n1634#2,3:1079\n1208#2,2:1083\n1236#2,4:1085\n1#3:1082\n*S KotlinDebug\n*F\n+ 1 SSHHostOptionsPane.kt\napp/termora/plugin/internal/ssh/SSHHostOptionsPane\n*L\n110#1:1078\n110#1:1079,3\n198#1:1083,2\n198#1:1085,4\n*E\n"})
public final class SSHHostOptionsPane
extends OptionsPane {
    @NotNull
    private final AccountOwner accountOwner;
    @NotNull
    private final TunnelingOption tunnelingOption;
    @NotNull
    private final GeneralOption generalOption;
    @NotNull
    private final BasicProxyOption proxyOption;
    @NotNull
    private final BasicTerminalOption terminalOption;
    @NotNull
    private final JumpHostsOption jumpHostsOption;
    @NotNull
    private final SFTPOption sftpOption;
    private boolean setHostMode;

    /*
     * WARNING - void declaration
     */
    public SSHHostOptionsPane(@NotNull AccountOwner accountOwner) {
        void $this$terminalOption_u24lambda_u240;
        BasicTerminalOption basicTerminalOption;
        Intrinsics.checkNotNullParameter((Object)accountOwner, (String)"accountOwner");
        this.accountOwner = accountOwner;
        this.tunnelingOption = new TunnelingOption();
        this.generalOption = new GeneralOption();
        this.proxyOption = new BasicProxyOption(null, 1, null);
        BasicTerminalOption basicTerminalOption2 = basicTerminalOption = new BasicTerminalOption();
        SSHHostOptionsPane sSHHostOptionsPane = this;
        boolean bl = false;
        $this$terminalOption_u24lambda_u240.setShowCharsetComboBox(true);
        $this$terminalOption_u24lambda_u240.setShowLoginScripts(true);
        $this$terminalOption_u24lambda_u240.setShowBackspaceComboBox(true);
        $this$terminalOption_u24lambda_u240.setShowEnvironmentTextArea(true);
        $this$terminalOption_u24lambda_u240.setShowStartupCommandTextField(true);
        $this$terminalOption_u24lambda_u240.setShowHeartbeatIntervalTextField(true);
        $this$terminalOption_u24lambda_u240.setShowTimeoutTextField(true);
        $this$terminalOption_u24lambda_u240.setShowHighlightSet(true);
        $this$terminalOption_u24lambda_u240.setAccountOwner(this.accountOwner);
        $this$terminalOption_u24lambda_u240.init();
        sSHHostOptionsPane.terminalOption = basicTerminalOption;
        this.jumpHostsOption = new JumpHostsOption();
        this.sftpOption = new SFTPOption();
        this.addOption(this.generalOption);
        this.addOption(this.proxyOption);
        this.addOption(this.tunnelingOption);
        this.addOption(this.jumpHostsOption);
        this.addOption(this.terminalOption);
        this.addOption(this.sftpOption);
    }

    private final Window getOwner() {
        Window window = SwingUtilities.getWindowAncestor(this);
        Intrinsics.checkNotNullExpressionValue((Object)window, (String)"getWindowAncestor(...)");
        return window;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Host getHost() {
        Object object;
        void $this$mapTo$iv$iv;
        String string;
        String string2;
        Object object2;
        Object object3;
        String name = this.generalOption.getNameTextField().getText();
        String protocol = "SSH";
        String host = this.generalOption.getHostTextField().getText();
        Object object4 = this.generalOption.getPortTextField().getValue();
        if (object4 == null) {
            object4 = 22;
        }
        int port = (Integer)object4;
        Authentication authentication = Authentication.Companion.getNo();
        Proxy proxy = Proxy.Companion.getNo();
        Object object5 = this.generalOption.getAuthenticationTypeComboBox().getSelectedItem();
        Intrinsics.checkNotNull((Object)object5, (String)"null cannot be cast to non-null type app.termora.AuthenticationType");
        AuthenticationType authenticationType = (AuthenticationType)((Object)object5);
        if (authenticationType == AuthenticationType.Password) {
            char[] cArray = this.generalOption.getPasswordTextField().getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            object3 = cArray;
            authentication = authentication.copy(authenticationType, new String((char[])object3));
        } else if (authenticationType == AuthenticationType.PublicKey) {
            Object object6 = this.generalOption.getPublicKeyComboBox().getSelectedItem();
            if (object6 == null || (object6 = object6.toString()) == null) {
                object6 = "";
            }
            authentication = authentication.copy(authenticationType, (String)object6);
        } else if (authenticationType == AuthenticationType.SSHAgent) {
            Object object7 = this.generalOption.getSshAgentComboBox().getSelectedItem();
            if (object7 == null || (object7 = object7.toString()) == null) {
                object7 = "";
            }
            authentication = authentication.copy(authenticationType, (String)object7);
        }
        if (this.proxyOption.getProxyTypeComboBox().getSelectedItem() != ProxyType.No) {
            object3 = proxy;
            Object object8 = this.proxyOption.getProxyTypeComboBox().getSelectedItem();
            Intrinsics.checkNotNull((Object)object8, (String)"null cannot be cast to non-null type app.termora.ProxyType");
            ProxyType proxyType = (ProxyType)((Object)object8);
            String string3 = this.proxyOption.getProxyHostTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
            object2 = string3;
            String string4 = this.proxyOption.getProxyUsernameTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
            string2 = string4;
            char[] cArray = this.proxyOption.getProxyPasswordTextField().getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            char[] cArray2 = cArray;
            string = new String(cArray2);
            Object object9 = this.proxyOption.getProxyPortTextField().getValue();
            Intrinsics.checkNotNull((Object)object9, (String)"null cannot be cast to non-null type kotlin.Int");
            int n = (Integer)object9;
            Object object10 = this.proxyOption.getProxyAuthenticationTypeComboBox().getSelectedItem();
            Intrinsics.checkNotNull((Object)object10, (String)"null cannot be cast to non-null type app.termora.AuthenticationType");
            AuthenticationType authenticationType2 = (AuthenticationType)((Object)object10);
            proxy = ((Proxy)object3).copy(proxyType, (String)object2, n, authenticationType2, string2, string);
        }
        SerialComm serialComm = new SerialComm(null, 0, 0, null, null, null, 63, null);
        object2 = Options.Companion.getDefault();
        Object object11 = this.terminalOption.getCharsetComboBox().getSelectedItem();
        Intrinsics.checkNotNull((Object)object11, (String)"null cannot be cast to non-null type kotlin.String");
        string2 = (String)object11;
        String string5 = this.terminalOption.getEnvironmentTextArea().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
        string = string5;
        String string6 = this.terminalOption.getStartupCommandTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
        Object object12 = string6;
        Object object13 = this.terminalOption.getHeartbeatIntervalTextField().getValue();
        if (object13 == null) {
            object13 = 30;
        }
        int n = (Integer)object13;
        Iterable $this$map$iv = this.jumpHostsOption.getJumpHosts();
        boolean $i$f$map = false;
        List<Tunneling> list = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            object = (Host)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        List list2 = (List)destination$iv$iv;
        String string7 = this.sftpOption.getDefaultDirectoryField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getText(...)");
        String string8 = string7;
        boolean bl = this.tunnelingOption.getX11ForwardingCheckBox().isSelected();
        String string9 = this.tunnelingOption.getX11ServerTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getText(...)");
        list = string9;
        List<LoginScript> list3 = this.terminalOption.getLoginScripts();
        Pair[] pairArray = new Pair[5];
        Object object14 = this.terminalOption.getBackspaceComboBox().getSelectedItem();
        Intrinsics.checkNotNull((Object)object14, (String)"null cannot be cast to non-null type app.termora.plugin.internal.telnet.TelnetHostOptionsPane.Backspace");
        pairArray[0] = TuplesKt.to((Object)"backspace", (Object)((TelnetHostOptionsPane.Backspace)((Object)object14)).name());
        Object object15 = this.terminalOption.getAltModifierComboBox().getSelectedItem();
        if (object15 == null || (object15 = object15.toString()) == null) {
            object15 = "EightBit";
        }
        pairArray[1] = TuplesKt.to((Object)"altModifier", (Object)object15);
        object = this.terminalOption.getHighlightSetComboBox().getSelectedItem();
        Object object16 = object instanceof KeywordHighlight ? (KeywordHighlight)object : null;
        if (object16 == null || (object16 = ((KeywordHighlight)object16).getId()) == null) {
            object16 = "-1";
        }
        pairArray[2] = TuplesKt.to((Object)"keywordHighlightSetId", (Object)object16);
        Object object17 = this.terminalOption.getTimeoutTextField().getValue();
        if (object17 == null) {
            object17 = 60;
        }
        pairArray[3] = TuplesKt.to((Object)"timeout", (Object)object17.toString());
        pairArray[4] = TuplesKt.to((Object)"forwardAgent", (Object)String.valueOf(this.tunnelingOption.getForwardAgentCheckBox().isSelected()));
        Map map = MapsKt.mutableMapOf((Pair[])pairArray);
        Options options = Options.copy$default((Options)object2, list2, list3, string2, string, (String)object12, n, serialComm, string8, bl, (String)((Object)list), null, map, 1024, null);
        Intrinsics.checkNotNull((Object)name);
        object2 = name;
        Intrinsics.checkNotNull((Object)host);
        string2 = host;
        String string10 = this.generalOption.getUsernameTextField().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getText(...)");
        string = string10;
        object12 = authentication;
        Proxy proxy2 = proxy;
        long l = System.currentTimeMillis();
        String string11 = this.generalOption.getRemarkTextArea().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getText(...)");
        String string12 = string11;
        list = this.tunnelingOption.getTunnelings();
        return new Host(null, (String)object2, protocol, string2, port, string, string12, (Authentication)object12, proxy2, options, list, l, null, null, null, null, false, 0L, 0L, 520193, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void setHost(@NotNull Host host) {
        int n2;
        Object $this$setHost_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this.setHostMode = true;
        this.generalOption.getPortTextField().setValue(host.getPort());
        this.generalOption.getNameTextField().setText(host.getName());
        this.generalOption.getUsernameTextField().setText(host.getUsername());
        this.generalOption.getHostTextField().setText(host.getHost());
        this.generalOption.getRemarkTextArea().setText(host.getRemark());
        this.generalOption.getAuthenticationTypeComboBox().setSelectedItem((Object)host.getAuthentication().getType());
        if (host.getAuthentication().getType() == AuthenticationType.Password) {
            this.generalOption.getPasswordTextField().setText(host.getAuthentication().getPassword());
        } else if (host.getAuthentication().getType() == AuthenticationType.PublicKey) {
            this.generalOption.getPublicKeyComboBox().setSelectedItem(host.getAuthentication().getPassword());
        } else if (host.getAuthentication().getType() == AuthenticationType.SSHAgent) {
            this.generalOption.getSshAgentComboBox().setSelectedItem(host.getAuthentication().getPassword());
        }
        this.proxyOption.getProxyTypeComboBox().setSelectedItem((Object)host.getProxy().getType());
        this.proxyOption.getProxyHostTextField().setText(host.getProxy().getHost());
        this.proxyOption.getProxyPasswordTextField().setText(host.getProxy().getPassword());
        this.proxyOption.getProxyUsernameTextField().setText(host.getProxy().getUsername());
        this.proxyOption.getProxyPortTextField().setValue(host.getProxy().getPort());
        this.proxyOption.getProxyAuthenticationTypeComboBox().setSelectedItem((Object)host.getProxy().getAuthenticationType());
        this.terminalOption.getCharsetComboBox().setSelectedItem(host.getOptions().getEncoding());
        this.terminalOption.getEnvironmentTextArea().setText(host.getOptions().getEnv());
        this.terminalOption.getStartupCommandTextField().setText(host.getOptions().getStartupCommand());
        this.terminalOption.getHeartbeatIntervalTextField().setValue(host.getOptions().getHeartbeatInterval());
        this.terminalOption.getLoginScripts().addAll((Collection<LoginScript>)host.getOptions().getLoginScripts());
        String string = host.getOptions().getExtras().get("altModifier");
        if (string == null) {
            string = "EightBit";
        }
        String altModifier = string;
        Object object = this;
        Object object2 = this.terminalOption.getAltModifierComboBox();
        try {
            $this$setHost_u24lambda_u240 = object;
            n2 = 0;
            $this$setHost_u24lambda_u240 = Result.constructor-impl((Object)((Object)AltKeyModifier.valueOf(altModifier)));
        }
        catch (Throwable n2) {
            $this$setHost_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)n2));
        }
        object = $this$setHost_u24lambda_u240;
        AltKeyModifier altKeyModifier = (AltKeyModifier)((Object)(Result.isFailure-impl((Object)object) ? null : object));
        if (altKeyModifier == null) {
            altKeyModifier = AltKeyModifier.EightBit;
        }
        ((JComboBox)object2).setSelectedItem((Object)altKeyModifier);
        JComboBox<TelnetHostOptionsPane.Backspace> jComboBox = this.terminalOption.getBackspaceComboBox();
        String string2 = host.getOptions().getExtras().get("backspace");
        if (string2 == null) {
            string2 = "Delete";
        }
        jComboBox.setSelectedItem((Object)TelnetHostOptionsPane.Backspace.valueOf(string2));
        String string3 = host.getOptions().getExtras().get("timeout");
        if (string3 == null) {
            string3 = "60";
        }
        String timeout = string3;
        IntSpinner intSpinner = this.terminalOption.getTimeoutTextField();
        Integer n3 = StringsKt.toIntOrNull((String)timeout);
        if (n3 == null) {
            n3 = 60;
        }
        intSpinner.setValue(n3);
        String keywordHighlightSetId = host.getOptions().getExtras().get("keywordHighlightSetId");
        n2 = this.terminalOption.getHighlightSetComboBox().getItemCount();
        for (int i = 0; i < n2; ++i) {
            KeywordHighlight item = this.terminalOption.getHighlightSetComboBox().getItemAt(i);
            if (!Intrinsics.areEqual((Object)item.getId(), (Object)keywordHighlightSetId)) continue;
            this.terminalOption.getHighlightSetComboBox().setSelectedItem(item);
            break;
        }
        this.tunnelingOption.getTunnelings().addAll((Collection<Tunneling>)host.getTunnelings());
        this.tunnelingOption.getX11ForwardingCheckBox().setSelected(host.getOptions().getEnableX11Forwarding());
        this.tunnelingOption.getX11ServerTextField().setText((String)StringUtils.defaultIfBlank((CharSequence)host.getOptions().getX11Forwarding(), (CharSequence)"localhost:0"));
        String string4 = host.getOptions().getExtras().get("forwardAgent");
        this.tunnelingOption.getForwardAgentCheckBox().setSelected(string4 != null ? Boolean.parseBoolean(string4) : false);
        if (!((Collection)host.getOptions().getJumpHosts()).isEmpty()) {
            void $this$associateByTo$iv$iv;
            Iterable $this$associateBy$iv = HostManager.Companion.getInstance().hosts();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                Host host2 = (Host)element$iv$iv;
                object2 = destination$iv$iv;
                boolean bl = false;
                object2.put(it.getId(), element$iv$iv);
            }
            Map hosts = destination$iv$iv;
            for (String id : host.getOptions().getJumpHosts()) {
                Host host3 = (Host)hosts.get(id);
                if (host3 == null) continue;
                this.jumpHostsOption.getJumpHosts().add(host3);
            }
        }
        this.jumpHostsOption.setFilter((Function1<? super Host, Boolean>)((Function1)arg_0 -> SSHHostOptionsPane.setHost$lambda$2(host, arg_0)));
        this.sftpOption.getDefaultDirectoryField().setText(host.getOptions().getSftpDefaultDirectory());
    }

    public final boolean validateFields() {
        Host host = this.getHost();
        if (this.validateField((JTextField)((Object)this.generalOption.getNameTextField())) || this.validateField((JTextField)((Object)this.generalOption.getHostTextField()))) {
            return false;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)host.getProtocol(), (CharSequence)"SSH") && this.validateField((JTextField)((Object)this.generalOption.getUsernameTextField()))) {
            return false;
        }
        if (host.getAuthentication().getType() == AuthenticationType.Password ? this.validateField((JTextField)((Object)this.generalOption.getPasswordTextField())) : host.getAuthentication().getType() == AuthenticationType.PublicKey && this.validateField((JComboBox)((Object)this.generalOption.getPublicKeyComboBox()))) {
            return false;
        }
        if (host.getProxy().getType() != ProxyType.No) {
            if (this.validateField((JTextField)((Object)this.proxyOption.getProxyHostTextField()))) {
                return false;
            }
            if (host.getProxy().getAuthenticationType() != AuthenticationType.No && (this.validateField((JTextField)((Object)this.proxyOption.getProxyUsernameTextField())) || this.validateField((JTextField)((Object)this.proxyOption.getProxyPasswordTextField())))) {
                return false;
            }
        }
        if (this.tunnelingOption.getX11ForwardingCheckBox().isSelected()) {
            if (this.validateField((JTextField)((Object)this.tunnelingOption.getX11ServerTextField()))) {
                return false;
            }
            String string = this.tunnelingOption.getX11ServerTextField().getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            String[] stringArray = new String[]{":"};
            List segments = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (segments.size() != 2 || StringsKt.toIntOrNull((String)((String)segments.get(1))) == null) {
                this.setOutlineError((JTextField)((Object)this.tunnelingOption.getX11ServerTextField()));
                return false;
            }
        }
        return true;
    }

    private final boolean validateField(JTextField textField) {
        if (textField.isEnabled()) {
            String string = textField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this.setOutlineError(textField);
                return true;
            }
        }
        return false;
    }

    private final void setOutlineError(JTextField textField) {
        this.selectOptionJComponent(textField);
        textField.putClientProperty("JComponent.outline", "error");
        textField.requestFocusInWindow();
    }

    private final boolean validateField(JComboBox<?> comboBox2) {
        Object selectedItem = comboBox2.getSelectedItem();
        if (comboBox2.isEnabled() && (selectedItem == null || selectedItem instanceof String && StringsKt.isBlank((CharSequence)((CharSequence)selectedItem)))) {
            this.selectOptionJComponent(comboBox2);
            comboBox2.putClientProperty("JComponent.outline", "error");
            comboBox2.requestFocusInWindow();
            return true;
        }
        return false;
    }

    private static final boolean setHost$lambda$2(Host $host, Host it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return !Intrinsics.areEqual((Object)it.getId(), (Object)$host.getId());
    }

    public static final /* synthetic */ boolean access$getSetHostMode$p(SSHHostOptionsPane $this) {
        return $this.setHostMode;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020+H\u0002J\b\u0010-\u001a\u00020+H\u0002J\u0010\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020)H\u0016J\b\u00101\u001a\u00020\u001aH\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u000203H\u0002J\b\u00105\u001a\u00020+H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u000e\u0010\u0011\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00020%0$\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$GeneralOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane;)V", "portTextField", "Lapp/termora/PortSpinner;", "getPortTextField", "()Lapp/termora/PortSpinner;", "nameTextField", "Lapp/termora/OutlineTextField;", "getNameTextField", "()Lapp/termora/OutlineTextField;", "usernameTextField", "getUsernameTextField", "hostTextField", "getHostTextField", "passwordPanel", "chooseKeyBtn", "Ljavax/swing/JButton;", "passwordTextField", "Lapp/termora/OutlinePasswordField;", "getPasswordTextField", "()Lapp/termora/OutlinePasswordField;", "sshAgentComboBox", "Lapp/termora/OutlineComboBox;", "", "getSshAgentComboBox", "()Lapp/termora/OutlineComboBox;", "publicKeyComboBox", "getPublicKeyComboBox", "remarkTextArea", "Lapp/termora/FixedLengthTextArea;", "getRemarkTextArea", "()Lapp/termora/FixedLengthTextArea;", "authenticationTypeComboBox", "Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "Lapp/termora/AuthenticationType;", "getAuthenticationTypeComboBox", "()Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "hostFocused", "", "initView", "", "initEvents", "chooseKeyPair", "getIcon", "Ljavax/swing/Icon;", "isSelected", "getTitle", "getJComponent", "Ljavax/swing/JComponent;", "getCenterComponent", "switchPasswordComponent", "termora"})
    @SourceDebugExtension(value={"SMAP\nSSHHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SSHHostOptionsPane.kt\napp/termora/plugin/internal/ssh/SSHHostOptionsPane$GeneralOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1077:1\n1#2:1078\n*E\n"})
    protected final class GeneralOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final PortSpinner portTextField;
        @NotNull
        private final OutlineTextField nameTextField;
        @NotNull
        private final OutlineTextField usernameTextField;
        @NotNull
        private final OutlineTextField hostTextField;
        @NotNull
        private final JPanel passwordPanel;
        @NotNull
        private final JButton chooseKeyBtn;
        @NotNull
        private final OutlinePasswordField passwordTextField;
        @NotNull
        private final OutlineComboBox<String> sshAgentComboBox;
        @NotNull
        private final OutlineComboBox<String> publicKeyComboBox;
        @NotNull
        private final FixedLengthTextArea remarkTextArea;
        @NotNull
        private final FlatComboBox<AuthenticationType> authenticationTypeComboBox;
        private boolean hostFocused;

        public GeneralOption() {
            super(new BorderLayout());
            this.portTextField = new PortSpinner(0, 1, null);
            this.nameTextField = new OutlineTextField(128);
            this.usernameTextField = new OutlineTextField(128);
            this.hostTextField = new OutlineTextField(255);
            this.passwordPanel = new JPanel(new BorderLayout());
            this.chooseKeyBtn = new JButton((Icon)((Object)Icons.INSTANCE.getGreyKey()));
            this.passwordTextField = new OutlinePasswordField(255, false, 2, null);
            this.sshAgentComboBox = new OutlineComboBox();
            this.publicKeyComboBox = new OutlineComboBox();
            this.remarkTextArea = new FixedLengthTextArea(512);
            this.authenticationTypeComboBox = new FlatComboBox();
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final PortSpinner getPortTextField() {
            return this.portTextField;
        }

        @NotNull
        public final OutlineTextField getNameTextField() {
            return this.nameTextField;
        }

        @NotNull
        public final OutlineTextField getUsernameTextField() {
            return this.usernameTextField;
        }

        @NotNull
        public final OutlineTextField getHostTextField() {
            return this.hostTextField;
        }

        @NotNull
        public final OutlinePasswordField getPasswordTextField() {
            return this.passwordTextField;
        }

        @NotNull
        public final OutlineComboBox<String> getSshAgentComboBox() {
            return this.sshAgentComboBox;
        }

        @NotNull
        public final OutlineComboBox<String> getPublicKeyComboBox() {
            return this.publicKeyComboBox;
        }

        @NotNull
        public final FixedLengthTextArea getRemarkTextArea() {
            return this.remarkTextArea;
        }

        @NotNull
        public final FlatComboBox<AuthenticationType> getAuthenticationTypeComboBox() {
            return this.authenticationTypeComboBox;
        }

        private final void initView() {
            this.add((Component)this.getCenterComponent(), "Center");
            this.publicKeyComboBox.setEditable(false);
            this.chooseKeyBtn.setFocusable(false);
            this.sshAgentComboBox.setEditable(SystemInfo.isWindows);
            this.sshAgentComboBox.setEnabled(SystemInfo.isWindows);
            this.publicKeyComboBox.setRenderer(new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Object text = "";
                    if (value instanceof String) {
                        Object object = KeyManager.Companion.getInstance().getOhKeyPair((String)value);
                        if (object == null || (object = ((OhKeyPair)object).getName()) == null) {
                            object = text;
                        }
                        text = object;
                    }
                    Component component = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                    return component;
                }
            });
            this.authenticationTypeComboBox.setRenderer((ListCellRenderer)new DefaultListCellRenderer(){

                public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                    Object object;
                    Object text;
                    Object object2 = value;
                    if (object2 == null || (object2 = object2.toString()) == null) {
                        object2 = text = "";
                    }
                    if ((object = value) == AuthenticationType.Password) {
                        text = "Password";
                    } else if (object == AuthenticationType.PublicKey) {
                        text = "Public Key";
                    } else if (object == AuthenticationType.KeyboardInteractive) {
                        text = "Keyboard Interactive";
                    }
                    Component component = super.getListCellRendererComponent(list, text, index, isSelected, cellHasFocus);
                    Intrinsics.checkNotNullExpressionValue((Object)component, (String)"getListCellRendererComponent(...)");
                    return component;
                }
            });
            this.authenticationTypeComboBox.addItem((Object)AuthenticationType.No);
            this.authenticationTypeComboBox.addItem((Object)AuthenticationType.Password);
            this.authenticationTypeComboBox.addItem((Object)AuthenticationType.PublicKey);
            this.authenticationTypeComboBox.addItem((Object)AuthenticationType.SSHAgent);
            if (SystemInfo.isWindows) {
                this.sshAgentComboBox.addItem(PageantConnector.DESCRIPTOR.getIdentityAgent());
                this.sshAgentComboBox.addItem(WinPipeConnector.DESCRIPTOR.getIdentityAgent());
                this.sshAgentComboBox.setPlaceholderText(PageantConnector.DESCRIPTOR.getIdentityAgent());
            } else {
                this.sshAgentComboBox.addItem(UnixDomainSocketConnector.DESCRIPTOR.getIdentityAgent());
                this.sshAgentComboBox.setPlaceholderText(UnixDomainSocketConnector.DESCRIPTOR.getIdentityAgent());
            }
            this.authenticationTypeComboBox.setSelectedItem((Object)AuthenticationType.Password);
        }

        private final void initEvents() {
            this.authenticationTypeComboBox.addItemListener(arg_0 -> GeneralOption.initEvents$lambda$0(this, arg_0));
            this.chooseKeyBtn.addActionListener(arg_0 -> GeneralOption.initEvents$lambda$1(this, arg_0));
            this.addComponentListener(new ComponentAdapter(this){
                final /* synthetic */ GeneralOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void componentResized(ComponentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    SwingUtilities.invokeLater(() -> initEvents.3.componentResized$lambda$0(this.this$0));
                    this.this$0.removeComponentListener(this);
                }

                private static final void componentResized$lambda$0(GeneralOption this$0) {
                    this$0.getNameTextField().requestFocusInWindow();
                }
            });
            this.hostTextField.addFocusListener(new FocusAdapter(this){
                final /* synthetic */ GeneralOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void focusGained(FocusEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    this.this$0.getHostTextField().removeFocusListener(this);
                    GeneralOption.access$setHostFocused$p(this.this$0, true);
                }
            });
            this.nameTextField.getDocument().addDocumentListener(new DocumentAdaptor(this, SSHHostOptionsPane.this){
                final /* synthetic */ GeneralOption this$0;
                final /* synthetic */ SSHHostOptionsPane this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void changedUpdate(DocumentEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (!this.this$0.getNameTextField().hasFocus()) {
                        return;
                    }
                    if (GeneralOption.access$getHostFocused$p(this.this$0) || SSHHostOptionsPane.access$getSetHostMode$p(this.this$1)) {
                        this.this$0.getNameTextField().getDocument().removeDocumentListener(this);
                        return;
                    }
                    this.this$0.getHostTextField().setText(this.this$0.getNameTextField().getText());
                }
            });
        }

        private final void chooseKeyPair() {
            KeyManagerDialog dialog2 = new KeyManagerDialog(SSHHostOptionsPane.this.getOwner(), true, null, SSHHostOptionsPane.this.accountOwner, 4, null);
            dialog2.pack();
            dialog2.setLocationRelativeTo(SSHHostOptionsPane.this.getOwner());
            dialog2.setVisible(true);
            Object selectedItem = this.publicKeyComboBox.getSelectedItem();
            this.publicKeyComboBox.removeAllItems();
            for (OhKeyPair keyPair : KeyManager.Companion.getInstance().getOhKeyPairs(SSHHostOptionsPane.this.accountOwner.getId())) {
                this.publicKeyComboBox.addItem(keyPair.getId());
            }
            this.publicKeyComboBox.setSelectedItem(selectedItem);
            if (!dialog2.getOk()) {
                return;
            }
            Object object = dialog2.getLasOhKeyPair();
            if (object == null || (object = ((OhKeyPair)object).getId()) == null) {
                return;
            }
            this.publicKeyComboBox.setSelectedItem(object);
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)((Object)Icons.INSTANCE.getSettings());
        }

        @Override
        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.new-host.general");
        }

        @Override
        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private final JComponent getCenterComponent() {
            void $this$getCenterComponent_u24lambda_u245;
            Object object;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow, 7dlu, pref, 7dlu, default", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
            this.remarkTextArea.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
            this.remarkTextArea.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
            this.remarkTextArea.setRows(8);
            this.remarkTextArea.setLineWrap(true);
            this.remarkTextArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
            this.switchPasswordComponent();
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$getCenterComponent_u24lambda_u240 = object = FormBuilder.create().layout(layout).add(I18n.INSTANCE.getString("termora.new-host.general.name") + ":", new Object[0]).xy(1, rows).add((Component)((Object)this.nameTextField)).xyw(3, rows, 5);
            boolean bl = false;
            FormBuilder $this$getCenterComponent_u24lambda_u241 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.host") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.hostTextField)).xy(3, rows).add(I18n.INSTANCE.getString("termora.new-host.general.port") + ":", new Object[0]).xy(5, rows).add((Component)((Object)this.portTextField)).xy(7, rows);
            boolean bl2 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u242 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.username") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.usernameTextField)).xyw(3, rows, 5);
            boolean bl3 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u243 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.authentication") + ":", new Object[0]).xy(1, rows += step).add((Component)this.authenticationTypeComboBox).xyw(3, rows, 5);
            boolean bl4 = false;
            FormBuilder $this$getCenterComponent_u24lambda_u244 = object = object.add(I18n.INSTANCE.getString("termora.new-host.general.password") + ":", new Object[0]).xy(1, rows += step).add((Component)this.passwordPanel).xyw(3, rows, 5);
            boolean bl5 = false;
            FormBuilder formBuilder = object.add(I18n.INSTANCE.getString("termora.new-host.general.remark") + ":", new Object[0]).xy(1, rows += step);
            $this$getCenterComponent_u24lambda_u244 = object = new JScrollPane((Component)((Object)this.remarkTextArea));
            FormBuilder formBuilder2 = formBuilder;
            boolean bl6 = false;
            $this$getCenterComponent_u24lambda_u245.setBorder((Border)new FlatTextBorder());
            Object $this$getCenterComponent_u24lambda_u246 = object = formBuilder2.add((Component)object).xyw(3, rows, 5);
            boolean bl7 = false;
            rows += step;
            JPanel panel2 = object.build();
            Intrinsics.checkNotNull((Object)panel2);
            return panel2;
        }

        private final void switchPasswordComponent() {
            this.passwordPanel.removeAll();
            if (this.authenticationTypeComboBox.getSelectedItem() == AuthenticationType.PublicKey) {
                Object selectedItem = this.publicKeyComboBox.getSelectedItem();
                this.publicKeyComboBox.removeAllItems();
                for (OhKeyPair pair : KeyManager.Companion.getInstance().getOhKeyPairs(SSHHostOptionsPane.this.accountOwner.getId())) {
                    this.publicKeyComboBox.addItem(pair.getId());
                }
                this.publicKeyComboBox.setSelectedItem(selectedItem);
                this.passwordPanel.add((Component)FormBuilder.create().layout(new FormLayout("default:grow, 4dlu, left:pref", "pref")).add((Component)((Object)this.publicKeyComboBox)).xy(1, 1).add((Component)this.chooseKeyBtn).xy(3, 1).build(), "Center");
            } else if (this.authenticationTypeComboBox.getSelectedItem() == AuthenticationType.SSHAgent) {
                this.passwordPanel.add((Component)((Object)this.sshAgentComboBox), "Center");
            } else {
                this.passwordPanel.add((Component)((Object)this.passwordTextField), "Center");
            }
            this.passwordPanel.revalidate();
            this.passwordPanel.repaint();
        }

        private static final void initEvents$lambda$0(GeneralOption this$0, ItemEvent it) {
            if (it.getStateChange() == 1) {
                this$0.switchPasswordComponent();
            }
        }

        private static final void initEvents$lambda$1(GeneralOption this$0, ActionEvent it) {
            this$0.chooseKeyPair();
        }

        public static final /* synthetic */ void access$setHostFocused$p(GeneralOption $this, boolean bl) {
            $this.hostFocused = bl;
        }

        public static final /* synthetic */ boolean access$getHostFocused$p(GeneralOption $this) {
            return $this.hostFocused;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0015\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\b\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000fH\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR5\u0010\n\u001a\u001d\u0012\u0013\u0012\u00110\u0007\u00a2\u0006\f\b\f\u0012\b\b\r\u0012\u0004\b\b(\u000e\u0012\u0004\u0012\u00020\u000f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$JumpHostsOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane;)V", "jumpHosts", "", "Lapp/termora/Host;", "getJumpHosts", "()Ljava/util/List;", "filter", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "host", "", "getFilter", "()Lkotlin/jvm/functions/Function1;", "setFilter", "(Lkotlin/jvm/functions/Function1;)V", "model", "app/termora/plugin/internal/ssh/SSHHostOptionsPane$JumpHostsOption$model$1", "Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$JumpHostsOption$model$1;", "table", "Ljavax/swing/JTable;", "addBtn", "Ljavax/swing/JButton;", "moveUpBtn", "moveDownBtn", "deleteBtn", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "termora"})
    @SourceDebugExtension(value={"SMAP\nSSHHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SSHHostOptionsPane.kt\napp/termora/plugin/internal/ssh/SSHHostOptionsPane$JumpHostsOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1077:1\n1#2:1078\n*E\n"})
    protected final class JumpHostsOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final List<Host> jumpHosts;
        @NotNull
        private Function1<? super Host, Boolean> filter;
        @NotNull
        private final model.1 model;
        @NotNull
        private final JTable table;
        @NotNull
        private final JButton addBtn;
        @NotNull
        private final JButton moveUpBtn;
        @NotNull
        private final JButton moveDownBtn;
        @NotNull
        private final JButton deleteBtn;

        public JumpHostsOption() {
            super(new BorderLayout());
            this.jumpHosts = new ArrayList();
            this.filter = JumpHostsOption::filter$lambda$0;
            this.model = new DefaultTableModel(this){
                final /* synthetic */ JumpHostsOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                public int getRowCount() {
                    return this.this$0.getJumpHosts().size();
                }

                public Object getValueAt(int row, int column) {
                    Host host = (Host)CollectionsKt.getOrNull(this.this$0.getJumpHosts(), (int)row);
                    if (host == null) {
                        return "";
                    }
                    Host host2 = host;
                    return column == 0 ? host2.getName() : host2.getHost() + ":" + host2.getPort();
                }
            };
            this.table = new JTable(this.model);
            this.addBtn = new JButton(I18n.INSTANCE.getString("termora.new-host.tunneling.add"));
            this.moveUpBtn = new JButton(I18n.INSTANCE.getString("termora.transport.bookmarks.up"));
            this.moveDownBtn = new JButton(I18n.INSTANCE.getString("termora.transport.bookmarks.down"));
            this.deleteBtn = new JButton(I18n.INSTANCE.getString("termora.new-host.tunneling.delete"));
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final List<Host> getJumpHosts() {
            return this.jumpHosts;
        }

        @NotNull
        public final Function1<Host, Boolean> getFilter() {
            return this.filter;
        }

        public final void setFilter(@NotNull Function1<? super Host, Boolean> function1) {
            Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
            this.filter = function1;
        }

        /*
         * WARNING - void declaration
         */
        private final void initView() {
            void $this$initView_u24lambda_u240;
            JScrollPane scrollPane = new JScrollPane(this.table);
            this.model.addColumn(I18n.INSTANCE.getString("termora.new-host.general.name"));
            this.model.addColumn(I18n.INSTANCE.getString("termora.new-host.general.host"));
            Object object = new Pair[]{TuplesKt.to((Object)"showHorizontalLines", (Object)true), TuplesKt.to((Object)"showVerticalLines", (Object)true)};
            this.table.putClientProperty("FlatLaf.style", MapsKt.mapOf((Pair[])object));
            this.table.setAutoResizeMode(2);
            Object object2 = object = new DefaultTableCellRenderer();
            Class<Object> clazz = Object.class;
            JTable jTable = this.table;
            boolean bl = false;
            $this$initView_u24lambda_u240.setHorizontalAlignment(0);
            Unit unit = Unit.INSTANCE;
            jTable.setDefaultRenderer(clazz, (TableCellRenderer)object);
            this.table.setFillsViewportHeight(true);
            scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createMatteBorder(1, 1, 1, 1, DynamicColor.Companion.getBorderColor())));
            this.table.setBorder(BorderFactory.createEmptyBorder());
            this.moveUpBtn.setFocusable(false);
            this.moveDownBtn.setFocusable(false);
            this.deleteBtn.setFocusable(false);
            this.moveUpBtn.setEnabled(false);
            this.moveDownBtn.setEnabled(false);
            this.deleteBtn.setEnabled(false);
            this.addBtn.setFocusable(false);
            Box box = Box.createHorizontalBox();
            box.add(this.addBtn);
            box.add(Box.createHorizontalStrut(4));
            box.add(this.deleteBtn);
            box.add(Box.createHorizontalStrut(4));
            box.add(this.moveUpBtn);
            box.add(Box.createHorizontalStrut(4));
            box.add(this.moveDownBtn);
            this.add((Component)new JLabel(this.getTitle() + ":"), "North");
            this.add((Component)scrollPane, "Center");
            this.add((Component)box, "South");
        }

        private final void initEvents() {
            this.addBtn.addActionListener(new AbstractAction(SSHHostOptionsPane.this, this){
                final /* synthetic */ SSHHostOptionsPane this$0;
                final /* synthetic */ JumpHostsOption this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                /*
                 * WARNING - void declaration
                 */
                public void actionPerformed(ActionEvent e) {
                    void $this$forEach$iv;
                    NewHostTreeDialog dialog2 = new NewHostTreeDialog(SSHHostOptionsPane.access$getOwner(this.this$0), new Filter(this.this$1){
                        final /* synthetic */ JumpHostsOption this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public boolean filter(Object node2) {
                            boolean bl;
                            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
                            if (!(node2 instanceof HostTreeNode)) return false;
                            Iterable $this$none$iv = this.this$0.getJumpHosts();
                            boolean $i$f$none = false;
                            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                bl = true;
                            } else {
                                for (T element$iv : $this$none$iv) {
                                    Host it = (Host)element$iv;
                                    boolean bl2 = false;
                                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)((HostTreeNode)node2).getHost().getId())) continue;
                                    return false;
                                }
                                bl = true;
                            }
                            if (!bl) return false;
                            if ((Boolean)this.this$0.getFilter().invoke((Object)((HostTreeNode)node2).getHost()) == false) return false;
                            return true;
                        }
                    });
                    dialog2.setTreeName("HostOptionsPane.JumpHostsOption.Tree");
                    dialog2.setLocationRelativeTo(SSHHostOptionsPane.access$getOwner(this.this$0));
                    dialog2.setVisible(true);
                    List<Host> hosts = dialog2.getHosts();
                    if (hosts.isEmpty()) {
                        return;
                    }
                    Iterable iterable = hosts;
                    JumpHostsOption jumpHostsOption = this.this$1;
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        Host it = (Host)element$iv;
                        boolean bl = false;
                        int rowCount = JumpHostsOption.access$getModel$p(jumpHostsOption).getRowCount();
                        jumpHostsOption.getJumpHosts().add(it);
                        JumpHostsOption.access$getModel$p(jumpHostsOption).fireTableRowsInserted(rowCount, rowCount + 1);
                    }
                }
            });
            this.deleteBtn.addActionListener(new AbstractAction(this){
                final /* synthetic */ JumpHostsOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int[] nArray = JumpHostsOption.access$getTable$p(this.this$0).getSelectedRows();
                    Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
                    List rows = ArraysKt.sortedDescending((int[])nArray);
                    if (rows.isEmpty()) {
                        return;
                    }
                    Iterator<E> iterator2 = rows.iterator();
                    while (iterator2.hasNext()) {
                        int row = ((Number)iterator2.next()).intValue();
                        this.this$0.getJumpHosts().remove(row);
                        JumpHostsOption.access$getModel$p(this.this$0).fireTableRowsDeleted(row, row);
                    }
                }
            });
            this.table.getSelectionModel().addListSelectionListener(arg_0 -> JumpHostsOption.initEvents$lambda$0(this, arg_0));
            this.moveUpBtn.addActionListener(new AbstractAction(this){
                final /* synthetic */ JumpHostsOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int[] nArray = JumpHostsOption.access$getTable$p(this.this$0).getSelectedRows();
                    Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
                    List rows = ArraysKt.sorted((int[])nArray);
                    if (rows.isEmpty()) {
                        return;
                    }
                    JumpHostsOption.access$getTable$p(this.this$0).clearSelection();
                    Iterator<E> iterator2 = rows.iterator();
                    while (iterator2.hasNext()) {
                        int row = ((Number)iterator2.next()).intValue();
                        Host host = this.this$0.getJumpHosts().get(row);
                        this.this$0.getJumpHosts().remove(row);
                        this.this$0.getJumpHosts().add(row - 1, host);
                        JumpHostsOption.access$getTable$p(this.this$0).addRowSelectionInterval(row - 1, row - 1);
                    }
                }
            });
            this.moveDownBtn.addActionListener(new AbstractAction(this){
                final /* synthetic */ JumpHostsOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int[] nArray = JumpHostsOption.access$getTable$p(this.this$0).getSelectedRows();
                    Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"getSelectedRows(...)");
                    List rows = ArraysKt.sortedDescending((int[])nArray);
                    if (rows.isEmpty()) {
                        return;
                    }
                    JumpHostsOption.access$getTable$p(this.this$0).clearSelection();
                    Iterator<E> iterator2 = rows.iterator();
                    while (iterator2.hasNext()) {
                        int row = ((Number)iterator2.next()).intValue();
                        Host host = this.this$0.getJumpHosts().get(row);
                        this.this$0.getJumpHosts().remove(row);
                        this.this$0.getJumpHosts().add(row + 1, host);
                        JumpHostsOption.access$getTable$p(this.this$0).addRowSelectionInterval(row + 1, row + 1);
                    }
                }
            });
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)((Object)Icons.INSTANCE.getServer());
        }

        @Override
        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.new-host.jump-hosts");
        }

        @Override
        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        private static final boolean filter$lambda$0(Host it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return true;
        }

        /*
         * Unable to fully structure code
         */
        private static final void initEvents$lambda$0(JumpHostsOption this$0, ListSelectionEvent it) {
            this$0.deleteBtn.setEnabled(this$0.table.getSelectedRowCount() > 0);
            v0 = this$0.moveUpBtn;
            if (!this$0.deleteBtn.isEnabled()) ** GOTO lbl-1000
            v1 = this$0.table.getSelectedRows();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"getSelectedRows(...)");
            if (!ArraysKt.contains((int[])v1, (int)0)) {
                v2 = true;
            } else lbl-1000:
            // 2 sources

            {
                v2 = false;
            }
            v0.setEnabled(v2);
            v3 = this$0.moveDownBtn;
            if (!this$0.deleteBtn.isEnabled()) ** GOTO lbl-1000
            v4 = this$0.table.getSelectedRows();
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"getSelectedRows(...)");
            if (!ArraysKt.contains((int[])v4, (int)(this$0.table.getRowCount() - 1))) {
                v5 = true;
            } else lbl-1000:
            // 2 sources

            {
                v5 = false;
            }
            v3.setEnabled(v5);
        }

        public static final /* synthetic */ model.1 access$getModel$p(JumpHostsOption $this) {
            return $this.model;
        }

        public static final /* synthetic */ JTable access$getTable$p(JumpHostsOption $this) {
            return $this.table;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0084\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$SFTPOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane;)V", "defaultDirectoryField", "Lapp/termora/OutlineTextField;", "getDefaultDirectoryField", "()Lapp/termora/OutlineTextField;", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "getCenterComponent", "termora"})
    @SourceDebugExtension(value={"SMAP\nSSHHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SSHHostOptionsPane.kt\napp/termora/plugin/internal/ssh/SSHHostOptionsPane$SFTPOption\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1077:1\n1#2:1078\n*E\n"})
    protected final class SFTPOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final OutlineTextField defaultDirectoryField;

        public SFTPOption() {
            super(new BorderLayout());
            this.defaultDirectoryField = new OutlineTextField(255);
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final OutlineTextField getDefaultDirectoryField() {
            return this.defaultDirectoryField;
        }

        private final void initView() {
            this.add((Component)this.getCenterComponent(), "Center");
        }

        private final void initEvents() {
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)((Object)Icons.INSTANCE.getFolder());
        }

        @Override
        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.transport.sftp");
        }

        @Override
        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        private final JComponent getCenterComponent() {
            FormBuilder formBuilder;
            FormLayout layout = new FormLayout("left:pref, 7dlu, default:grow", "pref, 7dlu, pref, 7dlu, pref, 7dlu, pref");
            int rows = 0;
            rows = 1;
            int step = 2;
            FormBuilder $this$getCenterComponent_u24lambda_u240 = formBuilder = FormBuilder.create().layout(layout).add(I18n.INSTANCE.getString("termora.settings.sftp.default-directory") + ":", new Object[0]).xy(1, rows).add((Component)((Object)this.defaultDirectoryField)).xy(3, rows);
            boolean bl = false;
            rows += step;
            JPanel panel2 = formBuilder.build();
            Intrinsics.checkNotNull((Object)panel2);
            return panel2;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002*\u0001\u0015\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0001(B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020\u001eH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$TunnelingOption;", "Ljavax/swing/JPanel;", "Lapp/termora/OptionsPane$Option;", "<init>", "(Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane;)V", "tunnelings", "", "Lapp/termora/Tunneling;", "getTunnelings", "()Ljava/util/List;", "x11ForwardingCheckBox", "Ljavax/swing/JCheckBox;", "getX11ForwardingCheckBox", "()Ljavax/swing/JCheckBox;", "forwardAgentCheckBox", "getForwardAgentCheckBox", "x11ServerTextField", "Lapp/termora/OutlineTextField;", "getX11ServerTextField", "()Lapp/termora/OutlineTextField;", "model", "app/termora/plugin/internal/ssh/SSHHostOptionsPane$TunnelingOption$model$1", "Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$TunnelingOption$model$1;", "table", "Ljavax/swing/JTable;", "addBtn", "Ljavax/swing/JButton;", "editBtn", "deleteBtn", "initView", "", "initEvents", "getIcon", "Ljavax/swing/Icon;", "isSelected", "", "getTitle", "", "getJComponent", "Ljavax/swing/JComponent;", "PortForwardingDialog", "termora"})
    private final class TunnelingOption
    extends JPanel
    implements OptionsPane.Option {
        @NotNull
        private final List<Tunneling> tunnelings;
        @NotNull
        private final JCheckBox x11ForwardingCheckBox;
        @NotNull
        private final JCheckBox forwardAgentCheckBox;
        @NotNull
        private final OutlineTextField x11ServerTextField;
        @NotNull
        private final model.1 model;
        @NotNull
        private final JTable table;
        @NotNull
        private final JButton addBtn;
        @NotNull
        private final JButton editBtn;
        @NotNull
        private final JButton deleteBtn;

        public TunnelingOption() {
            super(new BorderLayout());
            this.tunnelings = new ArrayList();
            this.x11ForwardingCheckBox = new JCheckBox("X DISPLAY:");
            this.forwardAgentCheckBox = new JCheckBox("Enable ForwardAgent");
            this.x11ServerTextField = new OutlineTextField(255);
            this.model = new DefaultTableModel(this){
                final /* synthetic */ TunnelingOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public int getRowCount() {
                    return this.this$0.getTunnelings().size();
                }

                public boolean isCellEditable(int row, int column) {
                    return false;
                }

                public final void addRow(Tunneling tunneling) {
                    Intrinsics.checkNotNullParameter((Object)tunneling, (String)"tunneling");
                    int rowCount = super.getRowCount();
                    this.this$0.getTunnelings().add(tunneling);
                    super.fireTableRowsInserted(rowCount, rowCount + 1);
                }

                public Object getValueAt(int row, int column) {
                    Tunneling tunneling = this.this$0.getTunnelings().get(row);
                    Object object = switch (column) {
                        case 0 -> tunneling.getName();
                        case 1 -> tunneling.getType();
                        case 2 -> tunneling.getSourceHost() + ":" + tunneling.getSourcePort();
                        case 3 -> tunneling.getDestinationHost() + ":" + tunneling.getDestinationPort();
                        default -> super.getValueAt(row, column);
                    };
                    Intrinsics.checkNotNull((Object)object);
                    return object;
                }
            };
            this.table = new JTable(this.model);
            this.addBtn = new JButton(I18n.INSTANCE.getString("termora.new-host.tunneling.add"));
            this.editBtn = new JButton(I18n.INSTANCE.getString("termora.new-host.tunneling.edit"));
            this.deleteBtn = new JButton(I18n.INSTANCE.getString("termora.new-host.tunneling.delete"));
            this.initView();
            this.initEvents();
        }

        @NotNull
        public final List<Tunneling> getTunnelings() {
            return this.tunnelings;
        }

        @NotNull
        public final JCheckBox getX11ForwardingCheckBox() {
            return this.x11ForwardingCheckBox;
        }

        @NotNull
        public final JCheckBox getForwardAgentCheckBox() {
            return this.forwardAgentCheckBox;
        }

        @NotNull
        public final OutlineTextField getX11ServerTextField() {
            return this.x11ServerTextField;
        }

        private final void initView() {
            JScrollPane scrollPane = new JScrollPane(this.table);
            this.model.addColumn(I18n.INSTANCE.getString("termora.new-host.tunneling.table.name"));
            this.model.addColumn(I18n.INSTANCE.getString("termora.new-host.tunneling.table.type"));
            this.model.addColumn(I18n.INSTANCE.getString("termora.new-host.tunneling.table.source"));
            this.model.addColumn(I18n.INSTANCE.getString("termora.new-host.tunneling.table.destination"));
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"showHorizontalLines", (Object)true), TuplesKt.to((Object)"showVerticalLines", (Object)true)};
            this.table.putClientProperty("FlatLaf.style", MapsKt.mapOf((Pair[])pairArray));
            this.table.setAutoResizeMode(2);
            this.table.setBorder(BorderFactory.createEmptyBorder());
            this.table.setFillsViewportHeight(true);
            scrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 0, 4, 0), BorderFactory.createMatteBorder(1, 1, 1, 1, DynamicColor.Companion.getBorderColor())));
            this.deleteBtn.setFocusable(false);
            this.addBtn.setFocusable(false);
            this.editBtn.setFocusable(false);
            this.editBtn.setEnabled(false);
            this.deleteBtn.setEnabled(false);
            Box box = Box.createHorizontalBox();
            box.add(this.addBtn);
            box.add(Box.createHorizontalStrut(4));
            box.add(this.editBtn);
            box.add(Box.createHorizontalStrut(4));
            box.add(this.deleteBtn);
            this.x11ForwardingCheckBox.setFocusable(false);
            this.forwardAgentCheckBox.setFocusable(false);
            String string = this.x11ServerTextField.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
            if (StringsKt.isBlank((CharSequence)string)) {
                this.x11ServerTextField.setText("localhost:0");
            }
            Box x11Forwarding = Box.createHorizontalBox();
            x11Forwarding.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("X11 Forwarding"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            x11Forwarding.add(this.x11ForwardingCheckBox);
            x11Forwarding.add((Component)((Object)this.x11ServerTextField));
            Box forwardAgent = Box.createHorizontalBox();
            forwardAgent.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Agent Forwarding"), BorderFactory.createEmptyBorder(4, 4, 4, 4)));
            forwardAgent.add(this.forwardAgentCheckBox);
            this.x11ServerTextField.setEnabled(this.x11ForwardingCheckBox.isSelected());
            JPanel panel2 = new JPanel(new BorderLayout());
            panel2.add((Component)new JLabel("TCP/IP Forwarding:"), "North");
            panel2.add((Component)scrollPane, "Center");
            panel2.add((Component)box, "South");
            panel2.setBorder(BorderFactory.createEmptyBorder(0, 0, 8, 0));
            Box forwardingBox = Box.createHorizontalBox();
            forwardingBox.add(x11Forwarding);
            forwardingBox.add(Box.createHorizontalStrut(4));
            forwardingBox.add(forwardAgent);
            this.add((Component)panel2, "Center");
            this.add((Component)forwardingBox, "South");
        }

        private final void initEvents() {
            this.x11ForwardingCheckBox.addChangeListener(arg_0 -> TunnelingOption.initEvents$lambda$0(this, arg_0));
            this.addBtn.addActionListener(new AbstractAction(this, SSHHostOptionsPane.this){
                final /* synthetic */ TunnelingOption this$0;
                final /* synthetic */ SSHHostOptionsPane this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void actionPerformed(ActionEvent e) {
                    PortForwardingDialog dialog2 = new PortForwardingDialog(this.this$0, SSHHostOptionsPane.access$getOwner(this.this$1), null, 2, null);
                    dialog2.setVisible(true);
                    Tunneling tunneling = dialog2.getTunneling();
                    if (tunneling == null) {
                        return;
                    }
                    Tunneling tunneling2 = tunneling;
                    TunnelingOption.access$getModel$p(this.this$0).addRow(tunneling2);
                }
            });
            this.editBtn.addActionListener(new AbstractAction(this, SSHHostOptionsPane.this){
                final /* synthetic */ TunnelingOption this$0;
                final /* synthetic */ SSHHostOptionsPane this$1;
                {
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void actionPerformed(ActionEvent e) {
                    int row = TunnelingOption.access$getTable$p(this.this$0).getSelectedRow();
                    if (row < 0) {
                        return;
                    }
                    PortForwardingDialog dialog2 = new PortForwardingDialog(this.this$0, SSHHostOptionsPane.access$getOwner(this.this$1), this.this$0.getTunnelings().get(row));
                    dialog2.setVisible(true);
                    Tunneling tunneling = dialog2.getTunneling();
                    if (tunneling == null) {
                        return;
                    }
                    this.this$0.getTunnelings().set(row, tunneling);
                    TunnelingOption.access$getModel$p(this.this$0).fireTableRowsUpdated(row, row);
                }
            });
            this.deleteBtn.addActionListener(new AbstractAction(this){
                final /* synthetic */ TunnelingOption this$0;
                {
                    this.this$0 = $receiver;
                }

                public void actionPerformed(ActionEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    int[] rows = TunnelingOption.access$getTable$p(this.this$0).getSelectedRows();
                    Intrinsics.checkNotNull((Object)rows);
                    if (rows.length == 0) {
                        return;
                    }
                    ArraysKt.sortDescending((int[])rows);
                    for (int row : rows) {
                        this.this$0.getTunnelings().remove(row);
                        TunnelingOption.access$getModel$p(this.this$0).fireTableRowsDeleted(row, row);
                    }
                }
            });
            this.table.getSelectionModel().addListSelectionListener(arg_0 -> TunnelingOption.initEvents$lambda$1(this, arg_0));
            this.table.addMouseListener(new MouseAdapter(this){
                final /* synthetic */ TunnelingOption this$0;
                {
                    this.this$0 = $receiver;
                }

                /*
                 * WARNING - void declaration
                 */
                public void mouseClicked(MouseEvent e) {
                    Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                    if (e.getClickCount() % 2 == 0 && SwingUtilities.isLeftMouseButton(e)) {
                        void $this$forEach$iv;
                        ActionListener[] actionListenerArray = TunnelingOption.access$getEditBtn$p(this.this$0).getActionListeners();
                        Intrinsics.checkNotNullExpressionValue((Object)actionListenerArray, (String)"getActionListeners(...)");
                        Object[] objectArray = actionListenerArray;
                        TunnelingOption tunnelingOption = this.this$0;
                        boolean $i$f$forEach = false;
                        for (void element$iv : $this$forEach$iv) {
                            ActionListener it = (ActionListener)element$iv;
                            boolean bl = false;
                            it.actionPerformed(new ActionEvent(TunnelingOption.access$getEditBtn$p(tunnelingOption), 1001, ""));
                        }
                    }
                }
            });
        }

        @Override
        @NotNull
        public Icon getIcon(boolean isSelected) {
            return (Icon)((Object)Icons.INSTANCE.getShowWriteAccess());
        }

        @Override
        @NotNull
        public String getTitle() {
            return I18n.INSTANCE.getString("termora.new-host.tunneling");
        }

        @Override
        @NotNull
        public JComponent getJComponent() {
            return this;
        }

        private static final void initEvents$lambda$0(TunnelingOption this$0, ChangeEvent it) {
            this$0.x11ServerTextField.setEnabled(this$0.x11ForwardingCheckBox.isSelected());
        }

        private static final void initEvents$lambda$1(TunnelingOption this$0, ListSelectionEvent it) {
            this$0.editBtn.setEnabled(this$0.table.getSelectedRowCount() > 0);
            this$0.deleteBtn.setEnabled(this$0.editBtn.isEnabled());
        }

        public static final /* synthetic */ model.1 access$getModel$p(TunnelingOption $this) {
            return $this.model;
        }

        public static final /* synthetic */ JTable access$getTable$p(TunnelingOption $this) {
            return $this.table;
        }

        public static final /* synthetic */ JButton access$getEditBtn$p(TunnelingOption $this) {
            return $this.editBtn;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0018\u001a\u00020\u0019H\u0014J\b\u0010\u001a\u001a\u00020\u0019H\u0014J\b\u0010\u001b\u001a\u00020\u001cH\u0014R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$TunnelingOption$PortForwardingDialog;", "Lapp/termora/DialogWrapper;", "owner", "Ljava/awt/Window;", "tunneling", "Lapp/termora/Tunneling;", "<init>", "(Lapp/termora/plugin/internal/ssh/SSHHostOptionsPane$TunnelingOption;Ljava/awt/Window;Lapp/termora/Tunneling;)V", "getTunneling", "()Lapp/termora/Tunneling;", "setTunneling", "(Lapp/termora/Tunneling;)V", "formMargin", "", "typeComboBox", "Lcom/formdev/flatlaf/extras/components/FlatComboBox;", "Lapp/termora/TunnelingType;", "nameTextField", "Lapp/termora/OutlineTextField;", "localHostTextField", "localPortSpinner", "Lapp/termora/PortSpinner;", "remoteHostTextField", "remotePortSpinner", "doOKAction", "", "doCancelAction", "createCenterPanel", "Ljavax/swing/JComponent;", "termora"})
        @SourceDebugExtension(value={"SMAP\nSSHHostOptionsPane.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SSHHostOptionsPane.kt\napp/termora/plugin/internal/ssh/SSHHostOptionsPane$TunnelingOption$PortForwardingDialog\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1077:1\n1#2:1078\n*E\n"})
        private final class PortForwardingDialog
        extends DialogWrapper {
            @Nullable
            private Tunneling tunneling;
            @NotNull
            private final String formMargin;
            @NotNull
            private final FlatComboBox<TunnelingType> typeComboBox;
            @NotNull
            private final OutlineTextField nameTextField;
            @NotNull
            private final OutlineTextField localHostTextField;
            @NotNull
            private final PortSpinner localPortSpinner;
            @NotNull
            private final OutlineTextField remoteHostTextField;
            @NotNull
            private final PortSpinner remotePortSpinner;
            final /* synthetic */ TunnelingOption this$0;

            public PortForwardingDialog(@NotNull TunnelingOption this$0, @Nullable Window owner, Tunneling tunneling) {
                Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
                this.this$0 = this$0;
                super(owner);
                this.tunneling = tunneling;
                this.formMargin = "4dlu";
                this.typeComboBox = new FlatComboBox();
                this.nameTextField = new OutlineTextField(32);
                this.localHostTextField = new OutlineTextField(0, 1, null);
                this.localPortSpinner = new PortSpinner(0, 1, null);
                this.remoteHostTextField = new OutlineTextField(0, 1, null);
                this.remotePortSpinner = new PortSpinner(0, 1, null);
                this.setModal(true);
                this.setTitle(I18n.INSTANCE.getString("termora.new-host.tunneling"));
                this.setControlsVisible(false);
                this.typeComboBox.addItem((Object)TunnelingType.Local);
                this.typeComboBox.addItem((Object)TunnelingType.Remote);
                this.typeComboBox.addItem((Object)TunnelingType.Dynamic);
                this.localHostTextField.setText("127.0.0.1");
                this.localPortSpinner.setValue(1080);
                this.remoteHostTextField.setText("127.0.0.1");
                this.typeComboBox.addItemListener(arg_0 -> PortForwardingDialog._init_$lambda$0(this, arg_0));
                Tunneling tunneling2 = this.tunneling;
                if (tunneling2 != null) {
                    Tunneling it = tunneling2;
                    boolean bl = false;
                    this.localHostTextField.setText(it.getSourceHost());
                    this.localPortSpinner.setValue(it.getSourcePort());
                    this.remoteHostTextField.setText(it.getDestinationHost());
                    this.remotePortSpinner.setValue(it.getDestinationPort());
                    this.nameTextField.setText(it.getName());
                    this.typeComboBox.setSelectedItem((Object)it.getType());
                }
                this.init();
                this.pack();
                this.setSize(new Dimension(UIManager.getInt("Dialog.width") - 300, this.getSize().height));
                this.setLocationRelativeTo(owner);
            }

            public /* synthetic */ PortForwardingDialog(TunnelingOption tunnelingOption, Window window, Tunneling tunneling, int n, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n & 2) != 0) {
                    tunneling = null;
                }
                this(tunnelingOption, window, tunneling);
            }

            @Nullable
            public final Tunneling getTunneling() {
                return this.tunneling;
            }

            public final void setTunneling(@Nullable Tunneling tunneling) {
                this.tunneling = tunneling;
            }

            @Override
            protected void doOKAction() {
                String string = this.nameTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
                if (StringsKt.isBlank((CharSequence)string)) {
                    this.nameTextField.setOutline("error");
                    this.nameTextField.requestFocusInWindow();
                    return;
                }
                String string2 = this.localHostTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getText(...)");
                if (StringsKt.isBlank((CharSequence)string2)) {
                    this.localHostTextField.setOutline("error");
                    this.localHostTextField.requestFocusInWindow();
                    return;
                }
                String string3 = this.remoteHostTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getText(...)");
                if (StringsKt.isBlank((CharSequence)string3)) {
                    this.remoteHostTextField.setOutline("error");
                    this.remoteHostTextField.requestFocusInWindow();
                    return;
                }
                String string4 = this.nameTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getText(...)");
                Object object = this.typeComboBox.getSelectedItem();
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type app.termora.TunnelingType");
                TunnelingType tunnelingType = (TunnelingType)((Object)object);
                String string5 = this.localHostTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getText(...)");
                Object object2 = this.localPortSpinner.getValue();
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.Int");
                int n = (Integer)object2;
                String string6 = this.remoteHostTextField.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getText(...)");
                Object object3 = this.remotePortSpinner.getValue();
                Intrinsics.checkNotNull((Object)object3, (String)"null cannot be cast to non-null type kotlin.Int");
                this.tunneling = new Tunneling(string4, tunnelingType, string5, n, string6, (Integer)object3);
                super.doOKAction();
            }

            @Override
            protected void doCancelAction() {
                this.tunneling = null;
                super.doCancelAction();
            }

            @Override
            @NotNull
            protected JComponent createCenterPanel() {
                FormBuilder formBuilder;
                FormLayout layout = new FormLayout("left:pref, " + this.formMargin + ", default:grow, " + this.formMargin + ", pref", "pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref, " + this.formMargin + ", pref");
                int rows = 0;
                rows = 1;
                int step = 2;
                FormBuilder $this$createCenterPanel_u24lambda_u240 = formBuilder = FormBuilder.create().layout(layout).padding("0dlu, " + this.formMargin + ", " + this.formMargin + ", " + this.formMargin, new Object[0]).add(I18n.INSTANCE.getString("termora.new-host.tunneling.table.name") + ":", new Object[0]).xy(1, rows).add((Component)((Object)this.nameTextField)).xyw(3, rows, 3);
                boolean bl = false;
                FormBuilder $this$createCenterPanel_u24lambda_u241 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.new-host.tunneling.table.type") + ":", new Object[0]).xy(1, rows += step).add((Component)this.typeComboBox).xyw(3, rows, 3);
                boolean bl2 = false;
                FormBuilder $this$createCenterPanel_u24lambda_u242 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.new-host.tunneling.table.source") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.localHostTextField)).xy(3, rows).add((Component)((Object)this.localPortSpinner)).xy(5, rows);
                boolean bl3 = false;
                FormBuilder $this$createCenterPanel_u24lambda_u243 = formBuilder = formBuilder.add(I18n.INSTANCE.getString("termora.new-host.tunneling.table.destination") + ":", new Object[0]).xy(1, rows += step).add((Component)((Object)this.remoteHostTextField)).xy(3, rows).add((Component)((Object)this.remotePortSpinner)).xy(5, rows);
                boolean bl4 = false;
                rows += step;
                JPanel jPanel = formBuilder.build();
                Intrinsics.checkNotNullExpressionValue((Object)jPanel, (String)"build(...)");
                return jPanel;
            }

            private static final void _init_$lambda$0(PortForwardingDialog this$0, ItemEvent it) {
                if (it.getStateChange() == 1) {
                    this$0.remoteHostTextField.setEnabled(this$0.typeComboBox.getSelectedItem() != TunnelingType.Dynamic);
                    this$0.remotePortSpinner.setEnabled(this$0.remoteHostTextField.isEnabled());
                }
            }
        }
    }
}

